/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowofthesoul;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public class SoulData {
    public static final Map<UUID, PlayerFearData> PLAYER_DATA = new ConcurrentHashMap<UUID, PlayerFearData>();

    public static PlayerFearData getData(Player player) {
        return PLAYER_DATA.computeIfAbsent(player.getUUID(), k -> new PlayerFearData());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fear").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"level", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(c -> {
            SoulData.getData((Player)((CommandSourceStack)c.getSource()).getPlayerOrException()).fearLevel = DoubleArgumentType.getDouble((CommandContext)c, (String)"level");
            return 1;
        })))).then(Commands.literal((String)"togglebar").executes(c -> {
            SoulData.getData((Player)((CommandSourceStack)c.getSource()).getPlayerOrException()).showBar = !SoulData.getData((Player)((CommandSourceStack)c.getSource()).getPlayerOrException()).showBar;
            return 1;
        })));
    }

    public static class PlayerFearData {
        public double fearLevel = 0.0;
        public SanityEvent currentEvent = SanityEvent.NONE;
        public int eventTimer = 0;
        public int globalCooldown = 600;
        public int watcherCooldown = 0;
        public int chatTimer = 4000;
        public long lastJumpScareTick = -48000L;
        public boolean showBar = false;
        public Vec3 originalPos = null;
    }

    public static enum SanityEvent {
        NONE,
        WHISPERS,
        HEARTBEAT,
        PHANTOM_FIRE,
        SLIP,
        FAKE_JUMP;

    }
}

