/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowofthesoul;

import java.util.Arrays;
import java.util.List;
import net.mcreator.shadowofthesoul.SoulData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SoulEventsUI {
    private static final List<String> SCARY_MESSAGES = Arrays.asList("\u00a77\u00a7o\"I can see you...\"", "\u00a77\u00a7o\"Don't look back.\"", "\u00a77\u00a7o\"You are not alone here.\"", "\u00a77\u00a7o\"I am right behind you.\"", "\u00a77\u00a7o\"Run.\"");

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        SoulData.PlayerFearData data = SoulData.getData(player);
        if (player.tickCount % 5 == 0 && data.showBar && !player.isCreative()) {
            SoulEventsUI.drawFearBar(player, data.fearLevel);
        }
        if (--data.chatTimer <= 0) {
            player.sendSystemMessage((Component)Component.literal((String)SCARY_MESSAGES.get(player.level().random.nextInt(SCARY_MESSAGES.size()))));
            data.chatTimer = 3600 + player.level().random.nextInt(2400);
        }
    }

    @SubscribeEvent
    public static void onSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (SoulData.getData((Player)player).fearLevel > 60.0) {
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou cannot sleep now, there is an unknown player nearby"));
            player.level().playSound(null, player.blockPosition(), SoundEvents.GHAST_SCREAM, SoundSource.PLAYERS, 0.8f, 0.4f);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            SoulData.PlayerFearData data = SoulData.getData((Player)sp);
            if (data.fearLevel >= 100.0) {
                sp.sendSystemMessage((Component)Component.literal((String)"\u00a7kYOU DIED. \u00a7r\u00a7c\u00a7k01010101"));
            }
            data.fearLevel = 0.0;
        }
    }

    private static void drawFearBar(Player player, double level) {
        StringBuilder bar = new StringBuilder("\u00a78[ ");
        for (int i = 1; i <= 10; ++i) {
            if (level >= (double)(i * 10)) {
                bar.append("\u00a74- ");
                continue;
            }
            if (level >= (double)(i * 10 - 5)) {
                bar.append("\u00a76- ");
                continue;
            }
            bar.append("\u00a7f- ");
        }
        bar.append("\u00a78]");
        player.displayClientMessage((Component)Component.literal((String)(" ".repeat(130) + bar.toString())), true);
    }
}

