/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowofthesoul;

import net.mcreator.shadowofthesoul.SoulData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SoulFearLogic {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide() || player.isCreative()) {
            return;
        }
        SoulData.PlayerFearData data = SoulData.getData(player);
        ServerLevel world = (ServerLevel)player.level();
        int light = world.getRawBrightness(player.blockPosition(), 0);
        if (light < 5) {
            data.fearLevel += 0.08;
        }
        if (player.getY() < 0.0) {
            data.fearLevel += 0.05;
        }
        if (player.tickCount % 10 == 0 && !world.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(10.0), e -> e instanceof Enemy).isEmpty()) {
            data.fearLevel += 2.5;
        }
        if (light > 10) {
            data.fearLevel -= 0.2;
        }
        data.fearLevel = Math.max(0.0, Math.min(100.0, data.fearLevel));
        if (data.fearLevel > 60.0) {
            int interval;
            int n = interval = data.fearLevel > 85.0 ? 12 : 25;
            if (player.tickCount % interval == 0) {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WARDEN_HEARTBEAT, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SoulData.PlayerFearData data = SoulData.getData(player);
            data.fearLevel += (double)event.getOriginalDamage() * 2.25;
            if (player.getHealth() < 8.0f) {
                data.fearLevel += 15.0;
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getDistance() > 3.0f) {
                SoulData.getData((Player)player).fearLevel += (double)event.getDistance() * 3.5;
            }
        }
    }
}

