/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowofthesoul;

import net.mcreator.shadowofthesoul.SoulData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SoulSoundSystem {
    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        SoulData.PlayerFearData data = SoulData.getData(player);
        if (data.fearLevel > 70.0) {
            int beatRate;
            int n = beatRate = data.fearLevel > 90.0 ? 12 : 25;
            if (player.tickCount % beatRate == 0) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WARDEN_HEARTBEAT, SoundSource.AMBIENT, 0.5f, 1.0f);
            }
        }
        if (data.fearLevel > 50.0 && player.level().random.nextInt(1000) < 2) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.AMBIENT, 0.5f, 0.5f);
        }
    }

    @SubscribeEvent
    public static void onSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (SoulData.getData((Player)player).fearLevel > 60.0) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou feel a presence... you cannot rest."));
            player.level().playSound(null, player.blockPosition(), SoundEvents.GHAST_SCREAM, SoundSource.AMBIENT, 0.6f, 0.4f);
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }
}

