/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowofthesoul;

import net.mcreator.shadowofthesoul.SoulData;
import net.mcreator.shadowofthesoul.init.ShadowOfTheSoulModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SoulWatcherSystem {
    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        SoulData.PlayerFearData data = SoulData.getData(player);
        ServerLevel world = (ServerLevel)player.level();
        if (data.fearLevel > 45.0 && player.tickCount % 80 == 0) {
            BlockPos pPos = player.blockPosition();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)pPos.offset(-7, -2, -7), (BlockPos)pPos.offset(7, 4, 7))) {
                if (!world.getBlockState(pos).is(Blocks.TORCH) && !world.getBlockState(pos).is(Blocks.WALL_TORCH) || world.random.nextInt(100) >= 60) continue;
                world.destroyBlock(pos, false);
                world.playSound(null, pos, SoundEvents.GHAST_SCREAM, SoundSource.AMBIENT, 0.5f, 0.5f);
                break;
            }
        }
        SoulWatcherSystem.handleWatcherLogic(world, player, data);
    }

    private static void handleWatcherLogic(ServerLevel world, Player player, SoulData.PlayerFearData data) {
        Entity watcher2;
        BlockPos spawnPos;
        world.getEntitiesOfClass(Entity.class, player.getBoundingBox().inflate(30.0), e -> e.getType().toString().contains("watcher")).forEach(watcher -> {
            Vec3 toWatcher;
            Vec3 lookVec = player.getLookAngle();
            if (lookVec.dot(toWatcher = watcher.position().subtract(player.position()).normalize()) > 0.6) {
                world.sendParticles((ParticleOptions)ParticleTypes.SQUID_INK, watcher.getX(), watcher.getY() + 1.0, watcher.getZ(), 40, 0.2, 0.5, 0.2, 0.05);
                world.playSound(null, watcher.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 0.8f, 0.1f);
                watcher.discard();
                data.fearLevel -= 10.0;
            }
        });
        if (data.fearLevel > 55.0 && data.watcherCooldown-- <= 0 && world.random.nextInt(1000) < 5 && world.isEmptyBlock(spawnPos = player.blockPosition().relative(player.getDirection().getOpposite(), 9)) && (watcher2 = ((EntityType)ShadowOfTheSoulModEntities.THE_WATCHER.get()).spawn(world, spawnPos, MobSpawnType.MOB_SUMMONED)) != null) {
            watcher2.setYRot(player.getYRot());
            world.playSound(null, spawnPos, (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.PLAYERS, 1.0f, 0.1f);
            data.watcherCooldown = 1200;
        }
    }
}

