/*
 * Decompiled with CFR 0.152.
 */
package com.panda.inventorybuttons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class InventoryButtons {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"InventoryButtons");
    private static final Path BASE_DIR = FabricLoader.getInstance().getConfigDir().resolve("inventorybuttons");
    private static final Path CONFIG_PATH = BASE_DIR.resolve("invbuttons.json");
    private static final Path PROFILES_DIR = BASE_DIR.resolve("profiles");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static InventoryButtons instance = new InventoryButtons();
    public boolean enabled = true;
    public boolean showTooltips = true;
    public boolean gridSnap = false;
    public boolean hideInCreative = false;
    public List<CustomButtonData> buttons = new ArrayList<CustomButtonData>();
    public static final Map<String, class_2960> CUSTOM_TEXTURES = new LinkedHashMap<String, class_2960>();

    private static void registerCustom(String name, String fileName) {
        CUSTOM_TEXTURES.put(name, class_2960.method_60655((String)"inventorybuttons", (String)("textures/icons/custom/" + fileName + ".png")));
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                instance = (InventoryButtons)GSON.fromJson((Reader)reader, InventoryButtons.class);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config", (Throwable)e);
            }
        } else {
            InventoryButtons.save();
        }
    }

    public static void save() {
        try {
            if (!Files.exists(BASE_DIR, new LinkOption[0])) {
                Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)instance, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void saveProfile(String name) {
        try {
            if (!Files.exists(PROFILES_DIR, new LinkOption[0])) {
                Files.createDirectories(PROFILES_DIR, new FileAttribute[0]);
            }
            Path profilePath = PROFILES_DIR.resolve(name + ".json");
            try (BufferedWriter writer = Files.newBufferedWriter(profilePath, new OpenOption[0]);){
                GSON.toJson(InventoryButtons.instance.buttons, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save profile: " + name, (Throwable)e);
        }
    }

    public static void loadProfile(String name) {
        block9: {
            try {
                Path profilePath = PROFILES_DIR.resolve(name + ".json");
                if (!Files.exists(profilePath, new LinkOption[0])) break block9;
                try (BufferedReader reader = Files.newBufferedReader(profilePath);){
                    List loaded = (List)GSON.fromJson((Reader)reader, new TypeToken<List<CustomButtonData>>(){}.getType());
                    if (loaded != null) {
                        InventoryButtons.instance.buttons = loaded;
                        InventoryButtons.save();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load profile: " + name, (Throwable)e);
            }
        }
    }

    public static void deleteProfile(String name) {
        try {
            Path profilePath = PROFILES_DIR.resolve(name + ".json");
            Files.deleteIfExists(profilePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete profile: " + name, (Throwable)e);
        }
    }

    public static List<String> getProfileNames() {
        List<String> list;
        block9: {
            if (!Files.exists(PROFILES_DIR, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.list(PROFILES_DIR);
            try {
                list = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")).map(file -> file.getFileName().toString().replace(".json", "")).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to list profiles", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    static {
        InventoryButtons.registerCustom("baubles ring", "baubles");
        InventoryButtons.registerCustom("baubles gold ring", "baubles_gold");
        InventoryButtons.registerCustom("cross x", "cross");
        InventoryButtons.registerCustom("green check mark", "green_check");
        InventoryButtons.registerCustom("white check mark", "white_check");
        InventoryButtons.registerCustom("question mark help", "question");
        InventoryButtons.registerCustom("settings cog config", "settings");
        InventoryButtons.registerCustom("accessory ring", "accessory");
        InventoryButtons.registerCustom("accessory ring gold", "accessory_gold");
        InventoryButtons.registerCustom("armor chestplate", "armor");
        InventoryButtons.registerCustom("armor gold chestplate", "armor_gold");
        InventoryButtons.registerCustom("pet cat", "pet");
        InventoryButtons.registerCustom("pet cat gold", "pet_gold");
        InventoryButtons.registerCustom("skyblock menu", "skyblock_menu");
        InventoryButtons.registerCustom("recipe book", "recipe");
        InventoryButtons.registerCustom("search glass", "search");
    }

    @Environment(value=EnvType.CLIENT)
    public static class CustomButtonData {
        public int x;
        public int y;
        public String command;
        public String itemId;
        public int backgroundIndex = 0;
        public boolean anchorRight = false;
        public boolean anchorBottom = false;

        public CustomButtonData(int x, int y, String cmd, String item) {
            this.x = x;
            this.y = y;
            this.command = cmd;
            this.itemId = item;
        }

        public class_1799 getItemStack() {
            if (this.itemId == null || this.itemId.isEmpty()) {
                return class_1799.field_8037;
            }
            if (this.itemId.startsWith("skull:")) {
                return CustomButtonData.getSkullStack(this.itemId);
            }
            try {
                if (!this.itemId.contains(":")) {
                    return class_1799.field_8037;
                }
                return new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.itemId)));
            }
            catch (Exception e) {
                return class_1799.field_8037;
            }
        }

        public static class_1799 getSkullStack(String skullStr) {
            try {
                String textureId = skullStr.substring("skull:".length());
                class_1799 head = new class_1799((class_1935)class_1802.field_8575);
                String textureUrl = "http://textures.minecraft.net/texture/" + textureId;
                String json = "{\"textures\":{\"SKIN\":{\"url\":\"" + textureUrl + "\"}}}";
                String base64 = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
                UUID uuid = UUID.nameUUIDFromBytes(textureId.getBytes(StandardCharsets.UTF_8));
                GameProfile profile = new GameProfile(uuid, "Skull");
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
                head.method_57379(class_9334.field_49617, (Object)new class_9296(profile));
                return head;
            }
            catch (Exception e) {
                LOGGER.error("Failed to create skull stack", (Throwable)e);
                return new class_1799((class_1935)class_1802.field_8575);
            }
        }
    }
}

