/*
 * Decompiled with CFR 0.152.
 */
package com.panda.inventorybuttons.gui;

import com.panda.inventorybuttons.InventoryButtons;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class GuiInvButtonConfig
extends class_437 {
    private static final class_2960 TRASH_ICON = class_2960.method_60655((String)"inventorybuttons", (String)"textures/gui/icons/delete_trashcan.png");
    private final class_437 parent;
    private Tab currentTab = Tab.GENERAL;
    private int boxX;
    private int boxY;
    private int boxW;
    private int boxH;
    private final List<ConfigToggle> generalButtons = new ArrayList<ConfigToggle>();
    private final List<ProfileButton> profileButtons = new ArrayList<ProfileButton>();
    private final List<ProfileButton> deleteButtons = new ArrayList<ProfileButton>();
    private class_342 profileNameField;
    private ProfileButton profileSaveBtn;
    private final LerpingInteger profileScroll = new LerpingInteger(0, 0);
    private String statusText = "";
    private long statusEndTime = 0L;

    public GuiInvButtonConfig(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Configuration"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.boxW = 240;
        this.boxH = 160;
        this.boxX = (this.field_22789 - this.boxW) / 2;
        this.boxY = (this.field_22790 - this.boxH) / 2;
        this.generalButtons.clear();
        int startY = this.boxY + 30;
        int spacing = 22;
        int btnW = 50;
        int btnH = 16;
        int btnX = this.boxX + this.boxW - btnW - 10;
        this.addGeneralSetting(this.boxX + 10, startY, btnX, btnW, btnH, "Inventory Buttons", () -> InventoryButtons.instance.enabled, v -> {
            InventoryButtons.instance.enabled = v;
        });
        this.addGeneralSetting(this.boxX + 10, startY += spacing, btnX, btnW, btnH, "Show Tooltips", () -> InventoryButtons.instance.showTooltips, v -> {
            InventoryButtons.instance.showTooltips = v;
        });
        this.addGeneralSetting(this.boxX + 10, startY += spacing, btnX, btnW, btnH, "Hide in Creative Mode", () -> InventoryButtons.instance.hideInCreative, v -> {
            InventoryButtons.instance.hideInCreative = v;
        });
        this.addGeneralSetting(this.boxX + 10, startY += spacing, btnX, btnW, btnH, "Grid Snap Default", () -> InventoryButtons.instance.gridSnap, v -> {
            InventoryButtons.instance.gridSnap = v;
        });
        int fieldW = 140;
        this.profileNameField = new class_342(this.field_22793, this.boxX + 10, this.boxY + 42, fieldW, 16, (class_2561)class_2561.method_43470((String)"Profile Name"));
        this.profileNameField.method_1880(32);
        this.profileSaveBtn = new ProfileButton(this.boxX + 10 + fieldW + 5, this.boxY + 42, 75, 16, "Save Profile", () -> {
            String name = this.profileNameField.method_1882().trim();
            if (!name.isEmpty()) {
                InventoryButtons.saveProfile(name);
                this.setStatus("Saved: " + name);
                this.refreshProfileList();
                this.profileNameField.method_1852("");
            }
        });
        this.refreshProfileList();
    }

    private void addGeneralSetting(int labelX, int y, int btnX, int btnW, int btnH, String label, BooleanSupplier get, BooleanConsumer set) {
        this.generalButtons.add(new ConfigToggle(labelX, y, btnX, btnW, btnH, label, get, set));
    }

    private void refreshProfileList() {
        this.profileButtons.clear();
        this.deleteButtons.clear();
        List<String> profiles = InventoryButtons.getProfileNames();
        int itemH = 18;
        int listY = 0;
        int deleteW = 18;
        int spacing = 4;
        int loadW = this.boxW - 30 - deleteW - spacing;
        Iterator<String> iterator = profiles.iterator();
        while (iterator.hasNext()) {
            String p;
            String fName = p = iterator.next();
            this.profileButtons.add(new ProfileButton(this.boxX + 10, listY, loadW, itemH, "Load: " + p, () -> {
                InventoryButtons.loadProfile(fName);
                this.setStatus("Loaded: " + fName);
            }));
            this.deleteButtons.add(new ProfileButton(this.boxX + 10 + loadW + spacing, listY, deleteW, itemH, "", () -> {
                InventoryButtons.deleteProfile(fName);
                this.setStatus("Deleted: " + fName);
                this.refreshProfileList();
            }));
            listY += itemH + 2;
        }
    }

    private void setStatus(String msg) {
        this.statusText = msg;
        this.statusEndTime = System.currentTimeMillis() + 3000L;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean hoverProf;
        boolean hoverGen;
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)(this.boxY - 25), 0.0f);
        float scale = 1.5f;
        context.method_51448().method_22905(scale, scale, 1.0f);
        String titleText = "Configuration";
        int tW = this.field_22793.method_1727(titleText);
        int n = -tW / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_51433(this.field_22793, titleText, n, -9 / 2, -1, true);
        context.method_51448().method_22909();
        context.method_25294(this.boxX, this.boxY, this.boxX + this.boxW, this.boxY + this.boxH, -1442840576);
        context.method_49601(this.boxX, this.boxY, this.boxW, this.boxH, -11513776);
        int tabH = 16;
        int tabW = this.boxW / 2;
        boolean bl = hoverGen = mouseX >= this.boxX && mouseX < this.boxX + tabW && mouseY >= this.boxY && mouseY < this.boxY + tabH;
        int colorGen = this.currentTab == Tab.GENERAL ? -868204480 : (hoverGen ? -1439682512 : -2011160544);
        context.method_25294(this.boxX, this.boxY, this.boxX + tabW, this.boxY + tabH, colorGen);
        context.method_25300(this.field_22793, "General", this.boxX + tabW / 2, this.boxY + 4, this.currentTab == Tab.GENERAL ? 0xFFFFFF : 0xAAAAAA);
        boolean bl2 = hoverProf = mouseX >= this.boxX + tabW && mouseX < this.boxX + this.boxW && mouseY >= this.boxY && mouseY < this.boxY + tabH;
        int colorProf = this.currentTab == Tab.PROFILES ? -868204480 : (hoverProf ? -1439682512 : -2011160544);
        context.method_25294(this.boxX + tabW, this.boxY, this.boxX + this.boxW, this.boxY + tabH, colorProf);
        context.method_25300(this.field_22793, "Profiles", this.boxX + tabW + tabW / 2, this.boxY + 4, this.currentTab == Tab.PROFILES ? 0xFFFFFF : 0xAAAAAA);
        context.method_25294(this.boxX, this.boxY + tabH, this.boxX + this.boxW, this.boxY + tabH + 1, -8355712);
        if (this.currentTab == Tab.GENERAL) {
            this.renderGeneral(context, mouseX, mouseY);
        } else {
            this.renderProfiles(context, mouseX, mouseY);
        }
    }

    private void renderGeneral(class_332 context, int mouseX, int mouseY) {
        for (ConfigToggle btn : this.generalButtons) {
            context.method_25303(this.field_22793, btn.label, btn.labelX, btn.y + 4, -1);
            boolean isHovered = mouseX >= btn.btnX && mouseX < btn.btnX + btn.btnW && mouseY >= btn.y && mouseY < btn.y + btn.btnH;
            int bgColor = isHovered ? -1610612736 : Integer.MIN_VALUE;
            context.method_25294(btn.btnX, btn.y, btn.btnX + btn.btnW, btn.y + btn.btnH, bgColor);
            boolean state = btn.getter.get();
            String stateTxt = state ? "ON" : "OFF";
            int color = state ? -11141291 : -43691;
            int txtW = this.field_22793.method_1727(stateTxt);
            context.method_51433(this.field_22793, stateTxt, btn.btnX + (btn.btnW - txtW) / 2, btn.y + 4, color, false);
        }
    }

    private void renderProfiles(class_332 context, int mouseX, int mouseY) {
        context.method_25303(this.field_22793, "Profile Name", this.boxX + 10, this.boxY + 30, -6250336);
        this.profileNameField.method_25394(context, mouseX, mouseY, 0.0f);
        ProfileButton saveBtn = this.profileSaveBtn;
        boolean hoverSave = mouseX >= saveBtn.x && mouseX < saveBtn.x + saveBtn.w && mouseY >= saveBtn.y && mouseY < saveBtn.y + saveBtn.h;
        context.method_25294(saveBtn.x, saveBtn.y, saveBtn.x + saveBtn.w, saveBtn.y + saveBtn.h, hoverSave ? -1610612736 : Integer.MIN_VALUE);
        int saveTW = this.field_22793.method_1727(saveBtn.label);
        context.method_51433(this.field_22793, saveBtn.label, saveBtn.x + (saveBtn.w - saveTW) / 2, saveBtn.y + 4, -1, false);
        if (System.currentTimeMillis() < this.statusEndTime) {
            context.method_25303(this.field_22793, this.statusText, this.boxX + 10, this.boxY + this.boxH - 12, -11141291);
        }
        int listY = this.boxY + 70;
        int listH = this.boxH - 85;
        int listW = this.boxW - 20;
        context.method_44379(this.boxX + 10, listY, this.boxX + 10 + listW, listY + listH);
        this.profileScroll.tick();
        int currentY = listY - this.profileScroll.getValue();
        for (int i = 0; i < this.profileButtons.size(); ++i) {
            boolean isDelHovered;
            boolean isHovered;
            ProfileButton btn = this.profileButtons.get(i);
            ProfileButton delBtn = this.deleteButtons.get(i);
            if (currentY + btn.h < listY) {
                currentY += btn.h + 2;
                continue;
            }
            if (currentY > listY + listH) break;
            int drawY = currentY;
            boolean bl = isHovered = mouseX >= btn.x && mouseX < btn.x + btn.w && mouseY >= drawY && mouseY < drawY + btn.h;
            if (mouseY < listY || mouseY > listY + listH) {
                isHovered = false;
            }
            context.method_25294(btn.x, drawY, btn.x + btn.w, drawY + btn.h, isHovered ? -1610612736 : Integer.MIN_VALUE);
            context.method_51433(this.field_22793, btn.label, btn.x + 5, drawY + 5, -1, false);
            boolean bl2 = isDelHovered = mouseX >= delBtn.x && mouseX < delBtn.x + delBtn.w && mouseY >= drawY && mouseY < drawY + delBtn.h;
            if (mouseY < listY || mouseY > listY + listH) {
                isDelHovered = false;
            }
            context.method_25294(delBtn.x, drawY, delBtn.x + delBtn.w, drawY + delBtn.h, isDelHovered ? -1610612736 : Integer.MIN_VALUE);
            context.method_25290(class_1921::method_62277, TRASH_ICON, delBtn.x + 1, drawY + 1, 0.0f, 0.0f, 16, 16, 16, 16);
            currentY += btn.h + 2;
        }
        context.method_44380();
        int totalH = this.profileButtons.size() * 20;
        if (totalH > listH) {
            int barH = (int)((float)listH / (float)totalH * (float)listH);
            if (barH < 10) {
                barH = 10;
            }
            int barTrackH = listH;
            float ratio = (float)this.profileScroll.getValue() / (float)(totalH - listH);
            int barY = listY + (int)((float)(barTrackH - barH) * ratio);
            context.method_25294(this.boxX + this.boxW - 8, barY, this.boxX + this.boxW - 4, barY + barH, -8355712);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        block16: {
            block17: {
                if (button != 0) break block16;
                int tabW = this.boxW / 2;
                if (mouseY >= (double)this.boxY && mouseY < (double)(this.boxY + 16)) {
                    if (mouseX >= (double)this.boxX && mouseX < (double)(this.boxX + tabW)) {
                        this.currentTab = Tab.GENERAL;
                        if (this.profileNameField != null) {
                            this.profileNameField.method_25365(false);
                        }
                        if (this.field_22787 != null) {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        }
                        return true;
                    }
                    if (mouseX >= (double)(this.boxX + tabW) && mouseX < (double)(this.boxX + this.boxW)) {
                        this.currentTab = Tab.PROFILES;
                        if (this.field_22787 != null) {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        }
                        return true;
                    }
                }
                if (this.currentTab != Tab.GENERAL) break block17;
                for (ConfigToggle btn : this.generalButtons) {
                    if (!(mouseX >= (double)btn.btnX) || !(mouseX < (double)(btn.btnX + btn.btnW)) || !(mouseY >= (double)btn.y) || !(mouseY < (double)(btn.y + btn.btnH))) continue;
                    btn.setter.accept(!btn.getter.get());
                    if (this.field_22787 != null) {
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    }
                    return true;
                }
                break block16;
            }
            boolean fieldClicked = this.profileNameField.method_25402(mouseX, mouseY, button);
            this.profileNameField.method_25365(fieldClicked);
            if (fieldClicked) {
                return true;
            }
            if (mouseX >= (double)this.profileSaveBtn.x && mouseX < (double)(this.profileSaveBtn.x + this.profileSaveBtn.w) && mouseY >= (double)this.profileSaveBtn.y && mouseY < (double)(this.profileSaveBtn.y + this.profileSaveBtn.h)) {
                this.profileSaveBtn.action.run();
                if (this.field_22787 != null) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                return true;
            }
            int listY = this.boxY + 70;
            int listH = this.boxH - 85;
            if (!(mouseY >= (double)listY) || !(mouseY <= (double)(listY + listH))) break block16;
            int currentY = listY - this.profileScroll.getValue();
            for (int i = 0; i < this.profileButtons.size(); ++i) {
                ProfileButton btn = this.profileButtons.get(i);
                ProfileButton delBtn = this.deleteButtons.get(i);
                if (mouseX >= (double)btn.x && mouseX < (double)(btn.x + btn.w) && mouseY >= (double)currentY && mouseY < (double)(currentY + btn.h)) {
                    btn.action.run();
                    if (this.field_22787 != null) {
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    }
                    return true;
                }
                if (mouseX >= (double)delBtn.x && mouseX < (double)(delBtn.x + delBtn.w) && mouseY >= (double)currentY && mouseY < (double)(currentY + delBtn.h)) {
                    delBtn.action.run();
                    if (this.field_22787 != null) {
                        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    }
                    return true;
                }
                currentY += btn.h + 2;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.currentTab == Tab.PROFILES) {
            int scroll = (int)(-verticalAmount * 10.0);
            int target = this.profileScroll.getTarget() + scroll;
            int totalH = this.profileButtons.size() * 20;
            int listH = this.boxH - 85;
            int maxScroll = Math.max(0, totalH - listH);
            if (target < 0) {
                target = 0;
            }
            if (target > maxScroll) {
                target = maxScroll;
            }
            this.profileScroll.setTarget(target);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && !this.profileNameField.method_25370()) {
            this.method_25419();
            return true;
        }
        if (this.currentTab == Tab.PROFILES && this.profileNameField.method_25370() && this.profileNameField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.currentTab == Tab.PROFILES && this.profileNameField.method_25370() && this.profileNameField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25419() {
        InventoryButtons.save();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Tab {
        GENERAL,
        PROFILES;

    }

    @Environment(value=EnvType.CLIENT)
    private static class LerpingInteger {
        private int value;
        private int target;

        public LerpingInteger(int value, int target) {
            this.value = value;
            this.target = target;
        }

        public void tick() {
            if (this.value != this.target) {
                int diff = this.target - this.value;
                int change = diff / 5;
                if (change == 0) {
                    change = diff > 0 ? 1 : -1;
                }
                this.value += change;
            }
        }

        public int getValue() {
            return this.value;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int t) {
            this.target = t;
        }
    }

    @Environment(value=EnvType.CLIENT)
    static interface BooleanSupplier {
        public boolean get();
    }

    @Environment(value=EnvType.CLIENT)
    static interface BooleanConsumer {
        public void accept(boolean var1);
    }

    @Environment(value=EnvType.CLIENT)
    private record ProfileButton(int x, int y, int w, int h, String label, Runnable action) {
    }

    @Environment(value=EnvType.CLIENT)
    private record ConfigToggle(int labelX, int y, int btnX, int btnW, int btnH, String label, BooleanSupplier getter, BooleanConsumer setter) {
    }
}

