/*
 * Decompiled with CFR 0.152.
 */
package com.panda.inventorybuttons.gui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.panda.inventorybuttons.InventoryButtons;
import com.panda.inventorybuttons.util.HypixelItemManager;
import java.awt.Point;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class GuiInvButtonEditor
extends class_437 {
    private static final class_2960 INVENTORY_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/inventory.png");
    private static final class_2960 BUTTONS_TEXTURE = class_2960.method_60655((String)"inventorybuttons", (String)"textures/gui/buttons.png");
    private static final class_2960 INFO_ICON_TEXTURE = class_2960.method_60655((String)"inventorybuttons", (String)"textures/gui/icons/info.png");
    private static final int TEXTURE_WIDTH = 90;
    private static final int TEXTURE_HEIGHT = 36;
    private static final int BUTTON_SIZE = 18;
    private static final int OUTER_PADDING = 2;
    private static final int OUTER_GRID_SIZE = 20;
    private static final int TOP_BOTTOM_START_X = 8;
    private static final List<Point> INVENTORY_FIXED_SLOTS = new ArrayList<Point>();
    private static final Map<String, String> SKULL_ICONS;
    private FilterMode currentMode = FilterMode.ALL;
    private final class_437 parent;
    private final int xSize = 176;
    private final int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private int dragOffsetX;
    private int dragOffsetY;
    private boolean isDragging = false;
    private boolean isEditorOpen = false;
    private boolean isInfoPanelOpen = false;
    private boolean isSavePanelOpen = false;
    private class_342 saveProfileField;
    private final int editorWidth = 150;
    private final int editorHeight = 224;
    private int editorLeft;
    private int editorTop;
    private class_342 commandTextField;
    private class_342 iconTextField;
    private class_342 addSkullField;
    private InventoryButtons.CustomButtonData editingButton = null;
    private final List<IconResult> searchedIcons = new ArrayList<IconResult>();
    private final LerpingInteger itemScroll = new LerpingInteger(0, 100);
    private String actionStatusText = "";
    private long actionStatusEndTime = 0L;
    private boolean localGridSnap;

    public GuiInvButtonEditor(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"NEU Button Editor Port"));
        this.parent = parent;
        this.localGridSnap = InventoryButtons.instance.gridSnap;
    }

    protected void method_25426() {
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 166) / 2;
        this.commandTextField = new class_342(this.field_22793, 0, 0, 136, 16, (class_2561)class_2561.method_43470((String)"Command"));
        this.commandTextField.method_1880(256);
        this.commandTextField.method_1863(s -> {
            if (this.editingButton != null) {
                Object text = s;
                if (((String)text).isEmpty()) {
                    text = "/";
                    this.commandTextField.method_1852((String)text);
                    this.commandTextField.method_1883(1, false);
                } else if (!((String)text).startsWith("/")) {
                    text = "/" + ((String)text).replace("/", "");
                    this.commandTextField.method_1852((String)text);
                    this.commandTextField.method_1883(((String)text).length(), false);
                }
                this.editingButton.command = text;
            }
        });
        this.iconTextField = new class_342(this.field_22793, 0, 0, 136, 16, (class_2561)class_2561.method_43470((String)"Icon"));
        this.iconTextField.method_1880(256);
        this.iconTextField.method_1863(this::search);
        this.addSkullField = new class_342(this.field_22793, 0, 0, 136, 16, (class_2561)class_2561.method_43470((String)"Skull ID"));
        this.addSkullField.method_1880(512);
        this.addSkullField.method_1863(s -> {
            if (this.editingButton != null && !s.isEmpty()) {
                this.editingButton.itemId = s;
            }
        });
        this.saveProfileField = new class_342(this.field_22793, 0, 0, 140, 20, (class_2561)class_2561.method_43470((String)"Profile Name"));
        this.saveProfileField.method_1880(32);
        this.search("");
    }

    private void updateEditorCoordinates() {
        if (this.editingButton == null) {
            return;
        }
        int btnX = this.guiLeft + this.editingButton.x;
        int btnY = this.guiTop + this.editingButton.y;
        if (this.editingButton.anchorRight) {
            btnX += 176;
        }
        if (this.editingButton.anchorBottom) {
            btnY += 166;
        }
        this.editorLeft = btnX + 25;
        this.editorTop = btnY - 20;
        if (this.editorLeft + 150 > this.field_22789) {
            this.editorLeft = btnX - 150 - 5;
        }
        if (this.editorTop + 224 > this.field_22790) {
            this.editorTop = this.field_22790 - 224 - 5;
        }
        if (this.editorTop < 0) {
            this.editorTop = 5;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 166) / 2;
        context.method_25290(class_1921::method_62276, INVENTORY_TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, 176, 166, 256, 256);
        for (InventoryButtons.CustomButtonData button : InventoryButtons.instance.buttons) {
            int x = this.guiLeft + button.x;
            int y = this.guiTop + button.y;
            if (button.anchorRight) {
                x += 176;
            }
            if (button.anchorBottom) {
                y += 166;
            }
            if (button == this.editingButton) {
                context.method_25294(x, y, x + 18, y + 18, -2147418368);
                context.method_49601(x, y, 18, 18, -1);
            } else {
                context.method_25290(class_1921::method_62276, BUTTONS_TEXTURE, x, y, (float)(button.backgroundIndex * 18), 18.0f, 18, 18, 90, 36);
            }
            if (button.itemId != null && !button.itemId.isEmpty()) {
                class_2960 customTex = null;
                for (Map.Entry<String, class_2960> entry : InventoryButtons.CUSTOM_TEXTURES.entrySet()) {
                    if (!entry.getValue().toString().equals(button.itemId)) continue;
                    customTex = entry.getValue();
                    break;
                }
                if (customTex != null) {
                    context.method_25290(class_1921::method_62277, customTex, x + 1, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                class_1799 stack = button.getItemStack();
                if (stack.method_7960()) continue;
                context.method_51427(stack, x + 1, y + 1);
                continue;
            }
            context.method_25300(this.field_22793, "?", x + 9, y + 5, -1);
        }
        if (this.editingButton != null && this.isEditorOpen) {
            this.updateEditorCoordinates();
            context.method_51448().method_22903();
            context.method_51448().method_22904(0.0, 0.0, 500.0);
            this.renderEditorPanel(context, mouseX, mouseY, delta);
            context.method_51448().method_22909();
        }
        if (this.editingButton == null) {
            context.method_25300(this.field_22793, "Click to select/drag, Click again to edit", this.field_22789 / 2, 10, -1);
            context.method_25300(this.field_22793, "Backspace while selected to delete", this.field_22789 / 2, 22, -5592406);
            context.method_25300(this.field_22793, "Right Click empty space to add new", this.field_22789 / 2, 34, -5592406);
        }
        String snapText = "Grid Snap (S): " + (this.localGridSnap ? "ON" : "OFF");
        int snapColor = this.localGridSnap ? -11141291 : -5592406;
        context.method_25303(this.field_22793, snapText, 5, this.field_22790 - 15, snapColor);
        this.renderIOButtons(context, mouseX, mouseY);
        if (this.isInfoPanelOpen) {
            this.renderSkullInfoPanel(context, mouseX, mouseY);
        }
        if (this.isSavePanelOpen) {
            context.method_51448().method_22903();
            context.method_51448().method_22904(0.0, 0.0, 1000.0);
            this.renderSaveProfilePanel(context, mouseX, mouseY, delta);
            context.method_51448().method_22909();
        }
    }

    private void renderIOButtons(class_332 context, int mouseX, int mouseY) {
        int btnH = 20;
        int spacing = 5;
        int startX = 10;
        int startY = 10;
        int saveW = 100;
        int saveY = startY;
        boolean hoverSave = mouseX >= startX && mouseX <= startX + saveW && mouseY >= saveY && mouseY <= saveY + btnH;
        context.method_25294(startX, saveY, startX + saveW, saveY + btnH, hoverSave ? -10461088 : -12566464);
        context.method_49601(startX, saveY, saveW, btnH, -1);
        context.method_25300(this.field_22793, "Save as Profile", startX + saveW / 2, saveY + 6, -1);
        int exportW = 50;
        int exportY = saveY + btnH + spacing;
        boolean hoverExport = mouseX >= startX && mouseX <= startX + exportW && mouseY >= exportY && mouseY <= exportY + btnH;
        context.method_25294(startX, exportY, startX + exportW, exportY + btnH, hoverExport ? -10461088 : -12566464);
        context.method_49601(startX, exportY, exportW, btnH, -1);
        context.method_25300(this.field_22793, "Export", startX + exportW / 2, exportY + 6, -1);
        int importW = 50;
        int importY = exportY + btnH + spacing;
        boolean hoverImport = mouseX >= startX && mouseX <= startX + importW && mouseY >= importY && mouseY <= importY + btnH;
        context.method_25294(startX, importY, startX + importW, importY + btnH, hoverImport ? -10461088 : -12566464);
        context.method_49601(startX, importY, importW, btnH, -1);
        context.method_25300(this.field_22793, "Import", startX + importW / 2, importY + 6, -1);
        if (System.currentTimeMillis() < this.actionStatusEndTime) {
            context.method_25303(this.field_22793, this.actionStatusText, startX + saveW + 5, startY + 6, -11141291);
        }
    }

    private void renderSaveProfilePanel(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1442840576, -1442840576);
        int panelW = 200;
        int panelH = 100;
        int panelX = (this.field_22789 - panelW) / 2;
        int panelY = (this.field_22790 - panelH) / 2;
        context.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -14671840);
        context.method_49601(panelX, panelY, panelW, panelH, -11513776);
        context.method_25300(this.field_22793, "Profile Name", panelX + panelW / 2, panelY + 10, -1);
        int closeSize = 12;
        int closeX = panelX + panelW - closeSize - 5;
        int closeY = panelY + 5;
        boolean hoverClose = mouseX >= closeX && mouseX <= closeX + closeSize && mouseY >= closeY && mouseY <= closeY + closeSize;
        context.method_25294(closeX, closeY, closeX + closeSize, closeY + closeSize, hoverClose ? -65536 : -3407872);
        context.method_25300(this.field_22793, "x", closeX + closeSize / 2, closeY + 2, -1);
        this.saveProfileField.method_46421(panelX + 30);
        this.saveProfileField.method_46419(panelY + 35);
        this.saveProfileField.method_25394(context, mouseX, mouseY, delta);
        int btnW = 60;
        int btnH = 20;
        int btnX = panelX + (panelW - btnW) / 2;
        int btnY = panelY + 65;
        boolean hoverConfirm = mouseX >= btnX && mouseX <= btnX + btnW && mouseY >= btnY && mouseY <= btnY + btnH;
        context.method_25294(btnX, btnY, btnX + btnW, btnY + btnH, hoverConfirm ? -12550080 : -14655456);
        context.method_49601(btnX, btnY, btnW, btnH, -1);
        context.method_25300(this.field_22793, "Save", btnX + btnW / 2, btnY + 6, -1);
    }

    private void handleExport() {
        try {
            Gson gson = new Gson();
            String json = gson.toJson(InventoryButtons.instance.buttons);
            String encoded = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
            if (this.field_22787 != null) {
                this.field_22787.field_1774.method_1455(encoded);
                this.actionStatusText = "Exported to Clipboard!";
                this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
            }
        }
        catch (Exception e) {
            this.actionStatusText = "Export Failed!";
            this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
            e.printStackTrace();
        }
    }

    private void handleImport() {
        try {
            if (this.field_22787 != null) {
                String clipboard = this.field_22787.field_1774.method_1460();
                if (clipboard == null || clipboard.isEmpty()) {
                    return;
                }
                Gson gson = new Gson();
                String json = new String(Base64.getDecoder().decode(clipboard), StandardCharsets.UTF_8);
                List loaded = (List)gson.fromJson(json, new TypeToken<List<InventoryButtons.CustomButtonData>>(this){}.getType());
                if (loaded != null) {
                    InventoryButtons.instance.buttons = loaded;
                    InventoryButtons.save();
                    this.actionStatusText = "Imported Successfully!";
                    this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
                }
            }
        }
        catch (Exception e) {
            this.actionStatusText = "Invalid Clipboard!";
            this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
            e.printStackTrace();
        }
    }

    private void renderEditorPanel(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(this.editorLeft, this.editorTop, this.editorLeft + 150, this.editorTop + 224, -14671840);
        context.method_49601(this.editorLeft, this.editorTop, 150, 224, -11513776);
        context.method_51433(this.field_22793, "Command", this.editorLeft + 7, this.editorTop + 7, -6250336, false);
        this.commandTextField.method_46421(this.editorLeft + 7);
        this.commandTextField.method_46419(this.editorTop + 19);
        this.commandTextField.method_25394(context, mouseX, mouseY, delta);
        context.method_51433(this.field_22793, "Background Style", this.editorLeft + 7, this.editorTop + 40, -6250336, false);
        for (int i = 0; i < 5; ++i) {
            int bx = this.editorLeft + 7 + i * 20;
            int by = this.editorTop + 52;
            context.method_25290(class_1921::method_62276, BUTTONS_TEXTURE, bx, by, (float)(i * 18), 0.0f, 18, 18, 90, 36);
            if (this.editingButton.backgroundIndex != i) continue;
            context.method_49601(bx - 1, by - 1, 20, 20, -16711936);
        }
        int filterY = this.editorTop + 75;
        int btnHeight = 20;
        int totalWidth = 136;
        int btnWidth = totalWidth / FilterMode.values().length;
        for (int i = 0; i < FilterMode.values().length; ++i) {
            FilterMode mode = FilterMode.values()[i];
            int bx = this.editorLeft + 7 + i * btnWidth;
            boolean isActive = this.currentMode == mode;
            int bgColor = isActive ? -10461088 : -13619152;
            int borderColor = isActive ? -1 : -11513776;
            context.method_25294(bx, filterY, bx + btnWidth, filterY + btnHeight, bgColor);
            context.method_49601(bx, filterY, btnWidth, btnHeight, borderColor);
            context.method_51427(mode.icon, bx + (btnWidth - 16) / 2, filterY + (btnHeight - 16) / 2);
        }
        context.method_51433(this.field_22793, "Search Icon", this.editorLeft + 7, this.editorTop + 100, -6250336, false);
        this.iconTextField.method_46421(this.editorLeft + 7);
        this.iconTextField.method_46419(this.editorTop + 112);
        this.iconTextField.method_25394(context, mouseX, mouseY, delta);
        int listY = this.editorTop + 135;
        int listH = 82;
        if (this.currentMode == FilterMode.SKULLS) {
            String infoText = "Add Skull by ID";
            int titleX = this.editorLeft + 7;
            int titleY = this.editorTop + 135;
            context.method_51433(this.field_22793, infoText, titleX, titleY, -6250336, false);
            int iconSize = 10;
            int infoIconX = titleX + this.field_22793.method_1727(infoText) + 5;
            int infoIconY = titleY - 1;
            context.method_25290(class_1921::method_62277, INFO_ICON_TEXTURE, infoIconX, infoIconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            if (mouseX >= infoIconX && mouseX < infoIconX + iconSize && mouseY >= infoIconY && mouseY < infoIconY + iconSize) {
                context.method_25294(infoIconX, infoIconY, infoIconX + iconSize, infoIconY + iconSize, 0x40FFFFFF);
            }
            this.addSkullField.method_46421(this.editorLeft + 7);
            this.addSkullField.method_46419(this.editorTop + 147);
            this.addSkullField.method_25394(context, mouseX, mouseY, delta);
            listY = this.editorTop + 170;
            listH = 47;
        }
        this.renderIconList(context, mouseX, mouseY, listY, listH);
    }

    private void renderSkullInfoPanel(class_332 context, int mouseX, int mouseY) {
        String[] steps;
        int panelW = 150;
        int panelH = 190;
        int panelX = 10;
        int panelY = (this.field_22790 - panelH) / 2;
        context.method_25294(panelX, panelY, panelX + panelW, panelY + panelH, -14671840);
        context.method_49601(panelX, panelY, panelW, panelH, -11513776);
        int closeSize = 10;
        int closeX = panelX + panelW - closeSize - 4;
        int closeY = panelY + 4;
        if (mouseX >= closeX && mouseX <= closeX + closeSize && mouseY >= closeY && mouseY <= closeY + closeSize) {
            context.method_25294(closeX, closeY, closeX + closeSize, closeY + closeSize, -65536);
        } else {
            context.method_25294(closeX, closeY, closeX + closeSize, closeY + closeSize, -3407872);
        }
        context.method_25300(this.field_22793, "x", closeX + closeSize / 2, closeY + 1, -1);
        int textX = panelX + 8;
        int textY = panelY + 8;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"How to find Skull IDs").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), textX, textY, -1);
        textY += 18;
        for (String step : steps = new String[]{"1. Go to a site like minecraft-heads.com", "2. Find and select a head.", "3. Look for the 'Texture URL' or 'Minecraft-URL' section.", "4. Copy only the long alphanumeric string at the very end of the URL.", "5. Paste it into the 'Add Skull ID' field preceded by 'skull:'.", "   Example: skull:a6cc4..."}) {
            List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)step), panelW - 16);
            for (class_5481 line : lines) {
                context.method_51430(this.field_22793, line, textX, textY, -6250336, false);
                Objects.requireNonNull(this.field_22793);
                textY += 9 + 2;
            }
            textY += 4;
        }
    }

    private void renderIconList(class_332 context, int mouseX, int mouseY, int listY, int listH) {
        int visibleRows;
        int totalRows;
        int listX = this.editorLeft + 7;
        int listW = 136;
        context.method_25294(listX, listY, listX + listW, listY + listH, -15724528);
        context.method_44379(listX, listY, listX + listW, listY + listH);
        this.itemScroll.tick();
        int cols = 6;
        int scroll = this.itemScroll.getValue();
        int startIndex = scroll / 20 * cols;
        int endIndex = Math.min(startIndex + 42, this.searchedIcons.size());
        IconResult resultToTooltip = null;
        for (int i = startIndex; i < endIndex && i < this.searchedIcons.size(); ++i) {
            IconResult result = this.searchedIcons.get(i);
            int col = (i - startIndex) % cols;
            int row = (i - startIndex) / cols;
            int ix = listX + 2 + col * 20;
            int iy = listY + 2 + row * 20 - scroll % 20;
            result.render(context, ix, iy);
            if (mouseX < ix || mouseX >= ix + 18 || mouseY < iy || mouseY >= iy + 18) continue;
            context.method_25294(ix, iy, ix + 18, iy + 18, 0x40FFFFFF);
            resultToTooltip = result;
        }
        context.method_44380();
        if (resultToTooltip != null) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)resultToTooltip.getDisplayName()), mouseX, mouseY);
        }
        if ((totalRows = (int)Math.ceil((double)this.searchedIcons.size() / (double)cols)) > (visibleRows = listH / 20)) {
            int barHeight;
            float ratio = (float)scroll / (float)((totalRows - visibleRows) * 20);
            if (ratio > 1.0f) {
                ratio = 1.0f;
            }
            if ((barHeight = (int)((float)listH * ((float)visibleRows / (float)totalRows))) < 10) {
                barHeight = 10;
            }
            int barY = listY + (int)((float)(listH - barHeight) * ratio);
            context.method_25294(listX + listW - 2, barY, listX + listW, barY + barHeight, -8355712);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(String query) {
        this.searchedIcons.clear();
        String lower = query.toLowerCase().trim();
        if (this.currentMode == FilterMode.ALL || this.currentMode == FilterMode.SKULLS) {
            for (Map.Entry<String, String> entry : SKULL_ICONS.entrySet()) {
                if (!entry.getKey().toLowerCase().contains(lower)) continue;
                class_1799 skullStack = InventoryButtons.CustomButtonData.getSkullStack(entry.getValue());
                skullStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)entry.getKey()));
                this.searchedIcons.add(new ItemStackResult(skullStack));
            }
            Iterator iterator = HypixelItemManager.SKULL_ITEMS;
            synchronized (iterator) {
                for (HypixelItemManager.HypixelItem hItem : HypixelItemManager.SKULL_ITEMS) {
                    if (!hItem.name().toLowerCase().contains(lower)) continue;
                    this.searchedIcons.add(new HypixelResult(hItem));
                }
            }
        }
        if (this.currentMode == FilterMode.ALL || this.currentMode == FilterMode.MISC) {
            for (Map.Entry<String, class_2960> entry : InventoryButtons.CUSTOM_TEXTURES.entrySet()) {
                if (!entry.getKey().toLowerCase().contains(lower)) continue;
                this.searchedIcons.add(new TextureResult(entry.getKey(), entry.getValue()));
            }
        }
        if (this.currentMode == FilterMode.ALL || this.currentMode == FilterMode.ITEMS || this.currentMode == FilterMode.BLOCKS) {
            for (class_1792 class_17922 : class_7923.field_41178) {
                class_2960 id;
                boolean isBlock = class_17922 instanceof class_1747;
                if (this.currentMode == FilterMode.BLOCKS && !isBlock || this.currentMode == FilterMode.ITEMS && isBlock || !(id = class_7923.field_41178.method_10221((Object)class_17922)).toString().contains(lower) && !class_17922.method_63680().getString().toLowerCase().contains(lower)) continue;
                this.searchedIcons.add(new ItemStackResult(new class_1799((class_1935)class_17922)));
                if (this.searchedIcons.size() <= 500 || lower.isEmpty()) continue;
                break;
            }
        }
        this.searchedIcons.sort(Comparator.comparing(r -> {
            String name = r.getDisplayName().toLowerCase();
            return name.startsWith(lower) ? 0 : 1;
        }).thenComparingInt(r -> r instanceof HypixelResult ? 1 : 0).thenComparing(r -> r.getDisplayName().toLowerCase()));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isSavePanelOpen) {
            int panelW = 200;
            int panelH = 100;
            int panelX = (this.field_22789 - panelW) / 2;
            int panelY = (this.field_22790 - panelH) / 2;
            int closeSize = 12;
            int closeX = panelX + panelW - closeSize - 5;
            int closeY = panelY + 5;
            if (mouseX >= (double)closeX && mouseX <= (double)(closeX + closeSize) && mouseY >= (double)closeY && mouseY <= (double)(closeY + closeSize)) {
                this.isSavePanelOpen = false;
                this.saveProfileField.method_25365(false);
                return true;
            }
            boolean fieldClicked = this.saveProfileField.method_25402(mouseX, mouseY, button);
            this.saveProfileField.method_25365(fieldClicked);
            if (fieldClicked) {
                return true;
            }
            int btnW = 60;
            int btnH = 20;
            int btnX = panelX + (panelW - btnW) / 2;
            int btnY = panelY + 65;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnW) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnH)) {
                String name = this.saveProfileField.method_1882().trim();
                if (!name.isEmpty()) {
                    InventoryButtons.saveProfile(name);
                    this.actionStatusText = "Saved: " + name;
                    this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
                    this.isSavePanelOpen = false;
                    this.saveProfileField.method_1852("");
                }
                return true;
            }
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                return true;
            }
            return true;
        }
        int btnH = 20;
        int spacing = 5;
        int startX = 10;
        int startY = 10;
        int saveW = 100;
        int saveY = startY;
        int exportW = 50;
        int exportY = saveY + btnH + spacing;
        int importW = 50;
        int importY = exportY + btnH + spacing;
        if (mouseX >= (double)startX && mouseX <= (double)(startX + saveW) && mouseY >= (double)saveY && mouseY <= (double)(saveY + btnH)) {
            this.isSavePanelOpen = true;
            this.saveProfileField.method_25365(true);
            return true;
        }
        if (mouseX >= (double)startX && mouseX <= (double)(startX + exportW) && mouseY >= (double)exportY && mouseY <= (double)(exportY + btnH)) {
            this.handleExport();
            return true;
        }
        if (mouseX >= (double)startX && mouseX <= (double)(startX + importW) && mouseY >= (double)importY && mouseY <= (double)(importY + btnH)) {
            this.handleImport();
            return true;
        }
        if (this.isInfoPanelOpen) {
            int panelW = 150;
            int panelH = 190;
            int panelX = 10;
            int panelY = (this.field_22790 - panelH) / 2;
            int closeSize = 10;
            int closeX = panelX + panelW - closeSize - 4;
            int closeY = panelY + 4;
            if (mouseX >= (double)closeX && mouseX <= (double)(closeX + closeSize) && mouseY >= (double)closeY && mouseY <= (double)(closeY + closeSize)) {
                this.isInfoPanelOpen = false;
                return true;
            }
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                return true;
            }
        }
        if (this.editingButton != null && this.isEditorOpen) {
            this.updateEditorCoordinates();
            int cmdY = this.editorTop + 19;
            int iconY = this.editorTop + 112;
            if (mouseX >= (double)this.editorLeft && mouseX <= (double)(this.editorLeft + 150) && mouseY >= (double)this.editorTop && mouseY <= (double)(this.editorTop + 224)) {
                int listH;
                int btnWidth;
                int index;
                boolean inCmd = mouseX >= (double)(this.editorLeft + 7) && mouseX <= (double)(this.editorLeft + 7 + this.commandTextField.method_25368()) && mouseY >= (double)cmdY && mouseY <= (double)(cmdY + this.commandTextField.method_25364());
                boolean inIcon = mouseX >= (double)(this.editorLeft + 7) && mouseX <= (double)(this.editorLeft + 7 + this.iconTextField.method_25368()) && mouseY >= (double)iconY && mouseY <= (double)(iconY + this.iconTextField.method_25364());
                boolean inSkull = false;
                if (this.currentMode == FilterMode.SKULLS) {
                    int skullTitleY = this.editorTop + 135;
                    int skullFieldY = this.editorTop + 147;
                    inSkull = mouseX >= (double)(this.editorLeft + 7) && mouseX <= (double)(this.editorLeft + 7 + this.addSkullField.method_25368()) && mouseY >= (double)skullFieldY && mouseY <= (double)(skullFieldY + this.addSkullField.method_25364());
                    int iconSize = 10;
                    int infoIconX = this.editorLeft + 7 + this.field_22793.method_1727("Add Skull by ID") + 5;
                    int infoIconY = skullTitleY - 1;
                    if (mouseX >= (double)infoIconX && mouseX < (double)(infoIconX + iconSize) && mouseY >= (double)infoIconY && mouseY < (double)(infoIconY + iconSize)) {
                        this.isInfoPanelOpen = !this.isInfoPanelOpen;
                        return true;
                    }
                }
                this.commandTextField.method_25365(inCmd);
                this.iconTextField.method_25365(inIcon);
                this.addSkullField.method_25365(inSkull);
                if (inCmd) {
                    this.commandTextField.method_25402(mouseX, mouseY, button);
                }
                if (inIcon) {
                    this.iconTextField.method_25402(mouseX, mouseY, button);
                }
                if (inSkull) {
                    this.addSkullField.method_25402(mouseX, mouseY, button);
                }
                if (mouseY >= (double)(this.editorTop + 52) && mouseY <= (double)(this.editorTop + 52 + 18)) {
                    for (int i = 0; i < 5; ++i) {
                        int bx = this.editorLeft + 7 + i * 20;
                        if (!(mouseX >= (double)bx) || !(mouseX <= (double)(bx + 18))) continue;
                        this.editingButton.backgroundIndex = i;
                        return true;
                    }
                }
                int filterY = this.editorTop + 75;
                int btnHeight = 20;
                if (mouseY >= (double)filterY && mouseY <= (double)(filterY + btnHeight) && (index = (int)((mouseX - (double)(this.editorLeft + 7)) / (double)(btnWidth = 136 / FilterMode.values().length))) >= 0 && index < FilterMode.values().length) {
                    this.currentMode = FilterMode.values()[index];
                    this.search(this.iconTextField.method_1882());
                    this.itemScroll.setTarget(0);
                    return true;
                }
                int listY = this.currentMode == FilterMode.SKULLS ? this.editorTop + 170 : this.editorTop + 135;
                int n = listH = this.currentMode == FilterMode.SKULLS ? 47 : 82;
                if (mouseY >= (double)listY && mouseY <= (double)(listY + listH)) {
                    this.handleListClick(mouseX, mouseY);
                    return true;
                }
                return true;
            }
        }
        for (InventoryButtons.CustomButtonData btn : InventoryButtons.instance.buttons) {
            int x = this.guiLeft + btn.x;
            int y = this.guiTop + btn.y;
            if (btn.anchorRight) {
                x += 176;
            }
            if (btn.anchorBottom) {
                y += 166;
            }
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
            if (this.editingButton != btn) {
                this.editingButton = btn;
                this.isEditorOpen = false;
                this.commandTextField.method_25365(false);
                this.iconTextField.method_25365(false);
                this.addSkullField.method_25365(false);
                this.isInfoPanelOpen = false;
            } else if (!this.isEditorOpen) {
                this.isEditorOpen = true;
                if (!btn.command.startsWith("/")) {
                    btn.command = "/" + btn.command;
                }
                this.commandTextField.method_1852(btn.command);
                this.commandTextField.method_1883(btn.command.length(), false);
                this.commandTextField.method_25365(true);
                this.iconTextField.method_25365(false);
                this.addSkullField.method_25365(false);
                if (btn.itemId.startsWith("skull:")) {
                    this.addSkullField.method_1852(btn.itemId);
                } else {
                    this.addSkullField.method_1852("");
                }
                this.currentMode = FilterMode.ALL;
                this.search(this.iconTextField.method_1882());
            }
            this.isDragging = true;
            this.dragOffsetX = (int)mouseX - x;
            this.dragOffsetY = (int)mouseY - y;
            return true;
        }
        if (button == 1) {
            int relX = (int)mouseX - this.guiLeft;
            int relY = (int)mouseY - this.guiTop;
            InventoryButtons.CustomButtonData newBtn = new InventoryButtons.CustomButtonData(relX, relY, "/cmd", "minecraft:stone");
            InventoryButtons.instance.buttons.add(newBtn);
            this.editingButton = newBtn;
            this.isEditorOpen = true;
            this.commandTextField.method_1852(newBtn.command);
            this.commandTextField.method_25365(true);
            this.isDragging = true;
            this.dragOffsetX = 9;
            this.dragOffsetY = 9;
            this.currentMode = FilterMode.ALL;
            this.search("");
            this.isInfoPanelOpen = false;
            return true;
        }
        this.editingButton = null;
        this.isDragging = false;
        this.isEditorOpen = false;
        this.isInfoPanelOpen = false;
        return super.method_25402(mouseX, mouseY, button);
    }

    private void handleListClick(double mouseX, double mouseY) {
        int index;
        int listX = this.editorLeft + 7;
        int listY = this.currentMode == FilterMode.SKULLS ? this.editorTop + 170 : this.editorTop + 135;
        int cols = 6;
        int scroll = this.itemScroll.getValue();
        int startIndex = scroll / 20 * cols;
        int relativeY = (int)mouseY - listY + scroll % 20;
        int relativeX = (int)mouseX - listX - 2;
        int col = relativeX / 20;
        int row = relativeY / 20;
        if (col >= 0 && col < cols && row >= 0 && (index = startIndex + row * cols + col) >= 0 && index < this.searchedIcons.size()) {
            String id;
            this.editingButton.itemId = id = this.searchedIcons.get(index).getConfigId();
            if (id.startsWith("skull:")) {
                this.addSkullField.method_1852(id);
            }
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isOverlapping(int x, int y) {
        for (InventoryButtons.CustomButtonData btn : InventoryButtons.instance.buttons) {
            if (btn == this.editingButton || Math.abs(btn.x - x) >= 18 || Math.abs(btn.y - y) >= 18) continue;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging && this.editingButton != null) {
            int newScreenX = (int)mouseX - this.dragOffsetX;
            int newScreenY = (int)mouseY - this.dragOffsetY;
            int relativeX = newScreenX - this.guiLeft;
            int relativeY = newScreenY - this.guiTop;
            if (this.editingButton.anchorRight) {
                relativeX -= 176;
            }
            if (this.editingButton.anchorBottom) {
                relativeY -= 166;
            }
            int proposedX = this.editingButton.x;
            int proposedY = this.editingButton.y;
            if (this.localGridSnap) {
                boolean isOutsideY;
                boolean isOutsideX = relativeX < 0 || relativeX > 158;
                boolean bl = isOutsideY = relativeY < 0 || relativeY > 148;
                if (!isOutsideX && !isOutsideY) {
                    if (relativeY < 80) {
                        Point bestMatch = null;
                        double closestDistSq = Double.MAX_VALUE;
                        for (Point p : INVENTORY_FIXED_SLOTS) {
                            double distSq = Math.pow(relativeX - p.x, 2.0) + Math.pow(relativeY - p.y, 2.0);
                            if (!(distSq < closestDistSq)) continue;
                            closestDistSq = distSq;
                            bestMatch = p;
                        }
                        if (bestMatch != null) {
                            proposedX = bestMatch.x;
                            proposedY = bestMatch.y;
                        }
                    } else {
                        Point bestMatch = null;
                        double closestDistSq = Double.MAX_VALUE;
                        for (Point p : INVENTORY_FIXED_SLOTS) {
                            double distSq = Math.pow(relativeX - p.x, 2.0) + Math.pow(relativeY - p.y, 2.0);
                            if (!(distSq < closestDistSq)) continue;
                            closestDistSq = distSq;
                            bestMatch = p;
                        }
                        if (bestMatch != null) {
                            proposedX = bestMatch.x;
                            proposedY = bestMatch.y;
                        }
                    }
                } else {
                    if (relativeX < 0) {
                        col = (relativeX + 2) / 20;
                        proposedX = -20 + col * 20;
                    } else if (relativeX > 158) {
                        col = (relativeX - 176 + 2) / 20;
                        proposedX = 178 + col * 20;
                    } else if (isOutsideY) {
                        col = Math.round((float)(relativeX - 8) / 20.0f);
                        proposedX = 8 + col * 20;
                    }
                    if (relativeY < 0) {
                        row = (relativeY + 2) / 20;
                        proposedY = -20 + row * 20;
                    } else if (relativeY > 148) {
                        row = (relativeY - 166 + 2) / 20;
                        proposedY = 168 + row * 20;
                    } else if (isOutsideX) {
                        row = Math.round((float)(relativeY - 2) / 20.0f);
                        proposedY = 2 + row * 20;
                    }
                }
            } else {
                boolean insideLeftZone;
                proposedX = relativeX;
                proposedY = relativeY;
                boolean insideBottomZone = relativeX + 18 > 0 && relativeX < 176 && relativeY + 18 > 83 && relativeY < 166;
                boolean bl = insideLeftZone = relativeX + 18 > 0 && relativeX < 26 && relativeY + 18 > 7 && relativeY < 83;
                if (insideBottomZone || insideLeftZone) {
                    Point bestMatch = null;
                    double closestDistSq = Double.MAX_VALUE;
                    for (Point p : INVENTORY_FIXED_SLOTS) {
                        double distSq = Math.pow(relativeX - p.x, 2.0) + Math.pow(relativeY - p.y, 2.0);
                        if (!(distSq < closestDistSq)) continue;
                        closestDistSq = distSq;
                        bestMatch = p;
                    }
                    if (bestMatch != null) {
                        proposedX = bestMatch.x;
                        proposedY = bestMatch.y;
                    }
                }
            }
            if (!this.isOverlapping(proposedX, proposedY)) {
                this.editingButton.x = proposedX;
                this.editingButton.y = proposedY;
                this.updateEditorCoordinates();
            }
            return true;
        }
        if (this.editingButton != null && this.isEditorOpen && mouseX >= (double)this.editorLeft && mouseX <= (double)(this.editorLeft + 150)) {
            int scroll = (int)(-deltaY * 10.0);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.editingButton != null && this.isEditorOpen && mouseX >= (double)this.editorLeft && mouseX <= (double)(this.editorLeft + 150)) {
            int scroll = (int)(-verticalAmount * 10.0);
            int target = this.itemScroll.getTarget() + scroll;
            int totalRows = (int)Math.ceil((double)this.searchedIcons.size() / 6.0);
            int listH = this.currentMode == FilterMode.SKULLS ? 47 : 82;
            int visibleRows = listH / 20;
            int maxScroll = Math.max(0, (totalRows - visibleRows) * 20);
            if (target < 0) {
                target = 0;
            }
            if (target > maxScroll) {
                target = maxScroll;
            }
            this.itemScroll.setTarget(target);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean inputsFocused;
        boolean bl = inputsFocused = this.isEditorOpen && (this.commandTextField.method_25370() || this.iconTextField.method_25370() || this.addSkullField.method_25370());
        if (keyCode == 83 && !inputsFocused) {
            this.localGridSnap = !this.localGridSnap;
            return true;
        }
        if (this.isSavePanelOpen) {
            if (keyCode == 256) {
                this.isSavePanelOpen = false;
                this.saveProfileField.method_25365(false);
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                String name = this.saveProfileField.method_1882().trim();
                if (!name.isEmpty()) {
                    InventoryButtons.saveProfile(name);
                    this.actionStatusText = "Saved: " + name;
                    this.actionStatusEndTime = System.currentTimeMillis() + 3000L;
                    this.isSavePanelOpen = false;
                    this.saveProfileField.method_1852("");
                }
                return true;
            }
            if (this.saveProfileField.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.editingButton != null) {
            if (this.isEditorOpen) {
                if (this.commandTextField.method_25370()) {
                    if (keyCode == 259) {
                        String txt = this.commandTextField.method_1882();
                        int cursor = this.commandTextField.method_1881();
                        if (txt.equals("/") || cursor <= 1 && this.commandTextField.method_1866().isEmpty()) {
                            return true;
                        }
                    }
                    return this.commandTextField.method_25404(keyCode, scanCode, modifiers);
                }
                if (this.iconTextField.method_25370()) {
                    return this.iconTextField.method_25404(keyCode, scanCode, modifiers);
                }
                if (this.addSkullField.method_25370()) {
                    return this.addSkullField.method_25404(keyCode, scanCode, modifiers);
                }
            }
            if (!(keyCode != 261 && keyCode != 259 || this.isEditorOpen && (this.commandTextField.method_25370() || this.iconTextField.method_25370() || this.addSkullField.method_25370()))) {
                InventoryButtons.instance.buttons.remove(this.editingButton);
                this.editingButton = null;
                this.isDragging = false;
                this.isEditorOpen = false;
                this.isInfoPanelOpen = false;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.isSavePanelOpen) {
            if (this.saveProfileField.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }
        if (this.editingButton != null && this.isEditorOpen) {
            if (this.commandTextField.method_25370() && this.commandTextField.method_25400(chr, modifiers)) {
                return true;
            }
            if (this.iconTextField.method_25370() && this.iconTextField.method_25400(chr, modifiers)) {
                this.search(this.iconTextField.method_1882());
                return true;
            }
            if (this.addSkullField.method_25370() && this.addSkullField.method_25400(chr, modifiers)) {
                return true;
            }
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25419() {
        InventoryButtons.save();
        if (this.parent != null) {
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    static {
        INVENTORY_FIXED_SLOTS.add(new Point(25, 8));
        INVENTORY_FIXED_SLOTS.add(new Point(57, 8));
        INVENTORY_FIXED_SLOTS.add(new Point(25, 60));
        INVENTORY_FIXED_SLOTS.add(new Point(57, 60));
        INVENTORY_FIXED_SLOTS.add(new Point(97, 17));
        INVENTORY_FIXED_SLOTS.add(new Point(115, 17));
        INVENTORY_FIXED_SLOTS.add(new Point(97, 35));
        INVENTORY_FIXED_SLOTS.add(new Point(115, 35));
        INVENTORY_FIXED_SLOTS.add(new Point(152, 27));
        INVENTORY_FIXED_SLOTS.add(new Point(98, 61));
        INVENTORY_FIXED_SLOTS.add(new Point(116, 61));
        INVENTORY_FIXED_SLOTS.add(new Point(134, 61));
        INVENTORY_FIXED_SLOTS.add(new Point(152, 61));
        SKULL_ICONS = new HashMap<String, String>();
        SKULL_ICONS.put("Personal Bank", "skull:e36e94f6c34a35465fce4a90f2e25976389eb9709a12273574ff70fd4daa6852");
        SKULL_ICONS.put("Skyblock Hub", "skull:d7cc6687423d0570d556ac53e0676cb563bbdd9717cd8269bdebed6f6d4e7bf8");
        SKULL_ICONS.put("Private Island", "skull:c9c8881e42915a9d29bb61a16fb26d059913204d265df5b439b3d792acd56");
        SKULL_ICONS.put("Castle", "skull:f4559d75464b2e40a518e4de8e6cf3085f0a3ca0b1b7012614c4cd96fed60378");
        SKULL_ICONS.put("Sirius Shack", "skull:7ab83858ebc8ee85c3e54ab13aabfcc1ef2ad446d6a900e471c3f33b78906a5b");
        SKULL_ICONS.put("Crypts", "skull:25d2f31ba162fe6272e831aed17f53213db6fa1c4cbe4fc827f3963cc98b9");
        SKULL_ICONS.put("Spiders Den", "skull:c754318a3376f470e481dfcd6c83a59aa690ad4b4dd7577fdad1c2ef08d8aee6");
        SKULL_ICONS.put("Top Of The Nest", "skull:9d7e3b19ac4f3dee9c5677c135333b9d35a7f568b63d1ef4ada4b068b5a25");
        SKULL_ICONS.put("The End", "skull:7840b87d52271d2a755dedc82877e0ed3df67dcc42ea479ec146176b02779a5");
        SKULL_ICONS.put("The End Dragons Nest", "skull:a1cd6d2d03f135e7c6b5d6cdae1b3a68743db4eb749faf7341e9fb347aa283b");
        SKULL_ICONS.put("The Park", "skull:a221f813dacee0fef8c59f76894dbb26415478d9ddfc44c2e708a6d3b7549b");
        SKULL_ICONS.put("The Park Jungle", "skull:79ca3540621c1c79c32bf42438708ff1f5f7d0af9b14a074731107edfeb691c");
        SKULL_ICONS.put("The Park Howling Cave", "skull:1832d53997b451635c9cf9004b0f22bb3d99ab5a093942b5b5f6bb4e4de47065");
        SKULL_ICONS.put("Gold Mines", "skull:73bc965d579c3c6039f0a17eb7c2e6faf538c7a5de8e60ec7a719360d0a857a9");
        SKULL_ICONS.put("Deep Caverns", "skull:569a1f114151b4521373f34bc14c2963a5011cdc25a6554c48c708cd96ebfc");
        SKULL_ICONS.put("The Barn", "skull:4d3a6bd98ac1833c664c4909ff8d2dc62ce887bdcf3cc5b3848651ae5af6b");
        SKULL_ICONS.put("Mushroom Desert", "skull:6b20b23c1aa2be0270f016b4c90d6ee6b8330a17cfef87869d6ad60b2ffbf3b5");
        SKULL_ICONS.put("Dungeon Hub", "skull:9b56895b9659896ad647f58599238af532d46db9c1b0389b8bbeb70999dab33d");
        SKULL_ICONS.put("Dwarven Mines", "skull:51539dddf9ed255ece6348193cd75012c82c93aec381f05572cecf7379711b3b");
        SKULL_ICONS.put("HOTM Heart Of The Mountain", "skull:86f06eaa3004aeed09b3d5b45d976de584e691c0e9cade133635de93d23b9edb");
        SKULL_ICONS.put("Bazaar Dude", "skull:c232e3820897429157619b0ee099fec0628f602fff12b695de54aef11d923ad7");
        SKULL_ICONS.put("Museum", "skull:438cf3f8e54afc3b3f91d20a49f324dca1486007fe545399055524c17941f4dc");
        SKULL_ICONS.put("Crystal Hollows", "skull:21dbe30b027acbceb612563bd877cd7ebb719ea6ed1399027dcee58bb9049d4a");
        SKULL_ICONS.put("Dwarven Forge", "skull:5cbd9f5ec1ed007259996491e69ff649a3106cf920227b1bb3a71ee7a89863f");
        SKULL_ICONS.put("Forgotton Skull", "skull:6becc645f129c8bc2faa4d8145481fab11ad2ee75749d628dcd999aa94e7");
        SKULL_ICONS.put("Crystal Nucleus", "skull:34d42f9c461cee1997b67bf3610c6411bf852b9e5db607bbf626527cfb42912c");
        SKULL_ICONS.put("Void Sepulture", "skull:eb07594e2df273921a77c101d0bfdfa1115abed5b9b2029eb496ceba9bdbb4b3");
        SKULL_ICONS.put("Crimson Isle", "skull:c3687e25c632bce8aa61e0d64c24e694c3eea629ea944f4cf30dcfb4fbce071");
        SKULL_ICONS.put("Trapper Den", "skull:6102f82148461ced1f7b62e326eb2db3a94a33cba81d4281452af4d8aeca4991");
        SKULL_ICONS.put("Arachne Sanctuary", "skull:35e248da2e108f09813a6b848a0fcef111300978180eda41d3d1a7a8e4dba3c3");
        SKULL_ICONS.put("Garden", "skull:f4880d2c1e7b86e87522e20882656f45bafd42f94932b2c5e0d6ecaa490cb4c");
        SKULL_ICONS.put("Winter", "skull:6dd663136cafa11806fdbca6b596afd85166b4ec02142c8d5ac8941d89ab7");
        SKULL_ICONS.put("Wizard Tower", "skull:838564e28aba98301dbda5fafd86d1da4e2eaeef12ea94dcf440b883e559311c");
        SKULL_ICONS.put("Dwarven Mines Base Camp", "skull:2461ec3bd654f62ca9a393a32629e21b4e497c877d3f3380bcf2db0e20fc0244");
    }

    @Environment(value=EnvType.CLIENT)
    private static enum FilterMode {
        ALL(class_1802.field_8529),
        ITEMS(class_1802.field_8802),
        BLOCKS(class_1802.field_8542),
        SKULLS(class_1802.field_8398),
        MISC(class_1802.field_8550);

        final class_1799 icon;

        private FilterMode(class_1792 item) {
            this.icon = new class_1799((class_1935)item);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class LerpingInteger {
        private int value;
        private int target;

        public LerpingInteger(int value, int target) {
            this.value = value;
            this.target = target;
        }

        public void tick() {
            if (this.value != this.target) {
                int diff = this.target - this.value;
                int change = diff / 5;
                if (change == 0) {
                    change = diff > 0 ? 1 : -1;
                }
                this.value += change;
            }
        }

        public int getValue() {
            return this.value;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int t) {
            this.target = t;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static interface IconResult {
        public void render(class_332 var1, int var2, int var3);

        public String getDisplayName();

        public String getConfigId();
    }

    @Environment(value=EnvType.CLIENT)
    private record ItemStackResult(class_1799 stack) implements IconResult
    {
        @Override
        public void render(class_332 context, int x, int y) {
            context.method_51427(this.stack, x, y);
        }

        @Override
        public String getDisplayName() {
            return this.stack.method_7964().getString();
        }

        @Override
        public String getConfigId() {
            String name;
            if (this.stack.method_7909() == class_1802.field_8575 && SKULL_ICONS.containsKey(name = this.stack.method_7964().getString())) {
                return SKULL_ICONS.get(name);
            }
            return class_7923.field_41178.method_10221((Object)this.stack.method_7909()).toString();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record HypixelResult(HypixelItemManager.HypixelItem item) implements IconResult
    {
        @Override
        public void render(class_332 context, int x, int y) {
            context.method_51427(this.item.iconStack(), x, y);
        }

        @Override
        public String getDisplayName() {
            return this.item.name();
        }

        @Override
        public String getConfigId() {
            return this.item.configId();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record TextureResult(String name, class_2960 textureId) implements IconResult
    {
        @Override
        public void render(class_332 context, int x, int y) {
            context.method_25290(class_1921::method_62277, this.textureId, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public String getConfigId() {
            return this.textureId.toString();
        }
    }
}

