/*
 * Decompiled with CFR 0.152.
 */
package com.panda.inventorybuttons.gui;

import com.panda.inventorybuttons.gui.GuiInvButtonConfig;
import com.panda.inventorybuttons.gui.GuiInvButtonEditor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class GuiInvButtonMenu
extends class_437 {
    private final List<MenuButton> menuButtons = new ArrayList<MenuButton>();

    public GuiInvButtonMenu() {
        super((class_2561)class_2561.method_43470((String)"Inventory Buttons"));
    }

    protected void method_25426() {
        this.menuButtons.clear();
        int btnWidth = 200;
        int btnHeight = 20;
        int spacing = 24;
        int startY = this.field_22790 / 4 + 40;
        int centerX = this.field_22789 / 2 - btnWidth / 2;
        this.menuButtons.add(new MenuButton(centerX, startY, btnWidth, btnHeight, "Config", () -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new GuiInvButtonConfig(this));
            }
        }));
        this.menuButtons.add(new MenuButton(centerX, startY + spacing, btnWidth, btnHeight, "Edit Buttons", () -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new GuiInvButtonEditor(this));
            }
        }));
        this.menuButtons.add(new MenuButton(centerX, startY + spacing * 2, btnWidth, btnHeight, "Open Config Folder", () -> {
            Path configDir = FabricLoader.getInstance().getConfigDir().resolve("inventorybuttons");
            File file = configDir.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            class_156.method_668().method_672(file);
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.field_22789 / 2.0f, 60.0f, 0.0f);
        float scale = 2.0f;
        context.method_51448().method_22905(scale, scale, 1.0f);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int n = -titleWidth / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_51439(this.field_22793, this.field_22785, n, -9 / 2, -1, true);
        context.method_51448().method_22909();
        for (MenuButton btn : this.menuButtons) {
            boolean isHovered = mouseX >= btn.x && mouseX < btn.x + btn.width && mouseY >= btn.y && mouseY < btn.y + btn.height;
            int color = isHovered ? -1610612736 : Integer.MIN_VALUE;
            context.method_25294(btn.x, btn.y, btn.x + btn.width, btn.y + btn.height, color);
            int textWidth = this.field_22793.method_1727(btn.label);
            int textX = btn.x + (btn.width - textWidth) / 2;
            int n2 = btn.y;
            int n3 = btn.height;
            Objects.requireNonNull(this.field_22793);
            int textY = n2 + (n3 - 9) / 2;
            context.method_51433(this.field_22793, btn.label, textX, textY, -1, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (MenuButton btn : this.menuButtons) {
                if (!(mouseX >= (double)btn.x) || !(mouseX < (double)(btn.x + btn.width)) || !(mouseY >= (double)btn.y) || !(mouseY < (double)(btn.y + btn.height))) continue;
                if (this.field_22787 != null) {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                btn.action.run();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    private record MenuButton(int x, int y, int width, int height, String label, Runnable action) {
    }
}

