/*
 * Decompiled with CFR 0.152.
 */
package com.panda.inventorybuttons.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.panda.inventorybuttons.InventoryButtons;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class HypixelItemManager {
    public static final List<HypixelItem> SKULL_ITEMS = new ArrayList<HypixelItem>();
    private static boolean loaded = false;
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("%%.*?%%");

    public static void loadAsync() {
        if (loaded) {
            return;
        }
        loaded = true;
        CompletableFuture.runAsync(() -> {
            try {
                InventoryButtons.LOGGER.info("Fetching Hypixel Skyblock items...");
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.hypixel.net/v2/resources/skyblock/items")).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    HypixelItemManager.parseItems(response.body());
                    InventoryButtons.LOGGER.info("Loaded " + SKULL_ITEMS.size() + " skulls from Hypixel.");
                } else {
                    InventoryButtons.LOGGER.error("Failed to fetch Hypixel items: HTTP " + response.statusCode());
                }
            }
            catch (Exception e) {
                InventoryButtons.LOGGER.error("Error loading Hypixel items", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseItems(String json) {
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            if (!root.has("items")) {
                return;
            }
            JsonArray items = root.getAsJsonArray("items");
            for (JsonElement el : items) {
                if (!el.isJsonObject()) continue;
                try {
                    String hash;
                    JsonObject skinObj;
                    JsonObject obj = el.getAsJsonObject();
                    String rawName = HypixelItemManager.getSafeString(obj, "name", "Unknown");
                    String name = HypixelItemManager.cleanName(rawName);
                    String id = HypixelItemManager.getSafeString(obj, "id", "UNKNOWN_ID");
                    String material = HypixelItemManager.getSafeString(obj, "material", "STONE");
                    if (!material.equals("SKULL_ITEM") && !material.equals("PLAYER_HEAD") || !obj.has("skin")) continue;
                    String skinBase64 = null;
                    JsonElement skinEl = obj.get("skin");
                    if (skinEl.isJsonPrimitive()) {
                        skinBase64 = skinEl.getAsString();
                    } else if (skinEl.isJsonObject() && (skinObj = skinEl.getAsJsonObject()).has("value")) {
                        skinBase64 = skinObj.get("value").getAsString();
                    }
                    if (skinBase64 == null || (hash = HypixelItemManager.extractHash(skinBase64)) == null) continue;
                    String configId = "skull:" + hash;
                    class_1799 stack = InventoryButtons.CustomButtonData.getSkullStack(configId);
                    stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
                    List<HypixelItem> list = SKULL_ITEMS;
                    synchronized (list) {
                        SKULL_ITEMS.add(new HypixelItem(name, id, stack, configId));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            InventoryButtons.LOGGER.error("Error parsing Hypixel items JSON", (Throwable)e);
        }
    }

    private static String cleanName(String name) {
        if (name == null) {
            return "";
        }
        return COLOR_CODE_PATTERN.matcher(name).replaceAll("").trim();
    }

    private static String getSafeString(JsonObject obj, String key, String def) {
        JsonElement el;
        if (obj.has(key) && (el = obj.get(key)).isJsonPrimitive()) {
            return el.getAsString();
        }
        return def;
    }

    private static String extractHash(String base64) {
        try {
            String json = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
            int urlIndex = json.indexOf("http://textures.minecraft.net/texture/");
            if (urlIndex == -1) {
                return null;
            }
            int hashStart = urlIndex + "http://textures.minecraft.net/texture/".length();
            int hashEnd = json.indexOf("\"", hashStart);
            if (hashEnd == -1) {
                hashEnd = json.length();
            }
            return json.substring(hashStart, hashEnd);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record HypixelItem(String name, String id, class_1799 iconStack, String configId) {
    }
}

