/*
 * Decompiled with CFR 0.152.
 */
package com.kleiders.kleidersplayerrenderer;

import com.kleiders.kleidersplayerrenderer.KleidersIgnoreCancel;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KleidersEntityRenderer
extends MobRenderer
implements KleidersIgnoreCancel {
    private final ResourceLocation PLAYER_SKIN;
    public EntityModel MODEL;

    public KleidersEntityRenderer(EntityRendererProvider.Context context, ResourceLocation skin, EntityModel model) {
        this(context, skin);
        this.MODEL = model;
        this.model = model;
    }

    @Nullable
    protected RenderType getRenderType(LivingEntity p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation((Entity)p_115322_);
        return RenderType.entityTranslucent((ResourceLocation)resourcelocation);
    }

    public boolean shouldRender(Mob livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        Entity entity = livingEntityIn.getLeashHolder();
        return false;
    }

    public KleidersEntityRenderer(EntityRendererProvider.Context context, ResourceLocation skin) {
        super(context, (EntityModel)new PigModel(context.bakeLayer(ModelLayers.PIG)), 0.5f);
        this.PLAYER_SKIN = skin;
    }

    public ResourceLocation getTextureLocation(Entity entity) {
        return this.PLAYER_SKIN;
    }

    public void render(Mob entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        catch (Exception e) {
            matrixStackIn.popPose();
        }
    }

    public ResourceLocation getTextureLocation(Mob entity) {
        return this.PLAYER_SKIN;
    }
}

