/*
 * Decompiled with CFR 0.152.
 */
package com.kleiders.kleidersplayerrenderer;

import com.kleiders.kleidersplayerrenderer.KleidersIgnoreCancel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class KleidersPlayerAnimatedRenderer
extends LivingEntityRenderer<AbstractClientPlayer, EntityModel<AbstractClientPlayer>>
implements KleidersIgnoreCancel {
    private final ResourceLocation PLAYER_SKIN;

    public KleidersPlayerAnimatedRenderer(EntityRendererProvider.Context context, ResourceLocation skin, EntityModel newmodel) {
        super(context, (EntityModel)new PigModel(context.bakeLayer(ModelLayers.PIG)), 0.5f);
        this.PLAYER_SKIN = skin;
        this.model = newmodel;
    }

    @Nullable
    protected RenderType getRenderType(AbstractClientPlayer p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(p_115322_);
        return RenderType.entityTranslucentCull((ResourceLocation)resourcelocation);
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return this.PLAYER_SKIN;
    }

    public void render(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        catch (Exception e) {
            matrixStackIn.popPose();
        }
    }

    public Vec3 getRenderOffset(AbstractClientPlayer p_117785_, float p_117786_) {
        return p_117785_.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)p_117785_, p_117786_);
    }

    protected void setupRotations(AbstractClientPlayer p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.getSwimAmount(p_117806_);
        float f1 = p_117802_.getViewXRot(p_117806_);
        if (p_117802_.isFallFlying()) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f2 = (float)p_117802_.getFallFlyingTicks() + p_117806_;
            float f3 = Mth.clamp((float)(f2 * f2 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.isAutoSpinAttack()) {
                p_117803_.mulPose(Axis.XP.rotationDegrees(f3 * (-90.0f - f1)));
            }
            Vec3 vec3 = p_117802_.getViewVector(p_117806_);
            Vec3 vec31 = p_117802_.getDeltaMovementLerped(p_117806_);
            double d0 = vec31.horizontalDistanceSqr();
            double d1 = vec3.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.x * vec3.x + vec31.z * vec3.z) / Math.sqrt(d0 * d1);
                double d3 = vec31.x * vec3.z - vec31.z * vec3.x;
                p_117803_.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f4 = p_117802_.isInWater() || p_117802_.isInFluidType((fluidType, height) -> p_117802_.canSwimInFluidType(fluidType)) ? -90.0f - p_117802_.getXRot() : -90.0f;
            float f5 = Mth.lerp((float)f, (float)0.0f, (float)f4);
            p_117803_.mulPose(Axis.XP.rotationDegrees(f5));
            if (p_117802_.isVisuallySwimming()) {
                p_117803_.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
        if (ModList.get().isLoaded("playeranimator")) {
            AnimationApplier animationPlayer = ((IAnimatedPlayer)p_117802_).playerAnimator_getAnimation();
            animationPlayer.setTickDelta(p_117806_);
            if (animationPlayer.isActive()) {
                Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
                p_117803_.translate((double)((Float)vec3d.getX()).floatValue(), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)((Float)vec3d.getZ()).floatValue());
                Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
                p_117803_.mulPose(Axis.ZP.rotation(((Float)vec3f.getZ()).floatValue()));
                p_117803_.mulPose(Axis.YP.rotation(((Float)vec3f.getY()).floatValue()));
                p_117803_.mulPose(Axis.XP.rotation(((Float)vec3f.getX()).floatValue()));
                p_117803_.translate(0.0, -0.7, 0.0);
            }
        }
    }
}

