/*
 * Decompiled with CFR 0.152.
 */
package net.smartex;

import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.smartex.init.ModBlocks;
import net.smartex.init.ModItems;
import net.smartex.init.ModSounds;
import net.smartex.network.ExplosionPacket;
import net.smartex.vfx.CinemaVFX;

@Mod(value="smartex")
public class SmartEX {
    public static final String MODID = "smartex";
    private static final Random random = new Random();
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("smartex", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"smartex");
    public static final RegistryObject<CreativeModeTab> SMARTEX_TAB = CREATIVE_TABS.register("smartex_tab", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModItems.GUNPOWDER_PATH_ITEM.get())).m_257941_((Component)Component.m_237115_((String)"creativetab.smartex")).m_257501_((params, output) -> {
        output.m_246326_((ItemLike)ModItems.GUNPOWDER_PATH_ITEM.get());
        output.m_246326_((ItemLike)ModItems.SMART_LIGHTER.get());
    }).m_257652_());

    public SmartEX() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GUNPOWDER_PATH.get()), (RenderType)RenderType.m_110463_()));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CHANNEL.messageBuilder(ExplosionPacket.class, 0).encoder(ExplosionPacket::encode).decoder(ExplosionPacket::decode).consumerMainThread(ExplosionPacket::handle).add());
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 center = event.getExplosion().getPosition();
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        float extraPower = 0.0f;
        int searchRange = 4;
        for (BlockPos p : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-searchRange, -searchRange, -searchRange), (BlockPos)centerPos.m_7918_(searchRange, searchRange, searchRange))) {
            if (!level.m_8055_(p).m_60713_(Blocks.f_50077_)) continue;
            level.m_7471_(p, false);
            extraPower += 1.2f;
        }
        float totalPower = Math.min(4.0f + extraPower, 20.0f);
        level.m_5594_(null, centerPos, (SoundEvent)ModSounds.ULTRA_EXPLOSION.get(), SoundSource.BLOCKS, 4.0f, 1.0f);
        CinemaVFX.spawnUltraExplosion(serverLevel, center, totalPower);
        int fireRadius = (int)((double)totalPower * 1.2);
        for (BlockPos firePos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-fireRadius, -1, -fireRadius), (BlockPos)centerPos.m_7918_(fireRadius, 2, fireRadius))) {
            if (!((double)random.nextFloat() < 0.15)) continue;
            BlockPos upPos = firePos.m_7494_();
            if (!level.m_8055_(firePos).isFlammable((BlockGetter)level, firePos, Direction.UP) || !level.m_46859_(upPos)) continue;
            level.m_46597_(upPos, Blocks.f_50083_.m_49966_());
        }
        event.getAffectedBlocks().clear();
        int radius = (int)((double)totalPower * 1.3);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-radius, -radius, -radius), (BlockPos)centerPos.m_7918_(radius, radius, radius))) {
            double d;
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_() || state.m_60713_(Blocks.f_50752_) || !((d = Math.sqrt(pos.m_203193_((Position)center))) < (double)radius) || !(random.nextFloat() < totalPower / (float)(d * 2.0 + 1.5))) continue;
            level.m_46961_(pos, false);
            if (!((double)random.nextFloat() < 0.2)) continue;
            FallingBlockEntity debris = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            Vec3 dir = Vec3.m_82512_((Vec3i)pos).m_82546_(center).m_82541_().m_82490_(0.5);
            debris.m_20256_(dir.m_82520_(0.0, 0.4, 0.0));
            level.m_7967_((Entity)debris);
        }
        CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(center.f_82479_, center.f_82480_, center.f_82481_, 250.0, serverLevel.m_46472_())), (Object)new ExplosionPacket(center.f_82479_, center.f_82480_, center.f_82481_, totalPower));
    }
}

