/*
 * Decompiled with CFR 0.152.
 */
package net.smartex.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GunpowderPathBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public GunpowderPathBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60910_().m_60966_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return !level.m_8055_(below).m_60713_((Block)this) && level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.ignite((Level)level, pos, state);
    }

    public void ignite(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            BlockPos[] targets;
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            for (BlockPos target : targets = new BlockPos[]{pos.m_121945_(dir), pos.m_121945_(dir.m_122424_())}) {
                if (this.checkAndIgnite(level, target) || this.checkAndIgnite(level, target.m_7494_())) continue;
                this.checkAndIgnite(level, target.m_7495_());
            }
            level.m_186460_(pos, Blocks.f_50016_, 1);
        }
    }

    private boolean checkAndIgnite(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof GunpowderPathBlock) {
            level.m_186460_(pos, state.m_60734_(), 2);
            return true;
        }
        if (state.m_60713_(Blocks.f_50077_)) {
            Blocks.f_50077_.onCaughtFire(state, level, pos, null, null);
            level.m_7471_(pos, false);
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

