/*
 * Decompiled with CFR 0.152.
 */
package net.smartex.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="smartex", value={Dist.CLIENT})
public class ClientExplosionRenderer {
    private static final Random random = new Random();
    private static float shakeIntensity = 0.0f;
    private static final List<Wave> activeWaves = new ArrayList<Wave>();

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (shakeIntensity > 0.0f) {
            float noiseX = (random.nextFloat() - 0.5f) * shakeIntensity * 2.5f;
            float noiseY = (random.nextFloat() - 0.5f) * shakeIntensity * 2.5f;
            event.setPitch(event.getPitch() + noiseX);
            event.setYaw(event.getYaw() + noiseY);
            event.setRoll(event.getRoll() + (random.nextFloat() - 0.5f) * shakeIntensity * 1.5f);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && shakeIntensity > 0.0f && (shakeIntensity *= 0.92f) < 0.01f) {
            shakeIntensity = 0.0f;
        }
    }

    public static void addWave(Vec3 center, float power) {
        activeWaves.add(new Wave(center, power * 3.0f));
        shakeIntensity = Math.min(shakeIntensity + power * 0.3f, 5.0f);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            int i;
            int particleCount = (int)(power * 40.0f);
            for (i = 0; i < particleCount; ++i) {
                double angle = random.nextDouble() * Math.PI * 2.0;
                double speed = 0.5 + random.nextDouble() * ((double)power / 4.0);
                double xDir = Math.cos(angle) * speed;
                double zDir = Math.sin(angle) * speed;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, xDir, 0.1, zDir);
            }
            for (i = 0; i < particleCount / 2; ++i) {
                double xDir = (random.nextDouble() - 0.5) * 0.5;
                double zDir = (random.nextDouble() - 0.5) * 0.5;
                double yDir = 0.5 + random.nextDouble() * 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, xDir, yDir, zDir);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (activeWaves.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172811_);
        poseStack.m_85836_();
        poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        Iterator<Wave> iterator = activeWaves.iterator();
        while (iterator.hasNext()) {
            Wave wave = iterator.next();
            if (wave.isDone()) {
                iterator.remove();
                continue;
            }
            wave.tick(event.getPartialTick());
            ClientExplosionRenderer.drawSphere(poseStack, buffer, wave.center, wave.currentRadius, 1.0f, 1.0f, 1.0f, wave.getAlpha() * 0.6f);
        }
        poseStack.m_85849_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void drawSphere(PoseStack poseStack, BufferBuilder buffer, Vec3 center, float radius, float r, float g, float b, float a) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= 20; ++i) {
            double lat0 = Math.PI * (-0.5 + (double)(i - 1) / 20.0);
            double z0 = Math.sin(lat0);
            double r0 = Math.cos(lat0);
            double lat1 = Math.PI * (-0.5 + (double)i / 20.0);
            double z1 = Math.sin(lat1);
            double r1 = Math.cos(lat1);
            for (int j = 0; j <= 20; ++j) {
                double lng = Math.PI * 2 * (double)(j - 1) / 20.0;
                double x = Math.cos(lng);
                double y = Math.sin(lng);
                buffer.m_252986_(matrix, (float)(center.f_82479_ + x * r0 * (double)radius), (float)(center.f_82480_ + z0 * (double)radius), (float)(center.f_82481_ + y * r0 * (double)radius)).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, (float)(center.f_82479_ + x * r1 * (double)radius), (float)(center.f_82480_ + z1 * (double)radius), (float)(center.f_82481_ + y * r1 * (double)radius)).m_85950_(r, g, b, a).m_5752_();
            }
        }
        Tesselator.m_85913_().m_85914_();
    }

    private static class Wave {
        Vec3 center;
        float maxRadius;
        float currentRadius;
        int age;

        Wave(Vec3 center, float maxRadius) {
            this.center = center;
            this.maxRadius = maxRadius;
            this.currentRadius = 0.0f;
            this.age = 0;
        }

        void tick(float partialTick) {
            ++this.age;
            this.currentRadius = Mth.m_14179_((float)partialTick, (float)this.currentRadius, (float)(this.maxRadius * (1.0f - (float)Math.pow(0.92, this.age))));
        }

        float getAlpha() {
            return 1.0f - this.currentRadius / this.maxRadius;
        }

        boolean isDone() {
            return (double)this.currentRadius >= (double)this.maxRadius * 0.95;
        }
    }
}

