/*
 * Decompiled with CFR 0.152.
 */
package net.smartex.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.smartex.client.ClientExplosionRenderer;

public class ExplosionPacket {
    public final double x;
    public final double y;
    public final double z;
    public final float power;

    public ExplosionPacket(double x, double y, double z, float power) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
    }

    public static void encode(ExplosionPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeFloat(msg.power);
    }

    public static ExplosionPacket decode(FriendlyByteBuf buf) {
        return new ExplosionPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat());
    }

    public static void handle(ExplosionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientExplosionRenderer.addWave(new Vec3(msg.x, msg.y, msg.z), msg.power));
        ctx.get().setPacketHandled(true);
    }
}

