/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleimagerenderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.polymer.core.impl.client.InternalClientItemGroup;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.simpleimagerenderer.ClientEntityUtils;
import eu.pb4.simpleimagerenderer.PreviewScreen;
import eu.pb4.simpleimagerenderer.renderer.AbstractImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.BlockImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.EntityImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.ItemImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.RegionImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.RendererSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2267;
import net.minecraft.class_2287;
import net.minecraft.class_2300;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9380;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ModInit
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"SimpleImageRenderer");
    public static final String ID = "simple-image-renderer";
    private static final boolean POLYMER = FabricLoader.getInstance().isModLoaded("polymer-core");
    public static final Path MAIN_PATH = FabricLoader.getInstance().getGameDir().relativize(FabricLoader.getInstance().getGameDir()).resolve("simple-image-renderer");
    public static long glintTimeOverride = -1L;
    @Nullable
    public static class_276 mainRenderTargetReplacement;
    private static boolean useIdAsName;
    public static RendererSettings settings;

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 bctx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"render").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"item").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)bctx)).executes(ctx -> ModInit.renderItems((CommandContext<FabricClientCommandSource>)ctx, class_2287.method_9777((CommandContext)ctx, (String)"item").method_9781(1, false))))).then(ClientCommandManager.literal((String)"hand").executes(ctx -> ModInit.renderItems((CommandContext<FabricClientCommandSource>)ctx, ((FabricClientCommandSource)ctx.getSource()).getPlayer().method_6047())))).then(ClientCommandManager.literal((String)"creative").then(ClientCommandManager.argument((String)"id", (ArgumentType)class_2232.method_9441()).suggests(ModInit::suggestCreativeTabs).executes(ctx -> ModInit.renderItems((CommandContext<FabricClientCommandSource>)ctx, ModInit.getCreativeTabsItems((class_2960)ctx.getArgument("id", class_2960.class)))))))).then(ClientCommandManager.literal((String)"entity").then(ClientCommandManager.argument((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ModInit::renderEntity)))).then(ClientCommandManager.literal((String)"block").then(ClientCommandManager.argument((String)"state", (ArgumentType)class_2257.method_9653((class_7157)bctx)).executes(ModInit::renderBlockState)))).then(ClientCommandManager.literal((String)"area").then(ClientCommandManager.argument((String)"start", (ArgumentType)class_2262.method_9698()).then(ClientCommandManager.argument((String)"end", (ArgumentType)class_2262.method_9698()).executes(ModInit::renderArea))))).then(ClientCommandManager.literal((String)"use_id_as_name").then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ModInit::setUseIdAsName)))).then(ClientCommandManager.literal((String)"open_folder").executes(ModInit::openFolder)));
    }

    private static int openFolder(CommandContext<FabricClientCommandSource> ctx) {
        class_156.method_668().method_60932(MAIN_PATH);
        return 1;
    }

    private static int setUseIdAsName(CommandContext<FabricClientCommandSource> ctx) {
        useIdAsName = BoolArgumentType.getBool(ctx, (String)"value");
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)("text.simple_image_renderer.filename_use_" + (useIdAsName ? "id" : "display_name"))));
        return 1;
    }

    private static class_1799[] getCreativeTabsItems(class_2960 identifier) {
        if (identifier.equals((Object)class_7706.field_40206.method_29177())) {
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            for (class_1799 item : class_310.method_1551().field_1724.method_31548()) {
                if (item.method_7960()) continue;
                list.add(item);
            }
            return (class_1799[])list.toArray(class_1799[]::new);
        }
        class_1761 tab = (class_1761)class_7923.field_44687.method_63535(identifier);
        if (POLYMER && tab == null) {
            tab = (class_1761)InternalClientRegistry.ITEM_GROUPS.get(identifier);
        }
        if (tab != null) {
            if (!tab.method_47310()) {
                class_638 level = class_310.method_1551().field_1687;
                class_7706.method_47330((class_7699)level.method_45162(), (boolean)false, (class_7225.class_7874)level.method_30349());
            }
            return (class_1799[])tab.method_47313().toArray(class_1799[]::new);
        }
        return new class_1799[0];
    }

    private static CompletableFuture<Suggestions> suggestCreativeTabs(CommandContext<FabricClientCommandSource> ctx, SuggestionsBuilder b) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        for (class_1761 x : class_7706.method_47341()) {
            if (POLYMER && x instanceof InternalClientItemGroup) {
                InternalClientItemGroup ex = (InternalClientItemGroup)x;
                ids.add(ex.getIdentifier());
                continue;
            }
            ids.add(class_7923.field_44687.method_10221((Object)x));
        }
        return class_2172.method_9270(ids, (SuggestionsBuilder)b);
    }

    private static int renderEntity(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        class_1297 entity = ClientEntityUtils.findEntities((FabricClientCommandSource)ctx.getSource(), (class_2300)ctx.getArgument("entity", class_2300.class)).getFirst();
        EntityImageRenderer renderer = new EntityImageRenderer(((FabricClientCommandSource)ctx.getSource()).getClient(), ModInit.settings.width, ModInit.settings.height, entity);
        ModInit.openRendererScreen(renderer, (textureTarget, entityx) -> {
            try {
                String itemName = entity.method_5476().getString();
                String name = useIdAsName ? class_7923.field_41177.method_10221((Object)entity.method_5864()).method_36181() : itemName;
                Path path = MAIN_PATH.resolve(name + ".png");
                ModInit.writeToImage((class_276)textureTarget, x -> x.method_4314(path));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Saved " + itemName + " as ")).method_10852((class_2561)class_2561.method_43470((String)path.toString()).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10607(path)))));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return 0;
    }

    private static int renderBlockState(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        class_2680 state = ((class_2247)ctx.getArgument("state", class_2247.class)).method_9494();
        BlockImageRenderer renderer = new BlockImageRenderer(((FabricClientCommandSource)ctx.getSource()).getClient(), ModInit.settings.width, ModInit.settings.height, state);
        ModInit.openRendererScreen(renderer, (textureTarget, entityx) -> {
            try {
                String itemName = state.method_26204().method_9518().getString();
                String name = useIdAsName ? class_7923.field_41175.method_10221((Object)state.method_26204()).method_36181() : itemName;
                Path path = MAIN_PATH.resolve(name + ".png");
                ModInit.writeToImage((class_276)textureTarget, x -> x.method_4314(path));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Saved " + itemName + " as ")).method_10852((class_2561)class_2561.method_43470((String)path.toString()).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10607(path)))));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return 0;
    }

    private static int renderArea(CommandContext<FabricClientCommandSource> ctx) {
        class_2338 start = class_2338.method_49638((class_2374)ClientEntityUtils.getPos(((FabricClientCommandSource)ctx.getSource()).getPosition(), ((FabricClientCommandSource)ctx.getSource()).getRotation(), (class_2267)ctx.getArgument("start", class_2267.class)));
        class_2338 end = class_2338.method_49638((class_2374)ClientEntityUtils.getPos(((FabricClientCommandSource)ctx.getSource()).getPosition(), ((FabricClientCommandSource)ctx.getSource()).getRotation(), (class_2267)ctx.getArgument("end", class_2267.class)));
        RegionImageRenderer renderer = new RegionImageRenderer(((FabricClientCommandSource)ctx.getSource()).getClient(), ModInit.settings.width, ModInit.settings.height, ((FabricClientCommandSource)ctx.getSource()).getWorld(), class_9380.method_58237((class_2338)start, (class_2338)end));
        ModInit.openRendererScreen(renderer, (textureTarget, entityx) -> {
            try {
                String name = "area_" + class_156.method_44893();
                Path path = MAIN_PATH.resolve(name + ".png");
                ModInit.writeToImage((class_276)textureTarget, x -> x.method_4314(path));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.simple_image_renderer.saved_image_region", (Object[])new Object[]{class_2561.method_43469((String)"text.simple_image_renderer.region", (Object[])new Object[]{start.method_23854(), end.method_23854()}), class_2561.method_43470((String)path.toString()).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10607(path)))}));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return 0;
    }

    private static <T> void openRendererScreen(AbstractImageRenderer<T> renderer, BiConsumer<class_6367, T> consumer) {
        settings.applyAll(renderer);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(new PreviewScreen(renderer, settings.clone(), consumer)));
    }

    private static int renderItems(CommandContext<FabricClientCommandSource> ctx, class_1799 ... items) {
        ItemImageRenderer renderer = new ItemImageRenderer(((FabricClientCommandSource)ctx.getSource()).getClient(), ModInit.settings.width, ModInit.settings.height, List.of(items));
        ModInit.openRendererScreen(renderer, (textureTarget, itemStack) -> {
            try {
                String itemName = itemStack.method_7964().getString();
                String name = useIdAsName ? ((class_2960)itemStack.method_58695(class_9334.field_54199, (Object)class_7923.field_41178.method_10221((Object)itemStack.method_7909()))).method_36181() : itemName;
                Path path = MAIN_PATH.resolve(name + ".png");
                ModInit.writeToImage((class_276)textureTarget, x -> x.method_4314(path));
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.simple_image_renderer.saved_image", (Object[])new Object[]{itemName, class_2561.method_43470((String)path.toString()).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10607(path)))}));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return 0;
    }

    public static void writeToImage(class_276 target, ThrowingConsumer<class_1011> imageConsumer) {
        int width = target.field_1482;
        int height = target.field_1481;
        GpuTexture sourceTexture = target.method_30277();
        if (sourceTexture == null) {
            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
        }
        GpuBuffer buffer = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", 9, (long)width * (long)height * (long)sourceTexture.getFormat().pixelSize());
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(sourceTexture, buffer, 0L, () -> {
            try (GpuBuffer.MappedView read = commandEncoder.mapBuffer(buffer, true, false);
                 class_1011 image = new class_1011(width, height, false);){
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int argb = read.data().getInt((x + y * width) * sourceTexture.getFormat().pixelSize());
                        image.method_4305(x, height - y - 1, argb);
                    }
                }
                imageConsumer.accept(image);
            }
            catch (Throwable e) {
                LOGGER.error("Image handling failer", e);
            }
            finally {
                buffer.close();
            }
        }, 0);
    }

    public void onInitializeClient() {
        try {
            Files.createDirectories(MAIN_PATH, new FileAttribute[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientCommandRegistrationCallback.EVENT.register(ModInit::registerCommands);
    }

    static {
        useIdAsName = false;
        settings = new RendererSettings();
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

