/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleimagerenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import eu.pb4.simpleimagerenderer.ModInit;
import eu.pb4.simpleimagerenderer.mixin.GuiGraphicsAccessor;
import eu.pb4.simpleimagerenderer.renderer.AbstractImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.BlockImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.EntityImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.ItemImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.RegionImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.RendererSettings;
import java.lang.runtime.SwitchBootstraps;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_10799;
import net.minecraft.class_11467;
import net.minecraft.class_11909;
import net.minecraft.class_12137;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_6367;
import net.minecraft.class_7842;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_811;
import net.minecraft.class_8132;
import net.minecraft.class_8133;
import net.minecraft.class_8667;

public class PreviewScreen<T>
extends class_437 {
    private final AbstractImageRenderer<T> renderer;
    private final BiConsumer<class_6367, T> consumer;
    private RendererSettings settings;
    private class_8132 layout;
    private int imageWidth;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private SliderWithText scale;
    private SliderWithText yaw;
    private SliderWithText pitch;
    private SliderWithText xpos;
    private SliderWithText ypos;
    private boolean startDraggingImage;
    private double overflowX;
    private double overflowY;

    protected PreviewScreen(AbstractImageRenderer<T> renderer, RendererSettings settings, BiConsumer<class_6367, T> consumer) {
        AbstractImageRenderer<T> abstractImageRenderer = renderer;
        Objects.requireNonNull(abstractImageRenderer);
        AbstractImageRenderer<T> abstractImageRenderer2 = abstractImageRenderer;
        int n = 0;
        super((class_2561)class_2561.method_43469((String)("title.simple_image_renderer.preview." + (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemImageRenderer.class, BlockImageRenderer.class, EntityImageRenderer.class, RegionImageRenderer.class}, abstractImageRenderer2, n)) {
            case 0 -> {
                ItemImageRenderer x = (ItemImageRenderer)abstractImageRenderer2;
                yield "item";
            }
            case 1 -> {
                BlockImageRenderer x = (BlockImageRenderer)abstractImageRenderer2;
                yield "block";
            }
            case 2 -> {
                EntityImageRenderer x = (EntityImageRenderer)abstractImageRenderer2;
                yield "entity";
            }
            case 3 -> {
                RegionImageRenderer x = (RegionImageRenderer)abstractImageRenderer2;
                yield "region";
            }
            default -> "default";
        })), (Object[])new Object[]{renderer.getTitle()}));
        this.renderer = renderer;
        this.consumer = consumer;
        this.settings = settings;
    }

    protected void method_25426() {
        this.layout = new class_8132((class_437)this);
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layout.method_48222();
    }

    protected void addTitle() {
        this.layout.method_57726(this.field_22785, this.field_22793);
    }

    protected void addContents() {
        ArrayList<class_8021> list = new ArrayList<class_8021>();
        this.createButtons(list::add);
        class_8667 list2 = class_8667.method_52741().method_52735(2);
        list2.method_52740().method_46467();
        list.forEach(arg_0 -> ((class_8667)list2).method_52736(arg_0));
        list2.method_48222();
        class_8667 hor = (class_8667)this.layout.method_48999((class_8021)class_8667.method_52742().method_52735(0));
        this.imageWidth = Math.min(this.field_22789 - list2.method_25368() - 20, this.field_22789 / 2);
        hor.method_52736((class_8021)new class_7852(this.imageWidth, 10));
        class_11467 scrl = (class_11467)hor.method_52736((class_8021)new class_11467(this.field_22787, (class_8133)list2, this.layout.method_57727()));
        scrl.method_71807(this.layout.method_57727());
        list2.method_48222();
    }

    public boolean method_25401(double x, double y, double dx, double dy) {
        if (this.isWithinImage(x, y)) {
            this.scale.update((int)((double)this.scale.get() + dy * (double)(this.field_22787.method_74188() ? 1 : (this.field_22787.method_74187() ? 4 : 8))));
            return true;
        }
        return super.method_25401(x, y, dx, dy);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        if (this.isWithinImage(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799())) {
            this.startDraggingImage = true;
            return true;
        }
        return super.method_25402(mouseButtonEvent, bl);
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        this.startDraggingImage = false;
        this.overflowY = 0.0;
        this.overflowX = 0.0;
        return super.method_25406(mouseButtonEvent);
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double dx, double dy) {
        if (this.startDraggingImage) {
            int scale = this.field_22787.method_22683().method_4495();
            if (this.field_22787.method_74187()) {
                double newX = (double)this.xpos.get() + dx * (double)scale * 1000.0 / (double)(this.endX - this.startX) + this.overflowX;
                double newY = (double)this.ypos.get() + dy * (double)scale * 1000.0 / (double)(this.endY - this.startY) + this.overflowY;
                this.xpos.update((int)newX);
                this.ypos.update((int)newY);
                this.overflowX = newX - (double)((int)newX);
                this.overflowY = newY - (double)((int)newY);
            } else {
                this.yaw.update((int)class_3532.method_15338((double)((double)this.yaw.get() + dx * (double)scale / 2.0)));
                this.pitch.update((int)class_3532.method_15338((double)((double)this.pitch.get() - dy * (double)scale / 2.0)));
            }
            return true;
        }
        return super.method_25403(mouseButtonEvent, dx, dy);
    }

    private boolean isWithinImage(double x, double y) {
        int mult = this.field_22787.method_22683().method_4495();
        return (x *= (double)mult) >= (double)this.startX && x <= (double)this.endX && (y *= (double)mult) >= (double)this.startY && y <= (double)this.endY;
    }

    private void createButtons(Consumer<class_8021> list) {
        Object unchanged;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMaximumFractionDigits(2);
        nf.setRoundingMode(RoundingMode.HALF_EVEN);
        class_8667 group = class_8667.method_52742().method_52735(4);
        group.method_52737((class_8021)new class_7842((class_2561)this.button("width"), this.field_22793), group.method_52739().method_46474());
        group.method_52736((class_8021)this.createIntEditBox((class_2561)this.button("width"), v -> {
            this.settings.width = v;
            this.renderer.setupTexture(this.settings.width, this.settings.height);
            this.updateMatrix();
        }, this.renderer::width, 40, 16, 8192));
        group.method_52737((class_8021)new class_7842((class_2561)this.button("height"), this.field_22793), group.method_52739().method_46474());
        group.method_52736((class_8021)this.createIntEditBox((class_2561)this.button("height"), v -> {
            this.settings.height = v;
            this.renderer.setupTexture(this.settings.width, this.settings.height);
            this.updateMatrix();
        }, this.renderer::height, 40, 16, 8192));
        group.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\uddd8"), btn -> {
            this.settings = new RendererSettings();
            this.settings.applyAll(this.renderer);
            this.method_41843();
        }).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)this.text("reset_local"))).method_46431());
        list.accept((class_8021)group);
        this.pitch = this.createIntSliderWithText((class_2561)this.button("pitch"), v -> {
            this.settings.pitch = v;
            this.updateMatrix();
        }, () -> this.settings.pitch, 140, 45, -180, 180);
        list.accept(this.pitch.group());
        this.yaw = this.createIntSliderWithText((class_2561)this.button("yaw"), v -> {
            this.settings.yaw = v;
            this.updateMatrix();
        }, () -> this.settings.yaw, 140, 45, -180, 180);
        list.accept(this.yaw.group());
        list.accept(this.createIntSliderWithText((class_2561)this.button("roll"), v -> {
            this.settings.roll = v;
            this.updateMatrix();
        }, () -> this.settings.roll, 140, 45, -180, 180).group());
        this.scale = this.createIntSliderWithText((class_2561)this.button("scale"), v -> {
            this.settings.scale = v;
            this.updateMatrix();
        }, () -> this.settings.scale, 140, 45, 1, 1000, 100, x -> x + "%");
        list.accept(this.scale.group());
        this.xpos = this.createIntSliderWithText((class_2561)this.button("x"), v -> {
            this.settings.x = v;
            this.updateMatrix();
        }, () -> this.settings.x, 140, 45, -6400, 6400, 0, x -> nf.format((double)x / 100.0), x -> (int)(Double.parseDouble(x) * 100.0), x -> Double.toString((double)x / 100.0));
        list.accept(this.xpos.group());
        this.ypos = this.createIntSliderWithText((class_2561)this.button("y"), v -> {
            this.settings.y = v;
            this.updateMatrix();
        }, () -> this.settings.y, 140, 45, -6400, 6400, 0, x -> nf.format((double)x / 100.0), x -> (int)(Double.parseDouble(x) * 100.0), x -> Double.toString((double)x / 100.0));
        list.accept(this.ypos.group());
        group = class_8667.method_52742().method_52735(4);
        group.method_52736((class_8021)class_4185.method_46430((class_2561)this.button("rotate_light").method_27693(": ").method_10852(class_5244.method_36134((boolean)this.renderer.multiplyNormals())), b -> {
            this.renderer.setMultiplyNormals(!this.renderer.multiplyNormals());
            this.settings.multiplyNormals = this.renderer.multiplyNormals();
            b.method_25355((class_2561)this.button("rotate_light").method_27693(": ").method_10852(class_5244.method_36134((boolean)this.renderer.multiplyNormals())));
        }).method_46432(100).method_46431());
        group.method_52736((class_8021)class_5676.method_75345(x -> class_2561.method_43470((String)x.name()), this.renderer::lightingType).method_32624((Object[])AbstractImageRenderer.LightingType.values()).method_32617(0, 0, 120, 20, (class_2561)this.button("lighting"), (btn, val) -> {
            this.renderer.setLightingType((AbstractImageRenderer.LightingType)((Object)val));
            this.settings.lightingType = val;
        }));
        list.accept((class_8021)group);
        AbstractImageRenderer<T> abstractImageRenderer = this.renderer;
        if (abstractImageRenderer instanceof ItemImageRenderer) {
            ItemImageRenderer itemImageRenderer = (ItemImageRenderer)abstractImageRenderer;
            list.accept((class_8021)class_5676.method_75345(x -> class_2561.method_43470((String)x.name()), itemImageRenderer::displayContext).method_32624((Object[])class_811.values()).method_57720((class_2561)this.button("item_display_context"), (btn, val) -> {
                itemImageRenderer.setDisplayContext((class_811)val);
                this.settings.context = val;
            }));
        }
        if ((abstractImageRenderer = this.renderer) instanceof EntityImageRenderer) {
            EntityImageRenderer entityImageRenderer = (EntityImageRenderer)abstractImageRenderer;
            unchanged = this.value("unchanged").getString();
            DoubleFunction<String> format = arg_0 -> PreviewScreen.lambda$createButtons$28((String)unchanged, nf, arg_0);
            list.accept(this.createIntSliderWithText((class_2561)this.button("entity_age"), v -> {
                this.settings.age = v;
                entityImageRenderer.setAge((float)this.settings.age);
                entityImageRenderer.setGlintTime((long)v * 1000L / 20L);
            }, () -> (int)this.settings.age, 140, 50, -1, 200, arg_0 -> PreviewScreen.lambda$createButtons$31((String)unchanged, arg_0)).group());
            if (entityImageRenderer.isLivingEntity()) {
                list.accept(this.createIntSliderWithText((class_2561)this.button("walking_pos"), v -> {
                    this.settings.walkAnimationPos = (double)v / 200.0;
                    entityImageRenderer.setWalkAnimationPos((float)this.settings.walkAnimationPos);
                }, () -> Math.toIntExact(Math.round(this.settings.walkAnimationPos * 200.0)), 140, 50, -1, 2000, -1, x -> (String)format.apply((float)x / 200.0f), x -> x.equals("-1") ? -1 : (int)(Double.parseDouble(x) * 200.0), x -> x == -1 ? "-1" : Double.toString((double)x / 200.0)).group());
                list.accept(this.createIntSliderWithText((class_2561)this.button("walking_speed"), v -> {
                    this.settings.walkAnimationSpeed = (double)v / 100.0;
                    entityImageRenderer.setWalkAnimationSpeed((float)this.settings.walkAnimationSpeed);
                }, () -> Math.toIntExact(Math.round(this.settings.walkAnimationSpeed * 100.0)), 140, 50, -1, 100, -1, x -> (String)format.apply((float)x / 100.0f), x -> x.equals("-1") ? -1 : (int)(Double.parseDouble(x) * 100.0), x -> x == -1 ? "-1" : Double.toString((double)x / 100.0)).group());
            }
        }
        if ((unchanged = this.renderer) instanceof RegionImageRenderer) {
            RegionImageRenderer regionImageRenderer = (RegionImageRenderer)unchanged;
            class_8667 group2 = class_8667.method_52742().method_52735(4);
            group2.method_52736((class_8021)class_5676.method_75345(class_5244::method_36134, regionImageRenderer::renderEntities).method_32624((Object[])new Boolean[]{true, false}).method_32617(0, 0, 110, 20, (class_2561)this.button("show_entities"), (btn, val) -> {
                regionImageRenderer.setRenderEntities((boolean)val);
                this.settings.renderEntities = val;
            }));
            group2.method_52736((class_8021)class_5676.method_75345(class_5244::method_36134, regionImageRenderer::renderSelf).method_32624((Object[])new Boolean[]{true, false}).method_32617(0, 0, 110, 20, (class_2561)this.button("show_self"), (btn, val) -> {
                regionImageRenderer.setRenderSelf((boolean)val);
                this.settings.renderSelf = val;
            }));
            list.accept((class_8021)group2);
            list.accept((class_8021)class_5676.method_75345(class_5244::method_36134, regionImageRenderer::renderNametags).method_32624((Object[])new Boolean[]{true, false}).method_32617(0, 0, 110, 20, (class_2561)this.button("show_name_tags"), (btn, val) -> {
                regionImageRenderer.setRenderNametags((boolean)val);
                this.settings.renderNametags = val;
            }));
        }
    }

    private class_5250 button(String name) {
        return class_2561.method_43471((String)("button.simple_image_renderer." + name));
    }

    private class_5250 text(String name) {
        return class_2561.method_43471((String)("text.simple_image_renderer." + name));
    }

    private class_5250 value(String name) {
        return class_2561.method_43471((String)("value.simple_image_renderer." + name));
    }

    private void updateMatrix() {
        this.settings.updateMatrix(this.renderer);
    }

    protected void addFooter() {
        class_8667 linearLayout = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        linearLayout.method_52736((class_8021)class_4185.method_46430((class_2561)this.button("render"), button -> {
            if (!class_310.method_1551().method_74187()) {
                this.field_22787.method_1507(null);
            } else {
                this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47585, (class_2561)this.text("rendered_image"), null));
            }
            this.renderer.render(this.consumer, false);
        }).method_46432(100).method_46431());
        linearLayout.method_52736((class_8021)class_4185.method_46430((class_2561)this.button("save_settings"), btn -> {
            ModInit.settings = this.settings.clone();
            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47585, (class_2561)this.text("saved_configuration"), null));
        }).method_46432(100).method_46431());
        linearLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.field_22787.method_1507(null)).method_46432(100).method_46431());
    }

    public void method_25419() {
        super.method_25419();
        this.renderer.close();
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        this.renderer.render((x, y) -> {
            class_276 tmp = ModInit.mainRenderTargetReplacement;
            ModInit.mainRenderTargetReplacement = null;
            class_276 main = this.field_22787.method_1522();
            int mult = this.field_22787.method_22683().method_4495();
            int maxHeight = main.field_1481 - (this.layout.method_48998() + this.layout.method_48994() + 2) * mult;
            int maxWidth = this.imageWidth * mult;
            int height = x.field_1481;
            int width = x.field_1482;
            boolean scaledDown = false;
            if (height > maxHeight) {
                width = (int)((float)maxHeight / (float)height * (float)width);
                height = maxHeight;
                scaledDown = true;
            }
            if (width > maxWidth) {
                height = (int)((float)maxWidth / (float)width * (float)height);
                width = maxWidth;
                scaledDown = true;
            }
            this.startX = (maxWidth - width) / 2;
            this.startY = main.field_1481 / 2 - height / 2;
            this.endX = this.startX + width;
            this.endY = this.startY + height;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(1.0f / (float)mult);
            guiGraphics.method_25294(this.startX, this.startY, this.endX, this.endY, -16777216);
            guiGraphics.method_73198(this.startX - 1, this.startY - 1, width + 2, height + 2, scaledDown ? -26300 : -1);
            class_12137 sampler = RenderSystem.getSamplerCache().method_75293(AddressMode.REPEAT, AddressMode.REPEAT, FilterMode.NEAREST, FilterMode.NEAREST, false);
            ((GuiGraphicsAccessor)guiGraphics).callSubmitBlit(class_10799.field_56883, x.method_71639(), sampler, this.startX, this.startY, this.endX, this.endY, 0.0f, 1.0f, 1.0f, 0.0f, -1);
            guiGraphics.method_51448().popMatrix();
            ModInit.mainRenderTargetReplacement = tmp;
        }, true);
    }

    private class_342 createIntEditBox(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int min, int max) {
        return this.createIntEditBox(name, consumer, supplier, width, min, max, (max + min) / 2, Integer::parseInt, String::valueOf);
    }

    private class_342 createIntEditBox(class_2561 name, IntConsumer consumer, final IntSupplier supplier, int width, int min, int max, int defaultVal, ToIntFunction<String> parser, final IntFunction<String> textBoxString) {
        class_342 size = new class_342(this, this.field_22793, width, 20, name){

            public void method_25365(boolean bl) {
                super.method_25365(bl);
                if (!bl) {
                    this.method_1852((String)textBoxString.apply(supplier.getAsInt()));
                }
            }
        };
        size.method_71502(true);
        size.method_1863(arg_0 -> PreviewScreen.lambda$createIntEditBox$49(defaultVal, parser, min, max, size, supplier, consumer, arg_0));
        size.method_1890(input -> {
            if (input.isEmpty()) {
                return true;
            }
            try {
                int i = parser.applyAsInt((String)input);
                return true;
            }
            catch (Exception e) {
                return min < 0 && input.length() == 1 && input.charAt(0) == '-';
            }
        });
        size.method_1852(textBoxString.apply(class_3532.method_15340((int)supplier.getAsInt(), (int)min, (int)max)));
        return size;
    }

    private class_342 createDoubleEditBox(class_2561 name, DoubleConsumer consumer, final DoubleSupplier supplier, int width, double min, double max, final DoubleFunction<String> rounder) {
        class_342 size = new class_342(this, this.field_22793, width, 20, name){

            public void method_25365(boolean bl) {
                super.method_25365(bl);
                if (!bl) {
                    this.method_1852((String)rounder.apply(supplier.getAsDouble()));
                }
            }
        };
        size.method_71502(true);
        size.method_1863(arg_0 -> PreviewScreen.lambda$createDoubleEditBox$51(min, max, size, rounder, supplier, consumer, arg_0));
        size.method_1890(input -> {
            if (input.isEmpty()) {
                return true;
            }
            try {
                double i = Double.parseDouble(input);
                return true;
            }
            catch (Exception e) {
                return min < 0.0 && input.length() == 1 && input.charAt(0) == '-';
            }
        });
        size.method_1852(rounder.apply(supplier.getAsDouble()));
        return size;
    }

    private SliderButton createIntSlider(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int min, int max) {
        return this.createIntSlider(name, consumer, supplier, width, min, max, String::valueOf);
    }

    private SliderButton createIntSlider(final class_2561 name, final IntConsumer consumer, final IntSupplier supplier, int width, final int min, final int max, final IntFunction<String> stringify) {
        return new SliderButton(this, 0, 0, width, 20, (class_2561)class_2561.method_43473(), (double)class_3532.method_15340((int)(supplier.getAsInt() - min), (int)min, (int)max) / (double)(max - min)){
            {
                super(i, j, k, l, component, d);
                this.method_25346();
            }

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43473().method_10852(name).method_27693(": " + (String)stringify.apply(supplier.getAsInt())));
            }

            protected void method_25344() {
                int value = class_3532.method_53063((float)((float)this.field_22753), (int)min, (int)max);
                if (value != supplier.getAsInt()) {
                    consumer.accept(value);
                }
            }
        };
    }

    private SliderButton createDoubleSlider(final class_2561 name, final DoubleConsumer consumer, final DoubleSupplier supplier, int width, final double min, final double max, final double step, final DoubleFunction<String> stringify) {
        return new SliderButton(this, 0, 0, width, 20, (class_2561)class_2561.method_43473(), (supplier.getAsDouble() - min) / (max - min)){
            {
                super(i, j, k, l, component, d);
                this.method_25346();
            }

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43473().method_10852(name).method_27693(": " + (String)stringify.apply(supplier.getAsDouble())));
            }

            protected void method_25344() {
                double value = (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)min, (double)max) / step) * step;
                if (value != supplier.getAsDouble()) {
                    consumer.accept(value);
                }
            }
        };
    }

    private SliderWithText createIntSliderWithText(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int width2, int min, int max) {
        return this.createIntSliderWithText(name, consumer, supplier, width, width2, min, max, String::valueOf);
    }

    private SliderWithText createIntSliderWithText(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int width2, int min, int max, IntFunction<String> display) {
        return this.createIntSliderWithText(name, consumer, supplier, width, width2, min, max, (min + max) / 2, display, Integer::parseInt, Integer::toString);
    }

    private SliderWithText createIntSliderWithText(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int width2, int min, int max, int defaultValue, IntFunction<String> display) {
        return this.createIntSliderWithText(name, consumer, supplier, width, width2, min, max, defaultValue, display, Integer::parseInt, Integer::toString);
    }

    private SliderWithText createIntSliderWithText(class_2561 name, IntConsumer consumer, IntSupplier supplier, int width, int width2, int min, int max, int defaultValue, IntFunction<String> display, ToIntFunction<String> parser, IntFunction<String> textBoxString) {
        var obj = new Object(this){
            SliderButton slider;
            class_342 editBox;
        };
        obj.slider = this.createIntSlider(name, x -> {
            consumer.accept(x);
            obj.editBox.method_1852((String)textBoxString.apply(x));
        }, supplier, width, min, max, display);
        obj.editBox = this.createIntEditBox(name, x -> {
            consumer.accept(x);
            obj.slider.method_25347((double)(supplier.getAsInt() - min) / (double)(max - min));
        }, supplier, width2, min, max, defaultValue, parser, textBoxString);
        class_8667 group = class_8667.method_52742().method_52735(2);
        group.method_52736((class_8021)obj.slider);
        group.method_52736((class_8021)obj.editBox);
        return new SliderWithText(supplier, x -> {
            x = class_3532.method_15340((int)x, (int)min, (int)max);
            consumer.accept(x);
            obj.slider.method_25347((double)(supplier.getAsInt() - min) / (double)(max - min));
            obj.editBox.method_1852((String)textBoxString.apply(x));
        }, obj.slider, obj.editBox, (class_8021)group);
    }

    private static /* synthetic */ void lambda$createDoubleEditBox$51(double min, double max, 2 size, DoubleFunction rounder, DoubleSupplier supplier, DoubleConsumer consumer, String input) {
        try {
            double value;
            double d = value = input.isEmpty() ? min : Double.parseDouble(input);
            if (value < min || value > max) {
                size.method_1868(-21846);
            } else {
                size.method_1868(-1);
                if (!((String)rounder.apply(value)).equals(rounder.apply(supplier.getAsDouble()))) {
                    consumer.accept(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$createIntEditBox$49(int defaultVal, ToIntFunction parser, int min, int max, 1 size, IntSupplier supplier, IntConsumer consumer, String input) {
        try {
            int value;
            int n = value = input.isEmpty() ? defaultVal : parser.applyAsInt(input);
            if (value < min || value > max) {
                size.method_1868(-21846);
            } else {
                size.method_1868(-1);
                if (value != supplier.getAsInt()) {
                    consumer.accept(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ String lambda$createButtons$31(String unchanged, int x) {
        return x == -1 ? unchanged : String.valueOf(x);
    }

    private static /* synthetic */ String lambda$createButtons$28(String unchanged, NumberFormat nf, double x) {
        return x < 0.0 ? unchanged : nf.format(x);
    }

    public record SliderWithText(IntSupplier supplier, IntConsumer consumer, SliderButton slider, class_342 editBox, class_8021 group) {
        public void update(int value) {
            this.consumer.accept(value);
        }

        int get() {
            return this.supplier.getAsInt();
        }
    }

    public static abstract class SliderButton
    extends class_357 {
        public SliderButton(int i, int j, int k, int l, class_2561 component, double d) {
            super(i, j, k, l, component, d);
        }

        public void method_25347(double d) {
            super.method_25347(d);
        }
    }
}

