/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleimagerenderer.renderer;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import eu.pb4.simpleimagerenderer.ModInit;
import java.util.function.BiConsumer;
import net.minecraft.class_10366;
import net.minecraft.class_11286;
import net.minecraft.class_11684;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractImageRenderer<T>
implements AutoCloseable {
    protected final class_310 minecraft;
    protected class_6367 renderTarget;
    protected final class_11684 renderDispatcher;
    protected final class_4597.class_4598 bufferSource;
    protected final class_11286 perspectiveBuffer;
    protected final Matrix4f projectionMatrix = new Matrix4f();
    protected int height;
    protected int width;
    protected final Matrix4f matrix = new Matrix4f();
    protected final Quaternionf cameraOrientation = new Quaternionf();
    private boolean multiplyNormals = true;
    protected LightingType lightingType = LightingType.DEFAULT;
    protected long glintTime = 0L;

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean multiplyNormals() {
        return this.multiplyNormals;
    }

    public void setMultiplyNormals(boolean multiplyNormals) {
        this.multiplyNormals = multiplyNormals;
    }

    public AbstractImageRenderer(class_310 minecraft, int width, int height) {
        this.minecraft = minecraft;
        this.renderDispatcher = minecraft.field_1773.method_72911();
        this.bufferSource = minecraft.method_22940().method_23000();
        this.perspectiveBuffer = new class_11286("render");
        this.setupTexture(width, height);
    }

    public void render(BiConsumer<class_6367, T> targetConsumer, boolean preview) {
        ModInit.glintTimeOverride = this.glintTime < 0L ? -1L : this.glintTime;
        GpuTextureView oldOutputColor = RenderSystem.outputColorTextureOverride;
        GpuTextureView oldOutputDepth = RenderSystem.outputDepthTextureOverride;
        Matrix4f oldModelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().identity();
        RenderSystem.outputColorTextureOverride = this.renderTarget.method_71639();
        RenderSystem.outputDepthTextureOverride = this.renderTarget.method_71640();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.perspectiveBuffer.method_71123(this.projectionMatrix), (class_10366)class_10366.field_54954);
        try {
            this.clearBuffer();
            this.renderInner(targetConsumer, preview);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)oldModelViewMatrix);
        RenderSystem.outputColorTextureOverride = oldOutputColor;
        RenderSystem.outputDepthTextureOverride = oldOutputDepth;
        ModInit.glintTimeOverride = -1L;
    }

    protected void clearBuffer() {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.renderTarget.method_30277(), 0, this.renderTarget.method_30278(), 1.0);
    }

    protected abstract void renderInner(BiConsumer<class_6367, T> var1, boolean var2);

    public void setupTexture(int width) {
        this.setupTexture(width, width);
    }

    public void setupTexture(int width, int height) {
        if (this.renderTarget != null) {
            this.renderTarget.method_1238();
        }
        this.width = width;
        this.height = height;
        this.renderTarget = new class_6367("image_out", width, height, true);
        this.projectionMatrix.identity().setOrtho((float)(-width) / 2.0f, (float)width / 2.0f, (float)height / 2.0f, (float)(-height) / 2.0f, -5000.0f, 5000.0f);
    }

    @Override
    public void close() {
        this.perspectiveBuffer.close();
        this.renderTarget.method_1238();
    }

    public void updateMatrix(Matrix4f matrix4f, Quaternionf cameraOrientation) {
        this.matrix.set((Matrix4fc)matrix4f);
        this.cameraOrientation.set((Quaternionfc)cameraOrientation);
    }

    protected void multiplyPoseStack(class_4587 poseStack) {
        if (this.multiplyNormals) {
            poseStack.method_34425((Matrix4fc)this.matrix);
        } else {
            poseStack.method_23760().method_23761().mul((Matrix4fc)this.matrix);
        }
    }

    public boolean isSingleRender() {
        return true;
    }

    public LightingType lightingType() {
        return this.lightingType;
    }

    public void setLightingType(LightingType lightingType) {
        this.lightingType = lightingType;
    }

    public long glintTime() {
        return this.glintTime;
    }

    public void setGlintTime(long glintTime) {
        this.glintTime = glintTime;
    }

    public abstract class_2561 getTitle();

    public static enum LightingType {
        DEFAULT(null),
        LEVEL(class_308.class_11274.field_60025),
        ITEMS_FLAT(class_308.class_11274.field_60026),
        ITEMS_3D(class_308.class_11274.field_60027),
        ENTITY_IN_UI(class_308.class_11274.field_60028);

        private final class_308.class_11274 entry;

        private LightingType(class_308.class_11274 entry) {
            this.entry = entry;
        }

        public class_308.class_11274 getEntry(class_308.class_11274 defaulted) {
            return this.entry == null ? defaulted : this.entry;
        }
    }
}

