/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleimagerenderer.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import eu.pb4.simpleimagerenderer.ManualCamera;
import eu.pb4.simpleimagerenderer.ModInit;
import eu.pb4.simpleimagerenderer.renderer.AbstractImageRenderer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.SequencedCollection;
import java.util.function.BiConsumer;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_10196;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_11515;
import net.minecraft.class_11516;
import net.minecraft.class_11531;
import net.minecraft.class_11532;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11943;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12137;
import net.minecraft.class_12393;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_6849;
import net.minecraft.class_750;
import net.minecraft.class_8251;
import net.minecraft.class_853;
import net.minecraft.class_9380;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9810;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;

public class RegionImageRenderer
extends AbstractImageRenderer<Void> {
    private final List<Section> sections = new ArrayList<Section>();
    private final List<class_10017> entities = new ArrayList<class_10017>();
    private final List<class_11954> blockEntities = new ArrayList<class_11954>();
    private final List<class_11942> particles = new ArrayList<class_11942>();
    private final class_12137 chunkLayerSampler;
    private final class_9380 area;
    private boolean renderEntities = true;
    private boolean renderNametags = true;
    private boolean renderSelf = true;

    public RegionImageRenderer(class_310 minecraft, int width, int height, class_638 level, class_9380 area) {
        super(minecraft, width, height);
        this.area = area;
        int i = this.minecraft.field_1690.method_76747().method_41753() == class_12393.field_64665 ? this.minecraft.field_1690.method_76248() : 1;
        this.chunkLayerSampler = RenderSystem.getDevice().createSampler(AddressMode.CLAMP_TO_EDGE, AddressMode.CLAMP_TO_EDGE, FilterMode.NEAREST, FilterMode.NEAREST, i, OptionalDouble.empty());
        FauxRenderSectionRegion region = new FauxRenderSectionRegion((class_1937)level, area);
        class_9810 compiler = new class_9810(minecraft.method_1541(), minecraft.method_31975());
        class_4076 sectionStart = class_4076.method_18682((class_2338)area.comp_2466());
        class_4076 sectionEnd = class_4076.method_18682((class_2338)area.comp_2467());
        class_750 builder = minecraft.method_22940().method_22997();
        Iterator iter = class_4076.method_20438((int)sectionStart.method_18674(), (int)sectionStart.method_18683(), (int)sectionStart.method_18687(), (int)sectionEnd.method_18674(), (int)sectionEnd.method_18683(), (int)sectionEnd.method_18687()).iterator();
        while (iter.hasNext()) {
            builder.method_23501();
            class_4076 pos = (class_4076)iter.next();
            class_9810.class_9811 results = compiler.method_60904(pos, (class_853)region, class_8251.field_43361, builder);
            class_11516 compiledSectionMesh = new class_11516(class_10196.method_64069((class_243)class_243.field_1353, (long)0L), results);
            for (class_11515 layer : class_11515.values()) {
                if (!results.field_52168.containsKey(layer)) continue;
                class_9801 meshData = (class_9801)results.field_52168.get(layer);
                compiledSectionMesh.method_72031(layer, meshData, pos.method_18694());
            }
            if (compiledSectionMesh.method_72027()) {
                this.sections.add(new Section(pos.method_19767(), compiledSectionMesh));
            } else {
                compiledSectionMesh.close();
            }
            results.method_60905();
        }
        for (Section section : this.sections) {
            for (class_2586 be : section.sectionMesh.method_72033()) {
                class_11954 state = this.minecraft.method_31975().method_74348(be, 0.0f, null);
                if (state == null) continue;
                this.blockEntities.add(state);
            }
        }
        for (class_1297 entity : level.method_8335(null, area.method_58240())) {
            class_10017 state = minecraft.method_1561().method_72977(entity, 0.0f);
            this.entities.add(state);
        }
        builder.method_23501();
    }

    @Override
    public void close() {
        super.close();
        for (Section section : this.sections) {
            section.sectionMesh.close();
        }
        this.sections.clear();
    }

    public boolean renderEntities() {
        return this.renderEntities;
    }

    public void setRenderEntities(boolean renderEntities) {
        this.renderEntities = renderEntities;
    }

    public boolean renderSelf() {
        return this.renderSelf;
    }

    public void setRenderSelf(boolean renderSelf) {
        this.renderSelf = renderSelf;
    }

    public boolean renderNametags() {
        return this.renderNametags;
    }

    public void setRenderNametags(boolean renderNametags) {
        this.renderNametags = renderNametags;
    }

    @Override
    protected void renderInner(BiConsumer<class_6367, Void> targetConsumer, boolean preview) {
        class_243 center = this.area.method_58240().method_1005();
        class_4587 poseStack = new class_4587();
        poseStack.method_22903();
        this.multiplyPoseStack(poseStack);
        class_12075 cameraState = new class_12075();
        cameraState.field_63080 = center;
        cameraState.field_63077 = class_2338.method_49638((class_2374)center);
        cameraState.field_63078 = cameraState.field_63080;
        cameraState.field_63081 = this.cameraOrientation;
        cameraState.field_63079 = true;
        ManualCamera camera = new ManualCamera();
        camera.method_19322(center);
        camera.setRotation(cameraState.field_63081);
        BoxyFrustum fakeFrustrum = new BoxyFrustum(this.area);
        this.minecraft.field_1773.method_71113().method_71116(this.renderTarget.field_1482, this.renderTarget.field_1481, ((Double)this.minecraft.field_1690.method_48581().method_41753()).doubleValue(), this.minecraft.field_1687 == null ? 0L : this.minecraft.field_1687.method_75260(), this.minecraft.method_61966(), this.minecraft.field_1690.method_57703(), (class_4184)camera, this.minecraft.field_1690.method_76747().method_41753() == class_12393.field_64664);
        poseStack.method_22905((float)this.width, (float)(-this.width), (float)this.width);
        float scale = 1.0f / (float)Math.min(Math.min(this.area.method_58243(), this.area.method_58245()), this.area.method_58246());
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_23760().method_23762().scale(1.0f, -1.0f, 1.0f);
        this.minecraft.field_1773.method_71114().method_71034(this.lightingType.getEntry(class_308.class_11274.field_60025));
        class_11532 render = this.prepareChunkRenders((Matrix4fc)poseStack.method_23760().method_23761());
        this.renderGroup(render, class_11531.field_61022, this.chunkLayerSampler);
        ModInit.mainRenderTargetReplacement = this.renderTarget;
        for (class_11954 class_119542 : this.blockEntities) {
            poseStack.method_22903();
            poseStack.method_22904((double)class_119542.field_62673.method_10263() - center.field_1352, (double)class_119542.field_62673.method_10264() - center.field_1351, (double)class_119542.field_62673.method_10260() - center.field_1350);
            this.minecraft.method_31975().method_3555(class_119542, poseStack, (class_11659)this.renderDispatcher.method_73003(), new class_12075());
            poseStack.method_22909();
        }
        this.renderDispatcher.method_73002();
        if (this.renderEntities) {
            for (class_10017 class_100172 : this.entities) {
                if (!this.renderSelf && class_100172 instanceof class_10055) {
                    class_10055 state1 = (class_10055)class_100172;
                    if (state1.field_53528 == this.minecraft.field_1724.method_5628()) continue;
                }
                poseStack.method_22903();
                poseStack.method_22904(class_100172.field_53325 - center.field_1352, class_100172.field_53326 - center.field_1351, class_100172.field_53327 - center.field_1350);
                class_2561 nameTag = class_100172.field_53337;
                if (!this.renderNametags) {
                    class_100172.field_53337 = null;
                }
                this.minecraft.method_1561().method_72976(class_100172, cameraState, 0.0, 0.0, 0.0, poseStack, (class_11659)this.renderDispatcher.method_73003());
                class_100172.field_53337 = nameTag;
                poseStack.method_22909();
            }
            this.renderDispatcher.method_73002();
        }
        class_11943 particles = new class_11943();
        this.minecraft.field_1713.method_74283(particles, (class_4604)fakeFrustrum, (class_4184)camera, this.minecraft.method_61966().method_60636());
        particles.method_74319(this.renderDispatcher.method_73003(), cameraState);
        particles.method_74317();
        this.renderDispatcher.method_73002();
        this.renderGroup(render, class_11531.field_61023, this.chunkLayerSampler);
        this.renderGroup(render, class_11531.field_61024, this.chunkLayerSampler);
        this.renderDispatcher.method_73002();
        this.renderDispatcher.method_74817();
        this.bufferSource.method_22993();
        ModInit.mainRenderTargetReplacement = null;
        targetConsumer.accept(this.renderTarget, null);
        this.minecraft.field_1773.method_71113().method_71116(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506(), ((Double)this.minecraft.field_1690.method_48581().method_41753()).doubleValue(), this.minecraft.field_1687 == null ? 0L : this.minecraft.field_1687.method_75260(), this.minecraft.method_61966(), this.minecraft.field_1690.method_57703(), this.minecraft.field_1773.method_19418(), this.minecraft.field_1690.method_76747().method_41753() == class_12393.field_64664);
    }

    @Override
    public void updateMatrix(Matrix4f matrix4f, Quaternionf quaternionf) {
        super.updateMatrix(matrix4f, quaternionf);
        Vector4f camPos = new Vector4f(0.0f, 0.0f, -1.0f, 0.0f);
        camPos.mul((Matrix4fc)new Matrix4f((Matrix4fc)this.projectionMatrix).invert()).mul((Matrix4fc)new Matrix4f((Matrix4fc)matrix4f).invert());
        Vector3f vec = new Vector3f(camPos.x, camPos.y, camPos.z).normalize().mul(1000.0f).mul(1.0f, -1.0f, 1.0f).add((Vector3fc)this.area.method_58240().method_1005().method_46409());
        class_243 vec3 = new class_243((Vector3fc)vec);
        class_750 builder = this.minecraft.method_22940().method_22997();
        builder.method_23501();
        for (Section section : this.sections) {
            class_9799.class_9800 result;
            long sectionId = class_4076.method_33706((class_2338)section.origin);
            class_10196 pow = class_10196.method_64069((class_243)new class_243((Vector3fc)vec), (long)sectionId);
            class_9801.class_9802 sortState = section.sectionMesh.method_72039();
            if (sortState == null || !section.sectionMesh.method_72037() || !section.sectionMesh.method_72036(pow) || (result = sortState.method_60824(builder.method_3154(class_11515.field_60926), class_8251.method_49909((Vector3fc)vec))) == null) continue;
            section.sectionMesh.method_72030(class_11515.field_60926, result, sectionId);
            section.sectionMesh.method_72032(pow);
            builder.method_23501();
        }
        this.sections.sort(Comparator.comparing(x -> x.origin.method_19770((class_2374)vec3)));
    }

    @Override
    public class_2561 getTitle() {
        return class_2561.method_43469((String)"text.simple_image_renderer.region", (Object[])new Object[]{this.area.comp_2466().method_23854(), this.area.comp_2467().method_23854()});
    }

    private void renderGroup(class_11532 sectionsToRender, class_11531 chunkSectionLayerGroup, class_12137 gpuSampler) {
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer gpuBuffer = sectionsToRender.comp_4403() == 0 ? null : autoStorageIndexBuffer.method_68274(sectionsToRender.comp_4403());
        VertexFormat.class_5595 indexType = sectionsToRender.comp_4403() == 0 ? null : autoStorageIndexBuffer.method_31924();
        class_11515[] chunkSectionLayers = chunkSectionLayerGroup.method_72167();
        class_310 minecraft = class_310.method_1551();
        boolean bl = class_155.field_29748 && minecraft.field_32144;
        class_6367 renderTarget = this.renderTarget;
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Section layers for " + chunkSectionLayerGroup.method_72166(), renderTarget.method_71639(), OptionalInt.empty(), renderTarget.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.bindTexture("Sampler2", minecraft.field_1773.method_22974().method_71650(), RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST));
            for (class_11515 chunkSectionLayer : chunkSectionLayers) {
                SequencedCollection list = (List)sectionsToRender.comp_4402().get(chunkSectionLayer);
                if (list.isEmpty()) continue;
                if (chunkSectionLayer == class_11515.field_60926) {
                    list = list.reversed();
                }
                renderPass.setPipeline(bl ? class_10799.field_57929 : chunkSectionLayer.method_72020());
                renderPass.bindTexture("Sampler0", sectionsToRender.comp_5192(), gpuSampler);
                renderPass.drawMultipleIndexed((Collection)list, gpuBuffer, indexType, List.of("ChunkSection"), (Object)sectionsToRender.comp_5193());
            }
        }
    }

    private class_11532 prepareChunkRenders(Matrix4fc modelViewMatrix) {
        EnumMap drawsByLayer = new EnumMap(class_11515.class);
        int largestIndexCount = 0;
        for (class_11515 layer : class_11515.values()) {
            drawsByLayer.put(layer, new ArrayList());
        }
        ArrayList<class_11282.class_12294> sectionInfos = new ArrayList<class_11282.class_12294>();
        GpuTextureView blockAtlas = this.minecraft.method_1531().method_4619(class_1059.field_5275).method_71659();
        int textureAtlasWidth = blockAtlas.getWidth(0);
        int textureAtlasHeight = blockAtlas.getHeight(0);
        for (Section section : this.sections) {
            class_11516 sectionMesh = section.sectionMesh();
            class_2338 renderOffset = section.origin;
            int uboIndex = -1;
            for (class_11515 layer : class_11515.values()) {
                VertexFormat.class_5595 indexType;
                GpuBuffer indexBuffer;
                class_10896 buffers = sectionMesh.method_72034(layer);
                if (buffers == null) continue;
                if (uboIndex == -1) {
                    uboIndex = sectionInfos.size();
                    sectionInfos.add(new class_11282.class_12294((Matrix4fc)new Matrix4f(modelViewMatrix), renderOffset.method_10263(), renderOffset.method_10264(), renderOffset.method_10260(), 1.0f, textureAtlasWidth, textureAtlasHeight));
                }
                if (buffers.method_68544() == null) {
                    if (buffers.method_68546() > largestIndexCount) {
                        largestIndexCount = buffers.method_68546();
                    }
                    indexBuffer = null;
                    indexType = null;
                } else {
                    indexBuffer = buffers.method_68544();
                    indexType = buffers.method_68547();
                }
                int finalUboIndex = uboIndex;
                ((List)drawsByLayer.get(layer)).add(new RenderPass.class_10884(0, buffers.method_68540(), indexBuffer, indexType, 0, buffers.method_68546(), (sectionUbos, uploader) -> uploader.upload("ChunkSection", sectionUbos[finalUboIndex])));
            }
        }
        GpuBufferSlice[] chunkSectionInfos = RenderSystem.getDynamicUniforms().method_76294(sectionInfos.toArray(new class_11282.class_12294[0]));
        return new class_11532(blockAtlas, drawsByLayer, largestIndexCount, chunkSectionInfos);
    }

    private static class FauxRenderSectionRegion
    extends class_853 {
        private class_2826 emptySection;
        private final class_9380 area;
        private final class_1937 level;
        private final Long2ObjectMap<class_2826> sections = new Long2ObjectOpenHashMap();

        public FauxRenderSectionRegion(class_1937 level, class_9380 area) {
            super(level, 0, 0, 0, new class_6849[0]);
            this.level = level;
            this.area = area;
        }

        public class_2680 method_8320(class_2338 blockPos) {
            if (this.area.method_58244(blockPos)) {
                long key = class_4076.method_33706((class_2338)blockPos);
                class_2826 section = (class_2826)this.sections.get(key);
                if (section == null) {
                    class_2818 chunk = this.level.method_8497(class_4076.method_18686((long)key), class_4076.method_18690((long)key));
                    section = chunk.method_38259(chunk.method_31603(class_4076.method_18689((long)key))).method_61771();
                    this.sections.put(key, (Object)section);
                }
                return (class_2680)section.method_12265().method_12321(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
            }
            return class_2246.field_10243.method_9564();
        }

        public class_3610 method_8316(class_2338 blockPos) {
            if (this.area.method_58244(blockPos)) {
                long key = class_4076.method_33706((class_2338)blockPos);
                class_2826 section = (class_2826)this.sections.get(key);
                if (section == null) {
                    class_2818 chunk = this.level.method_8497(class_4076.method_18686((long)key), class_4076.method_18690((long)key));
                    section = chunk.method_38259(chunk.method_31603(class_4076.method_18689((long)key))).method_61771();
                    this.sections.put(key, (Object)section);
                }
                return section.method_12255(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
            }
            return class_3612.field_15906.method_15785();
        }

        public @Nullable class_2586 method_8321(class_2338 blockPos) {
            if (this.area.method_58244(blockPos)) {
                return this.level.method_8321(blockPos);
            }
            return null;
        }
    }

    public record Section(class_2338 origin, class_11516 sectionMesh) {
    }

    private static class BoxyFrustum
    extends class_4604 {
        private final class_238 area;

        public BoxyFrustum(class_9380 area) {
            super(new Matrix4f(), new Matrix4f());
            this.area = area.method_58240();
        }

        public boolean method_23093(class_238 aABB) {
            return this.area.method_994(aABB);
        }

        public int method_62978(class_3341 boundingBox) {
            return this.area.method_994(class_238.method_19316((class_3341)boundingBox)) ? 1 : 0;
        }

        public boolean method_74404(double d, double e, double f) {
            return true;
        }
    }
}

