/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleimagerenderer.renderer;

import eu.pb4.simpleimagerenderer.renderer.AbstractImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.EntityImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.ItemImageRenderer;
import eu.pb4.simpleimagerenderer.renderer.RegionImageRenderer;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RendererSettings
implements Cloneable {
    public int width = 512;
    public int height = 512;
    public int yaw = 0;
    public int pitch = 0;
    public int roll = 0;
    public int scale = 100;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public AbstractImageRenderer.LightingType lightingType = AbstractImageRenderer.LightingType.DEFAULT;
    public boolean multiplyNormals = true;
    public double age = -1.0;
    public double walkAnimationSpeed = -1.0;
    public double walkAnimationPos = -1.0;
    public class_811 context = class_811.field_4317;
    public boolean renderEntities = true;
    public boolean renderNametags = true;
    public boolean renderSelf = true;

    public void updateMatrix(AbstractImageRenderer<?> renderer) {
        renderer.updateMatrix(new Matrix4f().translate((float)this.x / 1000.0f * (float)renderer.width, (float)this.y / 1000.0f * (float)renderer.height, (float)this.z / 1000.0f * (float)renderer.width).scale((float)this.scale / 100.0f).rotateXYZ((float)this.pitch * ((float)Math.PI / 180), (float)this.yaw * ((float)Math.PI / 180), (float)this.roll * ((float)Math.PI / 180)), new Quaternionf().rotateZYX((float)this.roll * ((float)Math.PI / 180), (float)(-this.yaw) * ((float)Math.PI / 180), (float)this.pitch * ((float)Math.PI / 180)));
    }

    public void applyAll(AbstractImageRenderer<?> renderer) {
        AbstractImageRenderer renderer1;
        this.updateMatrix(renderer);
        renderer.setupTexture(this.width, this.height);
        renderer.setLightingType(this.lightingType);
        renderer.setMultiplyNormals(this.multiplyNormals);
        if (renderer instanceof ItemImageRenderer) {
            renderer1 = (ItemImageRenderer)renderer;
            ((ItemImageRenderer)renderer1).setDisplayContext(this.context);
        }
        if (renderer instanceof EntityImageRenderer) {
            renderer1 = (EntityImageRenderer)renderer;
            ((EntityImageRenderer)renderer1).setAge((float)this.age);
            renderer.setGlintTime((long)(this.age * 1000.0 / 20.0));
            ((EntityImageRenderer)renderer1).setWalkAnimationPos((float)this.walkAnimationPos);
            ((EntityImageRenderer)renderer1).setWalkAnimationSpeed((float)this.walkAnimationSpeed);
        }
        if (renderer instanceof RegionImageRenderer) {
            renderer1 = (RegionImageRenderer)renderer;
            ((RegionImageRenderer)renderer1).setRenderNametags(this.renderNametags);
            ((RegionImageRenderer)renderer1).setRenderSelf(this.renderSelf);
            ((RegionImageRenderer)renderer1).setRenderEntities(this.renderEntities);
        }
    }

    public RendererSettings clone() {
        try {
            return (RendererSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

