# re-enable flight for players who have the stopped flying tag from raining or pressing the stop flight key
execute as @a[tag=hc_elytra.stopped_flying,tag=!hc_elytra.flight_disabled] run function handcrafted_elytra:flight_control/enable_flight

# stop mid-flight handling
execute unless score #hc_elytra.stop_mid_flight hc_elytra.stop_mid_flight matches 0 as @a[predicate=handcrafted_elytra:is_jumping_or_sneaking,tag=!hc_elytra.key_pressed,tag=hc_elytra.is_gliding] run function handcrafted_elytra:flight_control/stop_mid_flight_handle
tag @a[predicate=handcrafted_elytra:is_jumping_or_sneaking,tag=!hc_elytra.key_pressed] add hc_elytra.key_pressed
tag @a[predicate=handcrafted_elytra:is_gliding] add hc_elytra.is_gliding
tag @a[predicate=!handcrafted_elytra:is_gliding] remove hc_elytra.is_gliding
tag @a[predicate=!handcrafted_elytra:is_jumping_or_sneaking,tag=hc_elytra.key_pressed] remove hc_elytra.key_pressed

# Rocket Boost Handling
# Damage from Rocket Boosting
execute unless score #hc_elytra.rocket_boosting hc_elytra.rocket_boosting matches 0 unless score #hc_elytra.rocket_boosting hc_elytra.rocket_boosting matches 11 as @a[predicate=handcrafted_elytra:active_flight] if score @s hc_elytra.used_rocket matches 1.. run function handcrafted_elytra:boosting/handle_boost
# if no rocket boosting is enabled then disabled flight after boosting
execute if score #hc_elytra.rocket_boosting hc_elytra.rocket_boosting matches 11 as @a[predicate=handcrafted_elytra:active_flight] if score @s hc_elytra.used_rocket matches 1.. run function handcrafted_elytra:flight_control/disable_flight
# Sets score if no score is set
execute as @a unless score @s hc_elytra.flight_boost_cd matches 0.. run scoreboard players set @s hc_elytra.flight_boost_cd 0
# Reduce cooldown score
execute run scoreboard players remove @a[scores={hc_elytra.flight_boost_cd=1..}] hc_elytra.flight_boost_cd 1
# re-enable flight after cooldown period
execute as @a if score @s[tag=hc_elytra.flight_disabled] hc_elytra.flight_boost_cd matches 0 as @a at @s run function handcrafted_elytra:flight_control/enable_flight

# High Altitude Elytra Damage
# Sets score if no score is set
execute as @a unless score @s hc_elytra.altitude_cd matches 0.. run scoreboard players set @s hc_elytra.altitude_cd 0
# Reduce cooldown score
execute run scoreboard players remove @a[scores={hc_elytra.altitude_cd=1..}] hc_elytra.altitude_cd 1
# apply elytra damage after cooldown period
execute unless score #hc_elytra.high_altitude_elytra_damage hc_elytra.high_altitude_elytra_damage matches 0 as @a[predicate=handcrafted_elytra:active_flight] if score @s hc_elytra.altitude_cd matches 0 run function handcrafted_elytra:elytra_damage/apply_from_altitude

# Elytra Durability Damage from Rocket Boosting
execute unless score #hc_elytra.boost_durability_damage hc_elytra.boost_durability_damage matches 0 as @a[predicate=handcrafted_elytra:active_flight] if score @s hc_elytra.used_rocket matches 1.. run function handcrafted_elytra:elytra_damage/apply_from_boost
# High Altitude Fire Damage Check
execute unless score #hc_elytra.high_altitude_fire_damage hc_elytra.high_altitude_fire_damage matches 0 as @a[predicate=handcrafted_elytra:active_flight] at @s run function handcrafted_elytra:player_damage/check_fire_damage_altitude
# nether fire damage
execute unless score #hc_elytra.nether_fire_damage hc_elytra.nether_fire_damage matches 0 as @a[predicate=handcrafted_elytra:active_flight,predicate=handcrafted_elytra:in_nether] at @s run function handcrafted_elytra:player_damage/fire
# stop flight for players flying in rain
execute unless score #hc_elytra.flight_in_rain hc_elytra.flight_in_rain matches 0 as @a[predicate=handcrafted_elytra:active_flight,predicate=handcrafted_elytra:is_wet] at @s run function handcrafted_elytra:flight_control/disable_flight
# break behaviour
execute unless score #hc_elytra.break_behavior hc_elytra.break_behavior matches 0 as @a at @s run function handcrafted_elytra:break_behavior/destroy_broken_elytra
# elytra trail
execute unless score #hc_elytra.trail hc_elytra.trail matches 0 as @a[predicate=handcrafted_elytra:active_flight] at @s run particle item{item:"minecraft:phantom_membrane"} ^ ^0.5 ^-0.5 0.1 0.1 0.1 0.01 2 normal @s

# reset scoreboard used rocket values for Elytra Durability Damage from Rocket Boosting andRocket Boosting
execute unless score #hc_elytra.boost_durability_damage hc_elytra.boost_durability_damage matches 0 run scoreboard players reset @a hc_elytra.used_rocket
execute unless score #hc_elytra.rocket_boosting hc_elytra.rocket_boosting matches 0 run scoreboard players reset @a hc_elytra.used_rocket