/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cant_breathe.entities;

import de.cadentem.cant_breathe.config.ServerConfig;
import de.cadentem.cant_breathe.entities.goals.CantBreatheBreakDoorGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheBreakInvisGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheChaseGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheFleeGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheStareGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheStrollGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheTargetSeesMeGoal;
import de.cadentem.cant_breathe.entities.goals.CantBreatheTargetTooCloseGoal;
import de.cadentem.cant_breathe.entities.goals.CustomHurtByTargetGoal;
import de.cadentem.cant_breathe.entities.goals.Roll;
import de.cadentem.cant_breathe.network.CaveSound;
import de.cadentem.cant_breathe.network.NetworkHandler;
import de.cadentem.cant_breathe.registry.ModSounds;
import de.cadentem.cant_breathe.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CantBreatheEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation CHASE = RawAnimation.begin().then("animation.cant_breathe.new_run", Animation.LoopType.LOOP);
    private final RawAnimation CHASE_IDLE = RawAnimation.begin().then("animation.cant_breathe.run_idle", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_RUN = RawAnimation.begin().then("animation.cant_breathe.crouch_run_new", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_IDLE = RawAnimation.begin().then("animation.cant_breathe.crouch_idle", Animation.LoopType.LOOP);
    private final RawAnimation CALM_RUN = RawAnimation.begin().then("animation.cant_breathe.calm_move", Animation.LoopType.LOOP);
    private final RawAnimation CALM_STILL = RawAnimation.begin().then("animation.cant_breathe.calm_idle", Animation.LoopType.LOOP);
    private final RawAnimation IS_SPOTTED = RawAnimation.begin().then("animation.cant_breathe.spotted", Animation.LoopType.LOOP);
    private final RawAnimation CRAWL = RawAnimation.begin().then("animation.cant_breathe.crawl", Animation.LoopType.LOOP);
    private final RawAnimation FLEE = RawAnimation.begin().then("animation.cant_breathe.flee", Animation.LoopType.LOOP);
    public static final EntityDataAccessor<Boolean> FLEEING_ACCESSOR = SynchedEntityData.m_135353_(CantBreatheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CROUCHING_ACCESSOR = SynchedEntityData.m_135353_(CantBreatheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CRAWLING_ACCESSOR = SynchedEntityData.m_135353_(CantBreatheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SPOTTED_ACCESSOR = SynchedEntityData.m_135353_(CantBreatheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CLIMBING_ACCESSOR = SynchedEntityData.m_135353_(CantBreatheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public Roll currentRoll = Roll.STROLL;
    public boolean isFleeing;
    public boolean hasSpawned;
    public boolean pleaseStopMoving;
    public boolean targetIsFacingMe;
    private int ticksTillRemove;
    private int chaseSoundClock;
    private boolean alreadyPlayedFleeSound;
    private boolean alreadyPlayedSpottedSound;
    private boolean startedPlayingChaseSound;
    private boolean alreadyPlayedDeathSound;
    private int leapCooldown = 0;

    public CantBreatheEntity(EntityType<? extends CantBreatheEntity> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
        this.ticksTillRemove = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE.get());
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.setAttribute(this.m_21051_(Attributes.f_22276_), (Double)ServerConfig.MAX_HEALTH.get());
        this.setAttribute(this.m_21051_(Attributes.f_22281_), (Double)ServerConfig.ATTACK_DAMAGE.get());
        this.setAttribute(this.m_21051_(Attributes.f_22283_), (Double)ServerConfig.ATTACK_SPEED.get());
        this.setAttribute(this.m_21051_(Attributes.f_22279_), (Double)ServerConfig.MOVEMENT_SPEED.get());
        this.setAttribute(this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), 0.4);
    }

    private void setAttribute(AttributeInstance attribute, double newValue) {
        if (attribute != null) {
            double baseValue = attribute.m_22115_();
            float difference = (float)(newValue - baseValue);
            attribute.m_22100_(newValue);
            if (attribute.m_22099_() == Attributes.f_22276_) {
                this.m_21153_(this.m_21223_() + difference);
            } else if (attribute.m_22099_() == Attributes.f_22279_) {
                this.m_7910_(this.m_6113_() + difference);
            }
        }
    }

    public static AttributeSupplier getAttributeBuilder() {
        double maxHealth = 60.0;
        double attackDamage = 6.0;
        double attackSpeed = 0.35;
        double movementSpeed = 0.3;
        double followRange = 100.0;
        return CantBreatheEntity.m_21552_().m_22268_(Attributes.f_22276_, maxHealth).m_22268_(Attributes.f_22281_, attackDamage).m_22268_(Attributes.f_22283_, attackSpeed).m_22268_(Attributes.f_22279_, movementSpeed).m_22268_(Attributes.f_22277_, followRange).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLEEING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CROUCHING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CRAWLING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(SPOTTED_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CLIMBING_ACCESSOR, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CantBreatheChaseGoal(this, true));
        this.f_21345_.m_25352_(1, (Goal)new CantBreatheFleeGoal(this, 30.0f, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new CantBreatheBreakInvisGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CantBreatheStareGoal(this));
        if (((Boolean)ServerConfig.CAN_BREAK_DOOR.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new CantBreatheBreakDoorGoal((Mob)this, difficulty -> true));
        }
        this.f_21345_.m_25352_(3, (Goal)new CantBreatheStrollGoal(this, 0.1));
        this.f_21346_.m_25352_(0, (Goal)new CustomHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new CantBreatheTargetTooCloseGoal(this, 15.0f));
        this.f_21346_.m_25352_(2, (Goal)new CantBreatheTargetSeesMeGoal(this));
    }

    public void disappear() {
        this.playDisappearSound();
        this.m_146870_();
    }

    public boolean hasSpawned() {
        return this.hasSpawned;
    }

    protected boolean m_7341_(@NotNull Entity vehicle) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.m_7341_(vehicle);
        }
        return false;
    }

    public boolean m_7998_(@NotNull Entity vehicle, boolean force) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.m_7998_(vehicle, force);
        }
        return false;
    }

    public boolean m_213824_() {
        return (Boolean)ServerConfig.CAN_DISABLE_SHIELDS.get();
    }

    public boolean m_7327_(Entity target) {
        Player player;
        if (target instanceof Player && (player = (Player)target).m_21254_()) {
            Vec3 knockbackDirection = player.m_20154_().m_82541_().m_82490_(0.9);
            this.m_20334_(knockbackDirection.f_82479_, 0.4, knockbackDirection.f_82481_);
            this.f_19812_ = true;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 255, false, true, true));
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 150);
            System.out.println("CantBreatheEntity hit a blocking player! Knockback and Slowness applied.");
            return false;
        }
        return super.m_7327_(target);
    }

    public void m_8119_() {
        double heightDifference;
        --this.ticksTillRemove;
        if (this.ticksTillRemove <= 0) {
            this.disappear();
            this.breakBlocksNearby();
        }
        if (this.f_21345_.m_148105_().isEmpty() || this.f_21346_.m_148105_().isEmpty()) {
            this.m_8099_();
            this.f_21345_.m_25373_();
            this.f_21346_.m_25373_();
        }
        if (this.m_5448_() != null) {
            this.targetIsFacingMe = this.isLookingAtMe((Entity)this.m_5448_(), false);
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean shouldCrawl;
            boolean isAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_280296_();
            boolean isTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_280296_();
            boolean isThreeAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(3)).m_280296_();
            Vec3i offset = this.getDirectionVector();
            boolean isFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.m_6350_())).m_280296_();
            if (isFacingSolid) {
                offset = offset.m_7918_(0, 1, 0);
            }
            boolean isOffsetFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset)).m_280296_();
            boolean isOffsetFacingAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_7494_()).m_280296_();
            boolean isOffsetFacingTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_6630_(2)).m_280296_();
            boolean shouldCrouch = isTwoAboveSolid || !isOffsetFacingSolid && !isOffsetFacingAboveSolid && (isOffsetFacingTwoAboveSolid || isFacingSolid && isThreeAboveSolid);
            boolean bl = shouldCrawl = isAboveSolid || !isOffsetFacingSolid && isOffsetFacingAboveSolid || isFacingSolid && isTwoAboveSolid;
            if (this.m_5912_() || this.isFleeing) {
                this.f_19804_.m_135381_(SPOTTED_ACCESSOR, (Object)false);
            }
            this.setClimbing(this.f_19862_);
            this.f_19804_.m_135381_(CROUCHING_ACCESSOR, (Object)shouldCrouch);
            this.setCrawling(shouldCrawl);
        }
        if (((Boolean)this.f_19804_.m_135370_(SPOTTED_ACCESSOR)).booleanValue()) {
            this.playSpottedSound();
        }
        this.m_6210_();
        this.m_21573_().m_26517_(this.getSpeedModifier());
        super.m_8119_();
        this.leapCooldown = Math.max(0, this.leapCooldown - 1);
        LivingEntity target = this.m_5448_();
        if (target != null && this.leapCooldown == 0 && (heightDifference = target.m_20186_() - this.m_20186_()) > 4.0) {
            this.leapTowardsTarget(target);
            this.leapCooldown = 60;
        }
    }

    private void leapTowardsTarget(LivingEntity target) {
        Vec3 direction = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double horizontalLeapStrength = 0.9;
        double upwardLeapStrength = 1.5;
        this.m_20256_(new Vec3(direction.f_82479_ * horizontalLeapStrength, upwardLeapStrength, direction.f_82481_ * horizontalLeapStrength));
        this.f_19812_ = true;
        this.playLeapSound();
    }

    private void playLeapSound() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12387_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    private void breakBlocksNearby() {
        BlockPos entityPos = this.m_20183_();
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        List<TagKey> breakableTags = List.of(BlockTags.create((ResourceLocation)new ResourceLocation("forge", "glass")), BlockTags.create((ResourceLocation)new ResourceLocation("forge", "doors")), BlockTags.create((ResourceLocation)new ResourceLocation("forge", "fences")), BlockTags.create((ResourceLocation)new ResourceLocation("forge", "leaves")));
        block0: for (BlockPos pos : BlockPos.m_121940_((BlockPos)entityPos.m_7918_(-1, -1, -1), (BlockPos)entityPos.m_7918_(1, 1, 1))) {
            BlockState state = serverLevel.m_8055_(pos);
            for (TagKey tag : breakableTags) {
                if (!state.m_204336_(tag)) continue;
                serverLevel.m_46961_(pos, true);
                serverLevel.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
                continue block0;
            }
        }
    }

    public double getSpeedModifier() {
        return this.isCrawling() ? 0.35 : (this.m_6047_() ? 0.6 : 0.85);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (((Boolean)this.f_19804_.m_135370_(CRAWLING_ACCESSOR)).booleanValue()) {
            return new EntityDimensions(0.5f, 0.5f, true);
        }
        if (((Boolean)this.f_19804_.m_135370_(CROUCHING_ACCESSOR)).booleanValue()) {
            return new EntityDimensions(0.5f, 1.7f, true);
        }
        return super.m_6972_(pose);
    }

    private boolean isMoving() {
        Vec3 velocity = this.m_20184_();
        float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
        return avgVelocity > 0.03f;
    }

    public void reRoll() {
        this.currentRoll = Roll.fromValue(new Random().nextInt(3));
    }

    public void pickRoll(@NotNull List<Roll> rolls) {
        this.currentRoll = rolls.get(new Random().nextInt(rolls.size()));
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        if (!((Boolean)ServerConfig.CAN_CLIMB.get()).booleanValue()) {
            return false;
        }
        if (this.m_5448_() != null) {
            return !this.isCrawling() && !this.m_6047_() && (Boolean)this.f_19804_.m_135370_(CLIMBING_ACCESSOR) != false;
        }
        return false;
    }

    public void setSpotted(boolean value) {
        this.f_19804_.m_135381_(SPOTTED_ACCESSOR, (Object)value);
    }

    public void setClimbing(boolean isClimbing) {
        this.f_19804_.m_135381_(CLIMBING_ACCESSOR, (Object)isClimbing);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        WallClimberNavigation navigation = new WallClimberNavigation((Mob)this, level);
        navigation.m_26529_(4.0f);
        return navigation;
    }

    private PlayState predicate(AnimationState<CantBreatheEntity> state) {
        boolean isCurrentAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_280296_();
        boolean unsure = this.isCrawling() && this.m_9236_().m_8055_(this.m_20183_()).m_280296_();
        boolean isCurrentTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_280296_();
        if (isCurrentAboveSolid || unsure) {
            return state.setAndContinue(this.CRAWL);
        }
        if (isCurrentTwoAboveSolid) {
            if (state.isMoving()) {
                return state.setAndContinue(this.CROUCH_RUN);
            }
            return state.setAndContinue(this.CROUCH_IDLE);
        }
        if (this.m_5912_()) {
            if (state.isMoving()) {
                return state.setAndContinue(this.CHASE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (((Boolean)this.f_19804_.m_135370_(FLEEING_ACCESSOR)).booleanValue()) {
            if (state.isMoving()) {
                return state.setAndContinue(this.FLEE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (this.pleaseStopMoving || ((Boolean)this.f_19804_.m_135370_(SPOTTED_ACCESSOR)).booleanValue() && !state.isMoving()) {
            return state.setAndContinue(this.IS_SPOTTED);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.CALM_RUN);
        }
        return state.setAndContinue(this.CALM_STILL);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 7, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.m_7355_(pPos, pState);
        this.playEntitySound(this.chooseStep());
    }

    private void playEntitySound(SoundEvent soundEvent) {
        this.playEntitySound(soundEvent, 1.0f, 1.0f);
    }

    private void playEntitySound(SoundEvent soundEvent, float volume, float pitch) {
        this.m_9236_().m_6269_(null, (Entity)this, soundEvent, SoundSource.HOSTILE, volume, pitch);
    }

    private void playBlockPosSound(ResourceLocation soundResource, float volume, float pitch) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radius = 32;
            serverLevel.m_8795_(player -> player.m_20280_((Entity)this) <= (double)(radius * radius)).forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CaveSound(soundResource, this.m_20183_(), volume, pitch)));
        }
    }

    public void playChaseSound() {
        if (this.startedPlayingChaseSound || this.isMoving()) {
            if (this.chaseSoundClock <= 0) {
                Random rand = new Random();
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_1.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_2.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_3.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_4.get(), 3.0f, 1.0f);
                    }
                }
                this.startedPlayingChaseSound = true;
                this.resetChaseSoundClock();
            }
            --this.chaseSoundClock;
        }
    }

    public void playDisappearSound() {
        this.playBlockPosSound(((SoundEvent)ModSounds.DISAPPEAR.get()).m_11660_(), 3.0f, 1.0f);
    }

    public void playFleeSound() {
        if (!this.alreadyPlayedFleeSound) {
            Random rand = new Random();
            switch (rand.nextInt(2)) {
                case 0: {
                    this.playEntitySound((SoundEvent)ModSounds.FLEE_1.get(), 3.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.playEntitySound((SoundEvent)ModSounds.FLEE_2.get(), 3.0f, 1.0f);
                }
            }
            this.alreadyPlayedFleeSound = true;
        }
    }

    private void playSpottedSound() {
        if (!this.alreadyPlayedSpottedSound) {
            this.playEntitySound((SoundEvent)ModSounds.SPOTTED.get(), 3.0f, 1.0f);
            this.alreadyPlayedSpottedSound = true;
        }
    }

    private void resetChaseSoundClock() {
        this.chaseSoundClock = Utils.secondsToTicks(5);
    }

    private SoundEvent chooseStep() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> (SoundEvent)ModSounds.CHASE_STEP_2.get();
            case 2 -> (SoundEvent)ModSounds.CHASE_STEP_3.get();
            case 3 -> (SoundEvent)ModSounds.CHASE_STEP_4.get();
            default -> (SoundEvent)ModSounds.CHASE_STEP_1.get();
        };
    }

    private SoundEvent chooseHurtSound() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> (SoundEvent)ModSounds.DWELLER_HURT_2.get();
            case 2 -> (SoundEvent)ModSounds.DWELLER_HURT_3.get();
            case 3 -> (SoundEvent)ModSounds.DWELLER_HURT_4.get();
            default -> (SoundEvent)ModSounds.DWELLER_HURT_1.get();
        };
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        SoundEvent soundevent = this.chooseHurtSound();
        this.playEntitySound(soundevent, 2.0f, 1.0f);
    }

    public void setCrawling(boolean shouldCrawl) {
        if (shouldCrawl) {
            this.m_20088_().m_135381_(CROUCHING_ACCESSOR, (Object)false);
        }
        this.m_20088_().m_135381_(CRAWLING_ACCESSOR, (Object)shouldCrawl);
        this.m_6210_();
    }

    public boolean isCrawling() {
        return (Boolean)this.f_19804_.m_135370_(CRAWLING_ACCESSOR);
    }

    protected void m_6153_() {
        super.m_6153_();
        if (!this.alreadyPlayedDeathSound) {
            this.playBlockPosSound(((SoundEvent)ModSounds.DWELLER_DEATH.get()).m_11660_(), 2.0f, 1.0f);
            this.alreadyPlayedDeathSound = true;
        }
    }

    public boolean isLookingAtMe(Entity target, boolean directlyLooking) {
        if (!Utils.isValidTarget(target)) {
            return false;
        }
        if (target.m_20299_(1.0f).m_82554_(this.m_20318_(1.0f)) > (double)((Integer)ServerConfig.SPOTTING_RANGE.get()).intValue()) {
            return false;
        }
        Vec3 viewVector = target.m_20252_(1.0f).m_82541_();
        Vec3 difference = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20188_() - target.m_20188_(), this.m_20189_() - target.m_20189_());
        difference = difference.m_82541_();
        double dot = viewVector.m_82526_(difference);
        if (directlyLooking && target instanceof Player) {
            Player player = (Player)target;
            return dot > 0.99 && player.m_142582_((Entity)this);
        }
        return dot > 0.3;
    }

    public boolean teleportToTarget() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        Vec3 targetPosition = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_());
        targetPosition = targetPosition.m_82541_();
        double radius = 16.0;
        double d1 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (radius / 2.0) - targetPosition.f_82479_ * radius;
        double d2 = this.m_20186_() + ((double)this.m_217043_().m_188503_((int)radius) - radius / 2.0) - targetPosition.f_82480_ * radius;
        double d3 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (radius / 2.0) - targetPosition.f_82481_ * radius;
        BlockPos.MutableBlockPos validPosition = new BlockPos.MutableBlockPos(d1, d2, d3);
        while (validPosition.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)validPosition).m_280555_()) {
            validPosition.m_122173_(Direction.DOWN);
        }
        this.m_6021_(validPosition.m_123341_(), validPosition.m_123342_(), validPosition.m_123343_());
        return true;
    }

    private Vec3i getDirectionVector() {
        return new Vec3i(this.m_6350_().m_122429_(), this.m_6350_().m_122430_(), this.m_6350_().m_122431_());
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return this.chooseHurtSound();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DWELLER_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }
}

