/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cant_breathe;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import de.cadentem.cant_breathe.client.CantBreatheRenderer;
import de.cadentem.cant_breathe.config.ServerConfig;
import de.cadentem.cant_breathe.entities.CantBreatheEntity;
import de.cadentem.cant_breathe.network.CaveSound;
import de.cadentem.cant_breathe.network.NetworkHandler;
import de.cadentem.cant_breathe.registry.ModEntityTypes;
import de.cadentem.cant_breathe.registry.ModItems;
import de.cadentem.cant_breathe.registry.ModSounds;
import de.cadentem.cant_breathe.util.Timer;
import de.cadentem.cant_breathe.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="cant_breathe")
public class CantBreathe {
    public static final String MODID = "cant_breathe";
    public static final Logger LOG = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    private static final HashMap<String, Timer> TIMERS = new HashMap();
    public static boolean RELOAD_ALL = false;
    public static boolean RELOAD_MISSING = false;

    public CantBreathe() {
        GeckoLib.initialize();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntityTypes.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.cant_breathe.get()), CantBreatheRenderer::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    @SubscribeEvent
    public void serverStartup(ServerStartedEvent event) {
        RELOAD_ALL = true;
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        String key;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (RELOAD_ALL) {
            TIMERS.clear();
            RELOAD_ALL = false;
        }
        Iterable levels = event.getServer().m_129785_();
        if (TIMERS.isEmpty()) {
            for (ServerLevel level : levels) {
                key = level.m_46472_().m_135782_().toString();
                isRelevant = ((List)ServerConfig.DIMENSION_WHITELIST.get()).contains(key);
                if (!isRelevant) continue;
                TIMERS.put(key, new Timer());
            }
            if (TIMERS.isEmpty() && event.getServer().m_129921_() % 6000 == 0) {
                LOG.debug("There are currently no timers present - are the dimensions properly configured?");
            }
            RELOAD_ALL = false;
            RELOAD_MISSING = false;
        } else if (RELOAD_MISSING) {
            for (ServerLevel level : levels) {
                key = level.m_46472_().m_135782_().toString();
                isRelevant = TIMERS.get(key) == null && ((List)ServerConfig.DIMENSION_WHITELIST.get()).contains(key);
                if (!isRelevant) continue;
                TIMERS.put(key, new Timer());
            }
            RELOAD_MISSING = false;
        }
        for (ServerLevel level : levels) {
            key = level.m_46472_().m_135782_().toString();
            if (TIMERS.get(key) == null) continue;
            this.handleLogic(level);
        }
    }

    private void handleLogic(ServerLevel level) {
        if (level == null) {
            return;
        }
        List players = level.m_8795_(this::isRelevantPlayer);
        if (players.isEmpty()) {
            return;
        }
        String key = level.m_46472_().m_135782_().toString();
        Timer timer = TIMERS.get(key);
        if (timer.currentVictim == null || players.stream().filter(element -> element.m_20149_().equals(timer.currentVictim.m_20149_())).toList().isEmpty()) {
            timer.currentVictim = (Entity)players.get(RANDOM.nextInt(players.size()));
        }
        Iterable entities = level.m_8583_();
        AtomicInteger cantBreatheCount = new AtomicInteger();
        entities.forEach(entity -> {
            if (entity instanceof CantBreatheEntity) {
                cantBreatheCount.getAndAdd(1);
            }
        });
        ++timer.currentSpawn;
        ++timer.currentNoise;
        if (timer.isNoiseTimerReached() && (cantBreatheCount.get() > 0 || timer.currentSpawn >= Utils.secondsToTicks((Integer)ServerConfig.CAN_SPAWN_MAX.get()) / 2)) {
            this.playCaveSoundToSpelunkers(players, timer);
        }
        if (timer.isSpawnTimerReached() && cantBreatheCount.get() < (Integer)ServerConfig.MAXIMUM_AMOUNT.get() && RANDOM.nextDouble() <= (Double)ServerConfig.SPAWN_CHANCE_PER_TICK.get() && timer.currentVictim != null) {
            Optional optionalEntity = Utils.trySpawnMob(timer.currentVictim, (EntityType)ModEntityTypes.cant_breathe.get(), MobSpawnType.TRIGGERED, level, timer.currentVictim.m_20183_(), 40, 35, 6, SpawnUtil.Strategy.f_216413_);
            if (optionalEntity.isPresent()) {
                this.playCaveSoundToSpelunkers(players, timer);
                CantBreatheEntity cantBreathe = (CantBreatheEntity)((Object)optionalEntity.get());
                cantBreathe.m_6842_(true);
                cantBreathe.hasSpawned = true;
                timer.resetSpawnTimer();
            } else {
                timer.currentVictim = null;
            }
        }
    }

    private void playCaveSoundToSpelunkers(List<ServerPlayer> players, Timer timer) {
        Entity currentVictim = timer.currentVictim;
        if (currentVictim == null) {
            return;
        }
        players.forEach(player -> {
            ResourceLocation soundLocation;
            switch (RANDOM.nextInt(4)) {
                case 1: {
                    ResourceLocation resourceLocation = ((SoundEvent)ModSounds.CAVENOISE_2.get()).m_11660_();
                    break;
                }
                case 2: {
                    ResourceLocation resourceLocation = ((SoundEvent)ModSounds.CAVENOISE_3.get()).m_11660_();
                    break;
                }
                case 3: {
                    ResourceLocation resourceLocation = ((SoundEvent)ModSounds.CAVENOISE_4.get()).m_11660_();
                    break;
                }
                default: {
                    ResourceLocation resourceLocation = soundLocation = ((SoundEvent)ModSounds.CAVENOISE_1.get()).m_11660_();
                }
            }
            if (!((Boolean)ServerConfig.ONLY_PLAY_NOISE_TO_TARGET.get()).booleanValue() || player.m_7306_(timer.currentVictim)) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CaveSound(soundLocation, currentVictim.m_20183_(), 2.0f, 1.0f));
            }
        });
        timer.resetNoiseTimer();
    }

    private boolean isRelevantPlayer(ServerPlayer player) {
        if (!Utils.isValidTarget((Entity)player)) {
            return false;
        }
        if (player.m_20182_().f_82480_ > (double)((Integer)ServerConfig.SPAWN_HEIGHT.get()).intValue()) {
            return false;
        }
        ServerLevel serverLevel = player.m_9236_();
        int actualSkyLightLevel = serverLevel.m_45517_(LightLayer.SKY, player.m_20183_()) - serverLevel.m_7445_();
        float sunAngle = serverLevel.m_46490_(1.0f);
        if (actualSkyLightLevel > 0) {
            float f1 = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            sunAngle += (f1 - sunAngle) * 0.2f;
            actualSkyLightLevel = Math.round((float)actualSkyLightLevel * Mth.m_14089_((float)sunAngle));
        }
        if ((actualSkyLightLevel = Mth.m_14045_((int)actualSkyLightLevel, (int)0, (int)15)) > (Integer)ServerConfig.SKY_LIGHT_LEVEL.get()) {
            return false;
        }
        LayerLightEventListener blockLighting = player.m_9236_().m_5518_().m_75814_(LightLayer.BLOCK);
        if (blockLighting.m_7768_(player.m_20183_()) > (Integer)ServerConfig.BLOCK_LIGHT_LEVEL.get()) {
            return false;
        }
        boolean isOnSurface = Utils.isOnSurface((Entity)player);
        if (isOnSurface) {
            if (!((Boolean)ServerConfig.ALLOW_SURFACE_SPAWN.get()).booleanValue()) {
                return false;
            }
            return ServerConfig.isInValidBiome((Entity)player);
        }
        return true;
    }

    public static boolean speedUpTimers(String key, int spawnDelta, int noiseDelta) {
        Timer timer = TIMERS.get(key);
        LOG.debug("Speeding up timers for the dimension [{}], timer: [{}]", (Object)key, (Object)timer);
        if (timer != null) {
            timer.currentSpawn += spawnDelta;
            timer.currentNoise += noiseDelta;
            return true;
        }
        return false;
    }

    public static Pair<Integer, Integer> getTimer(String key, String type) {
        Timer timer = TIMERS.get(key);
        int current = -1;
        int target = -1;
        if (timer != null) {
            switch (type) {
                case "spawn": {
                    current = timer.currentSpawn;
                    target = timer.targetSpawn;
                    break;
                }
                case "noise": {
                    current = timer.currentNoise;
                    target = timer.targetNoise;
                }
            }
        }
        return Pair.of((Object)current, (Object)target);
    }

    @Nullable
    public static Entity getCurrentVictim(String key) {
        Timer timer = TIMERS.get(key);
        if (timer != null) {
            return timer.currentVictim;
        }
        return null;
    }
}

