/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cant_breathe.entities.goals;

import de.cadentem.cant_breathe.entities.CantBreatheEntity;
import de.cadentem.cant_breathe.entities.goals.Roll;
import de.cadentem.cant_breathe.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CantBreatheStareGoal
extends Goal {
    private final CantBreatheEntity cantBreathe;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CantBreatheStareGoal(CantBreatheEntity cantBreathe) {
        this.cantBreathe = cantBreathe;
        this.lookedAtMax = cantBreathe.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.cantBreathe.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.cantBreathe.m_5448_())) {
            return false;
        }
        return this.cantBreathe.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.cantBreathe.m_5448_())) {
            return false;
        }
        return this.cantBreathe.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.cantBreathe.pleaseStopMoving = false;
        this.cantBreathe.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.cantBreathe.m_5448_();
        if (target == null) {
            this.cantBreathe.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.cantBreathe.targetIsFacingMe && target.m_142582_((Entity)this.cantBreathe);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.cantBreathe.m_217043_().m_188500_() < 0.1) {
                this.cantBreathe.disappear();
            } else if (this.cantBreathe.m_217043_().m_188500_() < 0.3) {
                this.cantBreathe.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.cantBreathe.pleaseStopMoving = false;
            this.cantBreathe.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.cantBreathe.pleaseStopMoving = true;
            this.cantBreathe.m_21573_().m_26573_();
            this.cantBreathe.m_20256_(Vec3.f_82478_);
        }
        this.cantBreathe.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

