/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.client;

import com.fullfud.fullfud.client.render.FpvDroneRenderer;
import com.fullfud.fullfud.common.entity.FpvDroneEntity;
import com.fullfud.fullfud.common.item.FpvGogglesItem;
import com.fullfud.fullfud.core.FullfudRegistries;
import com.fullfud.fullfud.core.network.FullfudNetwork;
import com.fullfud.fullfud.core.network.packet.FpvControlPacket;
import com.fullfud.fullfud.core.network.packet.FpvReleasePacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class FpvClientHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final KeyMapping FPV_YAW_LEFT = new KeyMapping("key.fullfud.fpv_yaw_left", InputConstants.Type.KEYSYM, 81, "key.categories.fullfud");
    private static final KeyMapping FPV_YAW_RIGHT = new KeyMapping("key.fullfud.fpv_yaw_right", InputConstants.Type.KEYSYM, 69, "key.categories.fullfud");
    private static final KeyMapping FPV_ARM = new KeyMapping("key.fullfud.fpv_arm", InputConstants.Type.KEYSYM, 86, "key.categories.fullfud");
    private static final ResourceLocation FONT_DIGITAL_LOC = new ResourceLocation("fullfud", "digital");
    private static final Style DIGITAL_STYLE = Style.f_131099_.m_131150_(FONT_DIGITAL_LOC);
    private static final ResourceLocation TEX_PRICEL = new ResourceLocation("fullfud", "textures/gui/hud/pricel.png");
    private static final ResourceLocation TEX_VERT = new ResourceLocation("fullfud", "textures/gui/hud/vert.png");
    private static final ResourceLocation BATTERY_0 = new ResourceLocation("fullfud", "textures/gui/hud/battery/a0.png");
    private static final ResourceLocation BATTERY_25 = new ResourceLocation("fullfud", "textures/gui/hud/battery/a25.png");
    private static final ResourceLocation BATTERY_50 = new ResourceLocation("fullfud", "textures/gui/hud/battery/a50.png");
    private static final ResourceLocation BATTERY_75 = new ResourceLocation("fullfud", "textures/gui/hud/battery/a75.png");
    private static final ResourceLocation BATTERY_100 = new ResourceLocation("fullfud", "textures/gui/hud/battery/a100.png");
    private static final ResourceLocation SIGNAL_0 = new ResourceLocation("fullfud", "textures/gui/hud/signal/0.png");
    private static final ResourceLocation SIGNAL_25 = new ResourceLocation("fullfud", "textures/gui/hud/signal/25.png");
    private static final ResourceLocation SIGNAL_50 = new ResourceLocation("fullfud", "textures/gui/hud/signal/50.png");
    private static final ResourceLocation SIGNAL_75 = new ResourceLocation("fullfud", "textures/gui/hud/signal/75.png");
    private static final ResourceLocation SIGNAL_100 = new ResourceLocation("fullfud", "textures/gui/hud/signal/100.png");
    private static final ResourceLocation SHADER_LOC = new ResourceLocation("fullfud", "shaders/post/fpv_post.json");
    private static UUID activeDrone;
    private static float throttleDemand;
    private static double speedMs;
    private static double groundSpeedKmh;
    private static boolean escRequested;
    private static boolean releaseSent;
    private static double distanceToPilot;
    private static double lastMouseX;
    private static double lastMouseY;
    private static boolean mouseInitialized;
    private static double mouseAccumX;
    private static double mouseAccumY;
    private static final double MOUSE_SENSITIVITY = 0.015;
    private static boolean inFpvMode;
    private static PostChain fpvPostChain;
    private static Field passesFieldCache;
    private static int lastChainWidth;
    private static int lastChainHeight;
    private static float clientTime;

    private FpvClientHandler() {
    }

    public static void registerClientEvents(IEventBus modEventBus) {
        modEventBus.addListener(FpvClientHandler::onRegisterRenderers);
        modEventBus.addListener(FpvClientHandler::onRegisterKeyMappings);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MinecraftForge.EVENT_BUS.addListener(FpvClientHandler::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(FpvClientHandler::onRenderTick);
            MinecraftForge.EVENT_BUS.addListener(FpvClientHandler::onCameraAngles);
            MinecraftForge.EVENT_BUS.addListener(FpvClientHandler::onRenderGui);
        });
    }

    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)FullfudRegistries.FPV_DRONE_ENTITY.get(), FpvDroneRenderer::new);
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(FPV_YAW_LEFT);
        event.register(FPV_YAW_RIGHT);
        event.register(FPV_ARM);
    }

    private static void onRenderTick(TickEvent.RenderTickEvent event) {
        FpvDroneEntity drone;
        UUID controller;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            if (inFpvMode) {
                inFpvMode = false;
                FpvClientHandler.destroyFpvChain();
            }
            return;
        }
        boolean shouldFpv = false;
        float signal = 1.0f;
        Entity entity = minecraft.m_91288_();
        if (entity instanceof FpvDroneEntity && (controller = (drone = (FpvDroneEntity)entity).getControllerId()) != null && controller.equals(minecraft.f_91074_.m_20148_()) && FpvClientHandler.hasLinkedGoggles(minecraft, drone)) {
            shouldFpv = true;
            signal = drone.getSignalQuality();
        }
        if (!shouldFpv) {
            if (inFpvMode) {
                inFpvMode = false;
                FpvClientHandler.destroyFpvChain();
                LOGGER.info("[FPV] FPV post chain disabled");
            }
            return;
        }
        inFpvMode = true;
        clientTime += event.renderTickTime * 0.02f;
        FpvClientHandler.ensureFpvChain(minecraft);
        if (fpvPostChain != null) {
            FpvClientHandler.resizeFpvChainIfNeeded(minecraft);
            FpvClientHandler.updateShaderUniforms(signal);
            try {
                fpvPostChain.m_110023_(event.renderTickTime);
            }
            catch (Exception e) {
                LOGGER.info("[FPV] Error processing FPV post chain: {}", (Object)e.toString());
            }
        }
    }

    private static void ensureFpvChain(Minecraft mc) {
        if (fpvPostChain != null) {
            return;
        }
        try {
            fpvPostChain = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), SHADER_LOC);
            lastChainWidth = mc.m_91268_().m_85441_();
            lastChainHeight = mc.m_91268_().m_85442_();
            fpvPostChain.m_110025_(lastChainWidth, lastChainHeight);
            passesFieldCache = null;
            LOGGER.info("[FPV] Created FPV post chain {}", (Object)SHADER_LOC);
        }
        catch (Exception e) {
            fpvPostChain = null;
            passesFieldCache = null;
            LOGGER.info("[FPV] Failed to create FPV post chain: {}", (Object)e.toString());
        }
    }

    private static void resizeFpvChainIfNeeded(Minecraft mc) {
        if (fpvPostChain == null) {
            return;
        }
        int w = mc.m_91268_().m_85441_();
        int h = mc.m_91268_().m_85442_();
        if (w != lastChainWidth || h != lastChainHeight) {
            lastChainWidth = w;
            lastChainHeight = h;
            try {
                fpvPostChain.m_110025_(w, h);
                LOGGER.info("[FPV] Resized FPV post chain to {}x{}", (Object)w, (Object)h);
            }
            catch (Exception e) {
                LOGGER.info("[FPV] Error resizing FPV post chain: {}", (Object)e.toString());
            }
        }
    }

    private static void destroyFpvChain() {
        if (fpvPostChain != null) {
            try {
                fpvPostChain.close();
                LOGGER.info("[FPV] Destroyed FPV post chain {}", (Object)SHADER_LOC);
            }
            catch (Exception e) {
                LOGGER.info("[FPV] Error destroying FPV post chain: {}", (Object)e.toString());
            }
        }
        fpvPostChain = null;
        passesFieldCache = null;
        lastChainWidth = -1;
        lastChainHeight = -1;
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            FpvClientHandler.resetState();
            return;
        }
        Entity entity = minecraft.m_91288_();
        if (!(entity instanceof FpvDroneEntity)) {
            FpvClientHandler.resetState();
            return;
        }
        FpvDroneEntity drone = (FpvDroneEntity)entity;
        UUID controller = drone.getControllerId();
        if (controller == null || !controller.equals(minecraft.f_91074_.m_20148_())) {
            FpvClientHandler.resetState();
            return;
        }
        if (!FpvClientHandler.hasLinkedGoggles(minecraft, drone)) {
            if (!releaseSent) {
                FullfudNetwork.getChannel().sendToServer((Object)new FpvReleasePacket(drone.m_20148_()));
                releaseSent = true;
            }
            return;
        }
        releaseSent = false;
        if (activeDrone == null || !activeDrone.equals(drone.m_20148_())) {
            throttleDemand = drone.getThrust();
            activeDrone = drone.m_20148_();
        }
        double curX = minecraft.f_91067_.m_91589_();
        double curY = minecraft.f_91067_.m_91594_();
        if (!mouseInitialized) {
            lastMouseX = curX;
            lastMouseY = curY;
            mouseInitialized = true;
        }
        if (minecraft.f_91080_ == null && minecraft.m_91302_()) {
            double dx = curX - lastMouseX;
            double dy = curY - lastMouseY;
            mouseAccumX += dx * 0.015;
            mouseAccumY -= dy * 0.015;
        }
        lastMouseX = curX;
        lastMouseY = curY;
        Vec3 velocity = drone.m_20184_();
        speedMs = velocity.m_82553_() * 20.0;
        Vec3 horiz = new Vec3(velocity.f_82479_, 0.0, velocity.f_82481_);
        groundSpeedKmh = horiz.m_82553_() * 20.0 * 3.6;
        distanceToPilot = Math.sqrt(drone.m_20280_((Entity)minecraft.f_91074_));
        float keyPitch = FpvClientHandler.axis(minecraft.f_91066_.f_92085_.m_90857_(), minecraft.f_91066_.f_92087_.m_90857_());
        float keyRoll = FpvClientHandler.axis(minecraft.f_91066_.f_92086_.m_90857_(), minecraft.f_91066_.f_92088_.m_90857_());
        float pitchInput = Mth.m_14036_((float)(keyPitch + (float)mouseAccumY), (float)-1.0f, (float)1.0f);
        float rollInput = Mth.m_14036_((float)(keyRoll + (float)mouseAccumX), (float)-1.0f, (float)1.0f);
        mouseAccumX = 0.0;
        mouseAccumY = 0.0;
        float yawInput = FpvClientHandler.axis(FPV_YAW_LEFT.m_90857_(), FPV_YAW_RIGHT.m_90857_());
        float throttleDelta = FpvClientHandler.axis(minecraft.f_91066_.f_92089_.m_90857_(), minecraft.f_91066_.f_92090_.m_90857_());
        if (Math.abs(throttleDelta) > 0.001f) {
            throttleDemand = Mth.m_14036_((float)(throttleDemand + throttleDelta * 0.02f), (float)0.0f, (float)1.0f);
        }
        byte armAction = 0;
        if (FPV_ARM.m_90859_()) {
            armAction = drone.isArmed() ? (byte)2 : 1;
        }
        FullfudNetwork.getChannel().sendToServer((Object)new FpvControlPacket(drone.m_20148_(), pitchInput, rollInput, yawInput, throttleDemand, armAction));
        if (minecraft.f_91080_ instanceof PauseScreen && !escRequested) {
            escRequested = true;
            FullfudNetwork.getChannel().sendToServer((Object)new FpvReleasePacket(drone.m_20148_()));
        } else if (!(minecraft.f_91080_ instanceof PauseScreen)) {
            escRequested = false;
        }
    }

    private static void resetState() {
        if (inFpvMode) {
            inFpvMode = false;
            FpvClientHandler.destroyFpvChain();
        }
        activeDrone = null;
        throttleDemand = 0.0f;
        escRequested = false;
        releaseSent = false;
        distanceToPilot = 0.0;
        mouseAccumX = 0.0;
        mouseAccumY = 0.0;
        mouseInitialized = false;
    }

    private static void updateShaderUniforms(float signalQuality) {
        if (fpvPostChain == null) {
            return;
        }
        try {
            if (passesFieldCache == null) {
                for (Field f : PostChain.class.getDeclaredFields()) {
                    List list;
                    if (!List.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    Object obj = f.get(fpvPostChain);
                    if (!(obj instanceof List) || (list = (List)obj).isEmpty() || !(list.get(0) instanceof PostPass)) continue;
                    passesFieldCache = f;
                    LOGGER.info("[FPV] Cached passes field {}", (Object)f.getName());
                    break;
                }
            }
            if (passesFieldCache != null) {
                List passes = (List)passesFieldCache.get(fpvPostChain);
                for (PostPass pass : passes) {
                    Uniform timeU;
                    Uniform signalU = pass.m_110074_().m_108952_("SignalQuality");
                    if (signalU != null) {
                        signalU.m_5985_(signalQuality);
                    }
                    if ((timeU = pass.m_110074_().m_108952_("Time")) == null) continue;
                    timeU.m_5985_(clientTime);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("[FPV] Error updating shader uniforms: {}", (Object)e.toString());
        }
    }

    private static float axis(boolean positive, boolean negative) {
        float pos = positive ? 1.0f : 0.0f;
        float neg = negative ? 1.0f : 0.0f;
        return Mth.m_14036_((float)(pos - neg), (float)-1.0f, (float)1.0f);
    }

    private static void onCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof FpvDroneEntity) {
            FpvDroneEntity drone = (FpvDroneEntity)entity;
            float partial = (float)event.getPartialTick();
            event.setRoll(drone.getCameraRoll(partial));
            event.setPitch(drone.getCameraPitch(partial));
        }
    }

    private static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null) {
            return;
        }
        Entity entity = minecraft.m_91288_();
        if (!(entity instanceof FpvDroneEntity)) {
            return;
        }
        FpvDroneEntity drone = (FpvDroneEntity)entity;
        UUID controller = drone.getControllerId();
        if (controller == null || !controller.equals(minecraft.f_91074_.m_20148_())) {
            return;
        }
        if (!FpvClientHandler.hasLinkedGoggles(minecraft, drone)) {
            return;
        }
        GuiGraphics g = event.getGuiGraphics();
        PoseStack pose = g.m_280168_();
        int w = minecraft.m_91268_().m_85445_();
        int h = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91062_;
        float quality = drone.getSignalQuality();
        int rssi = (int)(quality * 100.0f);
        int battery = drone.getBatteryPercent();
        int cx = w / 2;
        int cy = h / 2;
        float partial = minecraft.getPartialTick();
        float roll = drone.getVisualRoll(partial);
        float pitch = drone.getVisualPitch(partial);
        g.m_280163_(TEX_PRICEL, cx - 16, cy - 16, 0.0f, 0.0f, 32, 32, 32, 32);
        pose.m_85836_();
        pose.m_252880_((float)cx, (float)cy, 0.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_(-roll));
        float pitchOffset = pitch * 2.5f;
        pose.m_252880_(0.0f, pitchOffset, 0.0f);
        pose.m_85841_(2.0f, 2.0f, 1.0f);
        g.m_280163_(TEX_VERT, -32, -2, 0.0f, 0.0f, 64, 4, 64, 4);
        pose.m_85849_();
        ResourceLocation batTex = FpvClientHandler.getBatteryTexture(battery);
        g.m_280411_(batTex, 10, 10, 16, 32, 0.0f, 0.0f, 64, 128, 64, 128);
        ResourceLocation sigTex = FpvClientHandler.getSignalTexture(rssi);
        int sigW = 64;
        int sigH = 32;
        int sigX = w - 10 - sigW;
        g.m_280411_(sigTex, sigX, 10, sigW, sigH, 0.0f, 0.0f, 128, 64, 128, 64);
        MutableComponent acroText = Component.m_237113_((String)"ACRO").m_130948_(DIGITAL_STYLE);
        int acroW = font.m_92852_((FormattedText)acroText);
        g.m_280614_(font, (Component)acroText, cx - acroW / 2, 45, -1, true);
        if (!drone.isArmed()) {
            MutableComponent disarmedText = Component.m_237113_((String)"D  I  S  A  R  M  E  D").m_130948_(DIGITAL_STYLE);
            int dW = font.m_92852_((FormattedText)disarmedText);
            int dY = (int)((float)h * 0.75f);
            g.m_280614_(font, (Component)disarmedText, cx - dW / 2, dY, -1, true);
        }
        if (quality <= 0.05f) {
            if (System.currentTimeMillis() % 1000L < 500L) {
                text = Component.m_237113_((String)"CONNECTION LOST").m_130948_(DIGITAL_STYLE);
                tw = font.m_92852_((FormattedText)text);
                g.m_280509_(cx - tw / 2 - 2, cy - 40 - 2, cx + tw / 2 + 2, cy - 40 + 10, -1442840576);
                g.m_280614_(font, (Component)text, cx - tw / 2, cy - 40, -65536, true);
            }
        } else if (distanceToPilot > 500.0) {
            text = Component.m_237113_((String)"MAX RANGE").m_130948_(DIGITAL_STYLE);
            tw = font.m_92852_((FormattedText)text);
            g.m_280614_(font, (Component)text, cx - tw / 2, cy - 40, -65536, true);
        } else if (distanceToPilot > 450.0 && System.currentTimeMillis() % 1000L < 500L) {
            text = Component.m_237113_((String)"TURN AROUND").m_130948_(DIGITAL_STYLE);
            tw = font.m_92852_((FormattedText)text);
            g.m_280614_(font, (Component)text, cx - tw / 2, cy - 40, -22016, true);
        }
        MutableComponent batText = Component.m_237113_((String)String.valueOf(battery)).m_130948_(DIGITAL_STYLE);
        g.m_280614_(font, (Component)batText, 30, 22, -1, true);
        MutableComponent rssiText = Component.m_237113_((String)String.valueOf(rssi)).m_130948_(DIGITAL_STYLE);
        int rssiTextW = font.m_92852_((FormattedText)rssiText);
        g.m_280614_(font, (Component)rssiText, sigX - rssiTextW - 5, 22, -1, true);
        int botY = h - 10;
        MutableComponent cZ = Component.m_237113_((String)String.format("z = %.0f", drone.m_20189_())).m_130948_(DIGITAL_STYLE);
        MutableComponent cY = Component.m_237113_((String)String.format("y = %.0f", drone.m_20186_())).m_130948_(DIGITAL_STYLE);
        MutableComponent cX = Component.m_237113_((String)String.format("x = %.0f", drone.m_20185_())).m_130948_(DIGITAL_STYLE);
        g.m_280614_(font, (Component)cZ, 10, botY, -1, true);
        g.m_280614_(font, (Component)cY, 10, botY - 10, -1, true);
        g.m_280614_(font, (Component)cX, 10, botY - 20, -1, true);
        MutableComponent power = Component.m_237113_((String)String.format("Power = %3d%%", (int)(drone.getThrust() * 100.0f))).m_130948_(DIGITAL_STYLE);
        MutableComponent ias = Component.m_237113_((String)String.format("IAS = %.0f KM/h", speedMs * 3.6)).m_130948_(DIGITAL_STYLE);
        MutableComponent gs = Component.m_237113_((String)String.format("GS = %.0f KM/h", groundSpeedKmh)).m_130948_(DIGITAL_STYLE);
        int rightX = w - 10;
        g.m_280614_(font, (Component)gs, rightX - font.m_92852_((FormattedText)gs), botY, -1, true);
        g.m_280614_(font, (Component)ias, rightX - font.m_92852_((FormattedText)ias), botY - 10, -1, true);
        g.m_280614_(font, (Component)power, rightX - font.m_92852_((FormattedText)power), botY - 20, -1, true);
    }

    private static ResourceLocation getBatteryTexture(int percent) {
        if (percent >= 75) {
            return BATTERY_100;
        }
        if (percent >= 50) {
            return BATTERY_75;
        }
        if (percent >= 25) {
            return BATTERY_50;
        }
        if (percent > 0) {
            return BATTERY_25;
        }
        return BATTERY_0;
    }

    private static ResourceLocation getSignalTexture(int percent) {
        if (percent >= 75) {
            return SIGNAL_100;
        }
        if (percent >= 50) {
            return SIGNAL_75;
        }
        if (percent >= 25) {
            return SIGNAL_50;
        }
        if (percent > 0) {
            return SIGNAL_25;
        }
        return SIGNAL_0;
    }

    private static boolean hasLinkedGoggles(Minecraft minecraft, FpvDroneEntity drone) {
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (!(head.m_41720_() instanceof FpvGogglesItem)) {
            return false;
        }
        return FpvGogglesItem.getLinked(head).filter(id -> id.equals(drone.m_20148_())).isPresent();
    }

    static {
        mouseInitialized = false;
        inFpvMode = false;
        lastChainWidth = -1;
        lastChainHeight = -1;
        clientTime = 0.0f;
    }
}

