/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.client;

import com.fullfud.fullfud.client.render.RebEmitterRenderer;
import com.fullfud.fullfud.client.render.ShahedDroneRenderer;
import com.fullfud.fullfud.client.render.ShahedLauncherRenderer;
import com.fullfud.fullfud.client.screen.ShahedMonitorScreen;
import com.fullfud.fullfud.client.sound.RebStaticNoiseSound;
import com.fullfud.fullfud.client.sound.ShahedEngineLoopSound;
import com.fullfud.fullfud.common.entity.RebEmitterEntity;
import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.core.FullfudRegistries;
import com.fullfud.fullfud.core.network.FullfudNetwork;
import com.fullfud.fullfud.core.network.packet.ShahedControlPacket;
import com.fullfud.fullfud.core.network.packet.ShahedLinkPacket;
import com.fullfud.fullfud.core.network.packet.ShahedStatusPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public final class ShahedClientHandler {
    private static final KeyMapping POWER_UP = new KeyMapping("key.fullfud.power_up", InputConstants.Type.KEYSYM, 82, "key.categories.fullfud");
    private static final KeyMapping POWER_DOWN = new KeyMapping("key.fullfud.power_down", InputConstants.Type.KEYSYM, 70, "key.categories.fullfud");
    private static ShahedStatusPacket lastStatus;
    private static long lastStatusTimestamp;
    private static final Map<UUID, EngineAudioController> ENGINE_AUDIO;
    private static final Map<Integer, RebNoiseHandle> REB_NOISE;

    private ShahedClientHandler() {
    }

    public static void registerClientEvents(IEventBus modEventBus) {
        modEventBus.addListener(ShahedClientHandler::onRegisterRenderers);
        modEventBus.addListener(ShahedClientHandler::onRegisterKeyMappings);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FullfudRegistries.SHAHED_MONITOR_MENU.get()), ShahedMonitorScreen::new);
            MinecraftForge.EVENT_BUS.addListener(ShahedClientHandler::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(ShahedClientHandler::onRenderLevelStage);
            MinecraftForge.EVENT_BUS.addListener(ShahedClientHandler::onRenderGui);
            MinecraftForge.EVENT_BUS.addListener(ShahedClientHandler::onComputeCameraAngles);
        });
    }

    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)FullfudRegistries.SHAHED_ENTITY.get(), ShahedDroneRenderer::new);
        event.registerEntityRenderer((EntityType)FullfudRegistries.SHAHED_LAUNCHER_ENTITY.get(), ShahedLauncherRenderer::new);
        event.registerEntityRenderer((EntityType)FullfudRegistries.REB_EMITTER_ENTITY.get(), RebEmitterRenderer::new);
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(POWER_UP);
        event.register(POWER_DOWN);
    }

    public static void handleStatusPacket(ShahedStatusPacket packet) {
        lastStatus = packet;
        lastStatusTimestamp = System.currentTimeMillis();
    }

    public static void handleLinkPacket(ShahedLinkPacket packet) {
    }

    public static ShahedStatusPacket getLastStatus() {
        return lastStatus;
    }

    public static KeyMapping getPowerUpKey() {
        return POWER_UP;
    }

    public static KeyMapping getPowerDownKey() {
        return POWER_DOWN;
    }

    public static boolean hasFreshStatus(int timeoutMs) {
        if (lastStatus == null) {
            return false;
        }
        return System.currentTimeMillis() - lastStatusTimestamp <= (long)timeoutMs;
    }

    public static void sendControlPacket(UUID droneId, float forward, float strafe, float vertical, float thrustDelta) {
        if (droneId == null) {
            return;
        }
        FullfudNetwork.getChannel().sendToServer((Object)new ShahedControlPacket(droneId, forward, strafe, vertical, thrustDelta));
    }

    private static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof ShahedDroneEntity) {
            ShahedDroneEntity drone = (ShahedDroneEntity)entity;
            event.setRoll(drone.getVisualRoll((float)event.getPartialTick()));
            event.setPitch(drone.getVisualPitch((float)event.getPartialTick()));
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        if (minecraft.f_91073_ == null || minecraft.m_91104_()) {
            ENGINE_AUDIO.values().forEach(EngineAudioController::stop);
            ENGINE_AUDIO.clear();
            REB_NOISE.values().forEach(RebNoiseHandle::stop);
            REB_NOISE.clear();
            return;
        }
        ENGINE_AUDIO.values().forEach(controller -> {
            controller.seen = false;
        });
        REB_NOISE.values().forEach(handle -> {
            handle.seen = false;
        });
        for (Entity entity : minecraft.f_91073_.m_104735_()) {
            if (entity instanceof ShahedDroneEntity) {
                ShahedDroneEntity drone = (ShahedDroneEntity)entity;
                ENGINE_AUDIO.computeIfAbsent(drone.m_20148_(), id -> new EngineAudioController(drone)).updateFromEntity();
                continue;
            }
            if (!(entity instanceof RebEmitterEntity)) continue;
            RebEmitterEntity emitter = (RebEmitterEntity)entity;
            REB_NOISE.computeIfAbsent(emitter.m_19879_(), id -> new RebNoiseHandle(emitter)).update(emitter);
        }
        ENGINE_AUDIO.entrySet().removeIf(entry -> ((EngineAudioController)entry.getValue()).shouldRemove());
        REB_NOISE.entrySet().removeIf(entry -> ((RebNoiseHandle)entry.getValue()).shouldRemove());
    }

    private static void onRenderLevelStage(RenderLevelStageEvent event) {
        RebEmitterEntity emitter;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        if (!ShahedClientHandler.isHoldingBattery((Player)minecraft.f_91074_)) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHit = (EntityHitResult)hitResult;
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof RebEmitterEntity) || (emitter = (RebEmitterEntity)entity).m_213877_() || emitter.hasBattery()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        Vec3 cameraPos = event.getCamera().m_90583_();
        poseStack.m_85837_(emitter.m_20185_() - cameraPos.f_82479_, emitter.m_20186_() - cameraPos.f_82480_, emitter.m_20189_() - cameraPos.f_82481_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        float half = 0.25f;
        float y = 0.5f;
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -0.25f, 0.5f, -0.25f).m_6122_(32, 255, 96, 160).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), 0.25f, 0.5f, -0.25f).m_6122_(32, 255, 96, 160).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), 0.25f, 0.5f, 0.25f).m_6122_(32, 255, 96, 160).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -0.25f, 0.5f, 0.25f).m_6122_(32, 255, 96, 160).m_5752_();
        BufferBuilder.RenderedBuffer renderedBuffer = builder.m_231175_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderedBuffer);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void onRenderGui(RenderGuiEvent.Post event) {
        RebEmitterEntity emitter;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        if (minecraft.f_91080_ != null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHit = (EntityHitResult)hitResult;
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof RebEmitterEntity) || (emitter = (RebEmitterEntity)entity).m_213877_()) {
            return;
        }
        Component statusText = ShahedClientHandler.resolveEmitterStatus(emitter);
        Component chargeText = ShahedClientHandler.resolveEmitterCharge(emitter);
        GuiGraphics graphics = event.getGuiGraphics();
        Font font = minecraft.f_91062_;
        int padding = 6;
        int spacing = 2;
        int width = Math.max(font.m_92852_((FormattedText)statusText), font.m_92852_((FormattedText)chargeText)) + 12;
        Objects.requireNonNull(font);
        int height = 9 * 2 + 2 + 12;
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int x = (screenWidth - width) / 2;
        int y = screenHeight / 2 + 20;
        graphics.m_280509_(x, y, x + width, y + height, -2013265920);
        graphics.m_280614_(font, statusText, x + 6, y + 6, -1, false);
        Objects.requireNonNull(font);
        graphics.m_280614_(font, chargeText, x + 6, y + 6 + 9 + 2, -5197648, false);
    }

    private static boolean isHoldingBattery(Player player) {
        return player.m_21205_().m_150930_((Item)FullfudRegistries.REB_BATTERY_ITEM.get()) || player.m_21206_().m_150930_((Item)FullfudRegistries.REB_BATTERY_ITEM.get());
    }

    private static Component resolveEmitterStatus(RebEmitterEntity emitter) {
        if (!emitter.hasBattery()) {
            return Component.m_237115_((String)"status.fullfud.reb.no_battery");
        }
        if (!emitter.hasFinishedStartup()) {
            return Component.m_237115_((String)"status.fullfud.reb.starting");
        }
        int chargeTicks = emitter.getChargeTicks();
        if (chargeTicks <= 0) {
            return Component.m_237115_((String)"status.fullfud.reb.low_power");
        }
        float percent = (float)chargeTicks / 4000.0f;
        if (percent <= 0.05f) {
            return Component.m_237115_((String)"status.fullfud.reb.low_power");
        }
        return Component.m_237115_((String)"status.fullfud.reb.working");
    }

    private static Component resolveEmitterCharge(RebEmitterEntity emitter) {
        int chargeTicks = emitter.hasBattery() ? emitter.getChargeTicks() : 0;
        int percent = Mth.m_14045_((int)Math.round((float)chargeTicks / 4000.0f * 100.0f), (int)0, (int)100);
        return Component.m_237110_((String)"status.fullfud.reb.charge", (Object[])new Object[]{percent});
    }

    static {
        ENGINE_AUDIO = new HashMap<UUID, EngineAudioController>();
        REB_NOISE = new HashMap<Integer, RebNoiseHandle>();
    }

    private static final class EngineAudioController {
        private static final float ACTIVE_THRESHOLD = 0.02f;
        private final ShahedDroneEntity drone;
        private ShahedEngineLoopSound loopSound;
        private float lastThrust;
        private boolean seen;

        private EngineAudioController(ShahedDroneEntity drone) {
            this.drone = drone;
        }

        private boolean isInvalid() {
            return this.drone.m_213877_() || !this.drone.m_6084_();
        }

        private void stop() {
            if (this.loopSound != null) {
                this.loopSound.stopSound();
                this.loopSound = null;
            }
        }

        private void updateFromEntity() {
            this.seen = true;
            this.update(this.drone.getThrust());
        }

        private void update(float thrust) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft == null || minecraft.f_91073_ == null) {
                return;
            }
            if (this.isInvalid()) {
                this.stop();
                return;
            }
            float clamped = Mth.m_14036_((float)thrust, (float)0.0f, (float)1.0f);
            if (clamped > 0.02f) {
                if (this.lastThrust <= 0.02f) {
                    this.playOneShot((SoundEvent)FullfudRegistries.SHAHED_ENGINE_START.get(), clamped);
                }
                this.ensureLoop();
                if (this.loopSound != null) {
                    this.loopSound.setEngineMix(clamped);
                }
            } else if (this.lastThrust > 0.02f) {
                this.stop();
                this.playOneShot((SoundEvent)FullfudRegistries.SHAHED_ENGINE_END.get(), this.lastThrust);
            }
            this.lastThrust = clamped;
            if (clamped <= 0.02f && this.loopSound != null) {
                this.loopSound.setEngineMix(0.0f);
            }
        }

        private boolean shouldRemove() {
            if (!this.seen || this.isInvalid()) {
                this.stop();
                return true;
            }
            return false;
        }

        private void ensureLoop() {
            Minecraft minecraft = Minecraft.m_91087_();
            if (this.loopSound != null && !this.loopSound.m_7801_()) {
                return;
            }
            this.loopSound = new ShahedEngineLoopSound(this.drone);
            this.loopSound.setEngineMix(Math.max(this.lastThrust, 0.02f));
            minecraft.m_91106_().m_120367_((SoundInstance)this.loopSound);
        }

        private void playOneShot(SoundEvent event, float thrust) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft == null || minecraft.f_91073_ == null) {
                return;
            }
            float volume = 0.25f + 0.75f * thrust;
            float pitch = 0.9f + 0.2f * thrust;
            minecraft.f_91073_.m_7785_(this.drone.m_20185_(), this.drone.m_20186_(), this.drone.m_20189_(), event, SoundSource.NEUTRAL, volume, pitch, false);
        }
    }

    private static final class RebNoiseHandle {
        private RebEmitterEntity emitter;
        private RebStaticNoiseSound sound;
        private boolean seen;

        private RebNoiseHandle(RebEmitterEntity emitter) {
            this.emitter = emitter;
        }

        private void update(RebEmitterEntity emitter) {
            this.emitter = emitter;
            this.seen = true;
            this.ensureSound();
        }

        private void ensureSound() {
            if (this.sound != null && !this.sound.m_7801_()) {
                return;
            }
            if (this.emitter == null || !this.emitter.hasBattery() || this.emitter.getChargeTicks() <= 0) {
                return;
            }
            this.sound = new RebStaticNoiseSound(this.emitter);
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null) {
                minecraft.m_91106_().m_120367_((SoundInstance)this.sound);
            }
        }

        private boolean shouldRemove() {
            if (!this.seen || this.emitter == null || this.emitter.m_213877_()) {
                this.stop();
                return true;
            }
            if (this.sound != null && this.sound.shouldRemove()) {
                this.sound = null;
            }
            return false;
        }

        private void stop() {
            if (this.sound != null) {
                this.sound.stopSound();
                this.sound = null;
            }
        }
    }
}

