/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.client.model;

import com.fullfud.fullfud.common.entity.ShahedColor;
import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class ShahedDroneModel
extends GeoModel<ShahedDroneEntity> {
    private static final ResourceLocation MODEL = new ResourceLocation("fullfud", "geo/shahed_136.geo.json");
    private static final ResourceLocation MODEL_ON_LAUNCHER = new ResourceLocation("fullfud", "geo/shahed_136onlauncher.geo.json");
    private static final ResourceLocation TEXTURE_WHITE = new ResourceLocation("fullfud", "textures/entity/shahed_136.png");
    private static final ResourceLocation TEXTURE_BLACK = new ResourceLocation("fullfud", "textures/entity/shahed_136_black.png");
    private static final ResourceLocation ANIMATION = new ResourceLocation("fullfud", "animations/shahed_136.animation.json");

    public ResourceLocation getModelResource(ShahedDroneEntity animatable) {
        return animatable.isOnLauncher() ? MODEL_ON_LAUNCHER : MODEL;
    }

    public ResourceLocation getTextureResource(ShahedDroneEntity animatable) {
        return animatable.getColor() == ShahedColor.BLACK ? TEXTURE_BLACK : TEXTURE_WHITE;
    }

    public ResourceLocation getAnimationResource(ShahedDroneEntity animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(ShahedDroneEntity animatable, long instanceId, AnimationState<ShahedDroneEntity> animationState) {
        double horizontalSpeed;
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        CoreGeoBone root = this.getAnimationProcessor().getBone("bone");
        if (root == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        float basePitchRad = (float)Math.toRadians(animatable.getVisualPitch(partialTick));
        float extraPitch = 0.0f;
        Vec3 motion = animatable.m_20184_();
        double speedSq = motion.m_82556_();
        if (speedSq > 0.001 && ((horizontalSpeed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) > 0.1 || Math.abs(motion.f_82480_) > 0.05)) {
            float velocityPitch = (float)Math.atan2(motion.f_82480_, Math.max(0.001, horizontalSpeed));
            float pitchWeight = (float)Mth.m_14008_((double)(horizontalSpeed / 12.0), (double)0.0, (double)1.0);
            extraPitch = Mth.m_14036_((float)((velocityPitch - basePitchRad) * pitchWeight * 8.0f), (float)((float)Math.toRadians(-60.0)), (float)((float)Math.toRadians(60.0)));
        }
        root.setRotX(basePitchRad + extraPitch);
        root.setRotZ(0.0f);
    }
}

