/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.client.screen;

import com.fullfud.fullfud.client.ShahedClientHandler;
import com.fullfud.fullfud.common.entity.RebEmitterEntity;
import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.common.menu.ShahedMonitorMenu;
import com.fullfud.fullfud.core.network.packet.ShahedStatusPacket;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class ShahedMonitorScreen
extends AbstractContainerScreen<ShahedMonitorMenu> {
    private static final int CONTROL_INTERVAL = 1;
    private static final int HUD_MARGIN = 28;
    private DynamicTexture noiseTexture;
    private ResourceLocation noiseTextureLocation;
    private int noiseTexWidth;
    private int noiseTexHeight;
    private float jammerNoiseOverride;
    private boolean jammerDisablesControls;
    private int controlTicker;
    private Entity previousCamera;
    private boolean cameraOverridden;
    private boolean hudOverridden;
    private boolean previousHideGui;
    private boolean hasCameraFeed;
    private boolean ascendPressed;
    private boolean descendPressed;
    private boolean strafeLeftPressed;
    private boolean strafeRightPressed;
    private boolean increasePowerPressed;
    private boolean decreasePowerPressed;
    private final SmoothedStatus smoothedStatus = new SmoothedStatus();
    private CameraType previousCameraType;

    public ShahedMonitorScreen(ShahedMonitorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97730_ = Integer.MIN_VALUE;
        this.f_97731_ = Integer.MIN_VALUE;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97726_ = this.f_96543_;
        this.f_97727_ = this.f_96544_;
        if (this.f_96541_ != null) {
            this.previousCamera = this.f_96541_.f_91074_;
            this.previousCameraType = this.f_96541_.f_91066_.m_92176_();
            this.previousHideGui = this.f_96541_.f_91066_.f_92062_;
            this.f_96541_.f_91066_.f_92062_ = true;
            this.hudOverridden = true;
            this.noiseTexWidth = this.f_96543_;
            this.noiseTexHeight = this.f_96544_;
            this.noiseTexture = new DynamicTexture(this.noiseTexWidth, this.noiseTexHeight, true);
            this.noiseTextureLocation = this.f_96541_.m_91097_().m_118490_("shahed_noise", this.noiseTexture);
        }
        this.cameraOverridden = false;
        this.hasCameraFeed = false;
        this.jammerNoiseOverride = 0.0f;
        this.jammerDisablesControls = false;
        this.ensureCamera();
    }

    protected void m_181908_() {
        super.m_181908_();
        ShahedStatusPacket status = ShahedClientHandler.getLastStatus();
        boolean fresh = ShahedClientHandler.hasFreshStatus(2000);
        if (status == null || !fresh || status.signalLost()) {
            this.restoreCamera();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
            return;
        }
        this.ensureCamera();
        this.updateJammerOverlay();
        this.applyCameraShake(status);
        if (++this.controlTicker >= 1) {
            this.controlTicker = 0;
            this.sendControlInput();
        }
    }

    private void applyCameraShake(ShahedStatusPacket status) {
        float totalShake;
        if (this.f_96541_ == null || this.f_96541_.f_91075_ == null) {
            return;
        }
        Entity entity = this.f_96541_.f_91075_;
        if (!(entity instanceof ShahedDroneEntity)) {
            return;
        }
        ShahedDroneEntity drone = (ShahedDroneEntity)entity;
        float thrust = status.thrust();
        float vSpeed = status.verticalSpeed();
        float engineShake = thrust * thrust * 1.2f;
        float diveShake = 0.0f;
        if (vSpeed < -15.0f) {
            float diveFactor = Math.min(Math.abs(vSpeed) - 15.0f, 40.0f) / 40.0f;
            diveShake = diveFactor * 2.5f;
        }
        if ((totalShake = Math.max(engineShake, diveShake)) > 0.01f) {
            float rx = (float)((Math.random() - 0.5) * (double)totalShake);
            float ry = (float)((Math.random() - 0.5) * (double)totalShake);
            drone.m_146926_(drone.m_146909_() + rx);
            drone.m_146922_(drone.m_146908_() + ry);
            drone.f_19860_ += rx;
            drone.f_19859_ += ry;
        }
    }

    public void m_7861_() {
        super.m_7861_();
        this.resetKeyStates();
        this.requestCameraRelease();
        this.restoreCamera();
        if (this.noiseTexture != null) {
            this.noiseTexture.close();
            this.noiseTexture = null;
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.requestCameraRelease();
        this.restoreCamera();
        this.resetKeyStates();
        if (this.noiseTexture != null) {
            this.noiseTexture.close();
            this.noiseTexture = null;
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.drawFullPanel(graphics);
    }

    public void m_280273_(GuiGraphics graphics) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.drawStatusOverlay(graphics, partialTick);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    private void drawFullPanel(GuiGraphics graphics) {
        boolean monitorX = false;
        boolean monitorY = false;
        int monitorWidth = this.f_96543_;
        int monitorHeight = this.f_96544_;
        graphics.m_280509_(0, 0, 0 + monitorWidth, 0 + monitorHeight, 0);
        ShahedStatusPacket status = ShahedClientHandler.getLastStatus();
        boolean liveSignal = this.hasLiveFeed(status);
        double distance = 0.0;
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && status != null) {
            double dx = status.x() - this.f_96541_.f_91074_.m_20185_();
            double dy = status.y() - this.f_96541_.f_91074_.m_20186_();
            double dz = status.z() - this.f_96541_.f_91074_.m_20189_();
            distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        float noiseOpacity = status != null ? status.noiseLevel() : 0.0f;
        noiseOpacity = Math.max(noiseOpacity, this.computeNoiseOpacityByDistance(distance));
        float displayNoise = this.toDisplayNoise(noiseOpacity = Math.max(noiseOpacity, this.jammerNoiseOverride));
        if (displayNoise > 0.0f) {
            this.renderTvNoise(graphics, 0, 0, monitorWidth, monitorHeight, displayNoise);
        }
        if (!liveSignal) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.fullfud.monitor.no_signal"), 28, 28, -43691, false);
        }
    }

    private void renderTvNoise(GuiGraphics graphics, int x, int y, int width, int height, float opacity) {
        if (opacity <= 0.0f || this.f_96541_ == null) {
            return;
        }
        if (this.noiseTexture == null || this.noiseTexWidth != width || this.noiseTexHeight != height) {
            this.noiseTexWidth = width;
            this.noiseTexHeight = height;
            this.noiseTexture = new DynamicTexture(this.noiseTexWidth, this.noiseTexHeight, true);
            this.noiseTextureLocation = this.f_96541_.m_91097_().m_118490_("shahed_noise", this.noiseTexture);
        }
        long time = this.f_96541_.f_91073_ != null ? this.f_96541_.f_91073_.m_46467_() : System.currentTimeMillis() / 50L;
        this.updateNoiseTexture(time);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.m_14036_((float)opacity, (float)0.0f, (float)1.0f));
        graphics.m_280163_(this.noiseTextureLocation, x, y, 0.0f, 0.0f, width, height, this.noiseTexWidth, this.noiseTexHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void updateNoiseTexture(long time) {
        if (this.noiseTexture == null) {
            return;
        }
        NativeImage image = this.noiseTexture.m_117991_();
        if (image == null) {
            return;
        }
        long seed = time * 341873128712L ^ 0x1EF1565BD5L;
        for (int y = 0; y < this.noiseTexHeight; ++y) {
            for (int x = 0; x < this.noiseTexWidth; ++x) {
                seed ^= seed << 13;
                seed ^= seed >> 7;
                seed ^= seed << 17;
                int grey = (int)(seed & 0xFFL);
                int color = 0xFF000000 | grey << 16 | grey << 8 | grey;
                image.m_84988_(x, y, color);
            }
        }
        this.noiseTexture.m_117985_();
    }

    private float computeNoiseOpacityByDistance(double distance) {
        if (distance <= 0.0) {
            return 0.0f;
        }
        return (float)Math.min(distance / 10000.0, 0.5);
    }

    private float toDisplayNoise(float percent) {
        float clamped = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        if (clamped <= 0.0f) {
            return 0.0f;
        }
        if (clamped <= 0.5f) {
            float normalized = clamped / 0.5f;
            float eased = 1.0f - (float)Math.pow(1.0f - normalized, 2.5);
            return 0.5f * eased;
        }
        float normalized = (clamped - 0.5f) / 0.5f;
        float eased = 1.0f - (float)Math.pow(1.0f - normalized, 2.5);
        return 0.5f + 0.5f * eased;
    }

    private void updateJammerOverlay() {
        this.jammerNoiseOverride = 0.0f;
        this.jammerDisablesControls = false;
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        ShahedStatusPacket status = ShahedClientHandler.getLastStatus();
        if (status == null) {
            return;
        }
        Vec3 dronePos = new Vec3(status.x(), status.y(), status.z());
        double maxRadius = 600.0;
        AABB searchBox = new AABB(dronePos, dronePos).m_82377_(600.0, 600.0, 600.0);
        float strongest = 0.0f;
        for (RebEmitterEntity emitter : this.f_96541_.f_91073_.m_45976_(RebEmitterEntity.class, searchBox)) {
            float strength;
            double dz;
            double dx;
            double horizontalDist;
            if (!emitter.hasBattery() || emitter.getChargeTicks() <= 0 || (horizontalDist = Math.sqrt((dx = emitter.m_20185_() - dronePos.f_82479_) * dx + (dz = emitter.m_20189_() - dronePos.f_82481_) * dz)) > 600.0 || !((strength = ShahedMonitorScreen.computeJammerStrength(horizontalDist)) > strongest)) continue;
            strongest = strength;
        }
        this.jammerNoiseOverride = strongest;
        this.jammerDisablesControls = strongest >= 1.0f;
    }

    private static float computeJammerStrength(double horizontalDist) {
        if (horizontalDist >= 600.0) {
            return 0.0f;
        }
        if (horizontalDist <= 300.0) {
            return 1.0f;
        }
        double normalized = (horizontalDist - 300.0) / 300.0;
        return (float)(1.0 - 0.99 * normalized);
    }

    private void drawStatusOverlay(GuiGraphics graphics, float partialTick) {
        ShahedStatusPacket status = ShahedClientHandler.getLastStatus();
        if (!this.hasLiveFeed(status)) {
            return;
        }
        SmoothedStatusSnapshot smoothed = this.smoothedStatus.sample(status);
        int margin = 15;
        int textHeight = 10;
        int primaryColor = -1;
        int secondaryColor = -16725604;
        int leftY = 15;
        int rightY = 15;
        int leftBoxW = 130;
        int leftBoxH = 66;
        this.drawOverlayPanel(graphics, 10, 10, leftBoxW, leftBoxH);
        float airspeedKph = status.airSpeed() * 3.6f;
        float groundSpeedKph = status.groundSpeed() * 3.6f;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("SPD  %3.0f km/h", Float.valueOf(airspeedKph))), 15, leftY, -16725604, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("GND  %3.0f km/h", Float.valueOf(groundSpeedKph))), 15, leftY += 12, -1, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("ALT  %.1f m", smoothed.y())), 15, leftY += 12, -16725604, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("VSPD %+.1f m/s", Float.valueOf(status.verticalSpeed()))), 15, leftY += 12, -1, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("AoA  %+.1f", Float.valueOf(status.angleOfAttack()))), 15, leftY += 12, -1641076, false);
        int rightBoxW = 140;
        int rightBoxH = 54;
        int rightX = this.f_96543_ - 15 - rightBoxW;
        this.drawOverlayPanel(graphics, rightX + 5, 10, rightBoxW, rightBoxH);
        int textRightX = this.f_96543_ - 15 - 130;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("X %.1f  Z %.1f", smoothed.x(), smoothed.z())), textRightX, rightY, -1, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("HDG %.0f\u00b0", Float.valueOf(smoothed.yaw()))), textRightX, rightY += 12, -16725604, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("FUEL %.1f kg", Float.valueOf(status.fuelKg()))), textRightX, rightY += 12, -467034, false);
        rightY += 12;
        ShahedDroneEntity drone = this.resolveDrone();
        if (drone != null) {
            int previewSize = 80;
            int previewX = this.f_96543_ - 80 - 15;
            int previewY = this.f_96544_ - 80 - 15;
            this.drawOverlayPanel(graphics, previewX, previewY, 80, 80);
            this.drawDronePreview(graphics, previewX + 40, previewY + 40 + 10, 14, drone, partialTick);
        }
        this.drawPowerBar(graphics, this.f_96543_ / 2 - 80, this.f_96544_ - 30, status.thrust());
        this.drawReticle(graphics);
        if (status.signalLost()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"message.fullfud.monitor.turn"), this.f_96543_ / 2 - 70, this.f_96544_ / 2, -43691, false);
        }
    }

    private void drawOverlayPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, 0x60000000);
    }

    private void drawPowerBar(GuiGraphics graphics, int x, int y, float thrust) {
        int barWidth = 160;
        int barHeight = 6;
        graphics.m_280509_(x, y, x + 160, y + 6, Integer.MIN_VALUE);
        int fillWidth = (int)(Math.max(0.0f, thrust) * 160.0f);
        fillWidth = Mth.m_14045_((int)fillWidth, (int)0, (int)160);
        int color = thrust > 0.9f ? -14680110 : -16725604;
        graphics.m_280509_(x, y, x + fillWidth, y + 6, color);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)((int)(thrust * 100.0f) + "%")), x + 160 + 6, y - 1, -16725604, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"THR"), x - 24, y - 1, -1, false);
    }

    private void drawReticle(GuiGraphics graphics) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int length = 9;
        boolean thickness = true;
        int color = -1342177280;
        graphics.m_280509_(centerX - 9, centerY - 1, centerX + 9, centerY + 1, -1342177280);
        graphics.m_280509_(centerX - 1, centerY - 9, centerX + 1, centerY + 9, -1342177280);
    }

    private void requestCameraRelease() {
        if (this.f_96541_ == null || ((ShahedMonitorMenu)this.f_97732_).getDroneId() == null) {
            return;
        }
        ShahedClientHandler.sendControlPacket(((ShahedMonitorMenu)this.f_97732_).getDroneId(), 0.0f, 0.0f, 0.0f, Float.NEGATIVE_INFINITY);
    }

    private void drawDronePreview(GuiGraphics graphics, int centerX, int centerY, int scale, ShahedDroneEntity drone, float partialTick) {
        Minecraft mc = this.f_96541_;
        if (mc == null || drone == null) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 1050.0f);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-drone.m_146908_()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(drone.getVisualPitch(partialTick)));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(drone.getVisualRoll(partialTick)));
        Lighting.m_166384_();
        dispatcher.m_252923_(Axis.f_252529_.m_252977_(180.0f));
        dispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        RenderSystem.enableDepthTest();
        dispatcher.m_114384_((Entity)drone, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        dispatcher.m_114468_(true);
        dispatcher.m_252923_(new Quaternionf());
        poseStack.m_85849_();
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
    }

    private void sendControlInput() {
        double dz;
        double dy;
        ShahedStatusPacket st = ShahedClientHandler.getLastStatus();
        if (!this.hasLiveFeed(st) || st != null && st.signalLost()) {
            return;
        }
        if (this.f_96541_ == null || ((ShahedMonitorMenu)this.f_97732_).getDroneId() == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        double dx = st.x() - this.f_96541_.f_91074_.m_20185_();
        double distance = Math.sqrt(dx * dx + (dy = st.y() - this.f_96541_.f_91074_.m_20186_()) * dy + (dz = st.z() - this.f_96541_.f_91074_.m_20189_()) * dz);
        if (distance >= 10000.0) {
            float vertical = -1.0f;
            float strafe = 0.0f;
            float thrustDelta = 0.0f;
            ShahedClientHandler.sendControlPacket(((ShahedMonitorMenu)this.f_97732_).getDroneId(), 0.0f, 0.0f, -1.0f, 0.0f);
            return;
        }
        if (this.jammerDisablesControls) {
            ShahedClientHandler.sendControlPacket(((ShahedMonitorMenu)this.f_97732_).getDroneId(), 0.0f, 0.0f, -1.0f, 0.0f);
            return;
        }
        float pitchInput = ShahedMonitorScreen.boolValue(this.ascendPressed) - ShahedMonitorScreen.boolValue(this.descendPressed);
        float strafe = ShahedMonitorScreen.boolValue(this.strafeRightPressed) - ShahedMonitorScreen.boolValue(this.strafeLeftPressed);
        float thrustDelta = 0.0f;
        if (this.increasePowerPressed) {
            thrustDelta += 0.02f;
        }
        if (this.decreasePowerPressed) {
            thrustDelta -= 0.02f;
        }
        ShahedClientHandler.sendControlPacket(((ShahedMonitorMenu)this.f_97732_).getDroneId(), pitchInput, strafe, 0.0f, thrustDelta);
    }

    private static float boolValue(boolean down) {
        return down ? 1.0f : 0.0f;
    }

    private void ensureCamera() {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            this.hasCameraFeed = false;
            return;
        }
        ShahedDroneEntity drone = this.resolveDrone();
        if (drone != null) {
            if (!this.cameraOverridden) {
                if (this.previousCamera == null) {
                    this.previousCamera = this.f_96541_.f_91074_;
                }
                if (this.previousCameraType == null) {
                    this.previousCameraType = this.f_96541_.f_91066_.m_92176_();
                }
            }
            this.f_96541_.m_91118_((Entity)drone);
            this.f_96541_.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            this.cameraOverridden = true;
            this.hasCameraFeed = true;
        } else {
            this.hasCameraFeed = false;
            this.restoreCamera();
        }
    }

    private void restoreCamera() {
        if (this.f_96541_ != null) {
            Entity fallback;
            Object object = fallback = this.f_96541_.f_91074_ != null ? this.f_96541_.f_91074_ : this.previousCamera;
            if (this.cameraOverridden && fallback != null) {
                this.f_96541_.m_91118_(fallback);
            }
            if (this.previousCameraType != null) {
                this.f_96541_.f_91066_.m_92157_(this.previousCameraType);
            }
            if (this.hudOverridden) {
                this.f_96541_.f_91066_.f_92062_ = this.previousHideGui;
                this.hudOverridden = false;
            }
        }
        this.cameraOverridden = false;
        this.previousCamera = null;
        this.previousCameraType = null;
    }

    private ShahedDroneEntity resolveDrone() {
        Entity entity;
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return null;
        }
        if (((ShahedMonitorMenu)this.f_97732_).getDroneEntityId() > 0 && (entity = this.f_96541_.f_91073_.m_6815_(((ShahedMonitorMenu)this.f_97732_).getDroneEntityId())) instanceof ShahedDroneEntity) {
            ShahedDroneEntity drone = (ShahedDroneEntity)entity;
            return drone;
        }
        if (((ShahedMonitorMenu)this.f_97732_).getDroneId() != null) {
            for (Entity entity2 : this.f_96541_.f_91073_.m_104735_()) {
                ShahedDroneEntity drone;
                if (!(entity2 instanceof ShahedDroneEntity) || !(drone = (ShahedDroneEntity)entity2).m_20148_().equals(((ShahedMonitorMenu)this.f_97732_).getDroneId())) continue;
                return drone;
            }
        }
        return null;
    }

    private boolean hasLiveFeed(ShahedStatusPacket status) {
        return this.hasCameraFeed && ShahedClientHandler.hasFreshStatus(2000) && status != null;
    }

    private void resetKeyStates() {
        this.ascendPressed = false;
        this.descendPressed = false;
        this.strafeLeftPressed = false;
        this.strafeRightPressed = false;
        this.increasePowerPressed = false;
        this.decreasePowerPressed = false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92103_.m_90832_(keyCode, scanCode)) {
            return true;
        }
        if (this.handleKeyChange(keyCode, scanCode, true)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyChange(keyCode, scanCode, false)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private boolean handleKeyChange(int keyCode, int scanCode, boolean pressed) {
        if (this.f_96541_ == null) {
            return false;
        }
        Options options = this.f_96541_.f_91066_;
        if (ShahedMonitorScreen.matches(options.f_92085_, keyCode, scanCode)) {
            this.ascendPressed = pressed;
            return true;
        }
        if (ShahedMonitorScreen.matches(options.f_92087_, keyCode, scanCode)) {
            this.descendPressed = pressed;
            return true;
        }
        if (ShahedMonitorScreen.matches(options.f_92086_, keyCode, scanCode)) {
            this.strafeLeftPressed = pressed;
            return true;
        }
        if (ShahedMonitorScreen.matches(options.f_92088_, keyCode, scanCode)) {
            this.strafeRightPressed = pressed;
            return true;
        }
        if (ShahedMonitorScreen.matches(ShahedClientHandler.getPowerUpKey(), keyCode, scanCode)) {
            this.increasePowerPressed = pressed;
            return true;
        }
        if (ShahedMonitorScreen.matches(ShahedClientHandler.getPowerDownKey(), keyCode, scanCode)) {
            this.decreasePowerPressed = pressed;
            return true;
        }
        return false;
    }

    private static boolean matches(KeyMapping mapping, int keyCode, int scanCode) {
        return mapping.m_90832_(keyCode, scanCode);
    }

    private static final class SmoothedStatus {
        private static final double MIN_DURATION_SEC = 0.05;
        private static final double EPSILON = 1.0E-4;
        private Sample previous;
        private Sample current;
        private long currentStartTimeNs;
        private double currentDurationSec = 0.05;

        private SmoothedStatus() {
        }

        SmoothedStatusSnapshot sample(ShahedStatusPacket packet) {
            if (packet == null) {
                return this.fallbackSnapshot();
            }
            long now = System.nanoTime();
            if (this.current == null) {
                this.previous = this.current = Sample.from(packet, Vec3.f_82478_);
                this.currentStartTimeNs = now;
                return this.current.snapshot();
            }
            if (this.hasNewData(packet)) {
                double elapsedSec = Math.max(0.001, (double)(now - this.currentStartTimeNs) / 1.0E9);
                Vec3 velocity = SmoothedStatus.computeVelocity(this.current.pos, new Vec3(packet.x(), packet.y(), packet.z()), elapsedSec);
                this.previous = this.current;
                this.current = Sample.from(packet, velocity);
                this.currentDurationSec = Math.max(0.05, elapsedSec);
                this.currentStartTimeNs = now;
            }
            double elapsed = Math.max(0.0, (double)(now - this.currentStartTimeNs) / 1.0E9);
            double t = this.currentDurationSec <= 0.0 ? 1.0 : Mth.m_14008_((double)(elapsed / this.currentDurationSec), (double)0.0, (double)1.0);
            Vec3 interpolatedPos = SmoothedStatus.hermite(this.previous.pos, this.current.pos, this.previous.velocity.m_82490_(this.currentDurationSec), this.current.velocity.m_82490_(this.currentDurationSec), t);
            float yaw = SmoothedStatus.lerpAngle(this.previous.yaw, this.current.yaw, t);
            float pitch = SmoothedStatus.lerpAngle(this.previous.pitch, this.current.pitch, t);
            return new SmoothedStatusSnapshot(interpolatedPos.f_82479_, interpolatedPos.f_82480_, interpolatedPos.f_82481_, yaw, pitch);
        }

        private boolean hasNewData(ShahedStatusPacket packet) {
            return Math.abs(packet.x() - this.current.pos.f_82479_) > 1.0E-4 || Math.abs(packet.y() - this.current.pos.f_82480_) > 1.0E-4 || Math.abs(packet.z() - this.current.pos.f_82481_) > 1.0E-4 || Math.abs(Mth.m_14177_((float)(packet.yaw() - this.current.yaw))) > 0.01f || Math.abs(Mth.m_14177_((float)(packet.pitch() - this.current.pitch))) > 0.01f;
        }

        private static Vec3 computeVelocity(Vec3 from, Vec3 to, double durationSec) {
            if (durationSec <= 0.001) {
                return Vec3.f_82478_;
            }
            return to.m_82546_(from).m_82490_(1.0 / durationSec);
        }

        private static Vec3 hermite(Vec3 p0, Vec3 p1, Vec3 m0, Vec3 m1, double t) {
            double tt = t * t;
            double ttt = tt * t;
            double h00 = 2.0 * ttt - 3.0 * tt + 1.0;
            double h10 = ttt - 2.0 * tt + t;
            double h01 = -2.0 * ttt + 3.0 * tt;
            double h11 = ttt - tt;
            return new Vec3(h00 * p0.f_82479_ + h10 * m0.f_82479_ + h01 * p1.f_82479_ + h11 * m1.f_82479_, h00 * p0.f_82480_ + h10 * m0.f_82480_ + h01 * p1.f_82480_ + h11 * m1.f_82480_, h00 * p0.f_82481_ + h10 * m0.f_82481_ + h01 * p1.f_82481_ + h11 * m1.f_82481_);
        }

        private static float lerpAngle(float from, float to, double t) {
            float delta = Mth.m_14177_((float)(to - from));
            return (float)((double)from + (double)delta * t);
        }

        private SmoothedStatusSnapshot fallbackSnapshot() {
            Sample sample;
            Sample sample2 = sample = this.current != null ? this.current : this.previous;
            if (sample == null) {
                return SmoothedStatusSnapshot.ZERO;
            }
            return sample.snapshot();
        }

        private record Sample(Vec3 pos, float yaw, float pitch, Vec3 velocity) {
            static Sample from(ShahedStatusPacket packet, Vec3 velocity) {
                return new Sample(new Vec3(packet.x(), packet.y(), packet.z()), packet.yaw(), packet.pitch(), velocity);
            }

            SmoothedStatusSnapshot snapshot() {
                return new SmoothedStatusSnapshot(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, this.yaw, this.pitch);
            }
        }
    }

    private record SmoothedStatusSnapshot(double x, double y, double z, float yaw, float pitch) {
        static final SmoothedStatusSnapshot ZERO = new SmoothedStatusSnapshot(0.0, 0.0, 0.0, 0.0f, 0.0f);
    }
}

