/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.client.sound;

import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.core.FullfudRegistries;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ShahedEngineLoopSound
extends AbstractTickableSoundInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ShahedDroneEntity drone;
    private float targetVolume = 0.0f;
    private float targetPitch = 1.0f;
    private String lastDebugState = "";
    private float smoothedTurn = 0.0f;

    public ShahedEngineLoopSound(ShahedDroneEntity drone) {
        super((SoundEvent)FullfudRegistries.SHAHED_ENGINE_LOOP.get(), SoundSource.NEUTRAL, RandomSource.m_216327_());
        this.drone = drone;
        this.f_119578_ = true;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119582_ = false;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
        this.f_119574_ = 1.0f;
    }

    public void setEngineMix(float thrust) {
        float clamped = Mth.m_14036_((float)thrust, (float)0.0f, (float)1.0f);
        this.targetVolume = 0.3f + clamped * 0.7f;
        this.targetPitch = 0.85f + clamped * 0.35f;
        this.f_119573_ = this.targetVolume;
        this.f_119574_ = this.targetPitch;
    }

    public void m_7788_() {
        if (this.drone.m_213877_() || !this.drone.m_6084_()) {
            this.m_119609_();
            return;
        }
        this.f_119575_ = this.drone.m_20185_();
        this.f_119576_ = this.drone.m_20186_();
        this.f_119577_ = this.drone.m_20189_();
        Vec3 motion = this.drone.m_20184_();
        double speed = motion.m_82553_();
        float diveFactor = (float)Mth.m_14008_((double)(-motion.f_82480_ / 1.4), (double)0.0, (double)1.4);
        float climbFactor = (float)Mth.m_14008_((double)(motion.f_82480_ / 1.8), (double)0.0, (double)1.0);
        float speedFactor = (float)Mth.m_14008_((double)(speed / 40.0), (double)0.0, (double)1.0);
        float rawTurn = (float)Mth.m_14008_((double)(Math.abs(Mth.m_14177_((float)(this.drone.m_146908_() - this.drone.f_19859_))) / 8.0f), (double)0.0, (double)1.0);
        this.smoothedTurn = Mth.m_14179_((float)0.08f, (float)this.smoothedTurn, (float)rawTurn);
        float flightVolumeMult = 1.0f + diveFactor * 0.9f + speedFactor * 0.35f + this.smoothedTurn * 0.25f;
        float flightPitchOffset = diveFactor * 1.15f - climbFactor * 0.25f + speedFactor * 0.18f + this.smoothedTurn * 0.75f;
        float distanceFactor = 1.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && minecraft.f_91074_ != null) {
            double dist = minecraft.f_91074_.m_20270_((Entity)this.drone);
            double norm = Mth.m_14008_((double)(dist / 700.0), (double)0.0, (double)1.0);
            distanceFactor = (float)Math.pow(1.0 - norm, 1.4);
        }
        float desiredVolume = this.targetVolume * flightVolumeMult * distanceFactor;
        float desiredPitch = this.targetPitch + flightPitchOffset;
        this.f_119573_ = Mth.m_14179_((float)0.2f, (float)this.f_119573_, (float)desiredVolume);
        this.f_119574_ = Mth.m_14179_((float)0.25f, (float)this.f_119574_, (float)desiredPitch);
        this.logState(distanceFactor, diveFactor, climbFactor, speedFactor, this.smoothedTurn);
    }

    private void logState(float distanceFactor, float diveFactor, float climbFactor, float speedFactor, float turnFactor) {
        String state;
        String string = diveFactor > 0.35f ? "PIKING" : (climbFactor > 0.35f ? "CLIMBING" : (state = turnFactor > 0.25f ? "TURNING" : "LEVEL"));
        if (!state.equals(this.lastDebugState)) {
            LOGGER.info("[ShahedAudio] {} thrustVol={} dive={} climb={} turn={} speed={}", new Object[]{state, String.format("%.2f", Float.valueOf(this.targetVolume)), String.format("%.2f", Float.valueOf(diveFactor)), String.format("%.2f", Float.valueOf(climbFactor)), String.format("%.2f", Float.valueOf(turnFactor)), String.format("%.2f", Float.valueOf(speedFactor))});
            this.lastDebugState = state;
        }
    }

    public void stopSound() {
        this.m_119609_();
    }
}

