/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.entity;

import com.fullfud.fullfud.client.sound.FpvEngineSoundInstance;
import com.fullfud.fullfud.common.entity.RebEmitterEntity;
import com.fullfud.fullfud.common.item.FpvControllerItem;
import com.fullfud.fullfud.common.item.FpvGogglesItem;
import com.fullfud.fullfud.core.FullfudRegistries;
import com.fullfud.fullfud.core.network.packet.FpvControlPacket;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FpvDroneEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_ARMED = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_THRUST = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ROLL = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_CONTROLLER = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_BATTERY = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SIGNAL_QUALITY = SynchedEntityData.m_135353_(FpvDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDimensions DRONE_SIZE = EntityDimensions.m_20395_((float)0.7f, (float)0.25f);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenLoop("running");
    private static final double GRAVITY = 0.055;
    private static final double AIR_DRAG = 0.96;
    private static final double MAX_THRUST = 0.12;
    private static final double ROTATION_RATE_DEG = 5.0;
    private static final double YAW_RATE_DEG = 4.0;
    private static final int MAX_BATTERY_TICKS = 12000;
    private static final TicketType<Integer> FPV_TICKET = TicketType.m_9465_((String)"fullfud_fpv", Integer::compareTo, (int)4);
    private static final String TAG_ARMED = "Armed";
    private static final String TAG_THRUST = "Thrust";
    private static final String TAG_ROLL = "Roll";
    private static final String TAG_VELOCITY = "Velocity";
    private static final String TAG_OWNER = "Owner";
    private static final String TAG_CONTROLLER = "Controller";
    private static final String TAG_BATTERY = "Battery";
    private static final String TAG_SESSION_DIM = "SessDim";
    private static final String TAG_SESSION_X = "SessX";
    private static final String TAG_SESSION_Y = "SessY";
    private static final String TAG_SESSION_Z = "SessZ";
    private static final String TAG_SESSION_YAW = "SessYaw";
    private static final String TAG_SESSION_PITCH = "SessPitch";
    private static final String TAG_SESSION_GAMEMODE = "SessGM";
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Quaternionf qRotation = new Quaternionf();
    private boolean physicsInitialized = false;
    private float targetThrottle;
    private float throttleOutput;
    private float inputPitch;
    private float inputRoll;
    private float inputYaw;
    private double droneRoll;
    private double droneRollO;
    private int controlTimeout;
    private UUID owner;
    private ControlSession session;
    private ChunkPos lastTicketPos;
    private int lastTicketRadius;
    private RemotePilotFakePlayer avatar;
    private boolean cameraPinned;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean wasArmedClient = false;
    private Object clientSoundInstance = null;

    public FpvDroneEntity(EntityType<? extends FpvDroneEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.m_20242_(true);
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ARMED, (Object)false);
        this.f_19804_.m_135372_(DATA_THRUST, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_CONTROLLER, Optional.empty());
        this.f_19804_.m_135372_(DATA_BATTERY, (Object)12000);
        this.f_19804_.m_135372_(DATA_SIGNAL_QUALITY, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag tag) {
        ResourceLocation dimId;
        ListTag list;
        this.setArmed(tag.m_128471_(TAG_ARMED));
        this.throttleOutput = this.targetThrottle = tag.m_128457_(TAG_THRUST);
        this.droneRollO = this.droneRoll = tag.m_128459_(TAG_ROLL);
        if (tag.m_128441_(TAG_BATTERY)) {
            this.f_19804_.m_135381_(DATA_BATTERY, (Object)tag.m_128451_(TAG_BATTERY));
        }
        this.updateQuaternionFromEuler();
        this.physicsInitialized = true;
        if (tag.m_128425_(TAG_VELOCITY, 9) && (list = tag.m_128437_(TAG_VELOCITY, 6)).size() == 3) {
            this.m_20334_(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
        }
        if (tag.m_128403_(TAG_OWNER)) {
            this.owner = tag.m_128342_(TAG_OWNER);
        }
        if (tag.m_128403_(TAG_CONTROLLER)) {
            this.f_19804_.m_135381_(DATA_CONTROLLER, Optional.of(tag.m_128342_(TAG_CONTROLLER)));
        }
        if (tag.m_128441_(TAG_SESSION_DIM) && (dimId = ResourceLocation.m_135820_((String)tag.m_128461_(TAG_SESSION_DIM))) != null) {
            this.session = new ControlSession((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimId), new Vec3(tag.m_128459_(TAG_SESSION_X), tag.m_128459_(TAG_SESSION_Y), tag.m_128459_(TAG_SESSION_Z)), tag.m_128457_(TAG_SESSION_YAW), tag.m_128457_(TAG_SESSION_PITCH), GameType.m_46393_((int)tag.m_128451_(TAG_SESSION_GAMEMODE)));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_(TAG_ARMED, this.isArmed());
        tag.m_128350_(TAG_THRUST, this.targetThrottle);
        tag.m_128347_(TAG_ROLL, this.droneRoll);
        tag.m_128405_(TAG_BATTERY, this.getBatteryTicks());
        Vec3 vel = this.m_20184_();
        ListTag velocityList = new ListTag();
        velocityList.add((Object)DoubleTag.m_128500_((double)vel.f_82479_));
        velocityList.add((Object)DoubleTag.m_128500_((double)vel.f_82480_));
        velocityList.add((Object)DoubleTag.m_128500_((double)vel.f_82481_));
        tag.m_128365_(TAG_VELOCITY, (Tag)velocityList);
        if (this.owner != null) {
            tag.m_128362_(TAG_OWNER, this.owner);
        }
        ((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).ifPresent(id -> tag.m_128362_(TAG_CONTROLLER, id));
        if (this.session != null) {
            tag.m_128359_(TAG_SESSION_DIM, this.session.dimension.m_135782_().toString());
            tag.m_128347_(TAG_SESSION_X, this.session.origin.f_82479_);
            tag.m_128347_(TAG_SESSION_Y, this.session.origin.f_82480_);
            tag.m_128347_(TAG_SESSION_Z, this.session.origin.f_82481_);
            tag.m_128350_(TAG_SESSION_YAW, this.session.yaw);
            tag.m_128350_(TAG_SESSION_PITCH, this.session.pitch);
            tag.m_128405_(TAG_SESSION_GAMEMODE, this.session.gameType.m_46392_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.droneRollO = this.droneRoll;
        if (!this.m_9236_().m_5776_()) {
            this.tickServer();
        } else {
            this.tickClient();
        }
    }

    private void tickClient() {
        this.throttleOutput = ((Float)this.f_19804_.m_135370_(DATA_THRUST)).floatValue();
        float targetRoll = ((Float)this.f_19804_.m_135370_(DATA_ROLL)).floatValue();
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            float curY = (float)Math.toRadians(-this.m_146908_());
            float curX = (float)Math.toRadians(this.m_146909_());
            float curR = (float)Math.toRadians(this.droneRoll);
            Quaternionf currentQ = new Quaternionf().rotationYXZ(curY, curX, curR);
            float tarY = (float)Math.toRadians(-this.lerpYRot);
            float tarX = (float)Math.toRadians(this.lerpXRot);
            float tarR = (float)Math.toRadians(targetRoll);
            Quaternionf targetQ = new Quaternionf().rotationYXZ(tarY, tarX, tarR);
            currentQ.slerp((Quaternionfc)targetQ, 1.0f / (float)this.lerpSteps);
            Vector3f euler = new Vector3f();
            currentQ.getEulerAnglesYXZ(euler);
            this.m_146922_((float)Math.toDegrees(-euler.y));
            this.m_146926_((float)Math.toDegrees(euler.x));
            this.droneRoll = (float)Math.toDegrees(euler.z);
            --this.lerpSteps;
        } else {
            this.droneRoll = Mth.m_14189_((float)0.5f, (float)((float)this.droneRoll), (float)targetRoll);
        }
        this.m_19915_(this.m_146908_(), this.m_146909_());
        boolean currentlyArmed = this.isArmed();
        float currentThrust = this.getThrust();
        if (currentlyArmed && !this.wasArmedClient) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)FullfudRegistries.FPV_ENGINE_START.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        if (!currentlyArmed && this.wasArmedClient) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)FullfudRegistries.FPV_ENGINE_STOP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (currentlyArmed && currentThrust > 0.01f && (this.clientSoundInstance == null || !mc.m_91106_().m_120403_((SoundInstance)((FpvEngineSoundInstance)((Object)this.clientSoundInstance))))) {
            FpvEngineSoundInstance sound = new FpvEngineSoundInstance(this);
            mc.m_91106_().m_120367_((SoundInstance)sound);
            this.clientSoundInstance = sound;
        }
        this.wasArmedClient = currentlyArmed;
    }

    private void tickServer() {
        if (!this.physicsInitialized) {
            this.updateQuaternionFromEuler();
            this.physicsInitialized = true;
        }
        if (this.isArmed()) {
            int currentBat = this.getBatteryTicks();
            if (currentBat > 0) {
                int drain = 1 + (int)(this.throttleOutput * 3.0f);
                this.f_19804_.m_135381_(DATA_BATTERY, (Object)Math.max(0, currentBat - drain));
            }
        } else {
            this.targetThrottle = 0.0f;
            this.inputPitch = 0.0f;
            this.inputRoll = 0.0f;
            this.inputYaw = 0.0f;
        }
        if (((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).isPresent()) {
            ServerPlayer controller = this.getController();
            if (controller == null) {
                this.f_19804_.m_135381_(DATA_CONTROLLER, Optional.empty());
                this.setArmed(false);
                this.removeAvatar();
            } else {
                if (this.f_19797_ % 5 == 0) {
                    this.calculateSignal(controller);
                }
                --this.controlTimeout;
                if (this.controlTimeout <= 0) {
                    this.endRemoteControl(controller);
                }
            }
        }
        this.ensureChunkTicket();
        this.updateSimplePhysics();
        this.updateControllerBinding();
        Vec3 preMoveVelocity = this.m_20184_();
        this.m_6478_(MoverType.SELF, preMoveVelocity);
        if (this.isArmed()) {
            double limit;
            double hSpeed;
            if ((this.f_19862_ || this.f_19863_) && (hSpeed = Math.sqrt(preMoveVelocity.f_82479_ * preMoveVelocity.f_82479_ + preMoveVelocity.f_82481_ * preMoveVelocity.f_82481_)) > (limit = 0.5)) {
                this.explode();
                return;
            }
            List collisions = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.2), e -> !e.m_5833_() && e.m_6087_());
            for (Entity entity : collisions) {
                if (this.avatar != null && entity == this.avatar) continue;
                this.explode();
                return;
            }
        }
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.5, 0.5, 0.5));
        }
        this.throttleOutput = Mth.m_14179_((float)0.2f, (float)this.throttleOutput, (float)this.targetThrottle);
        this.f_19804_.m_135381_(DATA_THRUST, (Object)Float.valueOf(this.throttleOutput));
        this.f_19804_.m_135381_(DATA_ROLL, (Object)Float.valueOf((float)this.droneRoll));
    }

    private void calculateSignal(ServerPlayer controller) {
        Vec3 start = this.session != null ? this.session.origin.m_82520_(0.0, (double)controller.m_20192_(), 0.0) : controller.m_146892_();
        Vec3 end = this.m_20182_().m_82520_(0.0, 0.25, 0.0);
        double dist = Math.sqrt(this.m_20182_().m_82557_(start));
        float currentSignal = 1.0f;
        currentSignal = dist > 600.0 ? 0.0f : (dist > 500.0 ? 0.5f * (1.0f - (float)((dist - 500.0) / 100.0)) : 1.0f - (float)dist / 500.0f * 0.5f);
        if (currentSignal > 0.0f) {
            int obstacles = this.countObstacles(start, end);
            if (obstacles >= 15) {
                currentSignal = 0.0f;
            } else if (obstacles > 0) {
                currentSignal *= 1.0f - (float)obstacles / 15.0f;
            }
        }
        if (currentSignal > 0.0f) {
            List rebs = this.m_9236_().m_6443_(RebEmitterEntity.class, this.m_20191_().m_82400_(300.0), e -> e.hasBattery() && e.hasFinishedStartup());
            float maxJamming = 0.0f;
            for (RebEmitterEntity reb : rebs) {
                float jam;
                double d = Math.sqrt(this.m_20280_(reb));
                if (d < 150.0) {
                    maxJamming = 1.0f;
                    break;
                }
                if (!(d < 300.0) || !((jam = 1.0f - (float)((d - 150.0) / 150.0)) > maxJamming)) continue;
                maxJamming = jam;
            }
            currentSignal *= 1.0f - maxJamming;
        }
        this.f_19804_.m_135381_(DATA_SIGNAL_QUALITY, (Object)Float.valueOf(Math.max(0.0f, currentSignal)));
    }

    private int countObstacles(Vec3 start, Vec3 end) {
        Vec3 vector = end.m_82546_(start);
        double length = vector.m_82553_();
        Vec3 dir = vector.m_82541_();
        double stepSize = 0.5;
        int steps = (int)(length / stepSize);
        int solidCount = 0;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < steps; ++i) {
            Vec3 point = start.m_82549_(dir.m_82490_((double)i * stepSize));
            mPos.m_122169_(point.f_82479_, point.f_82480_, point.f_82481_);
            if (!this.m_9236_().m_8055_((BlockPos)mPos).m_60815_()) continue;
            ++solidCount;
        }
        return solidCount / 2;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    private void updateQuaternionFromEuler() {
        float yRad = (float)Math.toRadians(-this.m_146908_());
        float xRad = (float)Math.toRadians(this.m_146909_());
        float zRad = (float)Math.toRadians(this.droneRoll);
        this.qRotation.identity().rotateYXZ(yRad, xRad, zRad);
    }

    private void updateSimplePhysics() {
        float pInputCurve = this.applyExpo(this.inputPitch, 0.4f);
        float rInputCurve = this.applyExpo(this.inputRoll, 0.4f);
        float yInputCurve = this.applyExpo(this.inputYaw, 0.4f);
        float pRad = (float)Math.toRadians((double)(-pInputCurve) * 5.0);
        float rRad = (float)Math.toRadians((double)(-rInputCurve) * 5.0);
        float yRad = (float)Math.toRadians((double)(-yInputCurve) * 4.0);
        if (!this.isArmed()) {
            pRad = 0.0f;
            rRad = 0.0f;
            yRad = 0.0f;
        }
        if (Float.isNaN(pRad)) {
            pRad = 0.0f;
        }
        if (Float.isNaN(rRad)) {
            rRad = 0.0f;
        }
        if (Float.isNaN(yRad)) {
            yRad = 0.0f;
        }
        Quaternionf delta = new Quaternionf().rotateY(yRad).rotateX(pRad).rotateZ(rRad);
        this.qRotation.mul((Quaternionfc)delta);
        this.qRotation.normalize();
        Vector3f euler = new Vector3f();
        this.qRotation.getEulerAnglesYXZ(euler);
        float newYaw = (float)Math.toDegrees(-euler.y);
        float newPitch = (float)Math.toDegrees(euler.x);
        float newRoll = (float)Math.toDegrees(euler.z);
        if (Float.isNaN(newYaw)) {
            newYaw = this.m_146908_();
        }
        if (Float.isNaN(newPitch)) {
            newPitch = this.m_146909_();
        }
        if (Float.isNaN(newRoll)) {
            newRoll = (float)this.droneRoll;
        }
        this.m_146922_(Mth.m_14177_((float)newYaw));
        this.m_146926_(Mth.m_14177_((float)newPitch));
        this.droneRoll = Mth.m_14177_((float)newRoll);
        Vector3f upVec = new Vector3f(0.0f, 1.0f, 0.0f);
        this.qRotation.transform(upVec);
        double thrustForce = (double)this.throttleOutput * 0.12;
        if (this.getBatteryTicks() <= 0 || !this.isArmed()) {
            thrustForce = 0.0;
        }
        Vec3 thrustVec = new Vec3((double)upVec.x, (double)upVec.y, (double)upVec.z).m_82490_(thrustForce);
        Vec3 motion = this.m_20184_();
        motion = motion.m_82549_(thrustVec);
        motion = motion.m_82520_(0.0, -0.055, 0.0);
        motion = motion.m_82490_(0.96);
        this.m_20256_(motion);
    }

    private float applyExpo(float input, float expo) {
        return input * (Math.abs(input) * expo + (1.0f - expo));
    }

    private void ensureChunkTicket() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ChunkPos currentPos = new ChunkPos(BlockPos.m_274446_((Position)this.m_20182_()));
        int radius = 2;
        if (this.lastTicketPos == null || !this.lastTicketPos.equals((Object)currentPos) || this.lastTicketRadius != 2) {
            if (this.lastTicketPos != null) {
                serverLevel.m_7726_().m_8438_(FPV_TICKET, this.lastTicketPos, this.lastTicketRadius, (Object)this.m_19879_());
            }
            serverLevel.m_7726_().m_8387_(FPV_TICKET, currentPos, 2, (Object)this.m_19879_());
            this.lastTicketPos = currentPos;
            this.lastTicketRadius = 2;
        }
    }

    private void releaseChunkTicket() {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (this.lastTicketPos != null) break block3;
            }
            this.lastTicketPos = null;
            this.lastTicketRadius = 0;
            return;
        }
        serverLevel.m_7726_().m_8438_(FPV_TICKET, this.lastTicketPos, this.lastTicketRadius, (Object)this.m_19879_());
        this.lastTicketPos = null;
        this.lastTicketRadius = 0;
    }

    private void updateControllerBinding() {
        ServerPlayer player = this.getController();
        if (player == null) {
            if (this.avatar != null) {
                this.removeAvatar();
            }
            return;
        }
        player.m_6842_(true);
        player.m_20225_(true);
        player.m_20242_(true);
        player.f_19794_ = true;
        if (this.session != null && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            player.m_143403_(GameType.SPECTATOR);
        }
        if ((this.f_19797_ & 1) == 0) {
            player.f_8906_.m_9774_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), player.m_146908_(), player.m_146909_());
            if (this.cameraPinned) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this));
            }
        }
        this.syncAvatar(player);
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.canAccess(player)) {
            return InteractionResult.FAIL;
        }
        Item item = held.m_41720_();
        if (item instanceof FpvControllerItem) {
            FpvControllerItem controller = (FpvControllerItem)item;
            controller.link(held, this, player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.m_6144_()) {
                    this.beginControl(serverPlayer);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && held.m_41619_() && !this.isArmed()) {
            this.dropAsItem();
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_5776_() || this.m_213877_()) {
            return false;
        }
        if (this.isArmed()) {
            this.explode();
            return true;
        }
        this.dropAsItem();
        this.m_146870_();
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_()) {
            ServerPlayer controller = this.getController();
            if (controller != null) {
                this.forceReturnCamera(controller);
                this.endRemoteControl(controller);
            }
            this.releaseChunkTicket();
        }
        super.m_142687_(reason);
    }

    private void explode() {
        ServerPlayer controller = this.getController();
        if (controller != null) {
            this.endRemoteControl(controller);
        }
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.TNT);
        this.m_146870_();
    }

    private void dropAsItem() {
        this.m_19983_(new ItemStack((ItemLike)FullfudRegistries.FPV_DRONE_ITEM.get()));
    }

    public void applyControl(FpvControlPacket packet, ServerPlayer sender) {
        if (!this.isController(sender)) {
            return;
        }
        if (this.getSignalQuality() < 0.05f) {
            this.controlTimeout = 20;
            return;
        }
        this.controlTimeout = 20;
        this.inputPitch = packet.pitchInput();
        this.inputRoll = packet.rollInput();
        this.inputYaw = packet.yawInput();
        this.targetThrottle = Mth.m_14036_((float)packet.throttle(), (float)0.0f, (float)1.0f);
        if (packet.armAction() == 1) {
            if (this.getBatteryTicks() > 0) {
                this.setArmed(true);
            }
        } else if (packet.armAction() == 2) {
            this.setArmed(false);
            this.targetThrottle = 0.0f;
        }
    }

    public void requestRelease(ServerPlayer sender) {
        if (!this.isController(sender)) {
            return;
        }
        this.endRemoteControl(sender);
    }

    private boolean isController(ServerPlayer player) {
        return ((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).map(player.m_20148_()::equals).orElse(false);
    }

    public boolean beginControl(ServerPlayer player) {
        if (((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).isPresent() && !this.isController(player)) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(player.m_20148_())) {
            return false;
        }
        if (this.owner == null) {
            this.owner = player.m_20148_();
        }
        if (!this.hasLinkedGoggles(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.fpv.need_goggles"), true);
            return false;
        }
        this.f_19804_.m_135381_(DATA_CONTROLLER, Optional.of(player.m_20148_()));
        this.controlTimeout = 20;
        this.session = new ControlSession((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20182_(), player.m_146908_(), player.m_146909_(), player.f_8941_.m_9290_());
        this.bindPlayer(player);
        this.spawnAvatar(player);
        player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this));
        this.cameraPinned = true;
        return true;
    }

    public void endRemoteControl(ServerPlayer player) {
        if (!((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).isPresent() && this.session == null) {
            return;
        }
        if (player != null) {
            this.forceReturnCamera(player);
            this.restorePlayer(player);
        }
        this.f_19804_.m_135381_(DATA_CONTROLLER, Optional.empty());
        this.inputPitch = 0.0f;
        this.inputRoll = 0.0f;
        this.inputYaw = 0.0f;
        this.targetThrottle = 0.0f;
        this.throttleOutput = 0.0f;
        this.setArmed(false);
        this.controlTimeout = 0;
        this.session = null;
        this.removeAvatar();
        this.cameraPinned = false;
        this.releaseChunkTicket();
    }

    private void forceReturnCamera(ServerPlayer player) {
        if (player == null || player.f_8906_ == null) {
            return;
        }
        player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)player));
    }

    private boolean isSignalLostFor(ServerPlayer p) {
        return p == null || this.getSignalQuality() <= 0.0f;
    }

    private void bindPlayer(ServerPlayer player) {
        player.m_6842_(true);
        player.m_20242_(true);
        player.f_19794_ = true;
        player.m_20256_(Vec3.f_82478_);
        if (player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            player.m_143403_(GameType.SPECTATOR);
        }
        player.m_6885_();
    }

    private void restorePlayer(ServerPlayer player) {
        if (this.session == null) {
            player.m_143403_(GameType.SURVIVAL);
            player.m_6842_(false);
            player.m_20242_(false);
            player.f_19794_ = false;
            return;
        }
        ServerLevel targetLevel = player.f_8924_.m_129880_(this.session.dimension);
        if (targetLevel == null) {
            targetLevel = player.m_284548_();
        }
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)this.session.origin));
        targetLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)player.m_19879_());
        player.m_8999_(targetLevel, this.session.origin.f_82479_, this.session.origin.f_82480_, this.session.origin.f_82481_, this.session.yaw, this.session.pitch);
        if (this.session.gameType != null) {
            player.m_143403_(this.session.gameType);
        } else {
            player.m_143403_(GameType.SURVIVAL);
        }
        player.m_6842_(false);
        player.m_20242_(false);
        player.f_19794_ = false;
        player.m_20256_(Vec3.f_82478_);
        player.m_6885_();
        this.removeAvatar();
    }

    private void spawnAvatar(ServerPlayer player) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (this.session != null) break block3;
            }
            return;
        }
        this.removeAvatar();
        GameProfile profile = new GameProfile(UUID.randomUUID(), player.m_36316_().getName());
        player.m_36316_().getProperties().forEach((name, prop) -> profile.getProperties().put(name, (Object)new Property(prop.getName(), prop.getValue(), prop.getSignature())));
        this.avatar = new RemotePilotFakePlayer(serverLevel, profile, player.m_20148_());
        this.avatar.syncFrom(player);
        this.avatar.m_6034_(this.session.origin.f_82479_, this.session.origin.f_82480_, this.session.origin.f_82481_);
        this.avatar.m_146922_(this.session.yaw);
        this.avatar.m_146926_(this.session.pitch);
        this.avatar.f_20885_ = this.session.yaw;
        this.avatar.f_20883_ = this.session.yaw;
        this.avatar.m_20256_(Vec3.f_82478_);
        this.avatar.m_6593_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " [FPV]")));
        this.avatar.m_20340_(true);
        this.broadcastAvatarInfo(true);
        serverLevel.m_7967_((Entity)this.avatar);
    }

    private void syncAvatar(ServerPlayer player) {
        if (this.avatar == null || this.avatar.m_213877_()) {
            this.spawnAvatar(player);
        } else {
            this.avatar.syncEquipment(player);
        }
    }

    private void removeAvatar() {
        if (this.avatar != null) {
            this.broadcastAvatarInfo(false);
            this.avatar.m_146870_();
            this.avatar = null;
        }
    }

    private void broadcastAvatarInfo(boolean add) {
        Level level;
        if (this.avatar == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (add) {
            packet = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)this.avatar);
            for (ServerPlayer viewer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                viewer.f_8906_.m_9829_((Packet)packet);
            }
        } else {
            packet = new ClientboundPlayerInfoRemovePacket(List.of(this.avatar.m_20148_()));
            for (ServerPlayer viewer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                viewer.f_8906_.m_9829_((Packet)packet);
            }
        }
    }

    private ServerPlayer getController() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return ((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).map(arg_0 -> ((PlayerList)serverLevel.m_7654_().m_6846_()).m_11259_(arg_0)).orElse(null);
    }

    private boolean hasLinkedGoggles(ServerPlayer player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (!(head.m_41720_() instanceof FpvGogglesItem)) {
            return false;
        }
        return FpvGogglesItem.getLinked(head).filter(id -> id.equals(this.m_20148_())).isPresent();
    }

    public boolean isArmed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ARMED);
    }

    public float getThrust() {
        return ((Float)this.f_19804_.m_135370_(DATA_THRUST)).floatValue();
    }

    public int getBatteryTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_BATTERY);
    }

    public int getBatteryPercent() {
        return (int)((float)this.getBatteryTicks() / 12000.0f * 100.0f);
    }

    public float getSignalQuality() {
        return ((Float)this.f_19804_.m_135370_(DATA_SIGNAL_QUALITY)).floatValue();
    }

    public UUID getControllerId() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CONTROLLER)).orElse(null);
    }

    public void setOwner(ServerPlayer player) {
        this.owner = player.m_20148_();
    }

    public boolean hasOwner(UUID playerId) {
        return this.owner != null && this.owner.equals(playerId);
    }

    private boolean canAccess(Player player) {
        return this.owner == null || this.owner.equals(player.m_20148_());
    }

    private void setArmed(boolean armed) {
        this.f_19804_.m_135381_(DATA_ARMED, (Object)armed);
    }

    public float getCameraRoll(float partialTick) {
        return Mth.m_14189_((float)partialTick, (float)((float)this.droneRollO), (float)((float)this.droneRoll));
    }

    public float getCameraPitch(float partialTick) {
        return Mth.m_14189_((float)partialTick, (float)this.f_19860_, (float)this.m_146909_());
    }

    public float getVisualRoll(float partialTick) {
        return Mth.m_14189_((float)partialTick, (float)((float)this.droneRollO), (float)((float)this.droneRoll));
    }

    public float getVisualPitch(float partialTick) {
        return Mth.m_14189_((float)partialTick, (float)this.f_19860_, (float)this.m_146909_());
    }

    public EntityDimensions m_6972_(Pose pose) {
        return DRONE_SIZE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<FpvDroneEntity> event) {
        if (!this.isArmed()) {
            return PlayState.STOP;
        }
        if (this.getThrust() > 0.1f) {
            return event.setAndContinue(RUNNING_ANIM);
        }
        return event.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    private record ControlSession(ResourceKey<Level> dimension, Vec3 origin, float yaw, float pitch, GameType gameType) {
    }

    private static final class RemotePilotFakePlayer
    extends FakePlayer {
        private final UUID ownerId;
        private boolean forwardingDamage;

        private RemotePilotFakePlayer(ServerLevel level, GameProfile profile, UUID ownerId) {
            super(level, profile);
            this.ownerId = ownerId;
            this.m_20242_(true);
            this.f_19794_ = true;
        }

        private void syncFrom(ServerPlayer player) {
            this.syncEquipment(player);
            this.m_21153_(player.m_21223_());
            this.m_36324_().m_38705_(player.m_36324_().m_38702_());
            this.m_36324_().m_38717_(player.m_36324_().m_38722_());
            this.m_21219_();
            player.m_21220_().forEach(effect -> this.m_7292_(new MobEffectInstance(effect)));
        }

        private void syncEquipment(ServerPlayer player) {
            for (int i = 0; i < this.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                this.m_150109_().m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            }
            EquipmentSlot[] equipmentSlotArray = EquipmentSlot.values();
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot slot;
                ItemStack stack = player.m_6844_(slot = equipmentSlotArray[i]);
                this.m_8061_(slot, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            }
        }

        public boolean m_6469_(DamageSource source, float amount) {
            if (!this.forwardingDamage) {
                this.forwardingDamage = true;
                ServerPlayer owner = this.getOwner();
                if (owner != null && !owner.m_21224_()) {
                    owner.m_6469_(source, amount);
                }
                this.forwardingDamage = false;
            }
            return super.m_6469_(source, amount);
        }

        public void m_6667_(DamageSource source) {
            ServerPlayer owner = this.getOwner();
            if (owner != null && !owner.m_21224_()) {
                owner.m_6667_(source);
            }
            super.m_6667_(source);
        }

        private ServerPlayer getOwner() {
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7654_().m_6846_().m_11259_(this.ownerId);
        }
    }
}

