/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.entity;

import com.fullfud.fullfud.common.item.RebBatteryItem;
import com.fullfud.fullfud.core.FullfudRegistries;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import org.lwjgl.openal.AL10;
import org.lwjgl.system.MemoryUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RebEmitterEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_HAS_BATTERY = SynchedEntityData.m_135353_(RebEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_CHARGE_TICKS = SynchedEntityData.m_135353_(RebEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_STARTUP_DONE = SynchedEntityData.m_135353_(RebEmitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation START_ANIMATION = RawAnimation.begin().then("animation.reb.start", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.reb.idle");
    private static final int STARTUP_DURATION_TICKS = 60;
    private static final float NOISE_MAX_VOLUME = 0.2f;
    private static final float NOISE_RADIUS = 15.0f;
    private static final int SAMPLE_RATE_HZ = 22050;
    private static final int BUFFER_SAMPLES = 2048;
    private static final int NUM_BUFFERS = 4;
    private ItemStack battery = ItemStack.f_41583_;
    private int chargeTicks;
    private boolean fallingFromSupport;
    private boolean wasOnGround;
    private int energyTickCounter;
    private int startupTicks;
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean cPrevActiveCondition;

    public RebEmitterEntity(EntityType<? extends RebEmitterEntity> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HAS_BATTERY, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_STARTUP_DONE, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(0.0, motion.f_82480_, 0.0);
            if (this.wasOnGround && !this.m_20096_()) {
                this.fallingFromSupport = true;
            }
            if (this.fallingFromSupport && this.m_20096_()) {
                this.dropContents();
                this.m_146870_();
            }
            this.updateStartup();
            this.drainEnergy();
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientTickNoise());
        }
        this.wasOnGround = this.m_20096_();
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Battery")) {
            this.battery = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Battery"));
            this.chargeTicks = tag.m_128451_("ChargeTicks");
            this.f_19804_.m_135381_(DATA_HAS_BATTERY, (Object)true);
            this.f_19804_.m_135381_(DATA_CHARGE_TICKS, (Object)this.chargeTicks);
        }
        this.startupTicks = tag.m_128451_("StartupTicks");
        boolean startupDone = tag.m_128471_("StartupDone");
        this.f_19804_.m_135381_(DATA_STARTUP_DONE, (Object)startupDone);
        if (startupDone) {
            this.startupTicks = 60;
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.hasBattery()) {
            tag.m_128365_("Battery", (Tag)this.battery.m_41739_(new CompoundTag()));
            tag.m_128405_("ChargeTicks", this.chargeTicks);
        }
        tag.m_128405_("StartupTicks", this.startupTicks);
        tag.m_128379_("StartupDone", ((Boolean)this.f_19804_.m_135370_(DATA_STARTUP_DONE)).booleanValue());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return false;
        }
        this.dropContents();
        this.m_146870_();
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.m_9236_() != null && this.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientWhiteNoiseManager.stop(this));
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!this.hasBattery() && heldItem.m_41720_() == FullfudRegistries.REB_BATTERY_ITEM.get()) {
            if (!this.m_9236_().f_46443_) {
                this.insertBattery(heldItem, player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_6047_() && this.hasBattery() && heldItem.m_41619_()) {
            ItemStack extracted;
            if (!(this.m_9236_().f_46443_ || (extracted = this.removeBattery()).m_41619_() || player.m_36356_(extracted))) {
                this.m_5552_(extracted, 0.25f);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean hasBattery() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_BATTERY);
    }

    public int getChargeTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_CHARGE_TICKS);
    }

    private void insertBattery(ItemStack stack, Player player) {
        ItemStack single = stack.m_41777_();
        single.m_41764_(1);
        this.chargeTicks = RebBatteryItem.getChargeTicks(single);
        RebBatteryItem.setChargeTicks(single, this.chargeTicks);
        this.battery = single;
        this.syncBatteryState(true, this.chargeTicks);
        this.energyTickCounter = 0;
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    private ItemStack removeBattery() {
        if (!this.hasBattery()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.battery.m_41777_();
        RebBatteryItem.setChargeTicks(result, this.chargeTicks);
        this.clearBattery();
        return result;
    }

    private void clearBattery() {
        this.battery = ItemStack.f_41583_;
        this.chargeTicks = 0;
        this.syncBatteryState(false, 0);
        this.energyTickCounter = 0;
    }

    private void dropContents() {
        ItemStack dropBattery;
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_19983_(new ItemStack((ItemLike)FullfudRegistries.REB_EMITTER_ITEM.get()));
        if (this.hasBattery() && !(dropBattery = this.removeBattery()).m_41619_()) {
            this.m_19983_(dropBattery);
        }
    }

    private void drainEnergy() {
        ItemStack discharged;
        if (!this.hasBattery()) {
            return;
        }
        ++this.energyTickCounter;
        if (this.energyTickCounter < 20) {
            return;
        }
        this.energyTickCounter = 0;
        this.setChargeTicks(Math.max(0, this.chargeTicks - 20));
        if (this.chargeTicks <= 0 && !(discharged = this.removeBattery()).m_41619_()) {
            this.m_19983_(discharged);
        }
    }

    private void setChargeTicks(int value) {
        this.chargeTicks = value;
        this.f_19804_.m_135381_(DATA_CHARGE_TICKS, (Object)this.chargeTicks);
    }

    private void syncBatteryState(boolean hasBattery, int charge) {
        this.f_19804_.m_135381_(DATA_HAS_BATTERY, (Object)hasBattery);
        this.f_19804_.m_135381_(DATA_CHARGE_TICKS, (Object)charge);
    }

    private void updateStartup() {
        if (((Boolean)this.f_19804_.m_135370_(DATA_STARTUP_DONE)).booleanValue()) {
            return;
        }
        ++this.startupTicks;
        if (this.startupTicks >= 60) {
            this.startupTicks = 60;
            this.f_19804_.m_135381_(DATA_STARTUP_DONE, (Object)true);
        }
    }

    public boolean hasFinishedStartup() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARTUP_DONE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "reb", 0, state -> {
            if (!this.hasFinishedStartup()) {
                state.setAndContinue(START_ANIMATION);
            } else {
                state.setAndContinue(IDLE_ANIMATION);
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    private void clientTickNoise() {
        boolean shouldPlay;
        boolean bl = shouldPlay = this.hasBattery() && this.hasFinishedStartup() && this.chargeTicks > 0 && !this.m_213877_();
        if (shouldPlay) {
            ClientWhiteNoiseManager.ensure(this);
            ClientWhiteNoiseManager.update(this);
        } else {
            ClientWhiteNoiseManager.stop(this);
        }
        this.cPrevActiveCondition = shouldPlay;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ClientWhiteNoiseManager {
        private static final Map<RebEmitterEntity, WhiteNoiseALStream> STREAMS = new WeakHashMap<RebEmitterEntity, WhiteNoiseALStream>();

        private ClientWhiteNoiseManager() {
        }

        static void ensure(RebEmitterEntity e) {
            STREAMS.computeIfAbsent(e, k -> new WhiteNoiseALStream(e));
        }

        static void update(RebEmitterEntity e) {
            WhiteNoiseALStream s = STREAMS.get((Object)e);
            if (s != null) {
                s.tick();
            }
        }

        static void stop(RebEmitterEntity e) {
            WhiteNoiseALStream s = STREAMS.remove((Object)e);
            if (s != null) {
                s.stopAndDispose();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class WhiteNoiseALStream {
        private final RebEmitterEntity emitter;
        private int sourceId = 0;
        private final int[] buffers = new int[4];
        private boolean disposed = false;
        private ShortBuffer scratch;

        WhiteNoiseALStream(RebEmitterEntity emitter) {
            this.emitter = emitter;
            this.initAL();
        }

        private void initAL() {
            try {
                int i;
                this.sourceId = AL10.alGenSources();
                AL10.alSourcef((int)this.sourceId, (int)4099, (float)1.0f);
                AL10.alSourcef((int)this.sourceId, (int)4106, (float)0.0f);
                AL10.alSource3f((int)this.sourceId, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
                AL10.alSource3f((int)this.sourceId, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
                AL10.alSourcei((int)this.sourceId, (int)4103, (int)0);
                for (i = 0; i < 4; ++i) {
                    this.buffers[i] = AL10.alGenBuffers();
                }
                this.scratch = MemoryUtil.memAllocShort((int)2048);
                for (i = 0; i < 4; ++i) {
                    this.fillWhiteNoisePCM(this.scratch, 2048);
                    AL10.alBufferData((int)this.buffers[i], (int)4353, (ShortBuffer)this.scratch, (int)22050);
                    AL10.alSourceQueueBuffers((int)this.sourceId, (int)this.buffers[i]);
                }
                AL10.alSourcePlay((int)this.sourceId);
            }
            catch (Throwable t) {
                this.disposeNative();
            }
        }

        void tick() {
            int buf;
            if (this.disposed || this.emitter.m_213877_() || this.emitter.m_9236_() == null || !this.emitter.m_9236_().f_46443_) {
                this.stopAndDispose();
                return;
            }
            AL10.alSource3f((int)this.sourceId, (int)4100, (float)((float)this.emitter.m_20185_()), (float)((float)this.emitter.m_20186_()), (float)((float)this.emitter.m_20189_()));
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p == null) {
                this.stopAndDispose();
                return;
            }
            double dx = p.m_20185_() - this.emitter.m_20185_();
            double dy = p.m_20188_() - (this.emitter.m_20186_() + 0.5);
            double dz = p.m_20189_() - this.emitter.m_20189_();
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            float gain = 0.0f;
            if (dist < 15.0) {
                gain = 0.2f * (1.0f - (float)(dist / 15.0));
            }
            AL10.alSourcef((int)this.sourceId, (int)4106, (float)gain);
            int processed = AL10.alGetSourcei((int)this.sourceId, (int)4118);
            while (processed-- > 0 && (buf = AL10.alSourceUnqueueBuffers((int)this.sourceId)) != 40963) {
                this.fillWhiteNoisePCM(this.scratch, 2048);
                AL10.alBufferData((int)buf, (int)4353, (ShortBuffer)this.scratch, (int)22050);
                AL10.alSourceQueueBuffers((int)this.sourceId, (int)buf);
            }
            int state = AL10.alGetSourcei((int)this.sourceId, (int)4112);
            if (state != 4114) {
                AL10.alSourcePlay((int)this.sourceId);
            }
        }

        void stopAndDispose() {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            try {
                if (this.sourceId != 0) {
                    AL10.alSourceStop((int)this.sourceId);
                    int queued = AL10.alGetSourcei((int)this.sourceId, (int)4117);
                    while (queued-- > 0) {
                        AL10.alSourceUnqueueBuffers((int)this.sourceId);
                    }
                }
                this.disposeNative();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void disposeNative() {
            try {
                for (int i = 0; i < 4; ++i) {
                    if (this.buffers[i] == 0) continue;
                    AL10.alDeleteBuffers((int)this.buffers[i]);
                }
                if (this.sourceId != 0) {
                    AL10.alDeleteSources((int)this.sourceId);
                }
                if (this.scratch != null) {
                    MemoryUtil.memFree((Buffer)this.scratch);
                    this.scratch = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void fillWhiteNoisePCM(ShortBuffer out, int samples) {
            out.clear();
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int i = 0; i < samples; ++i) {
                float f = rnd.nextFloat() * 2.0f - 1.0f;
                short s = (short)(f * 32767.0f);
                out.put(s);
            }
            out.flip();
        }
    }
}

