/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.entity;

import com.fullfud.fullfud.common.entity.RebEmitterEntity;
import com.fullfud.fullfud.common.entity.ShahedColor;
import com.fullfud.fullfud.common.entity.ShahedLauncherEntity;
import com.fullfud.fullfud.common.item.MonitorItem;
import com.fullfud.fullfud.core.FullfudRegistries;
import com.fullfud.fullfud.core.data.ShahedLinkData;
import com.fullfud.fullfud.core.network.FullfudNetwork;
import com.fullfud.fullfud.core.network.packet.ShahedControlPacket;
import com.fullfud.fullfud.core.network.packet.ShahedStatusPacket;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShahedDroneEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Float> DATA_THRUST = SynchedEntityData.m_135353_(ShahedDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(ShahedDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ON_LAUNCHER = SynchedEntityData.m_135353_(ShahedDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_ROLL = SynchedEntityData.m_135353_(ShahedDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final String TAG_THRUST = "Thrust";
    private static final String TAG_MOTION = "Motion";
    private static final String TAG_OWNER = "Owner";
    private static final String TAG_OWNER_VIEW = "OwnerView";
    private static final String TAG_ARMED = "Armed";
    private static final String TAG_LAUNCH_Y = "LaunchY";
    private static final String TAG_BODY_YAW = "BodyYaw";
    private static final String TAG_BODY_PITCH = "BodyPitch";
    private static final String TAG_BODY_ROLL = "BodyRoll";
    private static final String TAG_REMOTE_INIT = "RemoteInit";
    private static final String TAG_COLOR = "Color";
    private static final String TAG_ON_LAUNCHER = "OnLauncher";
    private static final String TAG_LAUNCHER_UUID = "LauncherUUID";
    private static final String TAG_PROJECTILE_HITS = "ProjectileHits";
    private static final String TAG_DAMAGE_TARGET_SPEED = "DamageTargetSpeed";
    private static final String TAG_LINEAR_VELOCITY = "LinearVelocity";
    private static final String TAG_FUEL = "FuelMass";
    private static final String TAG_SESS_X = "SessX";
    private static final String TAG_SESS_Y = "SessY";
    private static final String TAG_SESS_Z = "SessZ";
    private static final String TAG_SESS_YAW = "SessYaw";
    private static final String TAG_SESS_PITCH = "SessPitch";
    private static final String TAG_SESS_DIM = "SessDim";
    private static final String TAG_SESS_GM = "SessGM";
    private static final String TAG_CONTROLLER = "ControllerUUID";
    private static final int STATUS_INTERVAL = 1;
    private static final int CONTROL_TIMEOUT_TICKS = 20;
    private static final double TICK_SECONDS = 0.05;
    private static final double BASE_MASS_KG = 210.0;
    private static final double FUEL_CAPACITY_KG = 45.0;
    private static final double FUEL_CONSUMPTION_PER_SEC = 0.9286;
    private static final double MAX_THRUST_FORCE = 1500.0;
    private static final double THRUST_CURVE_EXPONENT = 2.0;
    private static final double RHO_SEA_LEVEL = 1.225;
    private static final double ATMOSPHERE_SCALE_HEIGHT = 8500.0;
    private static final double WING_AREA = 4.0;
    private static final double CL_ALPHA = 2.5;
    private static final double CL_MAX = 1.5;
    private static final double CL_ZERO = 0.25;
    private static final double CD_MIN = 0.052;
    private static final double DRAG_FACTOR = 0.055;
    private static final double CY_BETA = -0.85;
    private static final double GRAVITY = 9.81;
    private static final double MAX_ROLL_RATE = 60.0;
    private static final double MAX_PITCH_RATE = 45.0;
    private static final double ROLL_ACCEL = 120.0;
    private static final double PITCH_ACCEL = 90.0;
    private static final double GROUND_FRICTION = 0.62;
    private static final double MAX_AIRSPEED = 72.222;
    private static final double INITIAL_LAUNCH_SPEED = 55.5;
    private static final double ENGINE_IDLE_THRUST = 0.0;
    private static final double ENGINE_SPOOL_RATE = 0.05;
    private static final double STALL_ANGLE = Math.toRadians(17.0);
    private static final double PROJECTILE_DAMAGE_DECEL_PER_SEC = 24.0;
    private static final double DAMAGE_SMOKE_PARTICLES_PER_TICK = 0.35;
    private static final double DAMAGE_SMOKE_SPREAD = 0.7;
    private static final TicketType<Integer> SHAHED_TICKET = TicketType.m_9465_((String)"fullfud_shahed", Integer::compareTo, (int)4);
    private static final EntityDimensions SHAHEED_DIMENSIONS = EntityDimensions.m_20395_((float)3.0f, (float)1.0f);
    private static final Logger LOG = LogManager.getLogger((String)"ShahedDrone");
    private final Map<UUID, Integer> viewerDistances = new HashMap<UUID, Integer>();
    private float controlForward;
    private float controlStrafe;
    private float controlVertical;
    private Vec3 linearVelocity = Vec3.f_82478_;
    private double crippledHorizontalTargetSpeed = -1.0;
    private double damageSmokeAccumulator;
    private int projectileHitCount;
    private int controlTimeout;
    private double rollRate;
    private double pitchRate;
    private UUID ownerUUID;
    private int ownerViewDistance = 8;
    private ChunkPos lastTicketPos;
    private int lastTicketRadius;
    private int desiredChunkRadius;
    private float jammerOverride;
    private boolean jammerSuppressControls;
    private static final double JAMMER_HARD_RADIUS = 300.0;
    private static final double JAMMER_MAX_RADIUS = 600.0;
    private boolean armed;
    private double launchBaselineY;
    private UUID controllingPlayer;
    private ControlSession controlSession;
    private RemotePilotFakePlayer avatar;
    private double fuelMass = 45.0;
    private FlightTelemetry telemetry = FlightTelemetry.ZERO;
    private double bodyYaw;
    private double bodyPitch;
    private double bodyRoll;
    private double bodyPitchO;
    private double bodyRollO;
    private double engineOutput;
    private boolean remoteInitialized;
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.model.idle");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenLoop("animation.model.running");
    private boolean cameraPinned;
    private static final double LAUNCHER_VERTICAL_OFFSET = 0.25;
    private static final double LAUNCHER_FORWARD_OFFSET = 2.0;
    private static final double LAUNCHER_UP_OFFSET = 10.0;
    private static final double LAUNCHER_LAUNCH_SPEED = 72.22222222222221;
    private static final float LAUNCHER_LAUNCH_PITCH = -12.5f;
    private int mountedLauncherId = -1;
    private UUID mountedLauncherUuid;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public ShahedDroneEntity(EntityType<? extends ShahedDroneEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = false;
        this.m_20242_(true);
        this.launchBaselineY = this.m_20186_();
        this.bodyYaw = this.m_146908_();
        this.bodyPitch = 0.0;
        this.bodyPitchO = 0.0;
        this.bodyRoll = 0.0;
        this.bodyRollO = 0.0;
        this.m_146926_((float)this.bodyPitch);
        this.engineOutput = 0.0;
        this.remoteInitialized = false;
        this.updateBoundingBox();
        this.m_6210_();
    }

    public static Optional<ShahedDroneEntity> find(ServerLevel level, UUID uuid) {
        Entity entity = level.m_8791_(uuid);
        if (entity instanceof ShahedDroneEntity) {
            ShahedDroneEntity drone = (ShahedDroneEntity)entity;
            return Optional.of(drone);
        }
        return Optional.empty();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_THRUST, (Object)Float.valueOf(0.25f));
        this.f_19804_.m_135372_(DATA_COLOR, (Object)ShahedColor.WHITE.getId());
        this.f_19804_.m_135372_(DATA_ON_LAUNCHER, (Object)false);
        this.f_19804_.m_135372_(DATA_ROLL, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            ServerPlayer player;
            this.updateJammerState();
            if (this.controllingPlayer != null && (player = this.getControllingPlayer()) != null && !this.cameraPinned) {
                this.endRemoteControl(player);
            }
        }
        if (this.isOnLauncher()) {
            if (!this.m_9236_().f_46443_) {
                this.handleLauncherAttachment();
            }
            return;
        }
        this.bodyPitchO = this.bodyPitch;
        this.bodyRollO = this.bodyRoll;
        if (this.m_9236_().m_5776_()) {
            this.bodyRoll = ((Float)this.f_19804_.m_135370_(DATA_ROLL)).floatValue();
        }
        if (!this.m_9236_().m_5776_() || this.m_6109_()) {
            if (!this.m_9236_().m_5776_() && this.controllingPlayer == null) {
                this.bodyPitch *= (double)0.9f;
                this.bodyRoll *= (double)0.9f;
            }
            this.m_146926_((float)this.bodyPitch);
            this.updateControlTimeout();
            this.updateFlight();
            if (!this.m_9236_().m_5776_()) {
                this.f_19804_.m_135381_(DATA_ROLL, (Object)Float.valueOf((float)this.bodyRoll));
            }
        }
        if (this.m_9236_().m_5776_() && !this.m_6109_()) {
            if (this.lerpSteps > 0) {
                double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
                double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
                double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
                double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
                double d4 = Mth.m_14175_((double)(this.lerpXRot - (double)this.m_146909_()));
                this.m_146926_(this.m_146909_() + (float)d4 / (float)this.lerpSteps);
                --this.lerpSteps;
                this.m_6034_(d0, d1, d2);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
            this.bodyPitch = this.m_146909_();
            this.bodyYaw = this.m_146908_();
        }
        if (this.m_9236_().m_5776_() && this.m_6109_()) {
            this.m_146922_((float)this.bodyYaw);
            this.m_146926_((float)this.bodyPitch);
        }
        if (!this.m_9236_().m_5776_()) {
            this.updateLaunchState();
            if (this.armed) {
                if (this.detectImpact()) {
                    this.detonate();
                    return;
                }
                List collisions = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.3), e -> !e.m_5833_() && e.m_6087_());
                for (Entity entity : collisions) {
                    if (this.avatar != null && entity == this.avatar) continue;
                    this.detonate();
                    return;
                }
            }
            ServerPlayer cp = this.getControllingPlayer();
            if (this.cameraPinned && this.isSignalLostFor(cp)) {
                this.releaseCameraFor(cp);
            }
            this.ensureChunkTicket();
            this.updateControllerBinding();
            if (this.f_19797_ % 1 == 0) {
                this.broadcastStatus();
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (this.m_6109_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public float getVisualRoll(float partialTick) {
        return (float)Mth.m_14139_((double)partialTick, (double)this.bodyRollO, (double)this.bodyRoll);
    }

    public float getVisualPitch(float partialTick) {
        return (float)Mth.m_14139_((double)partialTick, (double)this.bodyPitchO, (double)this.bodyPitch);
    }

    private void updateControlTimeout() {
        if (this.controlTimeout > 0) {
            --this.controlTimeout;
        } else {
            this.controlForward = 0.0f;
            this.controlStrafe = 0.0f;
            this.controlVertical = 0.0f;
        }
    }

    private void updateFlight() {
        double dt = 0.05;
        float throttle = Mth.m_14036_((float)this.getThrust(), (float)0.0f, (float)1.0f);
        if (this.fuelMass > 0.0 && throttle > 0.0f) {
            double burn = Math.pow(throttle, 1.5) * 0.9286 * 0.05;
            if (throttle < 0.8f) {
                burn *= 0.6;
            }
            this.fuelMass = Math.max(0.0, this.fuelMass - burn);
        }
        if (this.fuelMass <= 0.0) {
            this.fuelMass = 0.0;
            if (throttle > 0.0f) {
                throttle = 0.0f;
                this.setThrust(0.0f);
            }
        }
        double totalMass = 210.0 + this.fuelMass;
        this.engineOutput += ((double)throttle - this.engineOutput) * 0.05;
        double thrustForce = this.fuelMass <= 0.0 ? 0.0 : this.computeEffectiveThrust(this.engineOutput);
        this.integrateAttitude(0.05);
        double yawRad = Math.toRadians(this.bodyYaw);
        double pitchRad = Math.toRadians(this.bodyPitch);
        double rollRad = Math.toRadians(this.bodyRoll);
        Vec3 forward = new Vec3(-Math.sin(yawRad) * Math.cos(pitchRad), -Math.sin(pitchRad), Math.cos(yawRad) * Math.cos(pitchRad)).m_82541_();
        Vec3 upBase = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.m_82537_(upBase).m_82541_();
        Vec3 localUp = right.m_82537_(forward).m_82541_();
        double sr = Math.sin(rollRad);
        double cr = Math.cos(rollRad);
        localUp = localUp.m_82490_(cr).m_82549_(right.m_82490_(sr)).m_82541_();
        double speed = this.linearVelocity.m_82553_();
        double altitude = this.m_20186_();
        double airDensity = ShahedDroneEntity.sampleAirDensity(altitude);
        double q = 0.5 * airDensity * speed * speed;
        double velocityPitch = speed > 0.01 ? Math.atan2(this.linearVelocity.f_82480_, Math.sqrt(this.linearVelocity.f_82479_ * this.linearVelocity.f_82479_ + this.linearVelocity.f_82481_ * this.linearVelocity.f_82481_)) : -pitchRad;
        double aoa = -pitchRad - velocityPitch;
        double cl = ShahedDroneEntity.applyStall(ShahedDroneEntity.resolveLiftCoefficient(aoa), aoa);
        double liftMagnitude = cl * q * 4.0;
        Vec3 liftVector = localUp.m_82490_(liftMagnitude);
        double cd = 0.052 + 0.055 * cl * cl;
        Vec3 dragVector = this.linearVelocity.m_82541_().m_82490_(-cd * q * 4.0);
        Vec3 thrustVector = forward.m_82490_(thrustForce);
        Vec3 gravityVector = new Vec3(0.0, -totalMass * 9.81, 0.0);
        Vec3 netForce = thrustVector.m_82549_(liftVector).m_82549_(dragVector).m_82549_(gravityVector);
        Vec3 acceleration = netForce.m_82490_(1.0 / totalMass);
        this.linearVelocity = this.linearVelocity.m_82549_(acceleration.m_82490_(0.05));
        double speedCapSq = 5216.017284;
        if (this.linearVelocity.m_82556_() > 5216.017284) {
            this.linearVelocity = this.linearVelocity.m_82541_().m_82490_(72.222);
        }
        this.applyProjectileDamageEffects(0.05);
        Vec3 velPerTick = this.linearVelocity.m_82490_(0.05);
        this.m_20256_(velPerTick);
        this.f_19812_ = true;
        this.m_6478_(MoverType.SELF, velPerTick);
        this.updateBoundingBox();
        this.resolveCollisionVelocity();
        if (this.linearVelocity.m_82556_() > 1.0) {
            double horizontalSpeed = Math.sqrt(this.linearVelocity.f_82479_ * this.linearVelocity.f_82479_ + this.linearVelocity.f_82481_ * this.linearVelocity.f_82481_);
            double moveYaw = Math.toDegrees(Math.atan2(-this.linearVelocity.f_82479_, this.linearVelocity.f_82481_));
            double yawDiff = Mth.m_14175_((double)(moveYaw - this.bodyYaw));
            this.bodyYaw += yawDiff * 0.1;
        }
        this.telemetry = new FlightTelemetry((float)speed, (float)Math.sqrt(this.linearVelocity.f_82479_ * this.linearVelocity.f_82479_ + this.linearVelocity.f_82481_ * this.linearVelocity.f_82481_), (float)this.linearVelocity.f_82480_, (float)Math.toDegrees(aoa), 0.0f, throttle, (float)this.fuelMass, (float)airDensity);
    }

    private void integrateAttitude(double dt) {
        double targetRollRate = (double)this.controlStrafe * 60.0;
        this.rollRate = ShahedDroneEntity.approach(this.rollRate, Math.toRadians(targetRollRate), Math.toRadians(120.0) * dt);
        double targetPitchRate = (double)this.controlForward * 45.0;
        this.pitchRate = ShahedDroneEntity.approach(this.pitchRate, Math.toRadians(targetPitchRate), Math.toRadians(90.0) * dt);
        this.bodyRoll += Math.toDegrees(this.rollRate * dt);
        this.bodyPitch += Math.toDegrees(this.pitchRate * dt);
        this.bodyPitch = Mth.m_14008_((double)this.bodyPitch, (double)-85.0, (double)85.0);
        this.bodyRoll = Mth.m_14175_((double)this.bodyRoll);
        this.bodyYaw = Mth.m_14175_((double)this.bodyYaw);
        this.m_146926_((float)this.bodyPitch);
        this.m_146922_((float)this.bodyYaw);
        this.m_5616_((float)this.bodyYaw);
    }

    private void applyProjectileDamageEffects(double dt) {
        if (this.projectileHitCount <= 0) {
            return;
        }
        double horizontalSpeed = Math.sqrt(this.linearVelocity.f_82479_ * this.linearVelocity.f_82479_ + this.linearVelocity.f_82481_ * this.linearVelocity.f_82481_);
        if (this.crippledHorizontalTargetSpeed < 0.0) {
            this.crippledHorizontalTargetSpeed = horizontalSpeed;
        }
        double slowdown = 24.0 * dt;
        this.crippledHorizontalTargetSpeed = Math.max(0.0, this.crippledHorizontalTargetSpeed - slowdown);
        if (horizontalSpeed > this.crippledHorizontalTargetSpeed) {
            if (horizontalSpeed <= 1.0E-4 || this.crippledHorizontalTargetSpeed <= 0.0) {
                this.linearVelocity = new Vec3(0.0, this.linearVelocity.f_82480_, 0.0);
            } else {
                Vec3 horizontal = new Vec3(this.linearVelocity.f_82479_, 0.0, this.linearVelocity.f_82481_).m_82541_();
                Vec3 clamped = horizontal.m_82490_(this.crippledHorizontalTargetSpeed);
                this.linearVelocity = new Vec3(clamped.f_82479_, this.linearVelocity.f_82480_, clamped.f_82481_);
            }
        }
        this.spawnDamageSmokeParticles();
    }

    private void spawnDamageSmokeParticles() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.damageSmokeAccumulator += 0.35;
        int spawnCount = (int)this.damageSmokeAccumulator;
        this.damageSmokeAccumulator -= (double)spawnCount;
        if (spawnCount <= 0) {
            return;
        }
        RandomSource random = this.f_19796_;
        for (int i = 0; i < spawnCount; ++i) {
            boolean large = random.m_188501_() < 0.65f;
            SimpleParticleType particle = large ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
            double offsetX = (random.m_188500_() - 0.5) * 0.7;
            double offsetZ = (random.m_188500_() - 0.5) * 0.7;
            double height = 0.6 + random.m_188500_() * 0.6;
            double px = this.m_20185_() + offsetX;
            double py = this.m_20186_() + height;
            double pz = this.m_20189_() + offsetZ;
            double driftX = (random.m_188500_() - 0.5) * 0.02;
            double driftY = 0.02 + random.m_188500_() * 0.05;
            double driftZ = (random.m_188500_() - 0.5) * 0.02;
            serverLevel.m_8767_((ParticleOptions)particle, px, py, pz, 1, driftX, driftY, driftZ, 0.0);
        }
    }

    private static double sampleAirDensity(double altitude) {
        return 1.225 * Math.exp(-Math.max(0.0, altitude) / 8500.0);
    }

    private static double resolveLiftCoefficient(double aoaRad) {
        return Mth.m_14008_((double)(0.25 + 2.5 * aoaRad), (double)-1.5, (double)1.5);
    }

    private static double applyStall(double cl, double aoaRad) {
        double absAoa = Math.abs(aoaRad);
        if (absAoa <= STALL_ANGLE) {
            return cl;
        }
        double excess = Math.min(absAoa - STALL_ANGLE, STALL_ANGLE);
        double stallFactor = Math.max(0.0, 1.0 - excess / STALL_ANGLE);
        return cl * stallFactor * stallFactor;
    }

    private double computeEffectiveThrust(double engineLevel) {
        double normalizedLevel = Mth.m_14008_((double)engineLevel, (double)0.0, (double)1.0);
        double throttleResponse = Math.pow(normalizedLevel, 2.0);
        return 0.0 + throttleResponse * 1500.0;
    }

    private Vec3 forwardGroundVector() {
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double x = -Mth.m_14031_((float)yawRad);
        double z = Mth.m_14089_((float)yawRad);
        return new Vec3(x, 0.0, z).m_82541_();
    }

    private void resolveCollisionVelocity() {
        if (this.f_19863_ && this.linearVelocity.f_82480_ < 0.0) {
            this.linearVelocity = new Vec3(this.linearVelocity.f_82479_ * 0.62, 0.0, this.linearVelocity.f_82481_ * 0.62);
        }
        if (this.f_19862_) {
            this.linearVelocity = new Vec3(this.linearVelocity.f_82479_ * 0.62, this.linearVelocity.f_82480_, this.linearVelocity.f_82481_ * 0.62);
        }
    }

    private void ensureFlightAltitude() {
        if (this.m_9236_() == null) {
            return;
        }
        int x = Mth.m_14107_((double)this.m_20185_());
        int z = Mth.m_14107_((double)this.m_20189_());
        int terrainY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        double desiredY = (double)terrainY + 10.0;
        if (this.m_20186_() >= desiredY) {
            return;
        }
        this.m_6034_(this.m_20185_(), desiredY, this.m_20189_());
        this.m_20256_(Vec3.f_82478_);
        this.linearVelocity = Vec3.f_82478_;
        this.bodyPitch = 0.0;
        this.bodyPitchO = 0.0;
        this.bodyRoll = 0.0;
        this.bodyRollO = 0.0;
        this.m_146926_((float)this.bodyPitch);
        this.launchBaselineY = desiredY;
        this.updateBoundingBox();
    }

    protected void m_7378_(CompoundTag tag) {
        this.setThrust(tag.m_128457_(TAG_THRUST));
        if (tag.m_128425_(TAG_LINEAR_VELOCITY, 9)) {
            ListTag list = tag.m_128437_(TAG_LINEAR_VELOCITY, 6);
            this.linearVelocity = new Vec3(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
        } else if (tag.m_128425_(TAG_MOTION, 9)) {
            ListTag legacy = tag.m_128437_(TAG_MOTION, 6);
            this.linearVelocity = new Vec3(legacy.m_128772_(0) * 20.0, legacy.m_128772_(1) * 20.0, legacy.m_128772_(2) * 20.0);
        } else {
            this.linearVelocity = Vec3.f_82478_;
        }
        if (tag.m_128403_(TAG_OWNER)) {
            this.ownerUUID = tag.m_128342_(TAG_OWNER);
        }
        this.ownerViewDistance = Math.max(2, tag.m_128451_(TAG_OWNER_VIEW));
        this.armed = tag.m_128471_(TAG_ARMED);
        this.launchBaselineY = tag.m_128441_(TAG_LAUNCH_Y) ? tag.m_128459_(TAG_LAUNCH_Y) : this.m_20186_();
        this.fuelMass = tag.m_128441_(TAG_FUEL) ? tag.m_128459_(TAG_FUEL) : 45.0;
        this.bodyYaw = tag.m_128441_(TAG_BODY_YAW) ? tag.m_128459_(TAG_BODY_YAW) : (double)this.m_146908_();
        this.bodyPitch = tag.m_128441_(TAG_BODY_PITCH) ? tag.m_128459_(TAG_BODY_PITCH) : (double)this.m_146909_();
        this.bodyRoll = tag.m_128441_(TAG_BODY_ROLL) ? tag.m_128459_(TAG_BODY_ROLL) : 0.0;
        this.bodyPitchO = this.bodyPitch;
        this.bodyRollO = this.bodyRoll;
        this.remoteInitialized = tag.m_128471_(TAG_REMOTE_INIT);
        if (tag.m_128441_(TAG_COLOR)) {
            this.setColor(ShahedColor.byId(tag.m_128451_(TAG_COLOR)));
        }
        boolean onLauncher = tag.m_128471_(TAG_ON_LAUNCHER);
        this.f_19804_.m_135381_(DATA_ON_LAUNCHER, (Object)onLauncher);
        if (onLauncher && tag.m_128403_(TAG_LAUNCHER_UUID)) {
            this.mountedLauncherUuid = tag.m_128342_(TAG_LAUNCHER_UUID);
            this.mountedLauncherId = -1;
        } else {
            this.mountedLauncherUuid = null;
            this.mountedLauncherId = -1;
        }
        this.projectileHitCount = tag.m_128451_(TAG_PROJECTILE_HITS);
        double d = this.crippledHorizontalTargetSpeed = tag.m_128441_(TAG_DAMAGE_TARGET_SPEED) ? tag.m_128459_(TAG_DAMAGE_TARGET_SPEED) : -1.0;
        if (this.projectileHitCount <= 0) {
            this.crippledHorizontalTargetSpeed = -1.0;
        }
        this.damageSmokeAccumulator = 0.0;
        if (tag.m_128403_(TAG_CONTROLLER)) {
            this.controllingPlayer = tag.m_128342_(TAG_CONTROLLER);
            if (tag.m_128441_(TAG_SESS_X)) {
                Vec3 origin = new Vec3(tag.m_128459_(TAG_SESS_X), tag.m_128459_(TAG_SESS_Y), tag.m_128459_(TAG_SESS_Z));
                float yaw = tag.m_128457_(TAG_SESS_YAW);
                float pitch = tag.m_128457_(TAG_SESS_PITCH);
                ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_SESS_DIM)));
                GameType gm = GameType.m_46393_((int)tag.m_128451_(TAG_SESS_GM));
                this.controlSession = new ControlSession((ResourceKey<Level>)dim, origin, yaw, pitch, gm);
            }
        }
        this.updateBoundingBox();
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_(TAG_THRUST, this.getThrust());
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.m_128500_((double)this.linearVelocity.f_82479_));
        list.add((Object)DoubleTag.m_128500_((double)this.linearVelocity.f_82480_));
        list.add((Object)DoubleTag.m_128500_((double)this.linearVelocity.f_82481_));
        tag.m_128365_(TAG_LINEAR_VELOCITY, (Tag)list);
        if (this.ownerUUID != null) {
            tag.m_128362_(TAG_OWNER, this.ownerUUID);
            tag.m_128405_(TAG_OWNER_VIEW, this.ownerViewDistance);
        }
        tag.m_128379_(TAG_ARMED, this.armed);
        tag.m_128347_(TAG_LAUNCH_Y, this.launchBaselineY);
        tag.m_128347_(TAG_FUEL, this.fuelMass);
        tag.m_128347_(TAG_BODY_YAW, this.bodyYaw);
        tag.m_128347_(TAG_BODY_PITCH, this.bodyPitch);
        tag.m_128347_(TAG_BODY_ROLL, this.bodyRoll);
        tag.m_128379_(TAG_REMOTE_INIT, this.remoteInitialized);
        tag.m_128405_(TAG_COLOR, this.getColor().getId());
        if (this.isOnLauncher() && this.mountedLauncherUuid != null) {
            tag.m_128379_(TAG_ON_LAUNCHER, true);
            tag.m_128362_(TAG_LAUNCHER_UUID, this.mountedLauncherUuid);
        }
        if (this.projectileHitCount > 0) {
            tag.m_128405_(TAG_PROJECTILE_HITS, this.projectileHitCount);
            tag.m_128347_(TAG_DAMAGE_TARGET_SPEED, Math.max(0.0, this.crippledHorizontalTargetSpeed));
        }
        if (this.controllingPlayer != null) {
            tag.m_128362_(TAG_CONTROLLER, this.controllingPlayer);
        }
        if (this.controlSession != null) {
            tag.m_128347_(TAG_SESS_X, this.controlSession.originPos.f_82479_);
            tag.m_128347_(TAG_SESS_Y, this.controlSession.originPos.f_82480_);
            tag.m_128347_(TAG_SESS_Z, this.controlSession.originPos.f_82481_);
            tag.m_128350_(TAG_SESS_YAW, this.controlSession.originYaw);
            tag.m_128350_(TAG_SESS_PITCH, this.controlSession.originPitch);
            tag.m_128359_(TAG_SESS_DIM, this.controlSession.originDimension.m_135782_().toString());
            tag.m_128405_(TAG_SESS_GM, this.controlSession.originalGameType.m_46392_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof MonitorItem) {
            MonitorItem.setLinkedDrone(heldItem, this.m_20148_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.assignOwner(serverPlayer);
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.monitor.linked"), true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (heldItem.m_41619_() && !this.m_9236_().f_46443_) {
            if (this.armed) {
                player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.shahed.armed"), true);
                return InteractionResult.FAIL;
            }
            ItemStack droneStack = new ItemStack(this.getColor() == ShahedColor.BLACK ? (ItemLike)FullfudRegistries.SHAHED_BLACK_ITEM.get() : (ItemLike)FullfudRegistries.SHAHED_ITEM.get());
            if (!player.m_36356_(droneStack)) {
                this.m_19983_(droneStack);
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.shahed.picked_up"), true);
            this.m_146870_();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void addViewer(ServerPlayer player) {
        this.viewerDistances.put(player.m_20148_(), this.resolveViewDistance(player));
        this.sendStatusTo(player);
        this.recalcDesiredChunkRadius();
        this.ensureChunkTicket();
    }

    public void removeViewer(ServerPlayer player) {
        this.viewerDistances.remove(player.m_20148_());
        this.recalcDesiredChunkRadius();
        this.ensureChunkTicket();
    }

    public void applyControl(ShahedControlPacket packet, ServerPlayer sender) {
        if (!Float.isFinite(packet.thrustDelta())) {
            this.releaseCameraFor(sender);
            return;
        }
        if (!this.canReceiveControl()) {
            return;
        }
        this.controlForward = Mth.m_14036_((float)packet.forward(), (float)-1.0f, (float)1.0f);
        this.controlStrafe = Mth.m_14036_((float)packet.strafe(), (float)-1.0f, (float)1.0f);
        this.controlVertical = Mth.m_14036_((float)packet.vertical(), (float)-1.0f, (float)1.0f);
        this.controlTimeout = 20;
        float newThrust = Mth.m_14036_((float)(this.getThrust() + packet.thrustDelta()), (float)0.0f, (float)1.0f);
        this.setThrust(newThrust);
    }

    private boolean canReceiveControl() {
        return !this.jammerSuppressControls;
    }

    private void updateJammerState() {
        this.jammerOverride = 0.0f;
        this.jammerSuppressControls = false;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double maxRadius = 600.0;
        AABB searchBox = new AABB(this.m_20185_() - 600.0, this.m_20186_() - 5.0, this.m_20189_() - 600.0, this.m_20185_() + 600.0, this.m_20186_() + 5.0, this.m_20189_() + 600.0);
        for (RebEmitterEntity emitter : serverLevel.m_45976_(RebEmitterEntity.class, searchBox)) {
            double dz;
            double dx;
            double horizontalDist;
            float strength;
            if (!emitter.hasBattery() || emitter.getChargeTicks() <= 0 || !((strength = ShahedDroneEntity.computeJammerStrength(horizontalDist = Math.sqrt((dx = emitter.m_20185_() - this.m_20185_()) * dx + (dz = emitter.m_20189_() - this.m_20189_()) * dz))) > this.jammerOverride)) continue;
            this.jammerOverride = strength;
        }
        if (this.jammerOverride >= 1.0f) {
            this.jammerSuppressControls = true;
            this.setThrust(0.0f);
        }
    }

    private static float computeJammerStrength(double horizontalDist) {
        if (horizontalDist >= 600.0) {
            return 0.0f;
        }
        if (horizontalDist <= 300.0) {
            return 1.0f;
        }
        double normalized = (horizontalDist - 300.0) / 300.0;
        return (float)(1.0 - 0.99 * normalized);
    }

    private void broadcastStatus() {
        Object object;
        if (this.viewerDistances.isEmpty() || !((object = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)object;
        for (UUID viewerId : Set.copyOf(this.viewerDistances.keySet())) {
            ServerPlayer viewer = serverLevel.m_7654_().m_6846_().m_11259_(viewerId);
            if (viewer == null) {
                this.viewerDistances.remove(viewerId);
                continue;
            }
            this.sendStatusTo(viewer);
        }
    }

    private void sendStatusTo(ServerPlayer viewer) {
        double distance = this.computeSignalDistance(viewer);
        float noise = Math.max(ShahedDroneEntity.computeNoise(distance), this.jammerOverride);
        boolean signalLost = distance > 10000.0;
        FlightTelemetry data = this.telemetry == null ? FlightTelemetry.ZERO : this.telemetry;
        ShahedStatusPacket packet = new ShahedStatusPacket(this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_(), this.getThrust(), noise, signalLost, data.airSpeed(), data.groundSpeed(), data.verticalSpeed(), data.angleOfAttack(), data.slipAngle(), data.fuelKg(), data.airDensity());
        FullfudNetwork.getChannel().send(PacketDistributor.PLAYER.with(() -> viewer), (Object)packet);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flight", state -> {
            if (this.shouldUseRunningAnimation()) {
                state.setAndContinue(RUN_ANIMATION);
            } else {
                state.setAndContinue(IDLE_ANIMATION);
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    private boolean shouldUseRunningAnimation() {
        return this.getThrust() > 0.2f || this.linearVelocity.m_82556_() > 4.0;
    }

    private void updateBoundingBox() {
        float width = 3.0f;
        float height = 1.0f;
        float halfWidth = 1.5f;
        Vec3 center = this.m_20182_();
        double yawRad = Math.toRadians(this.m_146908_());
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        Vec3[] corners = new Vec3[]{new Vec3(-1.5, 0.0, -1.5), new Vec3(1.5, 0.0, -1.5), new Vec3(1.5, 0.0, 1.5), new Vec3(-1.5, 0.0, 1.5)};
        double minX = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Vec3 corner : corners) {
            double rotX = corner.f_82479_ * cos - corner.f_82481_ * sin;
            double rotZ = corner.f_82479_ * sin + corner.f_82481_ * cos;
            minX = Math.min(minX, center.f_82479_ + rotX);
            minZ = Math.min(minZ, center.f_82481_ + rotZ);
            maxX = Math.max(maxX, center.f_82479_ + rotX);
            maxZ = Math.max(maxZ, center.f_82481_ + rotZ);
        }
        double minY = this.m_20186_();
        double maxY = this.m_20186_() + 1.0;
        AABB box = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        this.m_20011_(box);
    }

    private double computeSignalDistance(ServerPlayer viewer) {
        if (this.controllingPlayer != null && this.controllingPlayer.equals(viewer.m_20148_()) && this.controlSession != null) {
            if (this.controlSession.originPos == null) {
                return 0.0;
            }
            if (!this.m_9236_().m_46472_().equals(this.controlSession.originDimension)) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.sqrt(this.controlSession.originPos.m_82557_(this.m_20182_()));
        }
        return Math.sqrt(viewer.m_20280_((Entity)this));
    }

    private static float computeNoise(double distance) {
        if (distance <= 0.0) {
            return 0.0f;
        }
        return (float)Math.min(distance / 10000.0, 0.5);
    }

    private void setThrust(float thrust) {
        this.f_19804_.m_135381_(DATA_THRUST, (Object)Float.valueOf(thrust));
    }

    public float getThrust() {
        return ((Float)this.f_19804_.m_135370_(DATA_THRUST)).floatValue();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return SHAHEED_DIMENSIONS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Projectile) {
            if (!this.m_9236_().m_5776_()) {
                this.handleProjectileImpact();
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    private void handleProjectileImpact() {
        ++this.projectileHitCount;
        if (this.projectileHitCount >= 2) {
            this.detonate();
            return;
        }
        double horizontalSpeed = Math.sqrt(this.linearVelocity.f_82479_ * this.linearVelocity.f_82479_ + this.linearVelocity.f_82481_ * this.linearVelocity.f_82481_);
        this.crippledHorizontalTargetSpeed = Math.max(horizontalSpeed, 0.0);
        this.damageSmokeAccumulator = 0.0;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public ShahedColor getColor() {
        return ShahedColor.byId((Integer)this.f_19804_.m_135370_(DATA_COLOR));
    }

    public void setColor(ShahedColor color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color.getId());
    }

    public void setLaunchVelocity(Vec3 velocity) {
        this.linearVelocity = velocity;
        this.m_20256_(this.linearVelocity.m_82490_(0.05));
    }

    public boolean isOnLauncher() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ON_LAUNCHER);
    }

    public UUID getLauncherUuid() {
        return this.mountedLauncherUuid;
    }

    public void mountLauncher(ShahedLauncherEntity launcher) {
        this.mountedLauncherId = launcher.m_19879_();
        this.mountedLauncherUuid = launcher.m_20148_();
        this.f_19804_.m_135381_(DATA_ON_LAUNCHER, (Object)true);
        this.m_20242_(true);
        this.linearVelocity = Vec3.f_82478_;
        this.m_20256_(Vec3.f_82478_);
        this.updateLauncherPose(launcher);
    }

    public void launchFromLauncher(ShahedLauncherEntity launcher) {
        float yaw = launcher.m_146908_();
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)yaw).m_82541_();
        Vec3 base = launcher.m_20182_().m_82520_(0.0, 0.25, 0.0);
        Vec3 spawn = base.m_82549_(forward.m_82490_(2.0)).m_82520_(0.0, 10.0, 0.0);
        this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        this.releaseFromLauncher(new Vec3(forward.f_82479_ * 72.22222222222221, 0.0, forward.f_82481_ * 72.22222222222221), yaw);
    }

    public void releaseFromLauncher(Vec3 velocity, float launcherYaw) {
        this.f_19804_.m_135381_(DATA_ON_LAUNCHER, (Object)false);
        this.m_20242_(false);
        this.mountedLauncherId = -1;
        this.mountedLauncherUuid = null;
        this.setLaunchVelocity(velocity);
        float yaw = launcherYaw;
        this.m_146922_(yaw);
        this.m_5618_(yaw);
        this.m_5616_(yaw);
        this.bodyYaw = yaw;
        this.bodyPitch = -10.0;
        this.bodyRoll = 0.0;
        this.bodyRollO = 0.0;
        this.m_146926_((float)this.bodyPitch);
    }

    private void handleLauncherAttachment() {
        this.m_20256_(Vec3.f_82478_);
        ShahedLauncherEntity launcher = this.resolveLauncher();
        if (launcher != null) {
            this.updateLauncherPose(launcher);
            return;
        }
        if (!this.m_9236_().f_46443_) {
            ItemStack stack = new ItemStack(this.getColor() == ShahedColor.BLACK ? (ItemLike)FullfudRegistries.SHAHED_BLACK_ITEM.get() : (ItemLike)FullfudRegistries.SHAHED_ITEM.get());
            this.m_19983_(stack);
            this.m_146870_();
        }
    }

    private ShahedLauncherEntity resolveLauncher() {
        ServerLevel serverLevel;
        Entity entity;
        Level launcher2;
        Entity entity2;
        if (this.mountedLauncherId > 0 && (entity2 = this.m_9236_().m_6815_(this.mountedLauncherId)) instanceof ShahedLauncherEntity) {
            ShahedLauncherEntity launcher2 = (ShahedLauncherEntity)entity2;
            return launcher2;
        }
        if (this.mountedLauncherUuid != null && (launcher2 = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)launcher2).m_8791_(this.mountedLauncherUuid)) instanceof ShahedLauncherEntity) {
            ShahedLauncherEntity launcher3 = (ShahedLauncherEntity)entity;
            this.mountedLauncherId = launcher3.m_19879_();
            return launcher3;
        }
        return null;
    }

    private void updateLauncherPose(ShahedLauncherEntity launcher) {
        Vec3 anchor = launcher.m_20182_().m_82520_(0.0, 0.25, 0.0);
        this.m_6034_(anchor.f_82479_, anchor.f_82480_, anchor.f_82481_);
        float yaw = launcher.m_146908_();
        this.m_146922_(yaw);
        this.m_5618_(yaw);
        this.m_5616_(yaw);
        this.bodyYaw = yaw;
        this.bodyPitch = 0.0;
        this.bodyRoll = 0.0;
        this.bodyRollO = 0.0;
        this.m_146926_(0.0f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_()) {
            ServerLevel serverLevel;
            ServerPlayer offlineController;
            Level level;
            ServerPlayer controller = this.getControllingPlayer();
            if (controller != null) {
                this.forceReturnCamera(controller);
                this.endRemoteControl(controller);
            } else if (this.controllingPlayer != null && (level = this.m_9236_()) instanceof ServerLevel && (offlineController = (serverLevel = (ServerLevel)level).m_7654_().m_6846_().m_11259_(this.controllingPlayer)) != null) {
                this.forceReturnCamera(offlineController);
                this.endRemoteControl(offlineController);
            }
            level = this.m_9236_();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ShahedLinkData.get(serverLevel).unlink(this.m_20148_());
            }
            this.viewerDistances.clear();
            this.releaseChunkTicket();
        }
        super.m_142687_(reason);
    }

    public void onAddedToWorld() {
        Level level;
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_() && this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShahedLinkData.get(serverLevel).link(this.m_20148_(), this.ownerUUID);
            this.recalcDesiredChunkRadius();
            this.ensureChunkTicket();
        }
    }

    public void assignOwner(ServerPlayer player) {
        this.ownerUUID = player.m_20148_();
        this.ownerViewDistance = this.resolveViewDistance(player);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShahedLinkData.get(serverLevel).link(this.m_20148_(), this.ownerUUID);
        }
        this.recalcDesiredChunkRadius();
        this.ensureChunkTicket();
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.ownerUUID);
    }

    private int resolveViewDistance(ServerPlayer player) {
        return Math.max(2, player.m_284548_().m_7654_().m_6846_().m_11312_());
    }

    private void recalcDesiredChunkRadius() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int serverCap = Math.max(2, serverLevel.m_7654_().m_6846_().m_11312_());
        int desired = 0;
        for (int distance : this.viewerDistances.values()) {
            desired = Math.max(desired, Mth.m_14045_((int)distance, (int)2, (int)serverCap));
        }
        if (this.ownerUUID != null) {
            desired = Math.max(desired, Mth.m_14045_((int)this.ownerViewDistance, (int)2, (int)serverCap));
        }
        if (desired == 0) {
            desired = serverCap;
        }
        this.desiredChunkRadius = desired;
    }

    private void ensureChunkTicket() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.desiredChunkRadius <= 0) {
            this.recalcDesiredChunkRadius();
        }
        if (this.desiredChunkRadius <= 0) {
            this.releaseChunkTicket();
            return;
        }
        ChunkPos chunkPos = this.m_146902_();
        if (chunkPos.equals((Object)this.lastTicketPos) && this.desiredChunkRadius == this.lastTicketRadius) {
            return;
        }
        this.releaseChunkTicket();
        ServerChunkCache chunkSource = serverLevel.m_7726_();
        chunkSource.m_8387_(SHAHED_TICKET, chunkPos, this.desiredChunkRadius, (Object)this.m_19879_());
        this.lastTicketPos = chunkPos;
        this.lastTicketRadius = this.desiredChunkRadius;
    }

    private void releaseChunkTicket() {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (this.lastTicketPos != null) break block3;
            }
            this.lastTicketPos = null;
            this.lastTicketRadius = 0;
            return;
        }
        serverLevel.m_7726_().m_8438_(SHAHED_TICKET, this.lastTicketPos, Math.max(1, this.lastTicketRadius), (Object)this.m_19879_());
        this.lastTicketPos = null;
        this.lastTicketRadius = 0;
    }

    private ServerPlayer getControllingPlayer() {
        Level level;
        if (this.controllingPlayer == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return serverLevel.m_7654_().m_6846_().m_11259_(this.controllingPlayer);
    }

    private void updateControllerBinding() {
        ServerPlayer player = this.getControllingPlayer();
        if (player == null) {
            if (this.avatar != null) {
                this.removeAvatar();
            }
            return;
        }
        player.m_6842_(true);
        player.m_20225_(true);
        player.m_20242_(true);
        player.f_19794_ = true;
        if (this.controlSession != null && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            player.m_143403_(GameType.SPECTATOR);
        }
        if (player.m_9236_() != this.m_9236_()) {
            player.m_8999_((ServerLevel)this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.cameraPinned) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this));
            }
        } else if ((this.f_19797_ & 1) == 0) {
            player.f_8906_.m_9774_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), player.m_146908_(), player.m_146909_());
            if (this.cameraPinned) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this));
            }
        }
        this.syncAvatar(player);
    }

    private void updateLaunchState() {
        if (!this.armed) {
            double altitudeGain = this.m_20186_() - this.launchBaselineY;
            double verticalSpeed = Math.abs(this.linearVelocity.f_82480_);
            if (altitudeGain > 1.5 || verticalSpeed > 5.0) {
                this.armed = true;
            }
        }
    }

    private boolean detectImpact() {
        if (this.f_19862_ || this.f_19863_) {
            return this.hasDangerousSpeed();
        }
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        BlockState below = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if (!state.m_60795_() || !below.m_60795_()) {
            return this.hasDangerousSpeed();
        }
        int x = Mth.m_14107_((double)this.m_20185_());
        int z = Mth.m_14107_((double)this.m_20189_());
        int terrainY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        return this.m_20186_() <= (double)terrainY + 0.15 && this.hasDangerousSpeed();
    }

    private boolean hasDangerousSpeed() {
        return this.linearVelocity.m_82556_() > 1.0;
    }

    private void detonate() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer controller = this.getControllingPlayer();
        if (controller != null) {
            this.forceReturnCamera(controller);
            this.endRemoteControl(controller);
        }
        this.spawnSecondaryCharges();
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, Level.ExplosionInteraction.MOB);
        this.applyBlastDamage();
        this.m_146870_();
    }

    private void spawnSecondaryCharges() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = serverLevel.m_213780_();
        for (int i = 0; i < 10; ++i) {
            PrimedTnt charge = (PrimedTnt)EntityType.f_20515_.m_20615_((Level)serverLevel);
            if (charge == null) continue;
            double spread = 2.0;
            double offsetX = (random.m_188500_() - 0.5) * 2.0;
            double offsetY = random.m_188500_() * 0.6;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0;
            charge.m_7678_(this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, this.m_146908_(), this.m_146909_());
            charge.m_32085_(0);
            serverLevel.m_7967_((Entity)charge);
        }
    }

    private void applyBlastDamage() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double radius = 20.0;
        AABB area = new AABB(this.m_20185_() - 20.0, this.m_20186_() - 6.0, this.m_20189_() - 20.0, this.m_20185_() + 20.0, this.m_20186_() + 6.0, this.m_20189_() + 20.0);
        DamageSource damageSource = serverLevel.m_269111_().m_269036_((Entity)this, (Entity)this);
        for (LivingEntity target : serverLevel.m_45976_(LivingEntity.class, area)) {
            if (target.m_6673_(damageSource)) continue;
            double distance = Math.sqrt(target.m_20280_((Entity)this));
            if (distance <= 15.0) {
                target.m_6469_(damageSource, 100.0f);
                continue;
            }
            if (!(distance <= 20.0)) continue;
            target.m_6469_(damageSource, 50.0f);
        }
    }

    public void initializePlacement(double yPosition) {
        this.launchBaselineY = yPosition;
        this.armed = false;
        this.linearVelocity = Vec3.f_82478_;
        this.m_20256_(Vec3.f_82478_);
        this.controlForward = 0.0f;
        this.controlStrafe = 0.0f;
        this.controlVertical = 0.0f;
        this.rollRate = 0.0;
        this.pitchRate = 0.0;
        this.fuelMass = 45.0;
        this.telemetry = FlightTelemetry.ZERO;
        this.bodyYaw = this.m_146908_();
        this.bodyPitch = 0.0;
        this.bodyPitchO = 0.0;
        this.bodyRoll = 0.0;
        this.bodyRollO = 0.0;
        this.m_146926_((float)this.bodyPitch);
        this.engineOutput = 0.0;
        this.remoteInitialized = false;
    }

    public boolean beginRemoteControl(ServerPlayer player) {
        if (this.controllingPlayer != null && !this.controllingPlayer.equals(player.m_20148_())) {
            return false;
        }
        if (this.isOnLauncher()) {
            ShahedLauncherEntity launcher = this.resolveLauncher();
            if (launcher != null) {
                this.launchFromLauncher(launcher);
            } else {
                this.f_19804_.m_135381_(DATA_ON_LAUNCHER, (Object)false);
            }
        }
        if (this.controlSession == null) {
            this.controlSession = new ControlSession((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20182_(), player.m_146908_(), player.m_146909_(), player.f_8941_.m_9290_());
            this.spawnAvatar(player);
        }
        if (!this.remoteInitialized) {
            this.ensureFlightAltitude();
            double launchSpeed = Math.min(68.61089999999999, 55.5);
            this.linearVelocity = this.forwardGroundVector().m_82490_(launchSpeed);
            this.setThrust(1.0f);
            this.engineOutput = 1.0;
            this.remoteInitialized = true;
            this.bodyPitch = -10.0;
            this.m_146926_((float)this.bodyPitch);
        }
        this.controllingPlayer = player.m_20148_();
        this.bindPlayerToDrone(player);
        player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this));
        this.cameraPinned = true;
        return true;
    }

    public void endRemoteControl(ServerPlayer player) {
        if (this.controlSession == null) {
            player.m_143403_(GameType.SURVIVAL);
            player.m_6842_(false);
            player.m_20225_(false);
            player.m_20242_(false);
            player.f_19794_ = false;
            this.removeAvatar();
            return;
        }
        if (this.controllingPlayer != null && !this.controllingPlayer.equals(player.m_20148_())) {
            return;
        }
        this.forceReturnCamera(player);
        this.restorePlayer(player);
        this.controllingPlayer = null;
        this.controlSession = null;
        this.removeAvatar();
        this.cameraPinned = false;
    }

    private void bindPlayerToDrone(ServerPlayer player) {
        player.m_6842_(true);
        player.m_20225_(true);
        player.m_20242_(true);
        player.f_19794_ = true;
        player.m_20256_(Vec3.f_82478_);
        if (this.controlSession != null && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            player.m_143403_(GameType.SPECTATOR);
        }
        if (player.m_9236_() != this.m_9236_()) {
            player.m_8999_((ServerLevel)this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
        player.m_6885_();
    }

    private void restorePlayer(ServerPlayer player) {
        if (this.controlSession == null) {
            player.m_143403_(GameType.SURVIVAL);
            player.m_6842_(false);
            player.m_20225_(false);
            player.m_20242_(false);
            player.f_19794_ = false;
            return;
        }
        ServerLevel originLevel = player.m_20194_().m_129880_(this.controlSession.originDimension);
        if (originLevel == null) {
            originLevel = (ServerLevel)this.m_9236_();
        }
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)this.controlSession.originPos));
        originLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)player.m_19879_());
        player.m_8999_(originLevel, this.controlSession.originPos.f_82479_, this.controlSession.originPos.f_82480_, this.controlSession.originPos.f_82481_, this.controlSession.originYaw, this.controlSession.originPitch);
        player.m_6842_(false);
        player.m_20225_(false);
        player.m_20242_(false);
        player.f_19794_ = false;
        player.m_20256_(Vec3.f_82478_);
        if (this.controlSession.originalGameType != null) {
            player.m_143403_(this.controlSession.originalGameType);
        } else {
            player.m_143403_(GameType.SURVIVAL);
        }
        player.m_6885_();
        this.removeAvatar();
    }

    private void spawnAvatar(ServerPlayer player) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (this.controlSession != null) break block3;
            }
            return;
        }
        this.removeAvatar();
        GameProfile profile = new GameProfile(UUID.randomUUID(), player.m_36316_().getName());
        player.m_36316_().getProperties().forEach((name, prop) -> profile.getProperties().put(name, (Object)new Property(prop.getName(), prop.getValue(), prop.getSignature())));
        this.avatar = new RemotePilotFakePlayer(serverLevel, profile, player.m_20148_());
        this.avatar.syncFrom(player);
        this.avatar.m_6034_(this.controlSession.originPos.f_82479_, this.controlSession.originPos.f_82480_, this.controlSession.originPos.f_82481_);
        this.avatar.m_146922_(this.controlSession.originYaw);
        this.avatar.m_146926_(this.controlSession.originPitch);
        this.avatar.f_20885_ = this.controlSession.originYaw;
        this.avatar.f_20883_ = this.controlSession.originYaw;
        this.avatar.m_20256_(Vec3.f_82478_);
        this.avatar.m_6593_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " [UAV]")));
        this.avatar.m_20340_(true);
        this.broadcastAvatarInfo(true);
        serverLevel.m_7967_((Entity)this.avatar);
    }

    private void syncAvatar(ServerPlayer player) {
        if (this.avatar == null || this.avatar.m_213877_()) {
            this.spawnAvatar(player);
        } else {
            this.avatar.syncEquipment(player);
        }
    }

    private void removeAvatar() {
        if (this.avatar != null) {
            this.broadcastAvatarInfo(false);
            this.avatar.m_146870_();
            this.avatar = null;
        }
    }

    private void dbg(ServerPlayer p, String msg) {
        if (p != null) {
            p.m_5661_((Component)Component.m_237113_((String)("[SHAHED] " + msg)), true);
        }
    }

    private void releaseCameraFor(ServerPlayer player) {
        this.cameraPinned = false;
        this.forceReturnCamera(player);
    }

    private boolean isSignalLostFor(ServerPlayer p) {
        return p == null || Math.sqrt(p.m_20280_((Entity)this)) > 10000.0;
    }

    private void forceReturnCamera(ServerPlayer player) {
        if (player == null || player.f_8906_ == null) {
            LOG.warn("[DRONE {}] forceReturnCamera: player or connection null", (Object)this.m_20149_());
            return;
        }
        player.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)player));
    }

    private void broadcastAvatarInfo(boolean add) {
        Level level;
        if (this.avatar == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (add) {
            packet = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)this.avatar);
            for (ServerPlayer viewer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                viewer.f_8906_.m_9829_((Packet)packet);
            }
        } else {
            packet = new ClientboundPlayerInfoRemovePacket(List.of(this.avatar.m_20148_()));
            for (ServerPlayer viewer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                viewer.f_8906_.m_9829_((Packet)packet);
            }
        }
    }

    private static double approach(double current, double target, double maxStep) {
        double delta = Mth.m_14008_((double)(target - current), (double)(-maxStep), (double)maxStep);
        return current + delta;
    }

    private record FlightTelemetry(float airSpeed, float groundSpeed, float verticalSpeed, float angleOfAttack, float slipAngle, float throttle, float fuelKg, float airDensity) {
        static final FlightTelemetry ZERO = new FlightTelemetry(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private static final class RemotePilotFakePlayer
    extends FakePlayer {
        private final UUID ownerId;
        private boolean forwardingDamage;

        private RemotePilotFakePlayer(ServerLevel level, GameProfile profile, UUID ownerId) {
            super(level, profile);
            this.ownerId = ownerId;
            this.m_20242_(true);
            this.f_19794_ = true;
        }

        private void syncFrom(ServerPlayer player) {
            this.syncEquipment(player);
            this.m_21153_(player.m_21223_());
            this.m_36324_().m_38705_(player.m_36324_().m_38702_());
            this.m_36324_().m_38717_(player.m_36324_().m_38722_());
            this.m_21219_();
            player.m_21220_().forEach(effect -> this.m_7292_(new MobEffectInstance(effect)));
        }

        private void syncEquipment(ServerPlayer player) {
            for (int i = 0; i < this.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                this.m_150109_().m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            }
            EquipmentSlot[] equipmentSlotArray = EquipmentSlot.values();
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot slot;
                ItemStack stack = player.m_6844_(slot = equipmentSlotArray[i]);
                this.m_8061_(slot, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            }
        }

        public boolean m_6469_(DamageSource source, float amount) {
            if (!this.forwardingDamage) {
                this.forwardingDamage = true;
                ServerPlayer owner = this.getOwner();
                if (owner != null && !owner.m_21224_()) {
                    owner.m_6469_(source, amount);
                }
                this.forwardingDamage = false;
            }
            return super.m_6469_(source, amount);
        }

        public void m_6667_(DamageSource source) {
            ServerPlayer owner = this.getOwner();
            if (owner != null && !owner.m_21224_()) {
                owner.m_6667_(source);
            }
            super.m_6667_(source);
        }

        private ServerPlayer getOwner() {
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7654_().m_6846_().m_11259_(this.ownerId);
        }
    }

    private static final class ControlSession {
        final ResourceKey<Level> originDimension;
        final Vec3 originPos;
        final float originYaw;
        final float originPitch;
        final GameType originalGameType;

        private ControlSession(ResourceKey<Level> originDimension, Vec3 originPos, float originYaw, float originPitch, GameType originalGameType) {
            this.originDimension = originDimension;
            this.originPos = originPos;
            this.originYaw = originYaw;
            this.originPitch = originPitch;
            this.originalGameType = originalGameType;
        }
    }

    private record OrientationBasis(Vec3 forward, Vec3 up, Vec3 right) {
    }
}

