/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.entity;

import com.fullfud.fullfud.common.entity.ShahedColor;
import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.common.item.MonitorItem;
import com.fullfud.fullfud.core.FullfudRegistries;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShahedLauncherEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int storedDroneId = -1;
    private UUID storedDroneUuid;

    public ShahedLauncherEntity(EntityType<? extends ShahedLauncherEntity> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("StoredDrone")) {
            this.storedDroneUuid = tag.m_128342_("StoredDrone");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.storedDroneUuid != null) {
            tag.m_128362_("StoredDrone", this.storedDroneUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(Vec3.f_82478_);
        this.resolveStoredDrone();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (held.m_150930_((Item)FullfudRegistries.SHAHED_ITEM.get()) || held.m_150930_((Item)FullfudRegistries.SHAHED_BLACK_ITEM.get())) {
            if (this.hasDrone()) {
                return InteractionResult.FAIL;
            }
            ShahedColor color = held.m_150930_((Item)FullfudRegistries.SHAHED_BLACK_ITEM.get()) ? ShahedColor.BLACK : ShahedColor.WHITE;
            ShahedDroneEntity drone = (ShahedDroneEntity)((EntityType)FullfudRegistries.SHAHED_ENTITY.get()).m_20615_((Level)serverLevel);
            if (drone == null) {
                return InteractionResult.PASS;
            }
            drone.setColor(color);
            drone.mountLauncher(this);
            serverLevel.m_7967_((Entity)drone);
            this.setStoredDrone(drone);
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (held.m_41720_() instanceof MonitorItem) {
            if (!this.hasDrone()) {
                return InteractionResult.FAIL;
            }
            this.launchStoredDrone(player, held);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_6144_() && held.m_41619_() && this.hasDrone()) {
            this.ejectStoredDrone(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || !this.m_6084_()) {
            return false;
        }
        this.dropStoredDroneAsItem();
        this.dropSelf();
        this.m_146870_();
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.dropStoredDroneAsItem();
        super.m_142687_(reason);
    }

    private boolean hasDrone() {
        return this.getStoredDrone() != null;
    }

    private void resolveStoredDrone() {
        Level level;
        if (this.storedDroneId > 0) {
            return;
        }
        if (this.storedDroneUuid == null || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = serverLevel.m_8791_(this.storedDroneUuid);
        if (entity instanceof ShahedDroneEntity) {
            ShahedDroneEntity drone = (ShahedDroneEntity)entity;
            this.storedDroneId = drone.m_19879_();
        } else {
            this.storedDroneUuid = null;
        }
    }

    private ShahedDroneEntity getStoredDrone() {
        Object drone;
        if (this.storedDroneId > 0) {
            Entity entity = this.m_9236_().m_6815_(this.storedDroneId);
            if (entity instanceof ShahedDroneEntity && ((ShahedDroneEntity)((Object)(drone = (ShahedDroneEntity)entity))).isOnLauncher() && ((ShahedDroneEntity)((Object)drone)).getLauncherUuid() != null && ((ShahedDroneEntity)((Object)drone)).getLauncherUuid().equals(this.m_20148_())) {
                return drone;
            }
            this.storedDroneId = -1;
        }
        if (this.storedDroneUuid != null && (drone = this.m_9236_()) instanceof ServerLevel) {
            ShahedDroneEntity drone2;
            ServerLevel serverLevel = (ServerLevel)drone;
            Entity entity = serverLevel.m_8791_(this.storedDroneUuid);
            if (entity instanceof ShahedDroneEntity && (drone2 = (ShahedDroneEntity)entity).isOnLauncher() && drone2.getLauncherUuid() != null && drone2.getLauncherUuid().equals(this.m_20148_())) {
                this.storedDroneId = drone2.m_19879_();
                return drone2;
            }
            this.storedDroneUuid = null;
        }
        return null;
    }

    private void setStoredDrone(ShahedDroneEntity drone) {
        this.storedDroneId = drone.m_19879_();
        this.storedDroneUuid = drone.m_20148_();
    }

    private void clearStoredDrone() {
        this.storedDroneId = -1;
        this.storedDroneUuid = null;
    }

    private void launchStoredDrone(Player player, ItemStack monitorStack) {
        ShahedDroneEntity drone = this.getStoredDrone();
        if (drone == null) {
            return;
        }
        drone.launchFromLauncher(this);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            drone.assignOwner(serverPlayer);
        }
        MonitorItem.setLinkedDrone(monitorStack, drone.m_20148_());
        player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.monitor.linked"), true);
        this.clearStoredDrone();
    }

    private void ejectStoredDrone(Player player) {
        ShahedDroneEntity drone = this.getStoredDrone();
        if (drone == null) {
            return;
        }
        ItemStack stack = new ItemStack(drone.getColor() == ShahedColor.BLACK ? (ItemLike)FullfudRegistries.SHAHED_BLACK_ITEM.get() : (ItemLike)FullfudRegistries.SHAHED_ITEM.get());
        if (!player.m_36356_(stack)) {
            this.m_19983_(stack);
        }
        drone.m_146870_();
        this.clearStoredDrone();
    }

    private void dropStoredDroneAsItem() {
        ShahedDroneEntity drone = this.getStoredDrone();
        if (drone == null) {
            return;
        }
        ItemStack stack = new ItemStack(drone.getColor() == ShahedColor.BLACK ? (ItemLike)FullfudRegistries.SHAHED_BLACK_ITEM.get() : (ItemLike)FullfudRegistries.SHAHED_ITEM.get());
        this.m_19983_(stack);
        drone.m_146870_();
        this.clearStoredDrone();
    }

    private void dropSelf() {
        this.m_19983_(new ItemStack((ItemLike)FullfudRegistries.SHAHED_LAUNCHER_ITEM.get()));
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }
}

