/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.item;

import com.fullfud.fullfud.client.render.FpvControllerRenderer;
import com.fullfud.fullfud.common.entity.FpvDroneEntity;
import com.fullfud.fullfud.common.item.FpvGogglesItem;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FpvControllerItem
extends Item
implements GeoItem {
    private static final String LINK_TAG = "LinkedFpvDrone";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FpvControllerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        FpvDroneEntity drone;
        ItemStack stack = player.m_21120_(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.m_6144_()) {
            FpvControllerItem.clearLink(stack);
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.fpv.link_cleared"), true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        Optional<UUID> linked = FpvControllerItem.getLinked(stack);
        if (linked.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.fpv.no_link"), true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        ServerLevel serverLevel = serverPlayer.m_284548_();
        Entity entity = serverLevel.m_8791_(linked.get());
        if (!(entity instanceof FpvDroneEntity) || (drone = (FpvDroneEntity)entity).m_213877_()) {
            FpvControllerItem.clearLink(stack);
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.fpv.drone_missing"), true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        drone.beginControl(serverPlayer);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public void link(ItemStack stack, FpvDroneEntity drone, Player player) {
        FpvControllerItem.setLinked(stack, drone.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            drone.setOwner(serverPlayer);
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.fpv.linked"), true);
        FpvControllerItem.linkGoggles(player, drone.m_20148_());
    }

    public static Optional<UUID> getLinked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128403_(LINK_TAG)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128342_(LINK_TAG));
    }

    public static void setLinked(ItemStack stack, UUID id) {
        stack.m_41784_().m_128362_(LINK_TAG, id);
    }

    public static void clearLink(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(LINK_TAG);
        }
    }

    private static void linkGoggles(Player player, UUID id) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (head.m_41720_() instanceof FpvGogglesItem) {
            FpvGogglesItem.setLinked(head, id);
            return;
        }
        for (ItemStack stack : player.m_6167_()) {
            if (!(stack.m_41720_() instanceof FpvGogglesItem)) continue;
            FpvGogglesItem.setLinked(stack, id);
            return;
        }
        if (player.m_150109_() != null) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof FpvGogglesItem)) continue;
                FpvGogglesItem.setLinked(stack, id);
                return;
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private FpvControllerRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new FpvControllerRenderer();
                }
                return this.renderer;
            }
        });
    }
}

