/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.item;

import com.fullfud.fullfud.client.render.MonitorRenderer;
import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.common.menu.ShahedMonitorMenu;
import com.fullfud.fullfud.core.data.ShahedLinkData;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MonitorItem
extends Item
implements GeoItem {
    private static final String DRONE_TAG = "LinkedShahed";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MonitorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Optional<UUID> linkedDrone = MonitorItem.getLinkedDrone(stack);
        if (linkedDrone.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.monitor.no_link"), true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        UUID droneId = linkedDrone.get();
        ServerLevel serverLevel = serverPlayer.m_284548_();
        ShahedDroneEntity.find(serverLevel, droneId).ifPresentOrElse(drone -> {
            drone.assignOwner(serverPlayer);
            drone.addViewer(serverPlayer);
            if (!drone.beginRemoteControl(serverPlayer)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.monitor.in_use"), true);
                return;
            }
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inv, ply) -> new ShahedMonitorMenu(containerId, inv, droneId, drone.m_19879_()), (Component)Component.m_237115_((String)"menu.fullfud.shahed_monitor")), buf -> {
                buf.m_130077_(droneId);
                buf.writeInt(drone.m_19879_());
            });
        }, () -> {
            ShahedLinkData.get(serverLevel).unlink(droneId);
            MonitorItem.clearLinkedDrone(stack);
            player.m_5661_((Component)Component.m_237115_((String)"message.fullfud.monitor.drone_missing"), true);
        });
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public static Optional<UUID> getLinkedDrone(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128403_(DRONE_TAG)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128342_(DRONE_TAG));
    }

    public static void setLinkedDrone(ItemStack stack, UUID droneId) {
        stack.m_41784_().m_128362_(DRONE_TAG, droneId);
    }

    public static void clearLinkedDrone(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(DRONE_TAG);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MonitorRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MonitorRenderer();
                }
                return this.renderer;
            }
        });
    }
}

