/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.common.menu;

import com.fullfud.fullfud.common.entity.ShahedDroneEntity;
import com.fullfud.fullfud.core.FullfudRegistries;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ShahedMonitorMenu
extends AbstractContainerMenu {
    private final UUID droneId;
    private final int droneEntityId;

    public ShahedMonitorMenu(int containerId, Inventory inventory, FriendlyByteBuf buffer) {
        this(containerId, inventory, ShahedMonitorMenu.readDroneUuid(buffer), ShahedMonitorMenu.readDroneEntityId(buffer));
    }

    public ShahedMonitorMenu(int containerId, Inventory inventory, UUID droneId, int droneEntityId) {
        super((MenuType)FullfudRegistries.SHAHED_MONITOR_MENU.get(), containerId);
        this.droneId = droneId;
        this.droneEntityId = droneEntityId;
    }

    public UUID getDroneId() {
        return this.droneId;
    }

    public int getDroneEntityId() {
        return this.droneEntityId;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        ServerPlayer serverPlayer;
        block3: {
            block2: {
                super.m_6877_(player);
                if (!(player instanceof ServerPlayer)) break block2;
                serverPlayer = (ServerPlayer)player;
                if (this.droneId != null) break block3;
            }
            return;
        }
        ServerLevel level = serverPlayer.m_284548_();
        ShahedDroneEntity.find(level, this.droneId).ifPresent(drone -> {
            drone.removeViewer(serverPlayer);
            drone.endRemoteControl(serverPlayer);
        });
    }

    private static UUID readDroneUuid(FriendlyByteBuf buffer) {
        if (buffer == null || buffer.readableBytes() < 16) {
            return null;
        }
        return buffer.m_130259_();
    }

    private static int readDroneEntityId(FriendlyByteBuf buffer) {
        if (buffer == null || buffer.readableBytes() < 4) {
            return -1;
        }
        return buffer.readInt();
    }
}

