/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.core.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class ShahedLinkData
extends SavedData {
    private static final String DATA_NAME = "fullfud_shahed_links";
    private final Map<UUID, UUID> droneOwners = new HashMap<UUID, UUID>();

    public ShahedLinkData() {
    }

    public ShahedLinkData(CompoundTag tag) {
        ListTag list = tag.m_128437_("Links", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            if (!entry.m_128403_("Drone") || !entry.m_128403_("Owner")) continue;
            this.droneOwners.put(entry.m_128342_("Drone"), entry.m_128342_("Owner"));
        }
    }

    public static ShahedLinkData get(ServerLevel level) {
        return (ShahedLinkData)level.m_8895_().m_164861_(ShahedLinkData::new, ShahedLinkData::new, DATA_NAME);
    }

    public void link(UUID droneId, UUID ownerId) {
        this.droneOwners.put(droneId, ownerId);
        this.m_77762_();
    }

    public void unlink(UUID droneId) {
        if (this.droneOwners.remove(droneId) != null) {
            this.m_77762_();
        }
    }

    public Optional<UUID> owner(UUID droneId) {
        return Optional.ofNullable(this.droneOwners.get(droneId));
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, UUID> entry : this.droneOwners.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("Drone", entry.getKey());
            entryTag.m_128362_("Owner", entry.getValue());
            list.add((Object)entryTag);
        }
        tag.m_128365_("Links", (Tag)list);
        return tag;
    }
}

