/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.core.network;

import com.fullfud.fullfud.core.network.packet.FpvControlPacket;
import com.fullfud.fullfud.core.network.packet.FpvReleasePacket;
import com.fullfud.fullfud.core.network.packet.ShahedControlPacket;
import com.fullfud.fullfud.core.network.packet.ShahedLinkPacket;
import com.fullfud.fullfud.core.network.packet.ShahedStatusPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class FullfudNetwork {
    private static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel channel;
    private static int packetId;

    private FullfudNetwork() {
    }

    public static void init() {
        if (channel != null) {
            return;
        }
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("fullfud", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        FullfudNetwork.registerPackets();
    }

    public static SimpleChannel getChannel() {
        if (channel == null) {
            throw new IllegalStateException("Network channel accessed before initialization");
        }
        return channel;
    }

    private static void registerPackets() {
        channel.registerMessage(FullfudNetwork.nextId(), ShahedControlPacket.class, ShahedControlPacket::encode, ShahedControlPacket::decode, ShahedControlPacket::handle);
        channel.registerMessage(FullfudNetwork.nextId(), ShahedStatusPacket.class, ShahedStatusPacket::encode, ShahedStatusPacket::decode, ShahedStatusPacket::handle);
        channel.registerMessage(FullfudNetwork.nextId(), ShahedLinkPacket.class, ShahedLinkPacket::encode, ShahedLinkPacket::decode, ShahedLinkPacket::handle);
        channel.registerMessage(FullfudNetwork.nextId(), FpvControlPacket.class, FpvControlPacket::encode, FpvControlPacket::decode, FpvControlPacket::handle);
        channel.registerMessage(FullfudNetwork.nextId(), FpvReleasePacket.class, FpvReleasePacket::encode, FpvReleasePacket::decode, FpvReleasePacket::handle);
    }

    private static int nextId() {
        return packetId++;
    }

    static {
        packetId = 0;
    }
}

