/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.core.network.packet;

import com.fullfud.fullfud.core.network.handler.FpvNetworkHandlers;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record FpvControlPacket(UUID droneId, float pitchInput, float rollInput, float yawInput, float throttle, byte armAction) {
    public static FpvControlPacket decode(FriendlyByteBuf buffer) {
        UUID droneId = buffer.m_130259_();
        float pitch = buffer.readFloat();
        float roll = buffer.readFloat();
        float yaw = buffer.readFloat();
        float throttle = buffer.readFloat();
        byte arm = buffer.readByte();
        return new FpvControlPacket(droneId, pitch, roll, yaw, throttle, arm);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.droneId);
        buffer.writeFloat(this.pitchInput);
        buffer.writeFloat(this.rollInput);
        buffer.writeFloat(this.yawInput);
        buffer.writeFloat(this.throttle);
        buffer.writeByte((int)this.armAction);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> FpvNetworkHandlers.handleControl(this, context.getSender()));
        context.setPacketHandled(true);
    }
}

