/*
 * Decompiled with CFR 0.152.
 */
package com.fullfud.fullfud.core.network.packet;

import com.fullfud.fullfud.core.network.handler.ShahedNetworkHandlers;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ShahedStatusPacket(UUID droneId, double x, double y, double z, float yaw, float pitch, float thrust, float noiseLevel, boolean signalLost, float airSpeed, float groundSpeed, float verticalSpeed, float angleOfAttack, float slipAngle, float fuelKg, float airDensity) {
    public static ShahedStatusPacket decode(FriendlyByteBuf buffer) {
        UUID droneId = buffer.m_130259_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        float yaw = buffer.readFloat();
        float pitch = buffer.readFloat();
        float thrust = buffer.readFloat();
        float noise = buffer.readFloat();
        boolean signalLost = buffer.readBoolean();
        float airSpeed = buffer.readFloat();
        float groundSpeed = buffer.readFloat();
        float verticalSpeed = buffer.readFloat();
        float angleOfAttack = buffer.readFloat();
        float slipAngle = buffer.readFloat();
        float fuelKg = buffer.readFloat();
        float airDensity = buffer.readFloat();
        return new ShahedStatusPacket(droneId, x, y, z, yaw, pitch, thrust, noise, signalLost, airSpeed, groundSpeed, verticalSpeed, angleOfAttack, slipAngle, fuelKg, airDensity);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.droneId);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.thrust);
        buffer.writeFloat(this.noiseLevel);
        buffer.writeBoolean(this.signalLost);
        buffer.writeFloat(this.airSpeed);
        buffer.writeFloat(this.groundSpeed);
        buffer.writeFloat(this.verticalSpeed);
        buffer.writeFloat(this.angleOfAttack);
        buffer.writeFloat(this.slipAngle);
        buffer.writeFloat(this.fuelKg);
        buffer.writeFloat(this.airDensity);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ShahedNetworkHandlers.handleStatus(this));
        context.setPacketHandled(true);
    }
}

