/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ridiculousweapons.client.particle;

import net.mcreator.ridiculousweapons.procedures.CactusParticleAdditionalParticleExpiryConditionProcedure;
import net.mcreator.ridiculousweapons.procedures.CactusParticleParticleVisualScaleProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CactusParticleParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static CactusParticleParticleProvider provider(SpriteSet spriteSet) {
        return new CactusParticleParticleProvider(spriteSet);
    }

    protected CactusParticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.2f, 0.2f);
        this.lifetime = Math.max(1, 70 + (this.random.nextInt(60) - 30));
        this.gravity = 0.8f;
        this.hasPhysics = true;
        this.xd = vx * 1.0;
        this.yd = vy * 1.0;
        this.zd = vz * 1.0;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scale) {
        ClientLevel world = this.level;
        return super.getQuadSize(scale) * (float)CactusParticleParticleVisualScaleProcedure.execute(this.age);
    }

    public void tick() {
        super.tick();
        ClientLevel world = this.level;
        if (CactusParticleAdditionalParticleExpiryConditionProcedure.execute((LevelAccessor)world, this.x, this.y, this.z, this.onGround)) {
            this.remove();
        }
    }

    public static class CactusParticleParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public CactusParticleParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CactusParticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

