/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ridiculousweapons.client.particle;

import net.mcreator.ridiculousweapons.procedures.CookieParticleAdditionalParticleExpiryConditionProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CookieParticleParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static CookieParticleParticleProvider provider(SpriteSet spriteSet) {
        return new CookieParticleParticleProvider(spriteSet);
    }

    protected CookieParticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.2f, 0.2f);
        this.quadSize *= 2.0f;
        this.lifetime = Math.max(1, 70 + (this.random.nextInt(60) - 30));
        this.gravity = 0.2f;
        this.hasPhysics = true;
        this.xd = vx * 1.0;
        this.yd = vy * 1.0;
        this.zd = vz * 1.0;
        this.setSpriteFromAge(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        ClientLevel world;
        super.tick();
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(this.age / 1 % 28 + 1, 28));
        }
        if (CookieParticleAdditionalParticleExpiryConditionProcedure.execute((LevelAccessor)(world = this.level), this.x, this.y, this.z, this.onGround)) {
            this.remove();
        }
    }

    public static class CookieParticleParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public CookieParticleParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CookieParticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

