/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ridiculousweapons.client.particle;

import net.mcreator.ridiculousweapons.procedures.ThrowingUpParticleAdditionalParticleExpiryConditionProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ThrowingUpParticleParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static ThrowingUpParticleParticleProvider provider(SpriteSet spriteSet) {
        return new ThrowingUpParticleParticleProvider(spriteSet);
    }

    protected ThrowingUpParticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.2f, 0.2f);
        this.quadSize *= 0.5f;
        this.lifetime = 31;
        this.gravity = 1.0f;
        this.hasPhysics = true;
        this.xd = vx * 0.5;
        this.yd = vy * 0.5;
        this.zd = vz * 0.5;
        this.setSpriteFromAge(spriteSet);
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        ClientLevel world;
        super.tick();
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(this.age / 2 % 16 + 1, 16));
        }
        if (ThrowingUpParticleAdditionalParticleExpiryConditionProcedure.execute((LevelAccessor)(world = this.level), this.x, this.y, this.z, this.onGround)) {
            this.remove();
        }
    }

    public static class ThrowingUpParticleParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public ThrowingUpParticleParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ThrowingUpParticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

