/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.block;

import com.bobotweaks.betterfurnacesandchests.block.entity.CustomChestBlockEntity;
import com.bobotweaks.betterfurnacesandchests.config.ModConfig;
import com.bobotweaks.betterfurnacesandchests.init.ModBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CustomChestBlock
extends class_2237 {
    public static final MapCodec<CustomChestBlock> CODEC = CustomChestBlock.method_54094(CustomChestBlock::new);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    public MapCodec<? extends CustomChestBlock> method_53969() {
        return CODEC;
    }

    public CustomChestBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CustomChestBlockEntity(pos, state);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_3908 screenHandlerFactory;
        if (!world.method_8608() && (screenHandlerFactory = state.method_26196(world, pos)) != null) {
            player.method_17355(screenHandlerFactory);
        }
        return class_1269.field_5812;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.method_8608()) {
            return CustomChestBlockEntity::clientTick;
        }
        return null;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CustomChestBlockEntity) {
            ((CustomChestBlockEntity)blockEntity).onScheduledTick();
        }
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        if (!state.method_27852(world.method_8320(pos).method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CustomChestBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((CustomChestBlockEntity)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_66388(state, world, pos, moved);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        if (!world.method_8608()) {
            boolean requiresAxe = false;
            int requiredTier = 0;
            class_2248 block = state.method_26204();
            if (block == ModBlocks.IRON_CHEST) {
                requiresAxe = ModConfig.IRON_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.IRON_CHEST_AXE_TIER;
            } else if (block == ModBlocks.GOLD_CHEST) {
                requiresAxe = ModConfig.GOLD_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.GOLD_CHEST_AXE_TIER;
            } else if (block == ModBlocks.DIAMOND_CHEST) {
                requiresAxe = ModConfig.DIAMOND_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.DIAMOND_CHEST_AXE_TIER;
            } else if (block == ModBlocks.NETHERITE_CHEST) {
                requiresAxe = ModConfig.NETHERITE_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.NETHERITE_CHEST_AXE_TIER;
            }
            boolean canHarvest = true;
            if (requiresAxe) {
                boolean isAxe = stack.method_31573(class_3489.field_42612);
                int heldTier = this.getToolTier(stack);
                if (!isAxe || heldTier < requiredTier) {
                    canHarvest = false;
                }
            }
            if (canHarvest && !player.method_68878()) {
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this));
            }
        }
    }

    private int getToolTier(class_1799 stack) {
        if (stack.method_31573(class_3489.field_52387)) {
            return 4;
        }
        if (stack.method_31573(class_3489.field_52386)) {
            return 3;
        }
        if (stack.method_31573(class_3489.field_52382)) {
            return 2;
        }
        if (stack.method_31573(class_3489.field_23802)) {
            return 1;
        }
        if (stack.method_31573(class_3489.field_61216)) {
            return 1;
        }
        if (stack.method_31573(class_3489.field_52381)) {
            return 0;
        }
        if (stack.method_31573(class_3489.field_52385)) {
            return 0;
        }
        return 0;
    }

    public float method_36555() {
        if (this == ModBlocks.IRON_CHEST) {
            return ModConfig.IRON_CHEST_HARDNESS;
        }
        if (this == ModBlocks.GOLD_CHEST) {
            return ModConfig.GOLD_CHEST_HARDNESS;
        }
        if (this == ModBlocks.DIAMOND_CHEST) {
            return ModConfig.DIAMOND_CHEST_HARDNESS;
        }
        if (this == ModBlocks.NETHERITE_CHEST) {
            return ModConfig.NETHERITE_CHEST_HARDNESS;
        }
        return super.method_36555();
    }

    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float hardness = this.method_36555();
        if (hardness == -1.0f) {
            return 0.0f;
        }
        boolean requiresAxe = false;
        int requiredTier = 0;
        class_2248 block = state.method_26204();
        if (block == ModBlocks.IRON_CHEST) {
            requiresAxe = ModConfig.IRON_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.IRON_CHEST_AXE_TIER;
        } else if (block == ModBlocks.GOLD_CHEST) {
            requiresAxe = ModConfig.GOLD_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.GOLD_CHEST_AXE_TIER;
        } else if (block == ModBlocks.DIAMOND_CHEST) {
            requiresAxe = ModConfig.DIAMOND_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.DIAMOND_CHEST_AXE_TIER;
        } else if (block == ModBlocks.NETHERITE_CHEST) {
            requiresAxe = ModConfig.NETHERITE_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.NETHERITE_CHEST_AXE_TIER;
        }
        boolean canHarvest = true;
        if (requiresAxe) {
            class_1799 stack = player.method_6047();
            boolean isAxe = stack.method_31573(class_3489.field_42612);
            int heldTier = this.getToolTier(stack);
            if (!isAxe || heldTier < requiredTier) {
                canHarvest = false;
            }
        }
        float speed = player.method_7351(state);
        int i = canHarvest ? 30 : 100;
        return speed / hardness / (float)i;
    }
}

