/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.network;

import com.bobotweaks.betterfurnacesandchests.network.ChestActionPayload;
import com.bobotweaks.betterfurnacesandchests.screen.CustomChestScreenHandler;
import java.util.ArrayList;
import java.util.Comparator;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ModNetwork {
    public static void register() {
        PayloadTypeRegistry.playC2S().register(ChestActionPayload.ID, ChestActionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ChestActionPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 handler = player.field_7512;
            if (handler instanceof CustomChestScreenHandler) {
                CustomChestScreenHandler chestHandler = (CustomChestScreenHandler)handler;
                ModNetwork.handleAction(chestHandler, payload.actionType(), player);
            }
        }));
    }

    private static void handleAction(CustomChestScreenHandler handler, int action, class_3222 player) {
        int totalSlots = handler.field_7761.size();
        int chestSlotCount = totalSlots - 36;
        if (chestSlotCount <= 0) {
            return;
        }
        switch (action) {
            case 0: {
                ModNetwork.sortInventory(handler, 0, chestSlotCount);
                break;
            }
            case 1: {
                ModNetwork.stackInventory(handler, 0, chestSlotCount);
                break;
            }
            case 2: {
                ModNetwork.transferToChest(handler, chestSlotCount, totalSlots, 0, chestSlotCount);
                break;
            }
            case 3: {
                ModNetwork.transferToInventory(handler, 0, chestSlotCount, chestSlotCount, totalSlots);
            }
        }
    }

    private static void sortInventory(CustomChestScreenHandler handler, int start, int end) {
        int i;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (i = start; i < end; ++i) {
            class_1799 stack = ((class_1735)handler.field_7761.get(i)).method_7677();
            if (stack.method_7960()) continue;
            stacks.add(stack.method_7972());
            ((class_1735)handler.field_7761.get(i)).method_53512(class_1799.field_8037);
        }
        stacks.sort(Comparator.comparing(s -> s.method_7964().getString()).thenComparingInt(class_1799::method_7947).reversed());
        for (i = 0; i < stacks.size(); ++i) {
            if (start + i >= end) continue;
            ((class_1735)handler.field_7761.get(start + i)).method_53512((class_1799)stacks.get(i));
        }
    }

    private static void stackInventory(CustomChestScreenHandler handler, int start, int end) {
        for (int i = start; i < end; ++i) {
            class_1799 stack = ((class_1735)handler.field_7761.get(i)).method_7677();
            if (stack.method_7960() || stack.method_7947() >= stack.method_7914()) continue;
            for (int j = i + 1; j < end; ++j) {
                class_1799 other = ((class_1735)handler.field_7761.get(j)).method_7677();
                if (!class_1799.method_31577((class_1799)stack, (class_1799)other)) continue;
                int space = stack.method_7914() - stack.method_7947();
                int toMove = Math.min(space, other.method_7947());
                stack.method_7933(toMove);
                other.method_7934(toMove);
                if (other.method_7960()) {
                    ((class_1735)handler.field_7761.get(j)).method_53512(class_1799.field_8037);
                }
                if (stack.method_7947() == stack.method_7914()) break;
            }
            ((class_1735)handler.field_7761.get(i)).method_53512(stack);
        }
    }

    private static void transferToChest(CustomChestScreenHandler handler, int srcStart, int srcEnd, int destStart, int destEnd) {
        for (int i = srcStart; i < srcEnd; ++i) {
            class_1799 stack;
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (i >= srcEnd - 9 || (stack = slot.method_7677()).method_7960()) continue;
            class_1799 remaining = ModNetwork.insertIntoRange(handler, stack, destStart, destEnd);
            slot.method_53512(remaining);
        }
    }

    private static void transferToInventory(CustomChestScreenHandler handler, int srcStart, int srcEnd, int destStart, int destEnd) {
        for (int i = srcStart; i < srcEnd; ++i) {
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            class_1799 stack = slot.method_7677();
            if (stack.method_7960()) continue;
            class_1799 remaining = ModNetwork.insertIntoRange(handler, stack, destStart, destEnd);
            slot.method_53512(remaining);
        }
    }

    private static class_1799 insertIntoRange(CustomChestScreenHandler handler, class_1799 stack, int start, int end) {
        class_1735 slot;
        int i;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        for (i = start; i < end; ++i) {
            int space;
            slot = (class_1735)handler.field_7761.get(i);
            class_1799 existing = slot.method_7677();
            if (!class_1799.method_31577((class_1799)copy, (class_1799)existing) || (space = existing.method_7914() - existing.method_7947()) <= 0) continue;
            int move = Math.min(space, copy.method_7947());
            existing.method_7933(move);
            copy.method_7934(move);
            slot.method_53512(existing);
            if (!copy.method_7960()) continue;
            return class_1799.field_8037;
        }
        for (i = start; i < end; ++i) {
            slot = (class_1735)handler.field_7761.get(i);
            if (slot.method_7681()) continue;
            slot.method_53512(copy.method_7972());
            return class_1799.field_8037;
        }
        return copy;
    }
}

