/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.block;

import com.bobotweaks.betterfurnacesandchests.block.entity.CustomChestBlockEntity;
import com.bobotweaks.betterfurnacesandchests.config.ModConfig;
import com.bobotweaks.betterfurnacesandchests.init.ModBlocks;
import com.bobotweaks.betterfurnacesandchests.mixin.DoubleInventoryAccessor;
import com.bobotweaks.betterfurnacesandchests.network.ChestPayload;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_10225;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CustomChestBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<CustomChestBlock> CODEC = CustomChestBlock.method_54094(CustomChestBlock::new);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2754<class_2745> CHEST_TYPE = class_2741.field_12506;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MapCodec<? extends CustomChestBlock> method_53969() {
        return CODEC;
    }

    public CustomChestBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657(CHEST_TYPE, (Comparable)class_2745.field_12569)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CustomChestBlockEntity(pos, state);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_3908 screenHandlerFactory;
        if (!world.method_8608() && (screenHandlerFactory = this.method_17454(state, world, pos)) != null) {
            player.method_17355(screenHandlerFactory);
        }
        return class_1269.field_5812;
    }

    @Nullable
    protected class_3908 method_17454(final class_2680 state, final class_1937 world, final class_2338 pos) {
        final class_1263 inventory = CustomChestBlock.getInventory(this, state, world, pos, false);
        if (inventory == null) {
            return null;
        }
        return new ExtendedScreenHandlerFactory<ChestPayload>(){

            public ChestPayload getScreenOpeningData(class_3222 player) {
                return new ChestPayload(inventory.method_5439() / 9);
            }

            public class_2561 method_5476() {
                if (inventory instanceof class_1258) {
                    class_1275 nameable;
                    class_1258 di = (class_1258)inventory;
                    DoubleInventoryAccessor accessor = (DoubleInventoryAccessor)di;
                    class_1263 class_12632 = accessor.bfc$getFirst();
                    if (class_12632 instanceof class_1275 && (nameable = (class_1275)class_12632).method_16914()) {
                        return nameable.method_5476();
                    }
                    class_12632 = accessor.bfc$getSecond();
                    if (class_12632 instanceof class_1275 && (nameable = (class_1275)class_12632).method_16914()) {
                        return nameable.method_5476();
                    }
                }
                if (inventory instanceof class_1275) {
                    class_1275 nameable = (class_1275)inventory;
                    return nameable.method_5476();
                }
                return state.method_26204().method_9518();
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                class_2586 be = world.method_8321(pos);
                if (be instanceof CustomChestBlockEntity) {
                    CustomChestBlockEntity chestBe = (CustomChestBlockEntity)be;
                    return chestBe.createScreenHandler(syncId, playerInventory, inventory);
                }
                return null;
            }
        };
    }

    @Nullable
    public static class_1263 getInventory(CustomChestBlock block, class_2680 state, class_1937 world, class_2338 pos, boolean allowBlocked) {
        class_1263 otherInventory;
        class_2745 otherType;
        class_2745 chestType = (class_2745)state.method_11654(CHEST_TYPE);
        if (chestType == class_2745.field_12569) {
            return (class_1263)world.method_8321(pos);
        }
        class_2338 otherPos = pos.method_10093(CustomChestBlock.getDirectionToOther(state));
        class_2680 otherState = world.method_8320(otherPos);
        if (otherState.method_27852((class_2248)block) && (otherType = (class_2745)otherState.method_11654(CHEST_TYPE)) != class_2745.field_12569 && chestType != otherType && state.method_11654(FACING) == otherState.method_11654(FACING) && (otherInventory = (class_1263)world.method_8321(otherPos)) != null) {
            class_1263 currentInventory = (class_1263)world.method_8321(pos);
            return chestType == class_2745.field_12571 ? new class_1258(currentInventory, otherInventory) : new class_1258(otherInventory, currentInventory);
        }
        return (class_1263)world.method_8321(pos);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(CHEST_TYPE) == class_2745.field_12569) {
            return SHAPE;
        }
        class_2350 facing = (class_2350)state.method_11654(FACING);
        class_2745 type = (class_2745)state.method_11654(CHEST_TYPE);
        switch (facing) {
            case field_11043: {
                return type == class_2745.field_12574 ? class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0) : class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
            }
            case field_11035: {
                return type == class_2745.field_12574 ? class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0) : class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
            }
            case field_11039: {
                return type == class_2745.field_12574 ? class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0) : class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
            }
            case field_11034: {
                return type == class_2745.field_12574 ? class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0) : class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
            }
        }
        return SHAPE;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.method_8608()) {
            return CustomChestBlockEntity::clientTick;
        }
        return CustomChestBlockEntity::serverTick;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CustomChestBlockEntity) {
            ((CustomChestBlockEntity)blockEntity).onScheduledTick();
        }
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        if (!state.method_27852(world.method_8320(pos).method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CustomChestBlockEntity) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((CustomChestBlockEntity)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_66388(state, world, pos, moved);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction3;
        class_2745 chestType = class_2745.field_12569;
        class_2350 direction = ctx.method_8042().method_10153();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl = ctx.method_8046();
        class_2350 direction2 = ctx.method_8038();
        if (direction2.method_10166().method_10179() && bl && (direction3 = this.getNeighborChestDirection(ctx.method_8045(), ctx.method_8037(), direction2.method_10153())) != null && direction3.method_10166() != direction2.method_10166()) {
            direction = direction3;
            class_2745 class_27452 = chestType = direction3.method_10160() == direction2.method_10153() ? class_2745.field_12571 : class_2745.field_12574;
        }
        if (chestType == class_2745.field_12569 && !bl) {
            chestType = this.getChestType(ctx.method_8045(), ctx.method_8037(), direction);
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)direction)).method_11657(CHEST_TYPE, (Comparable)chestType)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    protected class_2745 getChestType(class_1937 world, class_2338 pos, class_2350 facing) {
        if (facing == this.getNeighborChestDirection(world, pos, facing.method_10170())) {
            return class_2745.field_12574;
        }
        return facing == this.getNeighborChestDirection(world, pos, facing.method_10160()) ? class_2745.field_12571 : class_2745.field_12569;
    }

    @Nullable
    private class_2350 getNeighborChestDirection(class_1937 world, class_2338 pos, class_2350 neighborOffset) {
        class_2680 blockState = world.method_8320(pos.method_10093(neighborOffset));
        return blockState.method_27852((class_2248)this) && blockState.method_11654(CHEST_TYPE) == class_2745.field_12569 ? (class_2350)blockState.method_11654(FACING) : null;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        if (neighborState.method_27852((class_2248)this) && direction.method_10166().method_10179()) {
            class_2745 neighborType = (class_2745)neighborState.method_11654(CHEST_TYPE);
            class_2350 facing = (class_2350)state.method_11654(FACING);
            if (facing == neighborState.method_11654(FACING) && state.method_11654(CHEST_TYPE) == class_2745.field_12569) {
                if (neighborType != class_2745.field_12569 && CustomChestBlock.getFacing(neighborState) == direction.method_10153()) {
                    return (class_2680)state.method_11657(CHEST_TYPE, (Comparable)neighborType.method_11824());
                }
                if (neighborType == class_2745.field_12569) {
                    if (direction == facing.method_10170()) {
                        return (class_2680)state.method_11657(CHEST_TYPE, (Comparable)class_2745.field_12574);
                    }
                    if (direction == facing.method_10160()) {
                        return (class_2680)state.method_11657(CHEST_TYPE, (Comparable)class_2745.field_12571);
                    }
                }
            }
        } else if (CustomChestBlock.getFacing(state) == direction) {
            return (class_2680)state.method_11657(CHEST_TYPE, (Comparable)class_2745.field_12569);
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        return state.method_11654(CHEST_TYPE) == class_2745.field_12574 ? direction.method_10170() : direction.method_10160();
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    public static class_2350 getDirectionToOther(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        class_2745 chestType = (class_2745)state.method_11654(CHEST_TYPE);
        if (chestType == class_2745.field_12569) {
            return null;
        }
        return chestType == class_2745.field_12574 ? direction.method_10170() : direction.method_10160();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, CHEST_TYPE, WATERLOGGED});
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        if (!world.method_8608()) {
            boolean requiresAxe = false;
            int requiredTier = 0;
            class_2248 block = state.method_26204();
            if (block == ModBlocks.IRON_CHEST) {
                requiresAxe = ModConfig.IRON_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.IRON_CHEST_AXE_TIER;
            } else if (block == ModBlocks.GOLD_CHEST) {
                requiresAxe = ModConfig.GOLD_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.GOLD_CHEST_AXE_TIER;
            } else if (block == ModBlocks.DIAMOND_CHEST) {
                requiresAxe = ModConfig.DIAMOND_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.DIAMOND_CHEST_AXE_TIER;
            } else if (block == ModBlocks.NETHERITE_CHEST) {
                requiresAxe = ModConfig.NETHERITE_CHEST_REQUIRES_AXE;
                requiredTier = ModConfig.NETHERITE_CHEST_AXE_TIER;
            }
            boolean canHarvest = true;
            if (requiresAxe) {
                boolean isAxe = stack.method_31573(class_3489.field_42612);
                int heldTier = this.getToolTier(stack);
                if (!isAxe || heldTier < requiredTier) {
                    canHarvest = false;
                }
            }
            if (canHarvest && !player.method_68878()) {
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this));
            }
        }
    }

    private int getToolTier(class_1799 stack) {
        if (stack.method_31573(class_3489.field_52387)) {
            return 4;
        }
        if (stack.method_31573(class_3489.field_52386)) {
            return 3;
        }
        if (stack.method_31573(class_3489.field_52382)) {
            return 2;
        }
        if (stack.method_31573(class_3489.field_23802)) {
            return 1;
        }
        if (stack.method_31573(class_3489.field_61216)) {
            return 1;
        }
        if (stack.method_31573(class_3489.field_52381)) {
            return 0;
        }
        if (stack.method_31573(class_3489.field_52385)) {
            return 0;
        }
        return 0;
    }

    public float method_36555() {
        if (this == ModBlocks.IRON_CHEST) {
            return ModConfig.IRON_CHEST_HARDNESS;
        }
        if (this == ModBlocks.GOLD_CHEST) {
            return ModConfig.GOLD_CHEST_HARDNESS;
        }
        if (this == ModBlocks.DIAMOND_CHEST) {
            return ModConfig.DIAMOND_CHEST_HARDNESS;
        }
        if (this == ModBlocks.NETHERITE_CHEST) {
            return ModConfig.NETHERITE_CHEST_HARDNESS;
        }
        return super.method_36555();
    }

    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float hardness = this.method_36555();
        if (hardness == -1.0f) {
            return 0.0f;
        }
        boolean requiresAxe = false;
        int requiredTier = 0;
        class_2248 block = state.method_26204();
        if (block == ModBlocks.IRON_CHEST) {
            requiresAxe = ModConfig.IRON_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.IRON_CHEST_AXE_TIER;
        } else if (block == ModBlocks.GOLD_CHEST) {
            requiresAxe = ModConfig.GOLD_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.GOLD_CHEST_AXE_TIER;
        } else if (block == ModBlocks.DIAMOND_CHEST) {
            requiresAxe = ModConfig.DIAMOND_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.DIAMOND_CHEST_AXE_TIER;
        } else if (block == ModBlocks.NETHERITE_CHEST) {
            requiresAxe = ModConfig.NETHERITE_CHEST_REQUIRES_AXE;
            requiredTier = ModConfig.NETHERITE_CHEST_AXE_TIER;
        }
        boolean canHarvest = true;
        if (requiresAxe) {
            class_1799 stack = player.method_6047();
            boolean isAxe = stack.method_31573(class_3489.field_42612);
            int heldTier = this.getToolTier(stack);
            if (!isAxe || heldTier < requiredTier) {
                canHarvest = false;
            }
        }
        float speed = player.method_7351(state);
        int i = canHarvest ? 30 : 100;
        return speed / hardness / (float)i;
    }
}

