/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.client.render;

import com.bobotweaks.betterfurnacesandchests.block.CustomChestBlock;
import com.bobotweaks.betterfurnacesandchests.block.entity.CustomChestBlockEntity;
import com.bobotweaks.betterfurnacesandchests.client.render.ChestModelLoadingPlugin;
import com.bobotweaks.betterfurnacesandchests.client.render.state.CustomChestBlockEntityRenderState;
import com.bobotweaks.betterfurnacesandchests.init.ModBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_310;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class CustomChestBlockEntityRenderer
implements class_827<CustomChestBlockEntity, CustomChestBlockEntityRenderState> {
    private final class_776 blockRenderManager;

    public CustomChestBlockEntityRenderer(class_5614.class_5615 context) {
        this.blockRenderManager = context.comp_4535();
    }

    public CustomChestBlockEntityRenderState createRenderState() {
        return new CustomChestBlockEntityRenderState();
    }

    public void updateRenderState(CustomChestBlockEntity entity, CustomChestBlockEntityRenderState state, float tickDelta, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)entity, (class_11954)state, tickDelta, cameraPos, crumblingOverlay);
        class_2680 blockState = entity.method_11010();
        if (blockState.method_26204() instanceof CustomChestBlock) {
            state.facing = (class_2350)blockState.method_11654(CustomChestBlock.FACING);
            state.lidAnimationProgress = entity.method_11274(tickDelta);
            state.block = blockState.method_26204();
            state.chestType = (class_2745)blockState.method_11654(CustomChestBlock.CHEST_TYPE);
            float rotation = 0.0f;
            switch (state.facing) {
                case field_11035: {
                    rotation = 180.0f;
                    break;
                }
                case field_11039: {
                    rotation = 90.0f;
                    break;
                }
                case field_11034: {
                    rotation = -90.0f;
                    break;
                }
                default: {
                    rotation = 0.0f;
                }
            }
            state.yaw = rotation;
            int light = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016());
            class_2350 direction = CustomChestBlock.getDirectionToOther(blockState);
            if (direction != null) {
                int lightOther = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016().method_10093(direction));
                light = Math.max(light, lightOther);
            }
            state.light = light;
            state.overlay = class_4608.field_21444;
        }
    }

    public void render(CustomChestBlockEntityRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        class_1092 modelManager = class_310.method_1551().method_1554();
        class_2680 blockState = state.facing != null ? ModBlocks.IRON_CHEST.method_9564() : null;
        class_1087 baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_BASE);
        class_1087 lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_LID);
        if (state.block == ModBlocks.IRON_CHEST) {
            switch (state.chestType) {
                case field_12569: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_LID);
                    break;
                }
                case field_12574: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_RIGHT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_RIGHT_LID);
                    break;
                }
                case field_12571: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_LEFT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.IRON_CHEST_LEFT_LID);
                }
            }
        } else if (state.block == ModBlocks.GOLD_CHEST) {
            switch (state.chestType) {
                case field_12569: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_LID);
                    break;
                }
                case field_12574: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_RIGHT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_RIGHT_LID);
                    break;
                }
                case field_12571: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_LEFT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.GOLD_CHEST_LEFT_LID);
                }
            }
        } else if (state.block == ModBlocks.DIAMOND_CHEST) {
            switch (state.chestType) {
                case field_12569: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_LID);
                    break;
                }
                case field_12574: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_RIGHT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_RIGHT_LID);
                    break;
                }
                case field_12571: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_LEFT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.DIAMOND_CHEST_LEFT_LID);
                }
            }
        } else if (state.block == ModBlocks.NETHERITE_CHEST) {
            switch (state.chestType) {
                case field_12569: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_LID);
                    break;
                }
                case field_12574: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_RIGHT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_RIGHT_LID);
                    break;
                }
                case field_12571: {
                    baseModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_LEFT_BASE);
                    lidModel = (class_1087)modelManager.getModel(ChestModelLoadingPlugin.NETHERITE_CHEST_LEFT_LID);
                }
            }
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(state.yaw));
        matrices.method_22904(-0.5, -0.5, -0.5);
        queue.method_73484(matrices, class_12249.method_75972(), baseModel, 1.0f, 1.0f, 1.0f, state.light, state.overlay, 0);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.625, 0.9375);
        float animationProgress = state.lidAnimationProgress;
        animationProgress = 1.0f - (1.0f - animationProgress) * (1.0f - animationProgress) * (1.0f - animationProgress);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(animationProgress * 90.0f));
        matrices.method_22904(-0.5, -0.625, -0.9375);
        queue.method_73484(matrices, class_12249.method_75972(), lidModel, 1.0f, 1.0f, 1.0f, state.light, state.overlay, 0);
        matrices.method_22909();
        if (state.field_62677 != null) {
            class_1921 crumblingLayer = (class_1921)class_1088.field_21772.get(state.field_62677.comp_4656());
            class_1087 finalBaseModel = baseModel;
            class_1087 finalLidModel = lidModel;
            queue.method_73483(matrices, crumblingLayer, (entry, vertexConsumer) -> {
                class_4583 overlayConsumer = new class_4583(vertexConsumer, state.field_62677.comp_4657(), 1.0f);
                class_4587 localMatrices = new class_4587();
                localMatrices.method_23760().method_66521(entry);
                class_778.method_3367((class_4587.class_4665)localMatrices.method_23760(), (class_4588)overlayConsumer, (class_1087)finalBaseModel, (float)1.0f, (float)1.0f, (float)1.0f, (int)state.light, (int)state.overlay);
                localMatrices.method_22903();
                localMatrices.method_22904(0.5, 0.625, 0.9375);
                float anim = state.lidAnimationProgress;
                anim = 1.0f - (1.0f - anim) * (1.0f - anim) * (1.0f - anim);
                localMatrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(anim * 90.0f));
                localMatrices.method_22904(-0.5, -0.625, -0.9375);
                class_778.method_3367((class_4587.class_4665)localMatrices.method_23760(), (class_4588)overlayConsumer, (class_1087)finalLidModel, (float)1.0f, (float)1.0f, (float)1.0f, (int)state.light, (int)state.overlay);
                localMatrices.method_22909();
            });
        }
        matrices.method_22909();
    }
}

