/*
 * Decompiled with CFR 0.152.
 */
package com.bobotweaks.betterfurnacesandchests.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"betterfurnacesandchests");
    public static int IRON_CHEST_ROWS = 5;
    public static float IRON_CHEST_HARDNESS = 1.5f;
    public static boolean IRON_CHEST_REQUIRES_AXE = false;
    public static int IRON_CHEST_AXE_TIER = 0;
    public static int GOLD_CHEST_ROWS = 7;
    public static float GOLD_CHEST_HARDNESS = 1.5f;
    public static boolean GOLD_CHEST_REQUIRES_AXE = false;
    public static int GOLD_CHEST_AXE_TIER = 0;
    public static int DIAMOND_CHEST_ROWS = 9;
    public static float DIAMOND_CHEST_HARDNESS = 1.5f;
    public static boolean DIAMOND_CHEST_REQUIRES_AXE = false;
    public static int DIAMOND_CHEST_AXE_TIER = 0;
    public static int NETHERITE_CHEST_ROWS = 11;
    public static float NETHERITE_CHEST_HARDNESS = 1.5f;
    public static boolean NETHERITE_CHEST_REQUIRES_AXE = false;
    public static int NETHERITE_CHEST_AXE_TIER = 0;
    public static boolean IRON_FURNACE_REQUIRES_PICKAXE = false;
    public static double IRON_FURNACE_SPEED = 2.0;
    public static int IRON_FURNACE_PICKAXE_TIER = 0;
    public static float IRON_FURNACE_HARDNESS = 1.5f;
    public static boolean GOLD_FURNACE_REQUIRES_PICKAXE = false;
    public static double GOLD_FURNACE_SPEED = 3.0;
    public static int GOLD_FURNACE_PICKAXE_TIER = 0;
    public static float GOLD_FURNACE_HARDNESS = 1.5f;
    public static boolean DIAMOND_FURNACE_REQUIRES_PICKAXE = false;
    public static double DIAMOND_FURNACE_SPEED = 4.0;
    public static int DIAMOND_FURNACE_PICKAXE_TIER = 0;
    public static float DIAMOND_FURNACE_HARDNESS = 1.5f;
    public static boolean NETHERITE_FURNACE_REQUIRES_PICKAXE = false;
    public static double NETHERITE_FURNACE_SPEED = 8.0;
    public static int NETHERITE_FURNACE_PICKAXE_TIER = 0;
    public static float NETHERITE_FURNACE_HARDNESS = 1.5f;
    private static final String FILE_NAME = "better-furnaces-and-chests.cfg";
    private static File configFile;

    public static void registerConfigs() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        configFile = new File(configDir, FILE_NAME);
        LOGGER.info("Configuration file path: " + configFile.getAbsolutePath());
        if (!configFile.exists()) {
            ModConfig.saveConfigs(configFile);
        } else {
            ModConfig.loadConfigs(configFile);
        }
    }

    public static void reloadConfigs() {
        if (configFile != null && configFile.exists()) {
            LOGGER.info("Reloading configuration...");
            ModConfig.loadConfigs(configFile);
        }
    }

    private static void saveConfigs(File configFile) {
        try (PrintWriter writer = new PrintWriter(new FileWriter(configFile));){
            writer.println("# ----------------------------------------");
            writer.println("# Better Furnaces & Chests");
            writer.println("# Made by BoboTweaks");
            writer.println("# Curseforge: https://curseforge.com/minecraft/mc-mods/better-furnaces-and-chests");
            writer.println("# Modrinth: https://modrinth.com/mod/better-furnaces-and-chests");
            writer.println("# Wiki: https://github.com/BoboTweaks/Better-Furnaces-and-Chests/wiki/Better-Furnaces-&-Chests-Config");
            writer.println("# ----------------------------------------");
            writer.println();
            writer.println("[Iron Chest]");
            writer.println("ironChest.rows = " + IRON_CHEST_ROWS + "  # Number of rows for iron chest");
            writer.println("ironChest.hardness = " + IRON_CHEST_HARDNESS + "  # Hardness for iron chest");
            writer.println("ironChest.requiresAxe = " + IRON_CHEST_REQUIRES_AXE + "  # Does it need an axe to drop?");
            writer.println("ironChest.axeTier = " + IRON_CHEST_AXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println();
            writer.println("[Gold Chest]");
            writer.println("goldChest.rows = " + GOLD_CHEST_ROWS + "  # Number of rows for gold chest");
            writer.println("goldChest.hardness = " + GOLD_CHEST_HARDNESS + "  # Hardness for gold chest");
            writer.println("goldChest.requiresAxe = " + GOLD_CHEST_REQUIRES_AXE + "  # Does it need an axe to drop?");
            writer.println("goldChest.axeTier = " + GOLD_CHEST_AXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println();
            writer.println("[Diamond Chest]");
            writer.println("diamondChest.rows = " + DIAMOND_CHEST_ROWS + "  # Number of rows for diamond chest");
            writer.println("diamondChest.hardness = " + DIAMOND_CHEST_HARDNESS + "  # Hardness for diamond chest");
            writer.println("diamondChest.requiresAxe = " + DIAMOND_CHEST_REQUIRES_AXE + "  # Does it need an axe to drop?");
            writer.println("diamondChest.axeTier = " + DIAMOND_CHEST_AXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println();
            writer.println("[Netherite Chest]");
            writer.println("netheriteChest.rows = " + NETHERITE_CHEST_ROWS + "  # Number of rows for netherite chest");
            writer.println("netheriteChest.hardness = " + NETHERITE_CHEST_HARDNESS + "  # Hardness for netherite chest");
            writer.println("netheriteChest.requiresAxe = " + NETHERITE_CHEST_REQUIRES_AXE + "  # Does it need an axe to drop?");
            writer.println("netheriteChest.axeTier = " + NETHERITE_CHEST_AXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println();
            writer.println("[Iron Furnace]");
            writer.println("ironFurnace.speed = " + IRON_FURNACE_SPEED + "  # Efficiency multiplier (2.0 = 2x faster)");
            writer.println("ironFurnace.requiresPickaxe = " + IRON_FURNACE_REQUIRES_PICKAXE + "  # Does it need a tool to drop?");
            writer.println("ironFurnace.pickaxeTier = " + IRON_FURNACE_PICKAXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println("ironFurnace.hardness = " + IRON_FURNACE_HARDNESS + "  # Time to break");
            writer.println();
            writer.println("[Gold Furnace]");
            writer.println("goldFurnace.speed = " + GOLD_FURNACE_SPEED + "  # Efficiency multiplier (3.0 = 3x faster)");
            writer.println("goldFurnace.requiresPickaxe = " + GOLD_FURNACE_REQUIRES_PICKAXE + "  # Does it need a tool to drop?");
            writer.println("goldFurnace.pickaxeTier = " + GOLD_FURNACE_PICKAXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println("goldFurnace.hardness = " + GOLD_FURNACE_HARDNESS + "  # Time to break");
            writer.println();
            writer.println("[Diamond Furnace]");
            writer.println("diamondFurnace.speed = " + DIAMOND_FURNACE_SPEED + "  # Efficiency multiplier (4.0 = 4x faster)");
            writer.println("diamondFurnace.requiresPickaxe = " + DIAMOND_FURNACE_REQUIRES_PICKAXE + "  # Does it need a tool to drop?");
            writer.println("diamondFurnace.pickaxeTier = " + DIAMOND_FURNACE_PICKAXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println("diamondFurnace.hardness = " + DIAMOND_FURNACE_HARDNESS + "  # Time to break");
            writer.println();
            writer.println("[Netherite Furnace]");
            writer.println("netheriteFurnace.speed = " + NETHERITE_FURNACE_SPEED + "  # Efficiency multiplier (8.0 = 8x faster)");
            writer.println("netheriteFurnace.requiresPickaxe = " + NETHERITE_FURNACE_REQUIRES_PICKAXE + "  # Does it need a tool to drop?");
            writer.println("netheriteFurnace.pickaxeTier = " + NETHERITE_FURNACE_PICKAXE_TIER + "  # 0=Wood, 1=Stone, 2=Iron, 3=Diamond, 4=Netherite");
            writer.println("netheriteFurnace.hardness = " + NETHERITE_FURNACE_HARDNESS + "  # Time to break");
            writer.println();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    private static void loadConfigs(File configFile) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("[")) continue;
                int commentIdx = line.indexOf("#");
                if (commentIdx != -1) {
                    line = line.substring(0, commentIdx).trim();
                }
                if ((parts = line.split("=", 2)).length != 2) continue;
                configMap.put(parts[0].trim(), parts[1].trim());
            }
            IRON_CHEST_ROWS = Integer.parseInt(configMap.getOrDefault("ironChest.rows", "5"));
            IRON_CHEST_HARDNESS = Float.parseFloat(configMap.getOrDefault("ironChest.hardness", "1.5"));
            IRON_CHEST_REQUIRES_AXE = Boolean.parseBoolean(configMap.getOrDefault("ironChest.requiresAxe", "false"));
            IRON_CHEST_AXE_TIER = Integer.parseInt(configMap.getOrDefault("ironChest.axeTier", "0"));
            GOLD_CHEST_ROWS = Integer.parseInt(configMap.getOrDefault("goldChest.rows", "7"));
            GOLD_CHEST_HARDNESS = Float.parseFloat(configMap.getOrDefault("goldChest.hardness", "1.5"));
            GOLD_CHEST_REQUIRES_AXE = Boolean.parseBoolean(configMap.getOrDefault("goldChest.requiresAxe", "false"));
            GOLD_CHEST_AXE_TIER = Integer.parseInt(configMap.getOrDefault("goldChest.axeTier", "0"));
            DIAMOND_CHEST_ROWS = Integer.parseInt(configMap.getOrDefault("diamondChest.rows", "9"));
            DIAMOND_CHEST_HARDNESS = Float.parseFloat(configMap.getOrDefault("diamondChest.hardness", "1.5"));
            DIAMOND_CHEST_REQUIRES_AXE = Boolean.parseBoolean(configMap.getOrDefault("diamondChest.requiresAxe", "false"));
            DIAMOND_CHEST_AXE_TIER = Integer.parseInt(configMap.getOrDefault("diamondChest.axeTier", "0"));
            NETHERITE_CHEST_ROWS = Integer.parseInt(configMap.getOrDefault("netheriteChest.rows", "11"));
            NETHERITE_CHEST_HARDNESS = Float.parseFloat(configMap.getOrDefault("netheriteChest.hardness", "1.5"));
            NETHERITE_CHEST_REQUIRES_AXE = Boolean.parseBoolean(configMap.getOrDefault("netheriteChest.requiresAxe", "false"));
            NETHERITE_CHEST_AXE_TIER = Integer.parseInt(configMap.getOrDefault("netheriteChest.axeTier", "0"));
            IRON_FURNACE_SPEED = Double.parseDouble(configMap.getOrDefault("ironFurnace.speed", "2.0"));
            IRON_FURNACE_REQUIRES_PICKAXE = Boolean.parseBoolean(configMap.getOrDefault("ironFurnace.requiresPickaxe", "false"));
            IRON_FURNACE_PICKAXE_TIER = Integer.parseInt(configMap.getOrDefault("ironFurnace.pickaxeTier", "0"));
            IRON_FURNACE_HARDNESS = Float.parseFloat(configMap.getOrDefault("ironFurnace.hardness", "1.5"));
            GOLD_FURNACE_SPEED = Double.parseDouble(configMap.getOrDefault("goldFurnace.speed", "3.0"));
            GOLD_FURNACE_REQUIRES_PICKAXE = Boolean.parseBoolean(configMap.getOrDefault("goldFurnace.requiresPickaxe", "false"));
            GOLD_FURNACE_PICKAXE_TIER = Integer.parseInt(configMap.getOrDefault("goldFurnace.pickaxeTier", "0"));
            GOLD_FURNACE_HARDNESS = Float.parseFloat(configMap.getOrDefault("goldFurnace.hardness", "1.5"));
            DIAMOND_FURNACE_SPEED = Double.parseDouble(configMap.getOrDefault("diamondFurnace.speed", "4.0"));
            DIAMOND_FURNACE_REQUIRES_PICKAXE = Boolean.parseBoolean(configMap.getOrDefault("diamondFurnace.requiresPickaxe", "false"));
            DIAMOND_FURNACE_PICKAXE_TIER = Integer.parseInt(configMap.getOrDefault("diamondFurnace.pickaxeTier", "0"));
            DIAMOND_FURNACE_HARDNESS = Float.parseFloat(configMap.getOrDefault("diamondFurnace.hardness", "1.5"));
            NETHERITE_FURNACE_SPEED = Double.parseDouble(configMap.getOrDefault("netheriteFurnace.speed", "8.0"));
            NETHERITE_FURNACE_REQUIRES_PICKAXE = Boolean.parseBoolean(configMap.getOrDefault("netheriteFurnace.requiresPickaxe", "false"));
            NETHERITE_FURNACE_PICKAXE_TIER = Integer.parseInt(configMap.getOrDefault("netheriteFurnace.pickaxeTier", "0"));
            NETHERITE_FURNACE_HARDNESS = Float.parseFloat(configMap.getOrDefault("netheriteFurnace.hardness", "1.5"));
        }
        catch (IOException | NumberFormatException e) {
            LOGGER.error("Failed to load config file, re-creating defaults", (Throwable)e);
            ModConfig.saveConfigs(configFile);
        }
    }
}

