/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.oasis;

import ai.decart.oasis.mixin.client.BufferManagerAccessor;
import ai.decart.oasis.mixin.client.GlGpuBufferAccessor;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_10859;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_10874;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL15;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002;<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ=\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0017J5\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001f\u0010(\u001a\n '*\u0004\u0018\u00010&0&8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u001f\u0010-\u001a\n '*\u0004\u0018\u00010,0,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00105\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\"\u00106\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00102\"\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lai/decart/oasis/Graphics;", "", "<init>", "()V", "", "init", "Lnet/minecraft/class_276;", "framebuffer", "", "getOrCreateColorFBO", "(Lnet/minecraft/class_276;)I", "usage", "size", "Lnet/minecraft/class_10859;", "createMutableBuffer", "(II)Lnet/minecraft/class_10859;", "srcFBOHandle", "srcWidth", "srcHeight", "dstFBOHandle", "dstWidth", "dstHeight", "blitFBO", "(IIIIII)V", "Lnet/minecraft/class_10868;", "texture", "pbo", "Ljava/nio/ByteBuffer;", "bufferRGBA", "width", "height", "updateTextureUsingPBO", "(Lnet/minecraft/class_10868;Lnet/minecraft/class_10859;Ljava/nio/ByteBuffer;II)V", "Lnet/minecraft/class_10865;", "device", "Lnet/minecraft/class_10865;", "getDevice", "()Lnet/minecraft/class_10865;", "Lnet/minecraft/class_10874;", "kotlin.jvm.PlatformType", "bufferManager", "Lnet/minecraft/class_10874;", "getBufferManager", "()Lnet/minecraft/class_10874;", "Lnet/minecraft/class_1041;", "window", "Lnet/minecraft/class_1041;", "getWindow", "()Lnet/minecraft/class_1041;", "getWindowWidth", "()I", "windowWidth", "getWindowHeight", "windowHeight", "windowFBOHandle", "I", "getWindowFBOHandle", "setWindowFBOHandle", "(I)V", "WindowDownloader", "WindowUploader", "mirage-minecraft-mod_client"})
@Environment(value=EnvType.CLIENT)
public final class Graphics {
    @NotNull
    public static final Graphics INSTANCE = new Graphics();
    @NotNull
    private static final class_10865 device;
    private static final class_10874 bufferManager;
    private static final class_1041 window;
    private static int windowFBOHandle;

    private Graphics() {
    }

    @NotNull
    public final class_10865 getDevice() {
        return device;
    }

    public final class_10874 getBufferManager() {
        return bufferManager;
    }

    public final class_1041 getWindow() {
        return window;
    }

    public final int getWindowWidth() {
        return window.method_4489();
    }

    public final int getWindowHeight() {
        return window.method_4506();
    }

    public final int getWindowFBOHandle() {
        return windowFBOHandle;
    }

    public final void setWindowFBOHandle(int n) {
        windowFBOHandle = n;
    }

    public final void init() {
        class_276 class_2762 = class_310.method_1551().method_1522();
        Intrinsics.checkNotNullExpressionValue((Object)class_2762, (String)"getFramebuffer(...)");
        windowFBOHandle = INSTANCE.getOrCreateColorFBO(class_2762);
    }

    public final int getOrCreateColorFBO(@NotNull class_276 framebuffer) {
        Intrinsics.checkNotNullParameter((Object)framebuffer, (String)"framebuffer");
        GpuTexture gpuTexture = framebuffer.method_30277();
        Intrinsics.checkNotNull((Object)gpuTexture, (String)"null cannot be cast to non-null type net.minecraft.client.texture.GlTexture");
        return ((class_10868)gpuTexture).method_68426(bufferManager, null);
    }

    @NotNull
    public final class_10859 createMutableBuffer(int usage, int size) {
        GlStateManager.clearGlErrors();
        int bufferId = GlStateManager._glGenBuffers();
        GlStateManager._glBindBuffer((int)36663, (int)bufferId);
        GlStateManager._glBufferData((int)36663, (long)size, (int)GlConst.bufferUsageToGlEnum((int)usage));
        GlStateManager._glBindBuffer((int)36663, (int)0);
        int error = GlStateManager._getError();
        if (error != 0) {
            throw new Exception("Could not allocate buffer: " + error);
        }
        class_10859 class_108592 = GlGpuBufferAccessor.create(null, bufferManager, usage, size, bufferId, null);
        Intrinsics.checkNotNullExpressionValue((Object)class_108592, (String)"create(...)");
        return class_108592;
    }

    public final void blitFBO(int srcFBOHandle, int srcWidth, int srcHeight, int dstFBOHandle, int dstWidth, int dstHeight) {
        GlStateManager._disableScissorTest();
        GlStateManager.clearGlErrors();
        class_10874 class_108742 = bufferManager;
        Intrinsics.checkNotNull((Object)class_108742, (String)"null cannot be cast to non-null type ai.decart.oasis.mixin.client.BufferManagerAccessor");
        ((BufferManagerAccessor)class_108742).setupBlitFramebuffer(srcFBOHandle, dstFBOHandle, 0, 0, srcWidth, srcHeight, 0, 0, dstWidth, dstHeight, 16384, 9728);
        int glError = GlStateManager._getError();
        if (glError != 0) {
            throw new IllegalStateException("Failed to blit FBO " + srcFBOHandle + " to FBO " + dstFBOHandle + ": " + glError);
        }
    }

    public final void updateTextureUsingPBO(@NotNull class_10868 texture, @NotNull class_10859 pbo, @NotNull ByteBuffer bufferRGBA, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)pbo, (String)"pbo");
        Intrinsics.checkNotNullParameter((Object)bufferRGBA, (String)"bufferRGBA");
        if (!(!texture.isClosed())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 < width && width <= texture.getWidth(0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 < height && height <= texture.getHeight(0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(texture.getFormat() == TextureFormat.RGBA8)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!pbo.isClosed())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(pbo.size >= width * height * 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((pbo.usage() & 0x10) != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((pbo.usage() & 2) != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(bufferRGBA.limit() == width * height * 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        GlStateManager._glBindBuffer((int)35052, (int)((GlGpuBufferAccessor)pbo).getId());
        GlStateManager._glBufferData((int)35052, (long)bufferRGBA.capacity(), (int)35040);
        ByteBuffer byteBuffer = GL15.glMapBuffer((int)35052, (int)35001, (long)((long)(width * height) * 4L), null);
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBuffer pboBuffer = byteBuffer;
        bufferRGBA.rewind();
        pboBuffer.put(bufferRGBA);
        bufferRGBA.rewind();
        GlStateManager._glUnmapBuffer((int)35052);
        GlStateManager._bindTexture((int)texture.method_68427());
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
        GlStateManager._texSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (long)0L);
        GlStateManager._glBindBuffer((int)35052, (int)0);
        GlStateManager._bindTexture((int)0);
    }

    static {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        Intrinsics.checkNotNull((Object)gpuDevice, (String)"null cannot be cast to non-null type net.minecraft.client.gl.GlBackend");
        device = (class_10865)gpuDevice;
        bufferManager = device.method_68401();
        window = class_310.method_1551().method_22683();
        windowFBOHandle = -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001d\u0010\u0015R\u001f\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lai/decart/oasis/Graphics$WindowDownloader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "width", "height", "<init>", "(II)V", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "Lkotlin/ParameterName;", "name", "bufferRGBA", "", "callback", "captureWindow", "(IILkotlin/jvm/functions/Function1;)V", "close", "()V", "I", "getWidth", "()I", "getHeight", "Lnet/minecraft/class_6367;", "fbo", "Lnet/minecraft/class_6367;", "getFbo", "()Lnet/minecraft/class_6367;", "fboHandle", "getFboHandle", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "kotlin.jvm.PlatformType", "pbo", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "getPbo", "()Lcom/mojang/blaze3d/buffers/GpuBuffer;", "mirage-minecraft-mod_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class WindowDownloader
    implements AutoCloseable {
        private final int width;
        private final int height;
        @NotNull
        private final class_6367 fbo;
        private final int fboHandle;
        private final GpuBuffer pbo;

        public WindowDownloader(int width, int height) {
            this.width = width;
            this.height = height;
            this.fbo = new class_6367(null, this.width, this.height, false);
            this.fboHandle = INSTANCE.getOrCreateColorFBO((class_276)this.fbo);
            this.pbo = INSTANCE.getDevice().createBuffer(null, 9, this.width * this.height * 4);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final class_6367 getFbo() {
            return this.fbo;
        }

        public final int getFboHandle() {
            return this.fboHandle;
        }

        public final GpuBuffer getPbo() {
            return this.pbo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void captureWindow(int width, int height, @NotNull Function1<? super ByteBuffer, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            INSTANCE.blitFBO(INSTANCE.getWindowFBOHandle(), INSTANCE.getWindowWidth(), INSTANCE.getWindowHeight(), this.fboHandle, width, height);
            CommandEncoder commandEncoder = INSTANCE.getDevice().createCommandEncoder();
            commandEncoder.copyTextureToBuffer(this.fbo.method_30277(), this.pbo, 0, WindowDownloader::captureWindow$lambda$0, 0, 0, 0, width, height);
            AutoCloseable autoCloseable = (AutoCloseable)commandEncoder.mapBuffer(this.pbo, true, false);
            Throwable throwable = null;
            try {
                GpuBuffer.MappedView it = (GpuBuffer.MappedView)autoCloseable;
                boolean bl = false;
                ByteBuffer bufferBGRA = it.data();
                Intrinsics.checkNotNull((Object)bufferBGRA);
                callback.invoke((Object)bufferBGRA);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @Override
        public void close() {
            this.fbo.method_1238();
            this.pbo.close();
        }

        private static final void captureWindow$lambda$0() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u001b\u0010\u0013R\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lai/decart/oasis/Graphics$WindowUploader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "maxWidth", "maxHeight", "<init>", "(II)V", "Ljava/nio/ByteBuffer;", "bufferRGBA", "width", "height", "", "drawImageToWindow", "(Ljava/nio/ByteBuffer;II)V", "close", "()V", "I", "getMaxWidth", "()I", "getMaxHeight", "Lnet/minecraft/class_6367;", "fbo", "Lnet/minecraft/class_6367;", "getFbo", "()Lnet/minecraft/class_6367;", "fboHandle", "getFboHandle", "Lnet/minecraft/class_10859;", "pbo", "Lnet/minecraft/class_10859;", "getPbo", "()Lnet/minecraft/class_10859;", "mirage-minecraft-mod_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class WindowUploader
    implements AutoCloseable {
        private final int maxWidth;
        private final int maxHeight;
        @NotNull
        private final class_6367 fbo;
        private final int fboHandle;
        @NotNull
        private final class_10859 pbo;

        public WindowUploader(int maxWidth, int maxHeight) {
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.fbo = new class_6367(null, this.maxWidth, this.maxHeight, false);
            this.fboHandle = INSTANCE.getOrCreateColorFBO((class_276)this.fbo);
            this.pbo = INSTANCE.createMutableBuffer(18, this.maxWidth * this.maxHeight * 4);
        }

        public final int getMaxWidth() {
            return this.maxWidth;
        }

        public final int getMaxHeight() {
            return this.maxHeight;
        }

        @NotNull
        public final class_6367 getFbo() {
            return this.fbo;
        }

        public final int getFboHandle() {
            return this.fboHandle;
        }

        @NotNull
        public final class_10859 getPbo() {
            return this.pbo;
        }

        public final void drawImageToWindow(@NotNull ByteBuffer bufferRGBA, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)bufferRGBA, (String)"bufferRGBA");
            if (!(0 < width && width <= this.maxWidth)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(0 < height && height <= this.maxHeight)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(bufferRGBA.limit() == width * height * 4)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            GpuTexture gpuTexture = this.fbo.method_30277();
            Intrinsics.checkNotNull((Object)gpuTexture, (String)"null cannot be cast to non-null type net.minecraft.client.texture.GlTexture");
            INSTANCE.updateTextureUsingPBO((class_10868)gpuTexture, this.pbo, bufferRGBA, width, height);
            INSTANCE.blitFBO(this.fboHandle, width, height, INSTANCE.getWindowFBOHandle(), INSTANCE.getWindowWidth(), INSTANCE.getWindowHeight());
        }

        @Override
        public void close() {
            this.fbo.method_1238();
            this.pbo.close();
        }
    }
}

